/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetPlanTempService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanTempVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.TwAssert;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetPlanTempConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanTempDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanTempRepo;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsTimesheetPlanTempServiceImpl
implements PmsTimesheetPlanTempService {
    private static final Logger log = LoggerFactory.getLogger(PmsTimesheetPlanTempServiceImpl.class);
    private final TimesheetPlanTempRepo timesheetPlanTempRepo;
    private final PmsProjectService pmsProjectService;
    private final TaskPackageService taskPackageService;
    private final TaskInfoService taskInfoService;
    private final PmsProjectActivityService pmsProjectActivityService;

    public PagingVO<TimesheetPlanTempVO> paging(TimesheetPlanTempQuery query) {
        Page page = this.timesheetPlanTempRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetPlanTempConvert.INSTANCE::toVo));
    }

    public List<TimesheetPlanTempVO> queryList(TimesheetPlanTempQuery query) {
        return TimesheetPlanTempConvert.INSTANCE.toVoList(this.timesheetPlanTempRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public long count(TimesheetPlanTempQuery query) {
        return this.timesheetPlanTempRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    public TimesheetPlanTempVO queryByKey(Long key) {
        TimesheetPlanTempDO entity = this.timesheetPlanTempRepo.findById(key).orElseGet(TimesheetPlanTempDO::new);
        TwAssert.notNull(entity.getId(), "\u4e0d\u5b58\u5728");
        TimesheetPlanTempVO vo = TimesheetPlanTempConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanTempVO insert(TimesheetPlanTempPayload payload) {
        this.check(payload);
        this.initData(payload);
        TimesheetPlanTempDO entityDo = TimesheetPlanTempConvert.INSTANCE.toDo(payload);
        return TimesheetPlanTempConvert.INSTANCE.toVo((TimesheetPlanTempDO)((Object)this.timesheetPlanTempRepo.save((Object)entityDo)));
    }

    private void check(TimesheetPlanTempPayload payload) {
        if (!StringUtils.hasText((String)payload.getType())) {
            throw TwException.error("", "\u53c2\u6570\u5f02\u5e38\uff1atype");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TimesheetPlanTempVO> batchInsert(TimesheetPlanTempListPayload payload) {
        List timesheetPlanTempList = payload.getTimesheetPlanTempList();
        ArrayList<TimesheetPlanTempVO> list = new ArrayList<TimesheetPlanTempVO>();
        if (!CollectionUtils.isEmpty((Collection)timesheetPlanTempList)) {
            timesheetPlanTempList.forEach(timesheetPlanTempPayload -> list.add(this.insert((TimesheetPlanTempPayload)timesheetPlanTempPayload)));
        }
        return list;
    }

    private void initData(TimesheetPlanTempPayload payload) {
        if (null != payload.getProjId()) {
            PmsProjectVO projectVO = this.pmsProjectService.queryByKeySimple(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (payload.getTaskPackageId() != null) {
            TaskPackageVO taskPackageVO = this.taskPackageService.queryByKey(payload.getTaskPackageId(), Boolean.valueOf(false));
            if (!StringUtils.hasText((String)payload.getTaskPackageNo())) {
                payload.setTaskPackageNo(null != taskPackageVO ? taskPackageVO.getTaskPackageNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskPackageName())) {
                payload.setTaskPackageName(null != taskPackageVO ? taskPackageVO.getTaskPackageName() : "");
            }
            if (ObjectUtils.isEmpty((Object)payload.getReasonId())) {
                payload.setReasonId(null != taskPackageVO ? taskPackageVO.getReasonId() : null);
            }
            if (!StringUtils.hasText((String)payload.getReasonType())) {
                payload.setReasonType(null != taskPackageVO ? taskPackageVO.getReasonType() : "");
            }
            if (!StringUtils.hasText((String)payload.getReasonName())) {
                payload.setReasonName(null != taskPackageVO ? taskPackageVO.getReasonName() : "");
            }
        }
        if (null != payload.getTaskId()) {
            TaskInfoVO taskVO = this.taskInfoService.queryByKey(payload.getTaskId(), Boolean.valueOf(false));
            if (!StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqvaQty()) {
                payload.setEqvaQty(null != taskVO ? taskVO.getValidEqva() : null);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanTempVO update(TimesheetPlanTempPayload payload) {
        TimesheetPlanTempDO entity = this.timesheetPlanTempRepo.findById(payload.getId()).orElseGet(TimesheetPlanTempDO::new);
        TwAssert.notNull(entity.getId(), "\u4e0d\u5b58\u5728");
        this.initData(payload);
        TimesheetPlanTempDO entityDo = TimesheetPlanTempConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetPlanTempConvert.INSTANCE.toVo((TimesheetPlanTempDO)((Object)this.timesheetPlanTempRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.timesheetPlanTempRepo.deleteSoft(keys);
        }
    }

    public void download(List<TimesheetPlanTempVO> all, HttpServletResponse response) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (TimesheetPlanTempVO timesheetPlanTemp : all) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u4efb\u52a1id", timesheetPlanTemp.getTaskId());
            map.put("\u5de5\u4f5c\u8ba1\u5212\u4e3b\u952e", timesheetPlanTemp.getPlanId());
            map.put("\u72b6\u6001", timesheetPlanTemp.getStatus());
            map.put("\u62d3\u5c551", timesheetPlanTemp.getExt1());
            map.put("\u62d3\u5c552", timesheetPlanTemp.getExt2());
            map.put("\u62d3\u5c553", timesheetPlanTemp.getExt3());
            map.put("\u62d3\u5c554", timesheetPlanTemp.getExt4());
            map.put("\u62d3\u5c555", timesheetPlanTemp.getExt5());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }

    public PmsTimesheetPlanTempServiceImpl(TimesheetPlanTempRepo timesheetPlanTempRepo, PmsProjectService pmsProjectService, TaskPackageService taskPackageService, TaskInfoService taskInfoService, PmsProjectActivityService pmsProjectActivityService) {
        this.timesheetPlanTempRepo = timesheetPlanTempRepo;
        this.pmsProjectService = pmsProjectService;
        this.taskPackageService = taskPackageService;
        this.taskInfoService = taskInfoService;
        this.pmsProjectActivityService = pmsProjectActivityService;
    }
}

