/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceNormalPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceNormalQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceNormalService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.MobAttendanceLogVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalExcelExport;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalMonthExcelExport;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalMonthVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceNormalConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceNormalDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceNormalMonthDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceNormalDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceNormalRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TAttendanceNormalServiceImpl
extends BaseServiceImpl
implements TAttendanceNormalService {
    private static final Logger log = LoggerFactory.getLogger(TAttendanceNormalServiceImpl.class);
    private final TAttendanceNormalRepo tAttendanceNormalRepo;
    private final TAttendanceNormalDAO tAttendanceNormalDAO;
    private final TAttendanceNormalMonthDAO tAttendanceNormalMonthDAO;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;
    private final VacationService vacationService;
    private final UdcUtil udcUtil;
    @Value(value="${tw4.attendance.normal}")
    private String attendanceNormalTo5Url;

    public PagingVO<TAttendanceNormalVO> queryPaging(TAttendanceNormalQuery query) {
        PagingVO<TAttendanceNormalVO> tAttendanceNormalVOPagingVO = this.tAttendanceNormalDAO.queryPaging(query);
        List records = tAttendanceNormalVOPagingVO.getRecords();
        this.translateList(records);
        return tAttendanceNormalVOPagingVO;
    }

    public PagingVO<TAttendanceNormalMonthVO> queryPagingMonth(TAttendanceNormalQuery query) {
        PagingVO<TAttendanceNormalMonthVO> tAttendanceNormalMonthVOPagingVO = this.tAttendanceNormalMonthDAO.queryPaging(query);
        List records = tAttendanceNormalMonthVOPagingVO.getRecords();
        this.translateMonthRecords(records);
        return tAttendanceNormalMonthVOPagingVO;
    }

    public List<TAttendanceNormalMonthVO> queryListMonth(TAttendanceNormalQuery query) {
        List<TAttendanceNormalMonthVO> tAttendanceNormalMonthVOS = this.tAttendanceNormalMonthDAO.queryListDynamic(query);
        this.translateMonthRecords(tAttendanceNormalMonthVOS);
        return tAttendanceNormalMonthVOS;
    }

    public List<TAttendanceNormalVO> queryListDynamic(TAttendanceNormalQuery query) {
        List<TAttendanceNormalVO> tAttendanceNormalVOS = this.tAttendanceNormalDAO.queryListDynamic(query);
        this.translateList(tAttendanceNormalVOS);
        return tAttendanceNormalVOS;
    }

    public void exportListMonth(TAttendanceNormalQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u6253\u5361\u6708\u5ea6\u62a5\u8868";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        List<TAttendanceNormalMonthVO> tAttendanceNormalVOS = this.queryListMonth(query);
        if (tAttendanceNormalVOS.size() > 50000) {
            throw TwException.error("500", "\u5bfc\u51fa\u6570\u636e\u8fc7\u5927\uff0c\u8bf7\u5206\u6279\u64cd\u4f5c\uff0c\u76ee\u524d\u5bfc\u51fa\u6570\u91cf\uff1a" + tAttendanceNormalVOS.size());
        }
        List resultList = this.udcUtil.translateList(tAttendanceNormalVOS);
        List<TAttendanceNormalMonthExcelExport> excelList = TAttendanceNormalConvert.INSTANCE.voMonthListMonthVoExcelExport(resultList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), TAttendanceNormalMonthExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, TAttendanceNormalMonthExcelExport.class, null);
        sheet.doWrite(excelList);
    }

    public TAttendanceNormalVO queryByKey(Long key) {
        TAttendanceNormalDO entity = this.tAttendanceNormalRepo.findById(key).orElseGet(TAttendanceNormalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceNormalVO vo = TAttendanceNormalConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceNormalVO insert(TAttendanceNormalPayload payload) {
        TAttendanceNormalDO entityDo = TAttendanceNormalConvert.INSTANCE.toDo(payload);
        return TAttendanceNormalConvert.INSTANCE.toVo((TAttendanceNormalDO)((Object)this.tAttendanceNormalRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public TAttendanceNormalVO update(TAttendanceNormalPayload payload) {
        TAttendanceNormalDO entity = this.tAttendanceNormalRepo.findById(payload.getId()).orElseGet(TAttendanceNormalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TAttendanceNormalDO entityDo = TAttendanceNormalConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceNormalConvert.INSTANCE.toVo((TAttendanceNormalDO)((Object)this.tAttendanceNormalRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TAttendanceNormalPayload payload) {
        TAttendanceNormalDO entity = this.tAttendanceNormalRepo.findById(payload.getId()).orElseGet(TAttendanceNormalDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tAttendanceNormalDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tAttendanceNormalDAO.deleteSoft(keys);
        }
    }

    public List<Long> findResAttendanceLog(Long resId, LocalDate attendanceDate) {
        return this.tAttendanceNormalDAO.findResAttendanceLog(resId, attendanceDate);
    }

    public String findStartTime(Long id) {
        return this.tAttendanceNormalDAO.findStartTime(id);
    }

    public String findResAttendanceStatus(Long id) {
        return this.tAttendanceNormalDAO.findResAttendanceStatus(id);
    }

    public String findResAttendanceResult(Long id) {
        return this.tAttendanceNormalDAO.findResAttendanceResult(id);
    }

    public List<MobAttendanceLogVO> getResAttendanceLog(Long resId, LocalDate attendanceDateStart, LocalDate attendanceDateEnd) {
        return this.tAttendanceNormalDAO.getResAttendanceLog(resId, attendanceDateStart, attendanceDateEnd);
    }

    public void attendanceNormalTo5(String param) {
        String syncType = "attendanceNormalTo5";
        LocalDateTime localDateTime = this.daoLog.queryOrgSyncLog(syncType);
        localDateTime = localDateTime == null ? LocalDateTime.of(1970, 1, 1, 0, 0) : localDateTime.minusSeconds(10L);
        XxlJobLogger.log((String)("syncVacationApply localDateTime\uff1a" + localDateTime), (Object[])new Object[0]);
        HashMap<String, Object> reqMap = new HashMap<String, Object>();
        long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log((String)("syncVacationApplyDetail syncTime\uff1a" + asyncTimeLong), (Object[])new Object[0]);
        String result = this.httpUtil.sendSyncGet(this.attendanceNormalTo5Url, reqMap);
        Map data = (Map)JSONObject.parse((String)result);
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        Object syncData = "";
        if ("true".equals("" + data.get("ok"))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map v4AndV5UserIds = this.employeeService.getV4AndV5UserIds();
                Object datum = data.get("datum");
                List attendanceNormalData = (List)datum;
                ArrayList<TAttendanceNormalDO> tAttendanceNormalDOList = new ArrayList<TAttendanceNormalDO>();
                List<Long> tw4AttendanceNormalIds = attendanceNormalData.stream().map(attendanceNormal -> (attendanceNormal.get("id") == null ? Integer.valueOf(0) : attendanceNormal.get("id")).longValue()).collect(Collectors.toList());
                List<TAttendanceNormalDO> oldTAttendanceNormalDOs = this.tAttendanceNormalRepo.selectByIdV4List(tw4AttendanceNormalIds);
                block0: for (TAttendanceNormalDO attendanceNormalDO : oldTAttendanceNormalDOs) {
                    Long attendanceNormalIdV4 = attendanceNormalDO.getAttendanceNormalIdV4();
                    for (Map applyData2 : attendanceNormalData) {
                        Long attendanceNormalIdV4FromV4 = (null == applyData2.get("id") ? Integer.valueOf(0) : applyData2.get("id")).longValue();
                        if (!attendanceNormalIdV4.equals(attendanceNormalIdV4FromV4)) continue;
                        TAttendanceNormalDO attendanceNormalDO1 = this.translateFromV4(applyData2, v4AndV5UserIds);
                        attendanceNormalDO1.setId(attendanceNormalDO.getId());
                        tAttendanceNormalDOList.add(attendanceNormalDO1);
                        continue block0;
                    }
                }
                this.tAttendanceNormalRepo.saveAll(tAttendanceNormalDOList);
                List newDatas = attendanceNormalData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = (applyData.get("id") == null ? Integer.valueOf(0) : applyData.get("id")).longValue();
                    for (TAttendanceNormalDO attendanceNormalDO : oldTAttendanceNormalDOs) {
                        if (!attendanceNormalDO.getAttendanceNormalIdV4().equals(applyId)) continue;
                        flag = false;
                    }
                    return flag;
                }).collect(Collectors.toList());
                ArrayList<TAttendanceNormalDO> newTAttendanceNormalDOs = new ArrayList<TAttendanceNormalDO>();
                for (Map newData : newDatas) {
                    TAttendanceNormalDO attendanceNormalDO1 = this.translateFromV4(newData, v4AndV5UserIds);
                    newTAttendanceNormalDOs.add(attendanceNormalDO1);
                }
                this.tAttendanceNormalRepo.saveAll(newTAttendanceNormalDOs);
                syncData = "\u66f4\u65b0\u4e86\u6b63\u5e38\u6253\u5361" + attendanceNormalData.size() + "\u6761\u6570\u636e";
            } else {
                syncData = "\u6b63\u5e38\u6253\u5361\u6570\u636e\u672a\u53d8\u5316";
            }
        } else {
            syncData = "" + data.get("reason");
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData((String)syncData);
        this.daoLog.save(logDO);
        log.info("\u3010\u6b63\u5e38\u6253\u5361\u4fe1\u606f\u540c\u6b65\uff0c\u540c\u6b65\u65e5\u5fd7\uff1a{}\u3011", (Object)logDO);
    }

    public void export(TAttendanceNormalQuery query, HttpServletResponse response) throws IOException {
        String sheetName = "\u6253\u5361\u62a5\u8868";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        List<TAttendanceNormalVO> tAttendanceNormalVOS = this.queryListDynamic(query);
        if (tAttendanceNormalVOS.size() > 50000) {
            throw TwException.error("500", "\u5bfc\u51fa\u6570\u636e\u8fc7\u5927\uff0c\u8bf7\u5206\u6279\u64cd\u4f5c\uff0c\u76ee\u524d\u5bfc\u51fa\u6570\u91cf\uff1a" + tAttendanceNormalVOS.size());
        }
        List resultList = this.udcUtil.translateList(tAttendanceNormalVOS);
        List<TAttendanceNormalExcelExport> excelList = TAttendanceNormalConvert.INSTANCE.voListVoExcelExport(resultList);
        for (TAttendanceNormalExcelExport tAttendanceNormalExcelExport : excelList) {
            for (TAttendanceNormalVO attendanceNormalVO : resultList) {
                if (!attendanceNormalVO.getId().equals(tAttendanceNormalExcelExport.getId())) continue;
                tAttendanceNormalExcelExport.setAttendanceDateStr("" + attendanceNormalVO.getAttendanceDate());
            }
        }
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), TAttendanceNormalExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, TAttendanceNormalExcelExport.class, null);
        sheet.doWrite(excelList);
    }

    private TAttendanceNormalDO translateFromV4(Map attendanceNormalData, Map<Long, Long> v4AndV5UserIds) {
        TAttendanceNormalDO attendanceNormalDO = BeanUtil.mapToBean(TAttendanceNormalDO.class, attendanceNormalData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != attendanceNormalData.get("id")) {
            attendanceNormalDO.setAttendanceNormalIdV4(((Integer)attendanceNormalData.get("id")).longValue());
        }
        if (null != attendanceNormalData.get("attendanceResId")) {
            Long attendanceResId = ((Integer)attendanceNormalData.get("attendanceResId")).longValue();
            attendanceNormalDO.setAttendanceResId(v4AndV5UserIds.get(attendanceResId));
        }
        return attendanceNormalDO;
    }

    private void translateList(List<TAttendanceNormalVO> tAttendanceNormalVOS) {
        for (TAttendanceNormalVO tAttendanceNormalVO : tAttendanceNormalVOS) {
            if (!StringUtils.hasText((String)tAttendanceNormalVO.getAttendanceTimeStart()) || !StringUtils.hasText((String)tAttendanceNormalVO.getAttendanceTimeEnd())) continue;
            tAttendanceNormalVO.setAttendanceTime(this.getDuration(tAttendanceNormalVO.getAttendanceTimeStart(), tAttendanceNormalVO.getAttendanceTimeEnd()));
        }
    }

    private String getDuration(String time1String, String time2String) {
        LocalTime time1 = LocalTime.parse(time1String, DateTimeFormatter.ofPattern("HH:mm"));
        LocalTime time2 = LocalTime.parse(time2String, DateTimeFormatter.ofPattern("HH:mm"));
        long minutesBetween = ChronoUnit.MINUTES.between(time1, time2);
        int hours = (int)minutesBetween / 60;
        int minutes = (int)minutesBetween % 60;
        String durationString = String.format("%d:%02d", hours, minutes);
        return durationString;
    }

    private void translateMonthRecords(List<TAttendanceNormalMonthVO> records) {
        for (TAttendanceNormalMonthVO record : records) {
            LocalDate monthDayLast;
            String attendanceMonth = record.getAttendanceMonth();
            YearMonth yearMonth = YearMonth.parse(attendanceMonth);
            Integer daysInMonth = yearMonth.lengthOfMonth();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate monthDayFirst = LocalDate.parse(attendanceMonth + "-01", formatter);
            List vacationDays = this.vacationService.findVacationDay(monthDayFirst, monthDayLast = monthDayFirst.with(TemporalAdjusters.lastDayOfMonth()));
            Integer vacationDaysSize = vacationDays == null ? 0 : vacationDays.size();
            long shouldClockDays = Long.parseLong(String.valueOf(daysInMonth - vacationDaysSize));
            record.setShouldColock(Long.valueOf(shouldClockDays));
            String attendanceResultDetailStr = record.getAttendanceResultDetailStr();
            if (StringUtils.hasText((String)attendanceResultDetailStr)) {
                String[] split = attendanceResultDetailStr.split(",");
                long normalCount = Arrays.stream(split).filter("NORMAL"::equals).count();
                record.setNormalDays(Long.valueOf(normalCount));
                record.setAbnormalDays(Long.valueOf(shouldClockDays - normalCount));
                continue;
            }
            record.setNormalDays(Long.valueOf(0L));
            record.setAbnormalDays(Long.valueOf(shouldClockDays));
        }
    }

    public TAttendanceNormalServiceImpl(TAttendanceNormalRepo tAttendanceNormalRepo, TAttendanceNormalDAO tAttendanceNormalDAO, TAttendanceNormalMonthDAO tAttendanceNormalMonthDAO, PrdOrgSyncLogDAO daoLog, HttpUtil httpUtil, PrdOrgEmployeeService employeeService, PrdOrgOrganizationService orgService, VacationService vacationService, UdcUtil udcUtil) {
        this.tAttendanceNormalRepo = tAttendanceNormalRepo;
        this.tAttendanceNormalDAO = tAttendanceNormalDAO;
        this.tAttendanceNormalMonthDAO = tAttendanceNormalMonthDAO;
        this.daoLog = daoLog;
        this.httpUtil = httpUtil;
        this.employeeService = employeeService;
        this.orgService = orgService;
        this.vacationService = vacationService;
        this.udcUtil = udcUtil;
    }
}

