/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.humanresources.query.EmployeeBlackListQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeBlackListVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgPersonPayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgPersonQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgPersonVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgPersonRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdOrgPersonDAO {
    private final PrdOrgPersonRepo prdOrgPersonRepo;
    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdOrgPersonDO prdOrgPersonDO = QPrdOrgPersonDO.prdOrgPersonDO;
    private final QPrdOrgEmployeeDO employeeDO = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    private JPAQuery<PrdOrgPersonVO> getPersonSelect() {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgPersonVO.class, (Expression[])new Expression[]{this.prdOrgPersonDO.id, this.prdOrgPersonDO.personName, this.prdOrgPersonDO.foreignName, this.prdOrgPersonDO.sex, this.prdOrgPersonDO.email, this.prdOrgPersonDO.mobile, this.prdOrgPersonDO.apprStatus, this.prdOrgPersonDO.createTime, this.prdOrgPersonDO.remark})).from((EntityPath)this.prdOrgPersonDO)).where((Predicate)this.prdOrgPersonDO.inBlackList.eq(Boolean.valueOf(false)).or((Predicate)this.prdOrgPersonDO.inBlackList.isNull()));
    }

    private JPAQuery<PrdOrgPersonVO> getPersonWhere(PrdOrgPersonQuery query) {
        JPAQuery<PrdOrgPersonVO> jpaQuery = this.getPersonSelect();
        jpaQuery.where((Predicate)this.prdOrgPersonDO.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)query.getPersonName())) {
            jpaQuery.where((Predicate)this.prdOrgPersonDO.personName.like(SqlUtil.toSqlLikeString(query.getPersonName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSex())) {
            jpaQuery.where((Predicate)this.prdOrgPersonDO.sex.eq((Object)query.getSex()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprStatus())) {
            jpaQuery.where((Predicate)this.prdOrgPersonDO.apprStatus.eq((Object)query.getApprStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            jpaQuery.where((Predicate)this.prdOrgPersonDO.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMobile())) {
            jpaQuery.where((Predicate)this.prdOrgPersonDO.mobile.eq((Object)query.getMobile()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart()) && !ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            jpaQuery.where((Predicate)this.prdOrgPersonDO.createTime.between((Comparable)query.getCreateTimeStart(), (Comparable)query.getCreateTimeEnd()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.prdOrgPersonDO._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.prdOrgPersonDO, query.getOrders()));
        return jpaQuery;
    }

    public PagingVO<PrdOrgPersonVO> queryPaging(PrdOrgPersonQuery query) {
        JPAQuery<PrdOrgPersonVO> jpaQuery = this.getPersonWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public void deleteSoft(Long id) {
        this.jpaQueryFactory.update((EntityPath)this.prdOrgPersonDO).set(this.prdOrgPersonDO.deleteFlag, (Object)1).where(new Predicate[]{this.prdOrgPersonDO.id.eq((Object)id)}).execute();
    }

    public PrdOrgPersonDO save(PrdOrgPersonDO prdOrgPersonDO) {
        return (PrdOrgPersonDO)this.prdOrgPersonRepo.save(prdOrgPersonDO);
    }

    public Optional<PrdOrgPersonDO> findById(Long id) {
        return this.prdOrgPersonRepo.findById(id);
    }

    public void deleteById(Long id) {
        this.jpaQueryFactory.update((EntityPath)this.prdOrgPersonDO).set(this.prdOrgPersonDO.deleteFlag, (Object)1).where(new Predicate[]{this.prdOrgPersonDO.id.eq((Object)id)}).execute();
    }

    public void updateProcessDate(PrdOrgPersonPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.prdOrgPersonDO).where(new Predicate[]{this.prdOrgPersonDO.id.eq((Object)payload.getId())});
        if (payload.getProcInstId() != null) {
            update.set((Path)this.prdOrgPersonDO.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(this.prdOrgPersonDO.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(this.prdOrgPersonDO.submitTime, (Object)payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.prdOrgPersonDO.approvedTime, (Object)payload.getApprovedTime());
        }
        update.execute();
    }

    public Long getIdByProcId(String procId) {
        return (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.prdOrgPersonDO.id).where((Predicate)this.prdOrgPersonDO.procInstId.eq((Object)procId))).from((EntityPath)this.prdOrgPersonDO)).fetchOne();
    }

    public void updateApprStatus(Long id, String apprStatus) {
        this.jpaQueryFactory.update((EntityPath)this.prdOrgPersonDO).set((Path)this.prdOrgPersonDO.apprStatus, (Object)apprStatus).where(new Predicate[]{this.prdOrgPersonDO.id.eq((Object)id)}).execute();
    }

    public void inBlackList(Long id) {
        this.jpaQueryFactory.update((EntityPath)this.prdOrgPersonDO).set((Path)this.prdOrgPersonDO.inBlackList, (Object)true).where(new Predicate[]{this.prdOrgPersonDO.id.eq((Object)id)}).execute();
    }

    public void outBlackList(Long personId) {
        this.jpaQueryFactory.update((EntityPath)this.prdOrgPersonDO).set((Path)this.prdOrgPersonDO.inBlackList, (Object)false).where(new Predicate[]{this.prdOrgPersonDO.id.eq((Object)personId)}).execute();
    }

    public JPAQuery<EmployeeBlackListVO> getBlackListSelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(EmployeeBlackListVO.class, (Expression[])new Expression[]{this.prdOrgPersonDO.id, this.prdOrgPersonDO.personName, this.prdOrgPersonDO.procInstStatus.as("apprStatus"), this.employeeDO.extString5, this.employeeDO.extString6, this.employeeDO.extString9, this.employeeDO.resourceStatus, this.employeeDO.enrollDate, this.employeeDO.extDate4, this.employeeDO.employeeNo, this.employeeDO.id.as("employeeId"), this.qdoOrg.id.as("orgId"), this.qdoOrg.orgName, this.prdOrgPersonDO.remark})).from((EntityPath)this.prdOrgPersonDO)).leftJoin((EntityPath)this.employeeDO)).on((Predicate)this.employeeDO.personId.eq(this.prdOrgPersonDO.id))).leftJoin((EntityPath)this.qdoRef)).on((Predicate)this.employeeDO.userId.longValue().eq((Expression)this.qdoRef.userId.longValue()).and((Predicate)this.qdoRef.isDefault.eq((Object)0)).and((Predicate)this.qdoRef.isCopy.eq((Object)0)).and((Predicate)this.qdoRef.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qdoOrg)).on((Predicate)this.qdoOrg.id.longValue().eq((Expression)this.qdoRef.orgId.longValue()).and((Predicate)this.qdoOrg.isCopy.eq((Object)0)))).where((Predicate)this.prdOrgPersonDO.inBlackList.eq(Boolean.valueOf(true)));
        return jpaQuery;
    }

    public PagingVO<EmployeeBlackListVO> queryBlackListPaging(EmployeeBlackListQuery query) {
        JPAQuery<EmployeeBlackListVO> jpaQuery = this.getBlackListWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    private JPAQuery<EmployeeBlackListVO> getBlackListWhere(EmployeeBlackListQuery query) {
        JPAQuery<EmployeeBlackListVO> jpaQuery = this.getBlackListSelect();
        jpaQuery.where((Predicate)this.prdOrgPersonDO.deleteFlag.eq((Object)0));
        if (!ObjectUtils.isEmpty((Object)query.getEmployeeNo())) {
            jpaQuery.where((Predicate)this.employeeDO.employeeNo.eq((Object)query.getEmployeeNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPersonName())) {
            jpaQuery.where((Predicate)this.prdOrgPersonDO.personName.like(SqlUtil.toSqlLikeString(query.getPersonName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString6()) && !ObjectUtils.isEmpty((Object)query.getExtString9())) {
            jpaQuery.where((Predicate)this.employeeDO.extString6.eq((Object)query.getExtString6()));
            jpaQuery.where((Predicate)this.employeeDO.extString9.eq((Object)query.getExtString9()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApprStatus())) {
            jpaQuery.where((Predicate)this.prdOrgPersonDO.apprStatus.eq((Object)query.getApprStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            jpaQuery.where((Predicate)this.qdoOrg.id.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtString5())) {
            jpaQuery.where((Predicate)this.employeeDO.extString5.eq((Object)query.getExtString5()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEnrollDateStart()) && !ObjectUtils.isEmpty((Object)query.getEnrollDateEnd())) {
            jpaQuery.where((Predicate)this.employeeDO.enrollDate.between((Comparable)query.getEnrollDateStart(), (Comparable)query.getEnrollDateEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExtDate4Start()) && !ObjectUtils.isEmpty((Object)query.getExtDate4End())) {
            jpaQuery.where((Predicate)this.employeeDO.extDate4.between((Comparable)query.getExtDate4Start(), (Comparable)query.getExtDate4End()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getResourceStatus())) {
            jpaQuery.where((Predicate)this.employeeDO.resourceStatus.eq((Object)query.getResourceStatus()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.prdOrgPersonDO._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.prdOrgPersonDO, query.getOrders()));
        return jpaQuery;
    }

    public List<PrdOrgPersonVO> getByMobile(String recommPhone) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgPersonVO.class, (Expression[])new Expression[]{this.prdOrgPersonDO.id, this.prdOrgPersonDO.personName, this.prdOrgPersonDO.apprStatus, this.prdOrgPersonDO.mobile, this.prdOrgPersonDO.remark})).from((EntityPath)this.prdOrgPersonDO);
        List res = ((JPAQuery)((JPAQuery)jpaQuery.where((Predicate)this.prdOrgPersonDO.mobile.eq((Object)recommPhone))).where((Predicate)this.prdOrgPersonDO.deleteFlag.eq((Object)0))).fetch();
        return res;
    }

    public PrdOrgPersonDO queryByMobile(String mobile) {
        return (PrdOrgPersonDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.prdOrgPersonDO).from((EntityPath)this.prdOrgPersonDO)).where((Predicate)this.prdOrgPersonDO.mobile.eq((Object)mobile))).where((Predicate)this.prdOrgPersonDO.deleteFlag.eq((Object)0))).fetchFirst();
    }

    public PrdOrgPersonDO queryByIdNo(String idNo) {
        return (PrdOrgPersonDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.prdOrgPersonDO).from((EntityPath)this.prdOrgPersonDO)).where((Predicate)this.prdOrgPersonDO.idNo.eq((Object)idNo))).where((Predicate)this.prdOrgPersonDO.deleteFlag.eq((Object)0))).fetchFirst();
    }

    public PrdOrgPersonDO queryByEmail(String email) {
        return (PrdOrgPersonDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.prdOrgPersonDO).from((EntityPath)this.prdOrgPersonDO)).where((Predicate)this.prdOrgPersonDO.email.eq((Object)email))).where((Predicate)this.prdOrgPersonDO.deleteFlag.eq((Object)0))).fetchFirst();
    }

    public PrdOrgEmployeeDO findEmployeeByPersonId(Long personId) {
        return (PrdOrgEmployeeDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.employeeDO).from((EntityPath)this.employeeDO)).where((Predicate)this.employeeDO.personId.eq((Object)personId))).where((Predicate)this.employeeDO.deleteFlag.eq((Object)0))).fetchFirst();
    }

    public PrdOrgPersonDO findByKey(Long key) {
        return (PrdOrgPersonDO)this.prdOrgPersonRepo.getReferenceById(key);
    }

    public PrdOrgPersonDAO(PrdOrgPersonRepo prdOrgPersonRepo, JPAQueryFactory jpaQueryFactory) {
        this.prdOrgPersonRepo = prdOrgPersonRepo;
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

