/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.service;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.param.AuthUserIdQueryDTO;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.provider.SysUserPermissionRpcService;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonResPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonAccountService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonCertService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonEduExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonProjectExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonRewardPunishService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonWorkExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonEntryCheckVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgTenantEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSelectionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemUserRoleVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.RedisCacheUtil;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeRefConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgPersonConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgPersonRepo;
import com.elitesland.tw.tw5.server.prd.org.service.AsyncEmployeeServiceImpl;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemUserRoleRepo;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PrdOrgEmployeeServiceImpl
extends BaseServiceImpl
implements PrdOrgEmployeeService {
    private static final Logger log = LoggerFactory.getLogger(PrdOrgEmployeeServiceImpl.class);
    private final PrdOrgEmployeeDAO dao;
    private final PrdSystemUserRoleRepo prdSystemUserRoleRepo;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdSystemSelectionService service;
    private final AsyncEmployeeServiceImpl serviceAsync;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final ExcelUtil excelUtil;
    private final FileUtil fileUtil;
    private final CacheUtil cacheUtil;
    private final UserRpcService userRpcService;
    private final RedisCacheUtil redisCacheUtil;
    @Value(value="${tw5.shortcut.size}")
    private Integer shortcutSize = 5;
    @Autowired
    private TextEncryptor encryptor;
    @Autowired
    SysUserPermissionRpcService sysUserPermissionRpcService;
    @Autowired
    private SysUserRpcService sysUserRpcService;
    @Value(value="${tw5.user_default.password}")
    private String default_password = "111111";
    @Value(value="${tw5.user_default.role_id}")
    private Long default_role_id;
    @Value(value="${tw5.user_default.external_role_id}")
    private Long external_role_id;
    @Value(value="${tw5.sys_default.dimensionId}")
    private Long default_dimension_id;
    private final PrdOrgPersonRepo prdOrgPersonRepo;
    private final PersonEduExperienceService personEduExperienceService;
    private final PersonWorkExperienceService personWorkExperienceService;
    private final PersonProjectExperienceService personProjectExperienceService;
    private final PersonCertService personCertService;
    private final PersonAccountService personAccountService;
    private final CalAccountService calAccountService;
    private final PersonRewardPunishService personRewardPunishService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService;

    @Transactional
    public PrdOrgEmployeeVO saveTenantUser(PrdOrgTenantEmployeePayload payload) {
        String shortcutIds = this.getDefultShortcut();
        String aa = "" + (System.currentTimeMillis() + (long)((int)(Math.random() * 10.0)));
        String substring = aa.substring(aa.length() - 7);
        PrdOrgPersonDO pDO = new PrdOrgPersonDO();
        pDO.setUserName(payload.getAdminAccount());
        pDO.setPersonName(payload.getAdminAccount());
        pDO.setEnabled(true);
        pDO.setTenantId(Long.valueOf(payload.getTenantId()));
        this.dao.savePerson(pDO);
        PrdOrgEmployeeDO ado = new PrdOrgEmployeeDO();
        ado.setEmployeeNo(substring);
        ado.setHrStatus(SystemDefaultEnum.DefaultHrStatus.getCode());
        ado.setEmployeeName(payload.getAdminAccount());
        ado.setPersonId(pDO.getId());
        ado.setUserId(Long.valueOf(payload.getAdminUserId()));
        ado.setShortcutIds(shortcutIds);
        ado.setTenantId(Long.valueOf(payload.getTenantId()));
        ado.setBookId(1001L);
        ado = this.dao.save(ado);
        ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
        PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
        roleDO.setRoleId(this.default_role_id);
        roleDO.setUserId(ado.getUserId());
        userRoleDOS.add(roleDO);
        this.dao.saveUserRoleAll(userRoleDOS);
        return PrdOrgEmployeeConvert.INSTANCE.toVo(ado);
    }

    public List<String> queryUserRole(Long userId) {
        return this.prdSystemUserRoleRepo.queryUserRoleCodes(userId);
    }

    public List<PrdSystemUserRoleVO> queryUserListRole(List<Long> userIdList, List<String> roleCodeList) {
        return this.dao.queryUserListRole(userIdList, roleCodeList);
    }

    public ApiResult<OAuthToken> wxLogin(String code) {
        String wecom = this.qyWxCommunicationService.getWxuserinfo(code);
        if (!org.springframework.util.StringUtils.hasText((String)wecom)) {
            return ApiResult.fail((String)"\u5f53\u524d\u5e10\u53f7\u672a\u7ed1\u5b9a\uff0c\u8bf7\u767b\u5f55\u7ed1\u5b9a\u540e\u91cd\u8bd5\uff01");
        }
        PrdOrgEmployeeDO prdOrgEmployeeDO = this.dao.queryByWeComeId(wecom);
        if (ObjectUtils.isEmpty((Object)prdOrgEmployeeDO)) {
            return ApiResult.fail((String)"\u5f53\u524d\u5e10\u53f7\u672a\u7ed1\u5b9a\uff0c\u8bf7\u767b\u5f55\u7ed1\u5b9a\u540e\u91cd\u8bd5\uff01");
        }
        Long userId = prdOrgEmployeeDO.getUserId();
        String encrypt = this.encryptor.encrypt(userId.toString());
        AuthUserIdQueryDTO queryDTO = new AuthUserIdQueryDTO();
        queryDTO.setUserIdCypher(encrypt);
        ApiResult oAuthTokenApiResult = this.sysUserPermissionRpcService.authByUserId(queryDTO);
        return oAuthTokenApiResult;
    }

    public String getUserUUid() {
        Long userId = GlobalUtil.getLoginUserId();
        String uuid = UUID.randomUUID().toString();
        this.redisCacheUtil.add(uuid, userId, 3600L, TimeUnit.SECONDS);
        return uuid;
    }

    @Transactional
    public Map<String, Object> bindWecomId(String uuid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String userId = this.redisCacheUtil.get(uuid);
        if (org.springframework.util.StringUtils.hasText((String)userId)) {
            PrdOrgEmployeeVO employeeVO = this.dao.queryByUserId1(Long.parseLong(userId));
            String wecom = this.qyWxCommunicationService.getQyWxuserid(employeeVO.getMobile());
            if (!"".equals(wecom)) {
                this.dao.updateWecomId(employeeVO.getUserId(), wecom);
                result.put("ok", true);
            } else {
                result.put("ok", false);
                result.put("reason", "notFind");
            }
        } else {
            result.put("ok", false);
            result.put("reason", "timeOut");
        }
        return result;
    }

    public List<PrdOrgEmployeeRefVO> queryLowerUserList(Long orgId, Long userId) {
        return this.dao.queryLowerUserList(orgId, userId);
    }

    public List<PrdOrgEmployeeRefVO> queryParentUsers(Long dimensionId, Long userId) {
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        return this.dao.queryParentUsers(dimensionId, userId);
    }

    public List<PrdOrgEmployeeRefVO> queryAllOrgRefByUserId(Long userId) {
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        return this.dao.queryAllOrgRefByUserId(userId);
    }

    public List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId, Long userId) {
        userId = userId == null ? GlobalUtil.getLoginUserId() : userId;
        return this.dao.queryLowListByKey(orgId, userId);
    }

    public List<PrdOrgEmployeeRefVO> queryLowChildListByKey(Long orgId, Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryAllOrgRef(orgId);
        if (prdOrgEmployeeRefVOS == null || prdOrgEmployeeRefVOS.size() == 0) {
            return prdOrgEmployeeRefVOS;
        }
        userId = userId == null ? GlobalUtil.getLoginUserId() : userId;
        HashSet<Long> userIds = new HashSet<Long>();
        this.getChildUserIds(prdOrgEmployeeRefVOS, userId, userIds);
        if (userIds.size() == 0) {
            return new ArrayList<PrdOrgEmployeeRefVO>();
        }
        return this.dao.findAllByUserIds(userIds);
    }

    void getChildUserIds(List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Long parenId, Set<Long> userIds) {
        List<Long> collect = prdOrgEmployeeRefVOS.stream().filter(vo -> parenId.equals(vo.getParentId()) && !parenId.equals(vo.getUserId()) && parenId.longValue() != vo.getUserId().longValue() && vo.getUserId() != 0L).map(PrdOrgEmployeeRefVO::getUserId).collect(Collectors.toList());
        if (collect.size() > 0) {
            userIds.addAll(collect);
            collect.forEach(userId -> this.getChildUserIds(prdOrgEmployeeRefVOS, (Long)userId, userIds));
        }
    }

    public List<PrdOrgEmployeeRefVO> queryAllParentUsers(Long dimensionId, Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryAllDimensionRef(dimensionId);
        if (prdOrgEmployeeRefVOS == null || prdOrgEmployeeRefVOS.size() == 0) {
            return null;
        }
        userId = userId == null ? GlobalUtil.getLoginUserId() : userId;
        HashSet<Long> userIds = new HashSet<Long>();
        this.getParentUserIds(prdOrgEmployeeRefVOS, userId, userIds);
        if (userIds.size() == 0) {
            return null;
        }
        return this.dao.findAllByUserIds(userIds);
    }

    void getParentUserIds(List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Long userId, Set<Long> userIds) {
        List<Long> collect = prdOrgEmployeeRefVOS.stream().filter(vo -> vo.getUserId().equals(userId) && vo.getParentId() != null && vo.getParentId() != 0L && !vo.getUserId().equals(vo.getParentId())).map(PrdOrgEmployeeRefVO::getParentId).distinct().collect(Collectors.toList());
        if (collect.size() > 0) {
            userIds.addAll(collect);
            collect.forEach(parentId -> this.getParentUserIds(prdOrgEmployeeRefVOS, (Long)parentId, userIds));
        }
    }

    @Transactional
    public PrdOrgEmployeeVO insert(PrdOrgEmployeePayload payload) {
        String shortcutIds = this.getDefultShortcut();
        PrdOrgEmployeeDO ado = this.insertEmployee(payload, shortcutIds);
        this.checkEmployeeRef(payload.getOrgId(), payload.getParentId(), ado.getUserId());
        PrdOrgEmployeeRefDO refDo = new PrdOrgEmployeeRefDO();
        refDo.setJoinDate(LocalDate.now());
        refDo.setOrgId(payload.getOrgId());
        refDo.setUserId(ado.getUserId());
        refDo.setParentId(payload.getParentId());
        refDo.setIsDefault(0);
        this.dao.saveRef(refDo);
        return PrdOrgEmployeeConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    public Long update(PrdOrgEmployeePayload payload) {
        PrdOrgEmployeeVO eDo = this.dao.queryByKey(payload.getId());
        String subType = payload.getSubType();
        if (subType.equals("system") || subType.equals("person")) {
            if (subType.equals("system")) {
                SysUserUpdateParam param = new SysUserUpdateParam();
                param.setEmail(payload.getEmail());
                param.setEnabled(payload.getEnabled());
                param.setId(eDo.getUserId());
                param.setLastName(payload.getLastName());
                param.setFirstName(payload.getEmployeeName());
                param.setMobile(payload.getMobile());
                this.sysUserRpcService.update(param);
                if (!eDo.getEmployeeName().equals(payload.getEmployeeName())) {
                    this.dao.update(payload);
                }
                if (payload.getRoleIds() != null) {
                    if (payload.getRoleIds().size() == 0) {
                        this.dao.deleteRolesByUserId(eDo.getUserId());
                    } else {
                        ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
                        for (Long roleId : payload.getRoleIds()) {
                            PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                            roleDO.setRoleId(roleId);
                            roleDO.setUserId(eDo.getUserId());
                            userRoleDOS.add(roleDO);
                        }
                        this.dao.deleteRolesByUserId(eDo.getUserId());
                        this.dao.saveUserRoleAll(userRoleDOS);
                    }
                }
            }
            payload.setPersonId(eDo.getPersonId());
            this.dao.updatePerson(payload);
        }
        if (subType.equals("company")) {
            PrdOrgEmployeeDO employeeDO = this.dao.queryByCode(payload.getEmployeeNo());
            if (employeeDO != null && employeeDO.getId().longValue() != payload.getId().longValue()) {
                throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
            }
            if (org.springframework.util.StringUtils.hasText((String)payload.getJobs()) && !eDo.getJobs().equals(payload.getJobs())) {
                BigDecimal eqvaRatio = this.cacheUtil.queryEqvaRatioByJob(payload.getJobs());
                payload.setEqvaRatio(eqvaRatio);
                PrdOrgEmployeeEqvaRatioPayload employeeEqvaRatioPayload = new PrdOrgEmployeeEqvaRatioPayload();
                employeeEqvaRatioPayload.setEqvaRatio(eqvaRatio);
                employeeEqvaRatioPayload.setStartDate(LocalDate.now());
                employeeEqvaRatioPayload.setUserId(eDo.getUserId());
                this.employeeEqvaRatioService.upsertEqvaRatio(employeeEqvaRatioPayload);
            }
            this.dao.update(payload);
        }
        return 0L;
    }

    @Transactional
    public Long updateEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads) {
        ArrayList<PrdOrgEmployeeRefDO> refDOS = new ArrayList<PrdOrgEmployeeRefDO>();
        int defaultNum = 0;
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (PrdOrgEmployeeRefPayload payload : payloads) {
            Long userId = (Long)map.get(payload.getOrgId());
            if (userId != null) {
                throw TwException.error("", "\u5458\u5de5\u7ec4\u7ec7\u4fe1\u606f\u91cd\u590d");
            }
            map.put(payload.getOrgId(), payload.getUserId());
            Long parentId = payload.getParentId();
            if (!ObjectUtils.isEmpty((Object)parentId) && parentId != 0L && parentId.longValue() == payload.getUserId().longValue()) {
                throw TwException.error("", "\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u5b58\u5728\u4e0d\u5408\u7406\u64cd\u4f5c");
            }
            if (payload.getIsDefault() == 0) {
                ++defaultNum;
            }
            PrdOrgEmployeeRefDO ado = PrdOrgEmployeeRefConvert.INSTANCE.toDo(payload);
            if (payload.getId() == null || payload.getId() == 0L) {
                ado.setJoinDate(LocalDate.now());
            }
            refDOS.add(ado);
        }
        if (defaultNum != 1) {
            throw TwException.error("", "\u5458\u5de5\u9ed8\u8ba4\u7ec4\u7ec7\u63d0\u4ea4\u5f02\u5e38");
        }
        this.dao.saveAllRef(refDOS);
        return 0L;
    }

    public List<PrdOrgEmployeeVO> queryList(PrdOrgEmployeeQuery query) {
        List<PrdOrgEmployeeVO> prdOrgEmployeeVOS = this.dao.queryList(query);
        prdOrgEmployeeVOS.forEach(vo -> vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs())));
        return prdOrgEmployeeVOS;
    }

    public PrdOrgEmployeeVO queryByKey(Long key) {
        PrdOrgEmployeeVO vo = this.dao.queryByKey(key);
        vo.setRoleDatas(this.dao.queryUserRoles(vo.getUserId()));
        vo.setDataRefVOS(this.dao.queryOrgListByKey(vo.getUserId()));
        vo.setIdValidDatas(this.fileUtil.getFileDatas(vo.getIdValidCodes()));
        vo.setHeadDatas(this.fileUtil.getFileDatas(vo.getHeadCodes()));
        vo.setResourceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
        vo.setHrName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));
        return vo;
    }

    public PrdOrgEmployeeVO queryByUserId(Long userId) {
        PrdOrgEmployeeVO vo = this.dao.queryByUserId1(userId);
        return vo;
    }

    public List<PrdOrgEmployeeVO> queryByUserIdIn(List<Long> userIds) {
        return this.dao.queryByUserIdIn(userIds);
    }

    public Set<Long> queryParentIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryDefaultOrgEmployeeRef(this.default_dimension_id);
        HashSet<Long> parentIds = new HashSet<Long>();
        this.getParentIds(userId, prdOrgEmployeeRefVOS, parentIds);
        return parentIds;
    }

    void getParentIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> parentIds) {
        PrdOrgEmployeeRefVO refVO2;
        Optional<PrdOrgEmployeeRefVO> first = prdOrgEmployeeRefVOS.stream().filter(refVO -> refVO.getUserId().equals(userId)).findFirst();
        if (first.isPresent() && (refVO2 = first.get()).getParentId() != null && !refVO2.getParentId().equals(0) && !refVO2.getParentId().equals(refVO2.getUserId())) {
            parentIds.add(refVO2.getParentId());
            this.getParentIds(refVO2.getParentId(), prdOrgEmployeeRefVOS, parentIds);
        }
    }

    public PagingVO<PrdOrgEmployeeVO> paging(PrdOrgEmployeeQuery query) {
        PagingVO<PrdOrgEmployeeVO> evo = this.dao.queryPaging(query);
        List vos = evo.getRecords();
        for (PrdOrgEmployeeVO vo : vos) {
            vo.setResourceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeResource.getCode(), vo.getResourceStatus()));
            vo.setHrName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeHr.getCode(), vo.getHrStatus()));
            vo.setSexName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
            vo.setIdTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeIdType.getCode(), vo.getIdType()));
            vo.setJobsName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeJobs.getCode(), vo.getJobs()));
        }
        return evo;
    }

    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        ArrayList<Long> personIds = new ArrayList<Long>();
        List<PrdOrgEmployeeVO> employeeVOS = this.dao.queryEmployeeList(keys);
        for (PrdOrgEmployeeVO eDo : employeeVOS) {
            userIds.add(eDo.getUserId());
            personIds.add(eDo.getPersonId());
        }
        this.dao.deleteRefSoft(userIds);
        this.dao.deleteSoft(keys);
        this.dao.deletePersonSoft(personIds);
        this.sysUserRpcService.deleteBatch(userIds);
        return true;
    }

    public boolean resetEmployeePawword(Long userId) {
        this.sysUserRpcService.changePasswordNoSec(userId, this.default_password);
        return true;
    }

    public void downloadPlus(HttpServletResponse response, PrdOrgEmployeeQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/employeeBatch.xlsx");
        List list = new ArrayList();
        if (org.springframework.util.StringUtils.hasText((String)query.getDownloadType()) && query.getDownloadType().equals("data")) {
            PagingVO<PrdOrgEmployeeVO> evo = this.paging(query);
            list = evo.getRecords();
        }
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u5458\u5de5\u6570\u636e");
            this.excelUtil.generateRangeList(batchProjectSheet, 3, 1, "LOV", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 8, 1, "LOV", 2, "C");
            this.excelUtil.generateRangeList(batchProjectSheet, 11, 1, "\u516c\u53f8\u6570\u636e", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 13, 1, "\u7ec4\u7ec7\u6570\u636e", 2, "A");
            this.excelUtil.generateRangeList(batchProjectSheet, 17, 1, "\u5c97\u4f4d\u6570\u636e", 2, "A");
            if (batchProjectSheet != null) {
                if (list.size() > 0) {
                    int nextRow = 1;
                    for (PrdOrgEmployeeVO dataPayload : list) {
                        XSSFRow row = batchProjectSheet.createRow(nextRow);
                        this.excelUtil.setCellValue((Row)row, 0, nextRow);
                        this.excelUtil.setCellValue((Row)row, 1, dataPayload.getUserName());
                        this.excelUtil.setCellValue((Row)row, 2, dataPayload.getPersonName());
                        this.excelUtil.setCellValue((Row)row, 3, dataPayload.getSexName());
                        this.excelUtil.setCellFormulas((Row)row, 4, "VLOOKUP(D:rowNo,LOV!A:B,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 5, dataPayload.getEmail());
                        this.excelUtil.setCellValue((Row)row, 6, dataPayload.getMobile());
                        this.excelUtil.setCellValue((Row)row, 7, dataPayload.getEmployeeNo());
                        this.excelUtil.setCellValue((Row)row, 8, dataPayload.getIdTypeName());
                        this.excelUtil.setCellFormulas((Row)row, 9, "VLOOKUP(I:rowNo,LOV!C:D,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 10, dataPayload.getIdNo());
                        this.excelUtil.setCellValue((Row)row, 11, dataPayload.getCompanyName());
                        this.excelUtil.setCellFormulas((Row)row, 12, "VLOOKUP(L:rowNo,\u516c\u53f8\u6570\u636e!A:B,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 13, dataPayload.getOrgName());
                        this.excelUtil.setCellFormulas((Row)row, 14, "VLOOKUP(N:rowNo,\u7ec4\u7ec7\u6570\u636e!A:B,2,FALSE)");
                        this.excelUtil.setCellValue((Row)row, 15, dataPayload.getParentName());
                        this.excelUtil.setCellValue((Row)row, 16, dataPayload.getParentNo());
                        this.excelUtil.setCellValue((Row)row, 17, dataPayload.getJobsName());
                        this.excelUtil.setCellFormulas((Row)row, 18, "VLOOKUP(R:rowNo,\u5c97\u4f4d\u6570\u636e!A:B,2,FALSE)");
                        ++nextRow;
                    }
                } else {
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 4, "VLOOKUP(D:rowNo,LOV!A:B,2,FALSE)");
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 9, "VLOOKUP(I:rowNo,LOV!C:D,2,FALSE)");
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 12, "VLOOKUP(L:rowNo,\u516c\u53f8\u6570\u636e!A:B,2,FALSE)");
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 14, "VLOOKUP(N:rowNo,\u7ec4\u7ec7\u6570\u636e!A:B,2,FALSE)");
                    this.excelUtil.setColumnFormulas(batchProjectSheet, 18, "VLOOKUP(R:rowNo,\u5c97\u4f4d\u6570\u636e!A:B,2,FALSE)");
                }
            }
            List<PrdOrgOrganizationRefVO> orgList = this.daoOrg.queryAll(null, null, null);
            Sheet orgSheet = workbook.getSheet("\u7ec4\u7ec7\u6570\u636e");
            if (!CollectionUtils.isEmpty(orgList) && orgSheet != null) {
                int nextRow = 1;
                for (PrdOrgOrganizationRefVO org : orgList) {
                    Long addrNo = org.getOrgId();
                    String addrName = org.getOrgName();
                    if (addrNo == null || !org.springframework.util.StringUtils.hasText((String)addrName)) continue;
                    Row row = orgSheet.createRow(nextRow);
                    this.excelUtil.setCellValue(row, 0, addrName);
                    this.excelUtil.setCellValue(row, 1, addrNo);
                    ++nextRow;
                }
            }
            List jobList = this.service.selectByCondition(FunctionSelectionEnum.EmployeeJobs.getCode());
            Sheet jobSheet = workbook.getSheet("\u5c97\u4f4d\u6570\u636e");
            if (!CollectionUtils.isEmpty((Collection)jobList) && jobSheet != null) {
                int nextRow = 1;
                for (PrdSystemSelectionVO job : jobList) {
                    String selectionValue = job.getSelectionValue();
                    String selectionName = job.getSelectionName();
                    if (!org.springframework.util.StringUtils.hasText((String)selectionName) || !org.springframework.util.StringUtils.hasText((String)selectionValue)) continue;
                    Row row = jobSheet.createRow(nextRow);
                    this.excelUtil.setCellValue(row, 0, selectionName);
                    this.excelUtil.setCellValue(row, 1, selectionValue);
                    ++nextRow;
                }
            }
            List businessCustomerSimpleVOS = this.businessCustomerInfoService.listSimple(BusinessPartnerIdentityEnum.INNER.getCode(), null);
            Sheet companySheet = workbook.getSheet("\u516c\u53f8\u6570\u636e");
            if (!CollectionUtils.isEmpty((Collection)businessCustomerSimpleVOS) && companySheet != null) {
                int nextRow = 1;
                for (BusinessCustomerSimpleVO businessCustomerSimpleVO : businessCustomerSimpleVOS) {
                    Long selectionValue = businessCustomerSimpleVO.getBookId();
                    String selectionName = businessCustomerSimpleVO.getCustomerName();
                    if (!org.springframework.util.StringUtils.hasText((String)selectionName) || selectionValue == null) continue;
                    Row row = companySheet.createRow(nextRow);
                    this.excelUtil.setCellValue(row, 0, selectionName);
                    this.excelUtil.setCellValue(row, 1, "" + selectionValue);
                    ++nextRow;
                }
            }
            String fileName = "\u5458\u5de5\u6279\u91cf\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    public boolean importEmployees(MultipartFile file) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u5458\u5de5\u6570\u636e");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<PrdOrgEmployeePayload> employeePayloads = new ArrayList<PrdOrgEmployeePayload>();
        ArrayList<String> employeeCodes = new ArrayList<String>();
        ArrayList<String> emails = new ArrayList<String>();
        ArrayList<Object> mobiles = new ArrayList<Object>();
        ArrayList<String> parentNos = new ArrayList<String>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            String parentNo;
            String orgId;
            Row row = sheet.getRow(i);
            PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
            String email = ExcelUtil.getCellFormatValue(row.getCell(5));
            if (org.springframework.util.StringUtils.hasText((String)email)) {
                if (emails.contains(email)) {
                    throw TwException.error("", "\u90ae\u7bb1\u4e0d\u53ef\u91cd\u590d");
                }
            } else {
                throw TwException.error("", "\u90ae\u7bb1\u4e0d\u53ef\u4e3a\u7a7a");
            }
            emails.add(email);
            employeePayload.setUserName(email);
            employeePayload.setEmail(email);
            String mobile = ExcelUtil.getCellFormatValue(row.getCell(6));
            if (org.springframework.util.StringUtils.hasText((String)mobile)) {
                if (mobiles.contains(mobile)) {
                    throw TwException.error("", "\u7535\u8bdd\u4e0d\u53ef\u91cd\u590d");
                }
            } else {
                throw TwException.error("", "\u7535\u8bdd\u4e0d\u53ef\u4e3a\u7a7a");
            }
            mobiles.add(mobile);
            employeePayload.setMobile(mobile);
            employeePayload.setEmployeeName(ExcelUtil.getCellFormatValue(row.getCell(2)));
            employeePayload.setPersonName(employeePayload.getEmployeeName());
            employeePayload.setSex(ExcelUtil.getCellFormatValue(row.getCell(4)));
            String code = ExcelUtil.getCellFormatValue(row.getCell(7));
            if (org.springframework.util.StringUtils.hasText((String)code)) {
                if (employeeCodes.contains(code)) {
                    throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
                }
            } else {
                throw TwException.error("", "\u5458\u5de5\u7f16\u53f7\u4e0d\u53ef\u4e3a\u7a7a");
            }
            employeeCodes.add(code);
            employeePayload.setEmployeeNo(code);
            employeePayload.setIdType(ExcelUtil.getCellFormatValue(row.getCell(9)));
            employeePayload.setIdNo(ExcelUtil.getCellFormatValue(row.getCell(10)));
            String companyId = ExcelUtil.getCellFormatValue(row.getCell(12));
            if (StringUtil.isInteger(companyId)) {
                employeePayload.setBookId(Long.valueOf(companyId));
            }
            if (StringUtil.isInteger(orgId = ExcelUtil.getCellFormatValue(row.getCell(14)))) {
                employeePayload.setOrgId(Long.valueOf(orgId));
            }
            if (org.springframework.util.StringUtils.hasText((String)(parentNo = ExcelUtil.getCellFormatValue(row.getCell(16))))) {
                parentNos.add(parentNo);
                employeePayload.setParentNo(parentNo);
            }
            employeePayload.setJobs(ExcelUtil.getCellFormatValue(row.getCell(18)));
            employeePayloads.add(employeePayload);
        }
        HashMap<String, Long> parentMap = new HashMap<String, Long>();
        HashMap<Long, String> employeeMap = new HashMap<Long, String>();
        String shortcutIds = this.getDefultShortcut();
        ArrayList<PrdOrgEmployeeRefDO> refDOs = new ArrayList<PrdOrgEmployeeRefDO>();
        for (PrdOrgEmployeePayload employeePayload : employeePayloads) {
            PrdOrgEmployeeDO edo = this.insertEmployee(employeePayload, shortcutIds);
            if (parentNos.contains(edo.getEmployeeNo())) {
                parentMap.put(edo.getEmployeeNo(), edo.getUserId());
                parentNos.remove(edo.getEmployeeNo());
            }
            PrdOrgEmployeeRefDO refDo2 = new PrdOrgEmployeeRefDO();
            refDo2.setJoinDate(LocalDate.now());
            refDo2.setOrgId(employeePayload.getOrgId());
            refDo2.setUserId(edo.getUserId());
            refDo2.setIsDefault(0);
            refDOs.add(refDo2);
            employeeMap.put(edo.getUserId(), employeePayload.getParentNo());
        }
        List<PrdOrgEmployeeDO> employeeList = this.dao.queryListByCode(parentNos);
        employeeList.forEach(employeeDO -> parentMap.put(employeeDO.getEmployeeNo(), employeeDO.getUserId()));
        refDOs.forEach(refDo -> refDo.setParentId((Long)parentMap.get(employeeMap.get(refDo.getUserId()))));
        this.dao.saveAllRef(refDOs);
        return true;
    }

    @Transactional
    public boolean deleteOrgRefSoft(Long userId, List<Long> orgIds) {
        long num = this.dao.deleteEmployeeRefSoft(userId, orgIds);
        if (num > (long)orgIds.size()) {
            throw TwException.error("", "\u5458\u5de5\u9ed8\u8ba4\u7ec4\u7ec7\u4e0d\u53ef\u88ab\u79fb\u9664");
        }
        return true;
    }

    @Transactional
    public boolean deleteOrgRefSoftAll(Long userId, LocalDate date) {
        long num = this.dao.deleteEmployeeRefSoftAll(userId, date);
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public boolean updateWecomId(List<Long> userIds) {
        List<PrdOrgEmployeeVO> employeeVOS = this.dao.queryMobileList(userIds);
        for (PrdOrgEmployeeVO employeeVO : employeeVOS) {
            this.serviceAsync.queryWecomId(employeeVO);
        }
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public boolean unbindWecomId(List<Long> userIds) {
        for (Long userId : userIds) {
            this.dao.updateWecomId(userId, "");
        }
        return true;
    }

    public Map<Long, Long> getV4AndV5UserIds() {
        HashMap<Long, Long> userMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5UserIds = this.dao.getV4AndV5UserIds();
        for (Map<String, Object> v4AndV5UserId : v4AndV5UserIds) {
            Long userId = (Long)v4AndV5UserId.get("userId");
            Long userIdV4 = (Long)v4AndV5UserId.get("userIdV4");
            if (userId == null || userIdV4 == null) continue;
            userMap.put(userIdV4, userId);
        }
        return userMap;
    }

    PrdOrgEmployeeDO insertEmployee(PrdOrgEmployeePayload payload, String shortcutIds) {
        if (this.dao.queryByCode(payload.getEmployeeNo()) == null) {
            payload.setLastName(payload.getEmployeeName());
            String wecom = this.qyWxCommunicationService.getQyWxuserid(payload.getMobile());
            UserCreateDTO param = new UserCreateDTO();
            param.setUsername(payload.getUserName());
            param.setPassword(this.default_password);
            param.setFullName(payload.getEmployeeName());
            param.setMobile(payload.getMobile());
            param.setEmail(payload.getEmail());
            param.setEnabled(payload.getEnabled());
            param.setSourceType("sys");
            ApiResult obj = this.userRpcService.upsert(param);
            if (obj == null || obj.getCode() != 200) {
                throw TwException.error("" + obj.getCode(), obj.getMsg());
            }
            PrdOrgPersonDO pDO = PrdOrgPersonConvert.INSTANCE.toDo(payload);
            pDO = this.dao.savePerson(pDO);
            PrdOrgEmployeeDO ado = PrdOrgEmployeeConvert.INSTANCE.toDo(payload);
            ado.setWecomId(wecom);
            ado.setPersonId(pDO.getId());
            ado.setUserId(Long.valueOf("" + obj.getData()));
            ado.setShortcutIds(shortcutIds);
            ado.setSortIndex(100000);
            BigDecimal eqvaRatio = this.cacheUtil.queryEqvaRatioByJob(payload.getJobs());
            ado.setEqvaRatio(eqvaRatio);
            ado = this.dao.save(ado);
            ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
            if (payload.getRoleIds() != null && payload.getRoleIds().size() > 0) {
                for (Long roleId : payload.getRoleIds()) {
                    PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                    roleDO.setRoleId(roleId);
                    roleDO.setUserId(ado.getUserId());
                    userRoleDOS.add(roleDO);
                }
            } else {
                PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                roleDO.setRoleId(this.default_role_id);
                roleDO.setUserId(ado.getUserId());
                userRoleDOS.add(roleDO);
            }
            this.dao.saveUserRoleAll(userRoleDOS);
            CalAccountPayload accountPayload = new CalAccountPayload();
            accountPayload.setAuType(CalAccTypeEnum.RES.getCode());
            accountPayload.setAuId(ado.getUserId());
            accountPayload.setLedgerName(ado.getEmployeeName());
            accountPayload.setLedgerNo(ado.getEmployeeNo());
            this.calAccountService.insert(accountPayload);
            return ado;
        }
        throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
    }

    void checkEmployeeRef(Long orgId, Long parentId, Long userId) {
        PrdOrgEmployeeRefDO employeeRefDO;
        if (!ObjectUtils.isEmpty((Object)parentId) && parentId != 0L && (employeeRefDO = this.dao.queryByOrgIdAndUserId(orgId, parentId)) != null && employeeRefDO.getParentId() != 0L && employeeRefDO.getParentId().longValue() == userId.longValue()) {
            throw TwException.error("", "\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u5b58\u5728\u4e0d\u5408\u7406\u64cd\u4f5c");
        }
    }

    String getDefultShortcut() {
        List<Long> shortcutIds = this.dao.getShortcuts(this.shortcutSize);
        return StringUtils.join((Object[])shortcutIds.toArray(), (String)",");
    }

    public Set<Long> queryOneSubordinatesIdsByUserId(Long userId) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryDefaultOrgEmployeeRef(this.default_dimension_id);
        HashSet<Long> subordinatesIds = new HashSet<Long>();
        this.getOneSubordinatesIds(userId, prdOrgEmployeeRefVOS, subordinatesIds);
        return subordinatesIds;
    }

    void getOneSubordinatesIds(Long userId, List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS, Set<Long> subordinatesIds) {
        Set collect = prdOrgEmployeeRefVOS.stream().filter(refVO -> refVO.getParentId() != null && refVO.getParentId().equals(userId)).map(PrdOrgEmployeeRefVO::getUserId).collect(Collectors.toSet());
        subordinatesIds.addAll(collect);
    }

    public PrdOrgEmployeeRefVO queryEmployeeRef(Long userId) {
        return this.dao.queryEmployeeRef(userId);
    }

    public void updateBlackList(Long id) {
        this.dao.updateBlackList(id);
    }

    @Transactional
    public PrdOrgEmployeeVO insertNew(PrdOrgEmployeePayload payload) {
        String shortcutIds = this.getDefultShortcut();
        PrdOrgEmployeeDO ado = this.insertEmployeeNew(payload, shortcutIds);
        this.checkEmployeeRef(payload.getOrgId(), payload.getParentId(), ado.getUserId());
        PrdOrgEmployeeRefDO refDo = new PrdOrgEmployeeRefDO();
        refDo.setJoinDate(LocalDate.now());
        refDo.setOrgId(payload.getOrgId());
        refDo.setUserId(ado.getUserId());
        refDo.setParentId(payload.getParentId());
        refDo.setIsDefault(0);
        this.dao.saveRef(refDo);
        return PrdOrgEmployeeConvert.INSTANCE.toVo(ado);
    }

    PrdOrgEmployeeDO insertEmployeeNew(PrdOrgEmployeePayload payload, String shortcutIds) {
        PrdOrgPersonDO personSaveDO;
        if (org.springframework.util.StringUtils.hasLength((String)payload.getEmployeeNo()) && this.dao.queryByCode(payload.getEmployeeNo()) != null) {
            throw TwException.error("", "\u5458\u5de5\u7f16\u53f7\u91cd\u590d");
        }
        payload.setLastName(payload.getPersonName());
        payload.setEmployeeName(payload.getPersonName());
        UserCreateDTO param = new UserCreateDTO();
        param.setId(payload.getUserId());
        param.setUsername(payload.getUserName());
        param.setPassword(this.default_password);
        param.setFullName(payload.getPersonName());
        param.setMobile(payload.getMobile());
        param.setEmail(payload.getEmail());
        param.setEnabled(payload.getEnabled());
        param.setSourceType("sys");
        ApiResult obj = this.userRpcService.upsert(param);
        if (obj == null || obj.getCode() != 200) {
            throw TwException.error("" + obj.getCode(), obj.getMsg());
        }
        if (Objects.equals(payload.getExtString6(), "EXTERNAL_RES")) {
            personSaveDO = (PrdOrgPersonDO)this.prdOrgPersonRepo.getReferenceById(payload.getPersonId());
            if (payload.getEmail() != null) {
                personSaveDO.setEmail(payload.getEmail());
            }
            if (payload.getMobile() != null) {
                personSaveDO.setMobile(payload.getMobile());
            }
            if (payload.getUserName() != null) {
                personSaveDO.setUserName(payload.getUserName());
            }
            if (payload.getEnabled() != null) {
                personSaveDO.setEnabled(payload.getEnabled());
            }
        } else {
            personSaveDO = PrdOrgPersonConvert.INSTANCE.toDo(payload);
            personSaveDO.setId(payload.getPersonId());
        }
        this.dao.savePerson(personSaveDO);
        PrdOrgEmployeeDO ado = PrdOrgEmployeeConvert.INSTANCE.toDo(payload);
        ado.setPersonId(payload.getPersonId());
        ado.setUserId(Long.valueOf("" + obj.getData()));
        ado.setShortcutIds(shortcutIds);
        BigDecimal eqvaRatio = this.cacheUtil.queryEqvaRatioByJob(payload.getJobs());
        ado.setEqvaRatio(eqvaRatio);
        String resNo = this.generateSeqNum("EMPLOYEE_NO", new String[0]);
        ado.setResNo(resNo);
        ado.setProcInstId(null);
        ado = this.dao.save(ado);
        ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
        if (payload.getRoleIds() != null && payload.getRoleIds().size() > 0) {
            for (Long roleId : payload.getRoleIds()) {
                PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                roleDO.setRoleId(roleId);
                roleDO.setUserId(ado.getUserId());
                userRoleDOS.add(roleDO);
            }
        } else {
            PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
            if (Objects.equals(payload.getExtString6(), "EXTERNAL_RES")) {
                roleDO.setRoleId(this.external_role_id);
            } else {
                roleDO.setRoleId(this.default_role_id);
            }
            roleDO.setUserId(ado.getUserId());
            userRoleDOS.add(roleDO);
        }
        this.dao.saveUserRoleAll(userRoleDOS);
        if (ObjectUtils.isEmpty((Object)payload.getUserId())) {
            CalAccountPayload accountPayload = new CalAccountPayload();
            accountPayload.setAuType(CalAccTypeEnum.RES.getCode());
            accountPayload.setAuId(ado.getUserId());
            accountPayload.setLedgerName(ado.getEmployeeName());
            accountPayload.setLedgerNo(resNo);
            this.calAccountService.insert(accountPayload);
        }
        return ado;
    }

    @Transactional
    public Long updateNew(PersonResPayload resPayload) {
        PrdOrgEmployeeDO employeeDO;
        PrdOrgEmployeePayload payload = resPayload.getPrdOrgEmployeePayload();
        PrdOrgEmployeeVO eDo = this.dao.queryByKey(payload.getId());
        Long personId = eDo.getPersonId();
        if (payload.getEmployeeNo() != null && (employeeDO = this.dao.queryByCode(payload.getEmployeeNo())) != null && employeeDO.getId().longValue() != payload.getId().longValue()) {
            throw TwException.error("", "\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d");
        }
        SysUserUpdateParam param = new SysUserUpdateParam();
        param.setEmail(payload.getEmail());
        param.setEnabled(payload.getEnabled());
        param.setId(eDo.getUserId());
        param.setLastName(payload.getLastName());
        param.setFirstName(payload.getEmployeeName());
        param.setMobile(payload.getMobile());
        this.sysUserRpcService.update(param);
        if (payload.getRoleIds() != null) {
            if (payload.getRoleIds().size() == 0) {
                this.dao.deleteRolesByUserId(eDo.getUserId());
            } else {
                ArrayList<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<PrdSystemUserRoleDO>();
                for (Long roleId : payload.getRoleIds()) {
                    PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                    roleDO.setRoleId(roleId);
                    roleDO.setUserId(eDo.getUserId());
                    userRoleDOS.add(roleDO);
                }
                this.dao.deleteRolesByUserId(eDo.getUserId());
                this.dao.saveUserRoleAll(userRoleDOS);
            }
        }
        payload.setPersonId(personId);
        this.dao.updatePerson(payload);
        if (!eDo.getJobs().equals(payload.getJobs())) {
            BigDecimal eqvaRatio = this.cacheUtil.queryEqvaRatioByJob(payload.getJobs());
            payload.setEqvaRatio(eqvaRatio);
            PrdOrgEmployeeEqvaRatioPayload employeeEqvaRatioPayload = new PrdOrgEmployeeEqvaRatioPayload();
            employeeEqvaRatioPayload.setEqvaRatio(eqvaRatio);
            employeeEqvaRatioPayload.setStartDate(LocalDate.now());
            employeeEqvaRatioPayload.setUserId(eDo.getUserId());
            this.employeeEqvaRatioService.upsertEqvaRatio(employeeEqvaRatioPayload);
        }
        this.dao.update(payload);
        this.dao.updateProcessDate(payload);
        List eduExperienceVOList = resPayload.getEduExperienceVOList();
        this.personEduExperienceService.saveAll(eduExperienceVOList, personId);
        List workExperienceVOList = resPayload.getWorkExperienceVOList();
        this.personWorkExperienceService.saveAll(workExperienceVOList, personId);
        List projectExperienceVOList = resPayload.getProjectExperienceVOList();
        this.personProjectExperienceService.saveAll(projectExperienceVOList, personId);
        List certVOList = resPayload.getCertVOList();
        this.personCertService.saveAll(certVOList, personId);
        List personAccountVOList = resPayload.getPersonAccountVOList();
        this.personAccountService.saveAll(personAccountVOList, personId);
        List personRewardPunishVOList = resPayload.getPersonRewardPunishVOList();
        this.personRewardPunishService.saveAll(personRewardPunishVOList, personId);
        return 0L;
    }

    public Set<Long> queryParentIdByIds(List<Long> userIds) {
        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.dao.queryParentIdByIds(userIds);
        HashSet<Long> parentIds = new HashSet<Long>();
        if (prdOrgEmployeeRefVOS == null) {
            return null;
        }
        for (PrdOrgEmployeeRefVO prdOrgEmployeeRefVO : prdOrgEmployeeRefVOS) {
            parentIds.add(prdOrgEmployeeRefVO.getParentId());
        }
        return parentIds;
    }

    public List<PrdOrgEmployeeVO> queryByEnrollDate(LocalDate localDate3) {
        Assert.notNull((Object)localDate3, (String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        List<PrdOrgEmployeeVO> resList = this.dao.queryByEnrollDate(localDate3);
        for (PrdOrgEmployeeVO prdOrgEmployeeVO : resList) {
            List<PrdOrgDataRefVO> prdOrgDataRefVOS = this.dao.queryDefOrgListByKey(prdOrgEmployeeVO.getUserId());
            prdOrgEmployeeVO.setDataRefVOS(prdOrgDataRefVOS);
        }
        return resList;
    }

    public PagingVO<PrdOrgEmployeeVO> pagingRole(PrdOrgEmployeeQuery query) {
        PagingVO<PrdOrgEmployeeVO> pagingVO = this.dao.queryPagingRole(query);
        List records = pagingVO.getRecords();
        for (PrdOrgEmployeeVO record : records) {
            record.setUuId(UUID.randomUUID().toString().trim().replace("-", ""));
        }
        return pagingVO;
    }

    public PersonEntryCheckVO entryInfoCheck(Long personId) {
        PersonEntryCheckVO personEntryCheckVO = new PersonEntryCheckVO();
        boolean eduFlag = false;
        boolean accountFlag = false;
        boolean workFlag = false;
        if (!this.personEduExperienceService.findAllByPersonId(personId).isEmpty()) {
            eduFlag = true;
        }
        if (!this.personAccountService.findAllByPersonId(personId).isEmpty()) {
            accountFlag = true;
        }
        if (!this.personWorkExperienceService.findAllByPersonId(personId).isEmpty()) {
            workFlag = true;
        }
        personEntryCheckVO.setEduFlag(Boolean.valueOf(eduFlag));
        personEntryCheckVO.setAccountFlag(Boolean.valueOf(accountFlag));
        personEntryCheckVO.setWorkFlag(Boolean.valueOf(workFlag));
        personEntryCheckVO.setBaseInfoFlag(Boolean.valueOf(true));
        return personEntryCheckVO;
    }

    public PrdOrgEmployeeServiceImpl(PrdOrgEmployeeDAO dao, PrdSystemUserRoleRepo prdSystemUserRoleRepo, PrdOrgOrganizationDAO daoOrg, PrdSystemSelectionService service, AsyncEmployeeServiceImpl serviceAsync, QyWxCommunicationService qyWxCommunicationService, ExcelUtil excelUtil, FileUtil fileUtil, CacheUtil cacheUtil, UserRpcService userRpcService, RedisCacheUtil redisCacheUtil, PrdOrgPersonRepo prdOrgPersonRepo, PersonEduExperienceService personEduExperienceService, PersonWorkExperienceService personWorkExperienceService, PersonProjectExperienceService personProjectExperienceService, PersonCertService personCertService, PersonAccountService personAccountService, CalAccountService calAccountService, PersonRewardPunishService personRewardPunishService, BusinessCustomerInfoService businessCustomerInfoService, PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService) {
        this.dao = dao;
        this.prdSystemUserRoleRepo = prdSystemUserRoleRepo;
        this.daoOrg = daoOrg;
        this.service = service;
        this.serviceAsync = serviceAsync;
        this.qyWxCommunicationService = qyWxCommunicationService;
        this.excelUtil = excelUtil;
        this.fileUtil = fileUtil;
        this.cacheUtil = cacheUtil;
        this.userRpcService = userRpcService;
        this.redisCacheUtil = redisCacheUtil;
        this.prdOrgPersonRepo = prdOrgPersonRepo;
        this.personEduExperienceService = personEduExperienceService;
        this.personWorkExperienceService = personWorkExperienceService;
        this.personProjectExperienceService = personProjectExperienceService;
        this.personCertService = personCertService;
        this.personAccountService = personAccountService;
        this.calAccountService = calAccountService;
        this.personRewardPunishService = personRewardPunishService;
        this.businessCustomerInfoService = businessCustomerInfoService;
        this.employeeEqvaRatioService = employeeEqvaRatioService;
    }
}

