/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.business.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.AccreditProjectRefPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.AccreditProjectRefQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.query.AccreditProjectSimpleQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.AccreditProjectRefVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.AccreditProjectRefDO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.QAccreditProjectRefDO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.QBusinessPartnerAccreditDO;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.AccreditProjectRefRepo;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class AccreditProjectRefDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final AccreditProjectRefRepo repo;
    private final QAccreditProjectRefDO qdo = QAccreditProjectRefDO.accreditProjectRefDO;
    private final QBusinessPartnerAccreditDO qBusinessPartnerAccreditDO = QBusinessPartnerAccreditDO.businessPartnerAccreditDO;
    private final QPmsProjectDO qPmsProjectDO = QPmsProjectDO.pmsProjectDO;

    private JPAQuery<AccreditProjectRefVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccreditProjectRefVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.accreditId, this.qdo.reasonId, this.qdo.reasonType, this.qdo.reasonName})).from((EntityPath)this.qdo);
    }

    private JPAQuery<AccreditProjectRefVO> getJpaQueryWhere(AccreditProjectRefQuery query) {
        JPAQuery<AccreditProjectRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(AccreditProjectRefQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(AccreditProjectRefQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccreditId())) {
            list.add(this.qdo.accreditId.eq((Object)query.getAccreditId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonId())) {
            list.add(this.qdo.reasonId.eq((Object)query.getReasonId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonType())) {
            list.add(this.qdo.reasonType.eq((Object)query.getReasonType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonName())) {
            list.add(this.qdo.reasonName.eq((Object)query.getReasonName()));
        }
        return ExpressionUtils.allOf(list);
    }

    public AccreditProjectRefVO queryByKey(Long id) {
        JPAQuery<AccreditProjectRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (AccreditProjectRefVO)jpaQuery.fetchFirst();
    }

    public List<AccreditProjectRefVO> queryListDynamic(AccreditProjectRefQuery query) {
        JPAQuery<AccreditProjectRefVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<AccreditProjectRefVO> queryPaging(AccreditProjectRefQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<AccreditProjectRefVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public AccreditProjectRefDO save(AccreditProjectRefDO ado) {
        return (AccreditProjectRefDO)this.repo.save(ado);
    }

    public List<AccreditProjectRefDO> saveAll(List<AccreditProjectRefDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(AccreditProjectRefPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getAccreditId() != null) {
            update.set(this.qdo.accreditId, (Object)payload.getAccreditId());
        }
        if (payload.getReasonId() != null) {
            update.set(this.qdo.reasonId, (Object)payload.getReasonId());
        }
        if (payload.getReasonType() != null) {
            update.set((Path)this.qdo.reasonType, (Object)payload.getReasonType());
        }
        if (payload.getReasonName() != null) {
            update.set((Path)this.qdo.reasonName, (Object)payload.getReasonName());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("accreditId")) {
                update.setNull(this.qdo.accreditId);
            }
            if (nullFields.contains("reasonId")) {
                update.setNull(this.qdo.reasonId);
            }
            if (nullFields.contains("reasonType")) {
                update.setNull((Path)this.qdo.reasonType);
            }
            if (nullFields.contains("reasonName")) {
                update.setNull((Path)this.qdo.reasonName);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteByAccreditId(List<Long> accreditIdList) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.accreditId.in(accreditIdList)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<AccreditProjectRefVO> queryInfoByUserId(Long userId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(AccreditProjectRefVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.accreditId, this.qdo.reasonId, this.qdo.reasonType, this.qdo.reasonName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerAccreditDO)).on((Predicate)this.qdo.accreditId.eq(this.qBusinessPartnerAccreditDO.id))).where((Predicate)this.qBusinessPartnerAccreditDO.userId.eq((Object)userId))).where((Predicate)this.qBusinessPartnerAccreditDO.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetch();
    }

    public PagingVO<PmsProjectVO> queryCustomerProjectPaging(AccreditProjectSimpleQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.accreditId, this.qdo.reasonId, this.qdo.reasonType, this.qdo.reasonName})).from((EntityPath)this.qPmsProjectDO)).leftJoin((EntityPath)this.qdo)).on((Predicate)this.qdo.reasonId.eq(this.qPmsProjectDO.id))).leftJoin((EntityPath)this.qBusinessPartnerAccreditDO)).on((Predicate)this.qdo.accreditId.eq(this.qBusinessPartnerAccreditDO.id))).where((Predicate)this.qBusinessPartnerAccreditDO.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qPmsProjectDO.deleteFlag.eq((Object)0));
        jpaQuery.where(this.PmsPrjectwhere(query));
        List PmsProjectVOList = jpaQuery.fetch();
        if (!CollectionUtils.isEmpty((Collection)PmsProjectVOList)) {
            PagingVO.builder().records(PmsProjectVOList).total((long)PmsProjectVOList.size()).build();
        }
        return PagingVO.empty();
    }

    private Predicate PmsPrjectwhere(AccreditProjectSimpleQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getUserId())) {
            list.add(this.qBusinessPartnerAccreditDO.userId.eq((Object)query.getUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectSearchKey())) {
            list.add(this.qPmsProjectDO.projName.like(SqlUtil.toSqlLikeString(query.getProjectSearchKey())).or((Predicate)this.qPmsProjectDO.projNo.like(SqlUtil.toSqlLikeString(query.getProjectSearchKey()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjStatus())) {
            list.add(this.qPmsProjectDO.projStatus.eq((Object)query.getProjStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPmResId())) {
            list.add(this.qPmsProjectDO.pmResId.eq((Object)query.getPmResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleManUserId())) {
            list.add(this.qPmsProjectDO.saleManUserId.eq((Object)query.getSaleManUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeStart())) {
            list.add(this.qPmsProjectDO.createTime.goe((Comparable)query.getCreateTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateTimeEnd())) {
            list.add(this.qPmsProjectDO.createTime.loe((Comparable)query.getCreateTimeEnd()));
        }
        return ExpressionUtils.allOf(list);
    }

    public AccreditProjectRefDAO(JPAQueryFactory jpaQueryFactory, AccreditProjectRefRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

