/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.business.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessPartnerAccreditPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.AccreditProjectRefQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.query.AccreditProjectSimpleQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessPartnerAccreditQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.service.AccreditProjectRefService;
import com.elitesland.tw.tw5.api.prd.partner.business.service.BusinessPartnerAccreditService;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.AccreditProjectRefVO;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessPartnerAccreditVO;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessPartnerProjectOverviewVO;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsCommunicatePlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsCommunicatePlanVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectSimpleVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.ReceStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.business.convert.AccreditProjectRefConvert;
import com.elitesland.tw.tw5.server.prd.partner.business.convert.BusinessPartnerAccreditConvert;
import com.elitesland.tw.tw5.server.prd.partner.business.dao.AccreditProjectRefDAO;
import com.elitesland.tw.tw5.server.prd.partner.business.dao.BusinessPartnerAccreditDAO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.AccreditProjectRefDO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.BusinessPartnerAccreditDO;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.AccreditProjectRefRepo;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.BusinessPartnerAccreditRepo;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.PmsCommunicatePlanService;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectWbsTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsDAO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemUserRoleRepo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessPartnerAccreditServiceImpl
extends BaseServiceImpl
implements BusinessPartnerAccreditService {
    private static final Logger log = LoggerFactory.getLogger(BusinessPartnerAccreditServiceImpl.class);
    private final BusinessPartnerAccreditRepo businessPartnerAccreditRepo;
    private final BusinessPartnerAccreditDAO businessPartnerAccreditDAO;
    private final AccreditProjectRefService accreditProjectRefService;
    private final AccreditProjectRefRepo accreditProjectRefRepo;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final AccreditProjectRefDAO accreditProjectRefDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final ConReceivablePlanService conReceivablePlanService;
    private final PmsProjectWbsDAO pmsProjectWbsDAO;
    private final PmsCommunicatePlanService pmsCommunicatePlanService;
    private final PrdSystemUserRoleRepo repoUserRole;
    @Autowired
    private SysUserRpcService sysUserService;
    @Value(value="${tws.accreditOrgId:896115233435753595}")
    private Long accreditOrgId;
    @Value(value="${tws.customerAccreditProjectRoleId:897466437176725541}")
    private Long customerAccreditProjectRoleId;

    public PagingVO<BusinessPartnerAccreditVO> queryPaging(BusinessPartnerAccreditQuery query) {
        return this.businessPartnerAccreditDAO.queryPaging(query);
    }

    public List<BusinessPartnerAccreditVO> queryListDynamic(BusinessPartnerAccreditQuery query) {
        return this.businessPartnerAccreditDAO.queryListDynamic(query);
    }

    public BusinessPartnerAccreditVO queryByKey(Long key) {
        BusinessPartnerAccreditDO entity = this.businessPartnerAccreditRepo.findById(key).orElseGet(BusinessPartnerAccreditDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerAccreditVO vo = BusinessPartnerAccreditConvert.INSTANCE.toVo(entity);
        AccreditProjectRefQuery refQuery = new AccreditProjectRefQuery();
        refQuery.setAccreditId(key);
        List accreditProjectRefVOS = this.accreditProjectRefService.queryListDynamic(refQuery);
        if (!CollectionUtils.isEmpty((Collection)accreditProjectRefVOS)) {
            vo.setAccreditProjectRefVOS(accreditProjectRefVOS);
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerAccreditVO insert(BusinessPartnerAccreditPayload payload) {
        PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
        employeeQuery.setEmployeeNoEqual(payload.getAccount());
        List employeeVOList = this.prdOrgEmployeeService.queryList(employeeQuery);
        Long userId = null;
        Long employeeId = null;
        if (CollectionUtils.isEmpty((Collection)employeeVOList)) {
            PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
            employeePayload.setEmployeeName(payload.getAccount());
            employeePayload.setEmployeeNo(payload.getAccount());
            employeePayload.setEnabled(Boolean.valueOf(true));
            employeePayload.setHrStatus("ACTIVE");
            employeePayload.setJobs("chairman");
            employeePayload.setEmail(payload.getAccount() + "@elitesland.com");
            employeePayload.setPersonName(payload.getAccount());
            employeePayload.setResourceStatus("3");
            employeePayload.setUserName(payload.getAccount());
            employeePayload.setOrgId(this.accreditOrgId);
            PrdOrgOrganizationVO org = this.cacheUtil.getOrg(this.accreditOrgId);
            employeePayload.setParentId(org.getManageId());
            ArrayList<Long> roleIds = new ArrayList<Long>();
            roleIds.add(this.customerAccreditProjectRoleId);
            employeePayload.setRoleIds(roleIds);
            PrdOrgEmployeeVO insert = this.prdOrgEmployeeService.insert(employeePayload);
            this.sysUserService.changePasswordNoSec(insert.getUserId(), payload.getPassword());
            userId = insert.getUserId();
            employeeId = insert.getId();
        } else {
            userId = ((PrdOrgEmployeeVO)employeeVOList.get(0)).getUserId();
            employeeId = ((PrdOrgEmployeeVO)employeeVOList.get(0)).getId();
            BusinessPartnerAccreditQuery query = new BusinessPartnerAccreditQuery();
            query.setUserId(userId);
            query.setBookId(payload.getBookId());
            long count = this.businessPartnerAccreditDAO.count(query);
            if (count > 0L) {
                throw TwException.error("", "\u8be5\u7528\u6237\u5df2\u6dfb\u52a0\u8fc7\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
        }
        payload.setUserId(userId);
        payload.setEmployeeId(employeeId);
        payload.setAccreditStatus("1");
        BusinessPartnerAccreditDO entityDo = BusinessPartnerAccreditConvert.INSTANCE.toDo(payload);
        BusinessPartnerAccreditDO partnerAccreditDO = (BusinessPartnerAccreditDO)this.businessPartnerAccreditRepo.save(entityDo);
        List accreditProjectRefPayloadList = payload.getAccreditProjectRefPayloadList();
        if (!CollectionUtils.isEmpty((Collection)accreditProjectRefPayloadList)) {
            accreditProjectRefPayloadList.stream().forEach(p -> p.setAccreditId(partnerAccreditDO.getId()));
            List<AccreditProjectRefDO> accreditProjectRefDOS = AccreditProjectRefConvert.INSTANCE.toDoList(accreditProjectRefPayloadList);
            this.accreditProjectRefRepo.saveAll(accreditProjectRefDOS);
        }
        return BusinessPartnerAccreditConvert.INSTANCE.toVo(partnerAccreditDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessPartnerAccreditVO update(BusinessPartnerAccreditPayload payload) {
        Boolean changePasswordFlag = false;
        BusinessPartnerAccreditDO entity = this.businessPartnerAccreditRepo.findById(payload.getId()).orElseGet(BusinessPartnerAccreditDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessPartnerAccreditDO entityDo = BusinessPartnerAccreditConvert.INSTANCE.toDo(payload);
        if (StringUtils.hasText((String)payload.getPassword()) && !payload.getPassword().equals(entity.getPassword())) {
            changePasswordFlag = true;
        }
        entity.copy(entityDo);
        BusinessPartnerAccreditDO accreditDO = (BusinessPartnerAccreditDO)this.businessPartnerAccreditRepo.save(entity);
        if (!CollectionUtils.isEmpty((Collection)payload.getAccreditProjectRefPayloadList())) {
            this.accreditProjectRefService.deleteByAccreditId(Collections.singletonList(payload.getId()));
            List accreditProjectRefPayloadList = payload.getAccreditProjectRefPayloadList();
            accreditProjectRefPayloadList.stream().forEach(p -> p.setAccreditId(accreditDO.getId()));
            List<AccreditProjectRefDO> accreditProjectRefDOS = AccreditProjectRefConvert.INSTANCE.toDoList(accreditProjectRefPayloadList);
            this.accreditProjectRefRepo.saveAll(accreditProjectRefDOS);
        }
        if (changePasswordFlag.booleanValue()) {
            this.sysUserService.changePasswordNoSec(entity.getUserId(), payload.getPassword());
        }
        return BusinessPartnerAccreditConvert.INSTANCE.toVo(accreditDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BusinessPartnerAccreditPayload payload) {
        BusinessPartnerAccreditDO entity = this.businessPartnerAccreditRepo.findById(payload.getId()).orElseGet(BusinessPartnerAccreditDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessPartnerAccreditDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional
    public void updateAccreditStatus(Long key, String status) {
        BusinessPartnerAccreditPayload payload = new BusinessPartnerAccreditPayload();
        payload.setId(key);
        payload.setAccreditStatus(status);
        BusinessPartnerAccreditDO entity = this.businessPartnerAccreditRepo.findById(payload.getId()).orElseGet(BusinessPartnerAccreditDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.businessPartnerAccreditDAO.updateByKeyDynamic(payload);
        PrdOrgEmployeePayload employeePayload = new PrdOrgEmployeePayload();
        employeePayload.setId(entity.getEmployeeId());
        employeePayload.setEmail(entity.getAccount() + "@elitesland.com");
        employeePayload.setEmployeeName(entity.getAccount());
        employeePayload.setUserName(entity.getAccount());
        employeePayload.setSubType("system");
        if ("1".equals(status)) {
            employeePayload.setEnabled(Boolean.valueOf(true));
        } else {
            employeePayload.setEnabled(Boolean.valueOf(false));
        }
        this.prdOrgEmployeeService.update(employeePayload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessPartnerAccreditDAO.deleteSoft(keys);
            this.accreditProjectRefService.deleteByAccreditId(keys);
        }
    }

    @Transactional
    public void updatePasswordByUserId(Long userId, String newPassword) {
        this.businessPartnerAccreditDAO.updatePasswordByUserId(userId, newPassword);
    }

    public BusinessPartnerProjectOverviewVO queryCustomerProjectOverview() {
        Long userId = GlobalUtil.getLoginUserId();
        BusinessPartnerProjectOverviewVO vo = new BusinessPartnerProjectOverviewVO();
        List<AccreditProjectRefVO> accreditProjectRefVOS = this.accreditProjectRefDAO.queryInfoByUserId(userId);
        if (!CollectionUtils.isEmpty(accreditProjectRefVOS)) {
            List projectIdList = accreditProjectRefVOS.stream().map(AccreditProjectRefVO::getReasonId).collect(Collectors.toList());
            PmsProjectQuery projectQuery = new PmsProjectQuery();
            projectQuery.setInIds(projectIdList);
            List<PmsProjectVO> pmsProjectVOList = this.pmsProjectDAO.queryListDynamic(projectQuery);
            pmsProjectVOList.stream().forEach(e -> e.setCustName(this.cacheUtil.getCompanyNameByBookId(e.getCustId())));
            if (!CollectionUtils.isEmpty(pmsProjectVOList)) {
                vo.setPmsProjectVOList(pmsProjectVOList);
                vo.setTotalProjectNum(BigDecimal.valueOf(pmsProjectVOList.size()));
                List underWayProjectList = pmsProjectVOList.stream().filter(e -> ProjectStatusEnum.ACTIVE.getCode().equals(e.getProjStatus()) || ProjectStatusEnum.APPROVING.getCode().equals(e.getProjStatus()) || ProjectStatusEnum.CLOSING.getCode().equals(e.getProjStatus())).collect(Collectors.toList());
                vo.setUnderWayProjectNum(BigDecimal.valueOf(underWayProjectList.size()));
                vo.setUnderWayProjectList(underWayProjectList);
                List completeProjectList = pmsProjectVOList.stream().filter(e -> ProjectStatusEnum.CLOSED.getCode().equals(e.getProjStatus())).collect(Collectors.toList());
                vo.setCompleteProjectNum(BigDecimal.valueOf(completeProjectList.size()));
                vo.setCompleteProjectList(completeProjectList);
                LocalDate now = LocalDate.now();
                List currentMonthCheckProjectList = pmsProjectVOList.stream().filter(p -> p.getPlanEndDate() != null && p.getPlanEndDate().getYear() == now.getYear() && p.getPlanEndDate().getMonth() == now.getMonth()).collect(Collectors.toList());
                vo.setCurrentMonthCheckNum(BigDecimal.valueOf(currentMonthCheckProjectList.size()));
                vo.setCurrentMonthCheckProjectList(currentMonthCheckProjectList);
                BigDecimal projectSize = BigDecimal.valueOf(pmsProjectVOList.size());
                HashMap projectTypeRatioMap = new HashMap();
                PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection(FunctionSelectionEnum.PROJECT_TYPE.getCode());
                if (systemSelection != null && !CollectionUtils.isEmpty((Collection)systemSelection.getChildren())) {
                    systemSelection.getChildren().forEach(e -> {
                        long count = pmsProjectVOList.stream().filter(p -> e.getSelectionValue().equals(p.getExt2())).count();
                        BigDecimal ratio = BigDecimal.valueOf(count).divide(projectSize, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                        projectTypeRatioMap.put(e.getSelectionName(), ratio);
                    });
                }
                vo.setProjectTypeRatioMap(projectTypeRatioMap);
                List contractIdList = pmsProjectVOList.stream().filter(p -> p.getContractId() != null).map(PmsProjectVO::getContractId).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(contractIdList)) {
                    ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
                    queryReceivablePlan.setSaleConIds(contractIdList);
                    queryReceivablePlan.setReceStatus(ReceStatusEnum.OK_INVOICE.getCode());
                    ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
                    orders.add(OrderItem.desc((String)"invDate"));
                    queryReceivablePlan.setOrders(orders);
                    List recvPlanViews = this.conReceivablePlanService.queryListDynamic(queryReceivablePlan);
                    if (!CollectionUtils.isEmpty((Collection)recvPlanViews)) {
                        vo.setConReceivablePlanVOList(recvPlanViews);
                    }
                }
                List idList = pmsProjectVOList.stream().map(p -> p.getId()).collect(Collectors.toList());
                PmsProjectWbsQuery wbsQuery = new PmsProjectWbsQuery();
                wbsQuery.setProjectIdList(idList);
                wbsQuery.setWbsTypeList(Arrays.asList(ProjectWbsTypeEnum.MS.getCode(), ProjectWbsTypeEnum.ACTG.getCode()));
                wbsQuery.setWbsStatus(ProjectWbsStatusEnum.FINISHED.getCode());
                wbsQuery.setVersionNo(Integer.valueOf(0));
                List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListDynamic(wbsQuery);
                if (!CollectionUtils.isEmpty(pmsProjectWbsVOS)) {
                    Map<Long, List<PmsProjectWbsVO>> wbsMap = pmsProjectWbsVOS.stream().collect(Collectors.groupingBy(PmsProjectWbsVO::getProjectId));
                    ArrayList pmsProjectSimpleVOList = new ArrayList();
                    pmsProjectVOList.stream().forEach(e -> {
                        PmsProjectSimpleVO pmsProjectSimpleVO = new PmsProjectSimpleVO();
                        pmsProjectSimpleVO.setId(e.getId());
                        pmsProjectSimpleVO.setProjName(e.getProjName());
                        pmsProjectSimpleVO.setCompPercent(e.getCompPercent());
                        pmsProjectSimpleVO.setPmResId(e.getPmResId());
                        pmsProjectSimpleVO.setPmResName(this.cacheUtil.getUserName(e.getPmResId()));
                        if (wbsMap.containsKey(e.getId())) {
                            List projectActgMsVOS;
                            List pmsProjectWbsVOS1 = (List)wbsMap.get(e.getId());
                            List projectWbsMsVOS = pmsProjectWbsVOS1.stream().filter(w -> ProjectWbsTypeEnum.MS.getCode().equals(w.getWbsType())).collect(Collectors.toList());
                            if (!CollectionUtils.isEmpty(projectWbsMsVOS)) {
                                if (projectWbsMsVOS.size() > 1) {
                                    Collections.sort(projectWbsMsVOS, Comparator.comparing(PmsProjectWbsVO::getEndDate));
                                }
                                pmsProjectSimpleVO.setWbsMsName(((PmsProjectWbsVO)projectWbsMsVOS.get(0)).getWbsName());
                            }
                            if (!CollectionUtils.isEmpty(projectActgMsVOS = pmsProjectWbsVOS1.stream().filter(w -> ProjectWbsTypeEnum.ACTG.getCode().equals(w.getWbsType())).collect(Collectors.toList()))) {
                                if (projectActgMsVOS.size() > 1) {
                                    Collections.sort(projectActgMsVOS, Comparator.comparing(PmsProjectWbsVO::getEndDate));
                                }
                                pmsProjectSimpleVO.setWbsActgName(((PmsProjectWbsVO)projectActgMsVOS.get(0)).getWbsName());
                            }
                        }
                        pmsProjectSimpleVOList.add(pmsProjectSimpleVO);
                    });
                    vo.setPmsProjectSimpleVOList(pmsProjectSimpleVOList);
                }
                PmsCommunicatePlanQuery communicateQuery = new PmsCommunicatePlanQuery();
                communicateQuery.setProIdList(idList);
                List<PmsCommunicatePlanVO> pmsCommunicatePlanVOS = this.pmsCommunicatePlanService.queryList(communicateQuery);
                vo.setPmsCommunicatePlanVOList(pmsCommunicatePlanVOS);
            }
        }
        return vo;
    }

    public PagingVO<PmsProjectVO> queryCustomerProjectPaging(AccreditProjectSimpleQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        query.setUserId(userId);
        return this.accreditProjectRefDAO.queryCustomerProjectPaging(query);
    }

    public BusinessPartnerAccreditServiceImpl(BusinessPartnerAccreditRepo businessPartnerAccreditRepo, BusinessPartnerAccreditDAO businessPartnerAccreditDAO, AccreditProjectRefService accreditProjectRefService, AccreditProjectRefRepo accreditProjectRefRepo, CacheUtil cacheUtil, PrdOrgEmployeeService prdOrgEmployeeService, AccreditProjectRefDAO accreditProjectRefDAO, PmsProjectDAO pmsProjectDAO, ConReceivablePlanService conReceivablePlanService, PmsProjectWbsDAO pmsProjectWbsDAO, PmsCommunicatePlanService pmsCommunicatePlanService, PrdSystemUserRoleRepo repoUserRole) {
        this.businessPartnerAccreditRepo = businessPartnerAccreditRepo;
        this.businessPartnerAccreditDAO = businessPartnerAccreditDAO;
        this.accreditProjectRefService = accreditProjectRefService;
        this.accreditProjectRefRepo = accreditProjectRefRepo;
        this.cacheUtil = cacheUtil;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.accreditProjectRefDAO = accreditProjectRefDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.conReceivablePlanService = conReceivablePlanService;
        this.pmsProjectWbsDAO = pmsProjectWbsDAO;
        this.pmsCommunicatePlanService = pmsCommunicatePlanService;
        this.repoUserRole = repoUserRole;
    }
}

