/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.common.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookLicensePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookLicenseQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookLicenseService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookLicenseVO;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BookLicenseConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookLicenseDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookLicenseDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookLicenseRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BookLicenseServiceImpl
extends BaseServiceImpl
implements BookLicenseService {
    private static final Logger log = LoggerFactory.getLogger(BookLicenseServiceImpl.class);
    private final BookLicenseRepo bookLicenseRepo;
    private final BookLicenseDAO bookLicenseDAO;
    private final FileUtil fileUtil;

    public PagingVO<BookLicenseVO> queryPaging(BookLicenseQuery query) {
        PagingVO<BookLicenseVO> bookLicenseVOPagingVO = this.bookLicenseDAO.queryPaging(query);
        bookLicenseVOPagingVO.stream().forEach(vo -> vo.setFileData(this.fileUtil.getFileDatas(vo.getFileCode())));
        return bookLicenseVOPagingVO;
    }

    public List<BookLicenseVO> queryListDynamic(BookLicenseQuery query) {
        List<BookLicenseVO> bookLicenseVOS = this.bookLicenseDAO.queryListDynamic(query);
        if (bookLicenseVOS != null && bookLicenseVOS.size() > 0) {
            bookLicenseVOS.stream().forEach(vo -> vo.setFileData(this.fileUtil.getFileDatas(vo.getFileCode())));
        }
        return bookLicenseVOS;
    }

    public BookLicenseVO queryByKey(Long key) {
        BookLicenseDO entity = this.bookLicenseRepo.findById(key).orElseGet(BookLicenseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BookLicenseVO vo = BookLicenseConvert.INSTANCE.toVo(entity);
        vo.setFileData(this.fileUtil.getFileDatas(vo.getFileCode()));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BookLicenseVO insert(BookLicensePayload payload) {
        BookLicenseDO entityDo = BookLicenseConvert.INSTANCE.toDo(payload);
        return BookLicenseConvert.INSTANCE.toVo((BookLicenseDO)this.bookLicenseRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BookLicenseVO update(BookLicensePayload payload) {
        BookLicenseDO entity = this.bookLicenseRepo.findById(payload.getId()).orElseGet(BookLicenseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BookLicenseDO entityDo = BookLicenseConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BookLicenseConvert.INSTANCE.toVo((BookLicenseDO)this.bookLicenseRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.bookLicenseDAO.deleteSoft(keys);
        }
    }

    public BookLicenseServiceImpl(BookLicenseRepo bookLicenseRepo, BookLicenseDAO bookLicenseDAO, FileUtil fileUtil) {
        this.bookLicenseRepo = bookLicenseRepo;
        this.bookLicenseDAO = bookLicenseDAO;
        this.fileUtil = fileUtil;
    }
}

