/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.identity.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCollaboratePartnerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCollaboratePartnerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCollaboratePartnerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamTypeEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.convert.BusinessCollaboratePartnerInfoConvert;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessCollaboratePartnerInfoDAO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCollaboratePartnerInfoRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessCollaboratePartnerInfoServiceImpl
extends BaseServiceImpl
implements BusinessCollaboratePartnerInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusinessCollaboratePartnerInfoServiceImpl.class);
    private final BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo;
    private final BusinessCollaboratePartnerInfoDAO businessCollaboratePartnerInfoDAO;
    private final FileUtil fileUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    private final PrdOrgEmployeeDAO employeeDAO;
    @Value(value="${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final TransactionUtilService transactionUtilService;
    private final BusinessTeamMemberService businessTeamMemberService;

    public PagingVO<BusinessCollaboratePartnerInfoVO> queryPaging(BusinessCollaboratePartnerInfoQuery query) {
        PagingVO<BusinessCollaboratePartnerInfoVO> businessCollaboratePartnerInfoVOPagingVO = this.businessCollaboratePartnerInfoDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty((Collection)businessCollaboratePartnerInfoVOPagingVO.getRecords())) {
            businessCollaboratePartnerInfoVOPagingVO.stream().forEach(p -> this.translate((BusinessCollaboratePartnerInfoVO)p));
        }
        return businessCollaboratePartnerInfoVOPagingVO;
    }

    public List<BusinessCollaboratePartnerInfoVO> queryListDynamic(BusinessCollaboratePartnerInfoQuery query) {
        List<BusinessCollaboratePartnerInfoVO> businessCollaboratePartnerInfoVOS = this.businessCollaboratePartnerInfoDAO.queryListDynamic(query);
        businessCollaboratePartnerInfoVOS.stream().forEach(vo -> this.translate((BusinessCollaboratePartnerInfoVO)vo));
        return businessCollaboratePartnerInfoVOS;
    }

    public BusinessCollaboratePartnerInfoVO queryByKey(Long key) {
        BusinessCollaboratePartnerInfoDO entity = this.businessCollaboratePartnerInfoRepo.findById(key).orElseGet(BusinessCollaboratePartnerInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCollaboratePartnerInfoVO vo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo(entity);
        this.translate(vo);
        return vo;
    }

    public BusinessCollaboratePartnerInfoVO queryByPartnerId(Long partnerId) {
        BusinessCollaboratePartnerInfoDO entity = this.businessCollaboratePartnerInfoRepo.findByPartnerId(partnerId);
        if (entity == null) {
            throw TwException.error("", "\u5408\u4f5c\u4f19\u4f34\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        BusinessCollaboratePartnerInfoVO vo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo(entity);
        this.translate(vo);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCollaboratePartnerInfoVO insert(BusinessCollaboratePartnerInfoPayload payload) {
        BusinessCollaboratePartnerInfoDO entityDo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toDo(payload);
        return BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo((BusinessCollaboratePartnerInfoDO)this.businessCollaboratePartnerInfoRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCollaboratePartnerInfoVO update(BusinessCollaboratePartnerInfoPayload payload) {
        BusinessCollaboratePartnerInfoDO entity = this.businessCollaboratePartnerInfoRepo.findById(payload.getId()).orElseGet(BusinessCollaboratePartnerInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.updateCollaborateTeamMember(payload);
        BusinessCollaboratePartnerInfoDO entityLog = new BusinessCollaboratePartnerInfoDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessCollaboratePartnerInfoDO entityDo = BusinessCollaboratePartnerInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (null != payload.getPartnerId()) {
            StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
            fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
        }
        return BusinessCollaboratePartnerInfoConvert.INSTANCE.toVo((BusinessCollaboratePartnerInfoDO)this.businessCollaboratePartnerInfoRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessCollaboratePartnerInfoDAO.deleteSoft(keys);
        }
    }

    @Transactional
    public void activeCollaboratePartnerWithWorkFlow(Long partnerId, String partnerName) {
        BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = this.queryByPartnerId(partnerId);
        ProcessInfo processInfo = new ProcessInfo();
        if (this.workflow_enabled.booleanValue()) {
            HashMap variables = this.dealActiveWorkFlowVariables(businessCollaboratePartnerInfoVO);
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.COLLABORATE_ACTIVE.name(), (String)(partnerName + "-\u5408\u4f5c\u4f19\u4f34\u6fc0\u6d3b\u6d41\u7a0b"), (String)("" + businessCollaboratePartnerInfoVO.getId()), (HashMap)variables), new Long[0]);
        }
        BusinessCollaboratePartnerInfoPayload payload = new BusinessCollaboratePartnerInfoPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(businessCollaboratePartnerInfoVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setCollaborateStatus(BusinessPartnerStatusEnum.APPROVING.getCode());
        this.transactionUtilService.executeWithRunnable(() -> this.businessCollaboratePartnerInfoDAO.updateByKeyDynamic(payload));
    }

    @Transactional
    public void activeCollaboratePartner(Long partnerId, String partnerName) {
        BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = this.queryByPartnerId(partnerId);
        BusinessCollaboratePartnerInfoPayload payload = new BusinessCollaboratePartnerInfoPayload();
        payload.setId(businessCollaboratePartnerInfoVO.getId());
        payload.setCollaborateStatus(BusinessPartnerStatusEnum.ACTIVE.getCode());
        this.businessCollaboratePartnerInfoDAO.updateByKeyDynamic(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCollaborateTeamMember(BusinessCollaboratePartnerInfoPayload payload) {
        List businessTeamMemberVOS = this.businessTeamMemberService.queryByObjectIdAndRole(payload.getPartnerId(), BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode());
        if (payload.getChannelUserId() != null) {
            Long orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getChannelUserId());
            if (!CollectionUtils.isEmpty((Collection)businessTeamMemberVOS)) {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setId(((BusinessTeamMemberVO)businessTeamMemberVOS.get(0)).getId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getChannelUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getChannelUserId());
                this.businessTeamMemberService.update(businessTeamMemberPayload);
            } else {
                BusinessTeamMemberPayload businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getChannelUserId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getChannelUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.CHANNEL_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.CHANNEL_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.CHANNEL_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                this.businessTeamMemberService.save(businessTeamMemberPayload);
            }
        }
    }

    public void translate(BusinessCollaboratePartnerInfoVO vo) {
        vo.setFileDatas1(this.fileUtil.getFileDatas(vo.getFileCodes1()));
        vo.setFileDatas2(this.fileUtil.getFileDatas(vo.getFileCodes2()));
        vo.setFileDatas3(this.fileUtil.getFileDatas(vo.getFileCodes3()));
        if (StringUtils.hasText((String)vo.getCollaborateTag())) {
            String[] identityArray = vo.getCollaborateTag().split(",");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < identityArray.length; ++i) {
                String selection = this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.COOP_TAG.getCode(), identityArray[i]);
                if (i == identityArray.length - 1) {
                    stringBuilder.append(selection);
                    continue;
                }
                stringBuilder.append(selection + ",");
            }
            vo.setCollaborateTagDesc(stringBuilder.toString());
        }
    }

    public HashMap dealActiveWorkFlowVariables(BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO) {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
        PrdOrgRoleVO channelOperation = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.CUST_CHANNER_OPERATION.getCode());
        if (ObjectUtils.isEmpty((Object)channelOperation)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.CUST_CHANNER_OPERATION.getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitChannelOperation = channelOperation.getRoleEmployees().split(",");
        variables.put("Activity_16gj46w", Arrays.asList(splitChannelOperation));
        PrdOrgRoleVO custOfficer = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.CUST_OFFICER.getCode());
        if (ObjectUtils.isEmpty((Object)custOfficer)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.CUST_OFFICER.getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitByCustOfficer = custOfficer.getRoleEmployees().split(",");
        variables.put("Activity_1opzy6c", Arrays.asList(splitByCustOfficer));
        return variables;
    }

    public BusinessCollaboratePartnerInfoServiceImpl(BusinessCollaboratePartnerInfoRepo businessCollaboratePartnerInfoRepo, BusinessCollaboratePartnerInfoDAO businessCollaboratePartnerInfoDAO, FileUtil fileUtil, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService, CacheUtil cacheUtil, WorkflowUtil workflowUtil, PrdOrgOrganizationDAO daoOrg, PrdOrgEmployeeDAO employeeDAO, TransactionUtilService transactionUtilService, BusinessTeamMemberService businessTeamMemberService) {
        this.businessCollaboratePartnerInfoRepo = businessCollaboratePartnerInfoRepo;
        this.businessCollaboratePartnerInfoDAO = businessCollaboratePartnerInfoDAO;
        this.fileUtil = fileUtil;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
        this.workflowUtil = workflowUtil;
        this.daoOrg = daoOrg;
        this.employeeDAO = employeeDAO;
        this.transactionUtilService = transactionUtilService;
        this.businessTeamMemberService = businessTeamMemberService;
    }
}

