/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personplan.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsCommunicatePlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ProRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsCommunicatePlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsCommunicatePlanVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PmsCommunicatePlanDao;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.PmsCommunicatePlanService;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class PmsCommunicatePlanServiceImpl
implements PmsCommunicatePlanService {
    private static final Logger log = LoggerFactory.getLogger(PmsCommunicatePlanServiceImpl.class);
    private final PmsCommunicatePlanDao dao;
    private final ProRelatedPartiesService proRelatedPartiesService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final PrdMessageConfigService prdMessageConfigService;

    @Override
    public PagingVO<PmsCommunicatePlanVO> queryPage(PmsCommunicatePlanQuery query) {
        PagingVO<PmsCommunicatePlanVO> pageVO = this.dao.queryPage(query);
        this.translate(pageVO.getRecords());
        return pageVO;
    }

    @Override
    public List<PmsCommunicatePlanVO> queryList(PmsCommunicatePlanQuery query) {
        List<PmsCommunicatePlanVO> listVO = this.dao.queryList(query);
        this.translate(listVO);
        return listVO;
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsCommunicatePlanQuery query) {
        return TwOutputUtil.ok(this.dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsCommunicatePlanVO> queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsCommunicatePlanVO vo = this.dao.queryByKey(id);
        Assert.notNull((Object)vo, (String)"\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.translate(List.of(vo));
        if (StrUtil.isNotBlank((CharSequence)vo.getProcessingUser())) {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            List idList = Arrays.stream(vo.getProcessingUser().split(",")).map(Long::valueOf).collect(Collectors.toList());
            proRelatedPartiesQuery.setIdList(idList);
            proRelatedPartiesQuery.setType(Integer.valueOf(1));
            List proRelatedPartiesVOList = this.proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            vo.setProRelatedPartiesVOList(proRelatedPartiesVOList);
        }
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsCommunicatePlanVO> insert(PmsCommunicatePlanPayload payload) {
        this.checkData(payload);
        if (null == payload.getStatus()) {
            payload.setStatus(Integer.valueOf(1));
        }
        PmsCommunicatePlanVO save = this.dao.save(payload);
        if (null != payload.getCommunicateTime() && StrUtil.isNotBlank((CharSequence)payload.getBeforeRemindTime()) && payload.getCommunicateTime().isAfter(LocalDateTime.now())) {
            for (String beforeRemindTime : payload.getBeforeRemindTime().split(",")) {
                PrdMessageConfigPayload prdMessageConfigPayload = new PrdMessageConfigPayload();
                prdMessageConfigPayload.setMessageTitle("\u9879\u76ee\u6c9f\u901a\u8ba1\u5212\u63d0\u9192");
                prdMessageConfigPayload.setContentType("systemMessage");
                prdMessageConfigPayload.setNoticeWay(payload.getRemindMode());
                prdMessageConfigPayload.setReleaseSource("\u57c3\u6797\u54f2\u5e73\u53f0\u7ba1\u7406");
                prdMessageConfigPayload.setNoticeScope("appoint_people");
                String processingUser = payload.getProcessingUser();
                prdMessageConfigPayload.setNoticeSource(processingUser);
                long pushTime = Long.parseLong(beforeRemindTime);
                LocalDateTime localDateTime = payload.getCommunicateTime().minusMinutes(pushTime);
                prdMessageConfigPayload.setTriggerTime(localDateTime);
                prdMessageConfigPayload.setMessageType(Integer.valueOf(2));
                prdMessageConfigPayload.setContentBigType("companyMessage");
                String msgContent = "\u6c9f\u901a\u8bae\u7a0b" + payload.getTitle() + "\u5373\u5c06\u5f00\u59cb\n   \u8ba1\u5212\u6c9f\u901a\u65f6\u95f4\uff1a" + payload.getCommunicateTime().toString() + "   \u5173\u8054\u8ba1\u5212\uff1a" + payload.getWbsName();
                prdMessageConfigPayload.setMessageContent(msgContent);
                this.prdMessageConfigService.insert(prdMessageConfigPayload);
            }
        }
        return this.queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsCommunicatePlanVO> update(PmsCommunicatePlanPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        PmsCommunicatePlanVO save = this.dao.save(payload);
        ProRelatedPartiesPayload proRelatedPartiesPayload = new ProRelatedPartiesPayload();
        return this.queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsCommunicatePlanVO> updateDynamic(PmsCommunicatePlanPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        if (payload.getStatus() != 1) {
            payload.setProcessingTime(LocalDateTime.now());
        }
        if (CollUtil.isNotEmpty((Collection)payload.getProRelatedPartiesPayloadList())) {
            payload.getProRelatedPartiesPayloadList().forEach(x -> {
                x.setId(x.getId());
                x.setExt3(x.getExt3());
                Long res = this.proRelatedPartiesService.update(x, Integer.valueOf(1));
            });
        }
        this.dao.updateByKeyDynamic(payload);
        return this.queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw TwException.error("", "ids\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return TwOutputUtil.ok(this.dao.deleteSoft(ids));
    }

    private TwOutputUtil<Long> startWorkFlow(PmsCommunicatePlanPayload payload) {
        HashMap varMaps = new HashMap();
        String procInstId = "";
        Long update = this.dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    private void checkData(PmsCommunicatePlanPayload payload) {
        if (payload.getCommunicateTime() != null) {
            // empty if block
        }
    }

    private void translate(List<PmsCommunicatePlanVO> vos) {
        vos.forEach(vo -> {
            if (StringUtils.hasText((String)vo.getProcessingUser())) {
                List processList = Arrays.stream(vo.getProcessingUser().split(",")).map(Long::valueOf).collect(Collectors.toList());
                ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
                proRelatedPartiesQuery.setIdList(processList);
                List proRelatedPartiesVOList = this.proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
                List relateName = proRelatedPartiesVOList.stream().map(x -> x.getName()).collect(Collectors.toList());
                vo.setProcessingUserDesc(StrUtil.join((CharSequence)",", relateName));
            }
        });
    }

    public PmsCommunicatePlanServiceImpl(PmsCommunicatePlanDao dao, ProRelatedPartiesService proRelatedPartiesService, PrdFsmFileRefService prdFsmFileRefService, PrdMessageConfigService prdMessageConfigService) {
        this.dao = dao;
        this.proRelatedPartiesService = proRelatedPartiesService;
        this.prdFsmFileRefService = prdFsmFileRefService;
        this.prdMessageConfigService = prdMessageConfigService;
    }
}

