/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsProjectWbsDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectWbsRepo repo;
    private final QPmsProjectWbsDO qdo = QPmsProjectWbsDO.pmsProjectWbsDO;

    private JPAQuery<PmsProjectWbsVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectWbsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.projectId, this.qdo.parentId, this.qdo.wbsName, this.qdo.wbsType, this.qdo.wbsCode, this.qdo.nodeCode, this.qdo.parentWbsCode, this.qdo.wbsStatus, this.qdo.cancelShowFlag, this.qdo.managerUserId, this.qdo.subjectDist, this.qdo.startDate, this.qdo.endDate, this.qdo.preStartDate, this.qdo.preEndDate, this.qdo.preDurationDay, this.qdo.wbsProgress, this.qdo.durationDay, this.qdo.earlyStartDate, this.qdo.earlyEndDate, this.qdo.lateStartDate, this.qdo.lateEndDate, this.qdo.totalFloat, this.qdo.freeFloat, this.qdo.delayLag, this.qdo.isKeyNode, this.qdo.autoScheduling, this.qdo.costType, this.qdo.invoiceAttr, this.qdo.costPlan, this.qdo.wbsWeight, this.qdo.manualSettingWeight, this.qdo.versionId, this.qdo.versionNo, this.qdo.state, this.qdo.effRelateId, this.qdo.releaseFlag, this.qdo.cancelShowFlag, this.qdo.receivePlanId, this.qdo.allocateStatus, this.qdo.allocateCost, this.qdo.allocateEqva, this.qdo.distedEqva, this.qdo.planEqva, this.qdo.originalPlanEqva, this.qdo.detailControlFlag, this.qdo.occupyEqva, this.qdo.usedEqva, this.qdo.usedEqvaProportion, this.qdo.usedAmtProportion})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsProjectWbsVO> getJpaQueryWhere(PmsProjectWbsQuery query) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    private Predicate where(PmsProjectWbsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectIdList())) {
            list.add(this.qdo.projectId.in((Collection)query.getProjectIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsSearch())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString(query.getWbsSearch())).or((Predicate)this.qdo.wbsCode.like(SqlUtil.toSqlLikeString(query.getWbsSearch()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsName())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString(query.getWbsName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsType())) {
            list.add(this.qdo.wbsType.eq((Object)query.getWbsType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsTypeList())) {
            list.add(this.qdo.wbsType.in((Collection)query.getWbsTypeList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsCode())) {
            list.add(this.qdo.wbsCode.like(SqlUtil.toSqlLikeString(query.getWbsCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNodeCode())) {
            list.add(this.qdo.nodeCode.eq((Object)query.getNodeCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentWbsCode())) {
            list.add(this.qdo.parentWbsCode.eq((Object)query.getParentWbsCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentWbsCodes())) {
            list.add(this.qdo.parentWbsCode.in((Collection)query.getParentWbsCodes()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostPlan())) {
            list.add(this.qdo.costPlan.eq((Object)query.getCostPlan()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectDist())) {
            list.add(this.qdo.subjectDist.eq((Object)query.getSubjectDist()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceAttr())) {
            list.add(this.qdo.invoiceAttr.eq((Object)query.getInvoiceAttr()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDurationDay())) {
            list.add(this.qdo.durationDay.eq((Object)query.getDurationDay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostType())) {
            list.add(this.qdo.costType.eq((Object)query.getCostType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartDate())) {
            list.add(this.qdo.startDate.eq((Object)query.getStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndDate())) {
            list.add(this.qdo.endDate.eq((Object)query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreStartDate())) {
            list.add(this.qdo.preStartDate.goe((Comparable)query.getPreStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreEndDate())) {
            list.add(this.qdo.preEndDate.loe((Comparable)query.getPreEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreDurationDay())) {
            list.add(this.qdo.preDurationDay.eq((Object)query.getPreDurationDay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsProgress())) {
            list.add(this.qdo.wbsProgress.eq((Object)query.getWbsProgress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManagerUserIds())) {
            list.add(this.qdo.managerUserId.in((Collection)query.getManagerUserIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsStatus())) {
            list.add(this.qdo.wbsStatus.eq((Object)query.getWbsStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getState())) {
            list.add(this.qdo.state.eq((Object)query.getState()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVersionNo())) {
            list.add(this.qdo.versionNo.eq((Object)query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVersionId())) {
            list.add(this.qdo.versionId.eq((Object)query.getVersionId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceivePlanId())) {
            list.add(this.qdo.receivePlanId.eq((Object)query.getReceivePlanId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectWbsVO queryByKey(Long id) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectWbsVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectWbsVO> queryByKeys(List<Long> keys) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(keys));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsVO> queryByParentWbsCode(Long projectId, String parentWbsCode) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.parentWbsCode.eq((Object)parentWbsCode));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsVO> queryByParentWbsCodes(Long projectId, List<String> parentWbsCodes) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.parentWbsCode.in(parentWbsCodes));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsVO> queryByProjectId(Long projectId) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsVO> queryByProjectIdAndVersion(Long projectId, Integer versionNo) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.versionNo.eq((Object)versionNo));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsVO> queryListByIds(List<Long> keys) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(keys));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsVO> queryListDynamic(PmsProjectWbsQuery query) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PmsProjectWbsDO save(PmsProjectWbsDO ado) {
        return (PmsProjectWbsDO)this.repo.save(ado);
    }

    public List<PmsProjectWbsDO> saveAll(List<PmsProjectWbsDO> dos) {
        return this.repo.saveAll(dos);
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<PmsProjectWbsVO> querySimpleByProjectId(Long projectId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectWbsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.wbsName, this.qdo.preStartDate, this.qdo.preEndDate, this.qdo.durationDay})).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long upadateManagerUserId(Long projectId, List<Long> managerUserIds, Long managerUserId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.managerUserId, (Object)managerUserId).where(new Predicate[]{this.qdo.projectId.eq((Object)projectId).and((Predicate)this.qdo.managerUserId.in(managerUserIds))});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateWbsProgress(Long id, BigDecimal wbsProgress, String wbsStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.wbsProgress, (Object)wbsProgress).set((Path)this.qdo.wbsStatus, (Object)wbsStatus).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateWbsProgress(Long id, BigDecimal wbsProgress) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.wbsProgress, (Object)wbsProgress).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsProjectWbsVO queryByProjectAndWbs(Long projectId, String wbsCode) {
        JPAQuery<PmsProjectWbsVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.wbsCode.eq((Object)wbsCode));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectWbsVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectWbsVO> queryParentWbsCodeIsNull(Long projectId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectWbsVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.wbsWeight, this.qdo.wbsProgress})).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.parentWbsCode.eq((Object)""));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long updateKeyNode(Long projectId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.isKeyNode, (Object)0).where(new Predicate[]{this.qdo.projectId.eq((Object)projectId)});
        return update.execute();
    }

    public long updateKeyNodeAndVersionNo(Long projectId, Integer versionNo) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.isKeyNode, (Object)0).where(new Predicate[]{this.qdo.projectId.eq((Object)projectId)}).where(new Predicate[]{this.qdo.versionNo.eq((Object)versionNo)});
        return update.execute();
    }

    public long updateScheduling(Long projectId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.autoScheduling, (Object)2).where(new Predicate[]{this.qdo.projectId.eq((Object)projectId).and((Predicate)this.qdo.autoScheduling.eq((Object)1))});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public void submit(List<Long> wbsId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.state, (Object)"1").where(new Predicate[]{this.qdo.id.in(wbsId)}).where(new Predicate[]{this.qdo.state.eq((Object)"0")});
        update.execute();
    }

    public Long queryBykeyAndVersion(Long proid, String code, int versionNo) {
        Long res = (Long)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qdo.id).from((EntityPath)this.qdo)).where((Predicate)this.qdo.projectId.eq((Object)proid))).where((Predicate)this.qdo.wbsCode.eq((Object)code))).where((Predicate)this.qdo.versionNo.eq((Object)versionNo))).fetchFirst();
        return res;
    }

    public Long updateByKeyNoVersion(PmsProjectWbsPayload pmsProjectWbsPayload) {
        JPAUpdateClause update = this.getJpaUpdateClause(pmsProjectWbsPayload);
        long res = update.where(new Predicate[]{this.qdo.id.eq((Object)pmsProjectWbsPayload.getId())}).execute();
        return res;
    }

    public Long updateReceplanIdNull(List<Long> webIdList) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo);
        update.setNull(this.qdo.receivePlanId);
        long res = update.where(new Predicate[]{this.qdo.id.in(webIdList)}).execute();
        return res;
    }

    public Long updateByKeyNoVersionByEffId(PmsProjectWbsPayload pmsProjectWbsPayload) {
        JPAUpdateClause update = this.getJpaUpdateClause(pmsProjectWbsPayload);
        long res = update.where(new Predicate[]{this.qdo.effRelateId.eq((Object)pmsProjectWbsPayload.getEffRelateId())}).execute();
        return res;
    }

    private JPAUpdateClause getJpaUpdateClause(PmsProjectWbsPayload pmsProjectWbsPayload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo);
        if (null != pmsProjectWbsPayload.getProjectId()) {
            update.set(this.qdo.projectId, (Object)pmsProjectWbsPayload.getProjectId());
        }
        if (null != pmsProjectWbsPayload.getParentId()) {
            update.set(this.qdo.parentId, (Object)pmsProjectWbsPayload.getParentId());
        }
        if (StringUtils.isNotEmpty((CharSequence)pmsProjectWbsPayload.getWbsName())) {
            update.set((Path)this.qdo.wbsName, (Object)pmsProjectWbsPayload.getWbsName());
        }
        if (StringUtils.isNotEmpty((CharSequence)pmsProjectWbsPayload.getWbsType())) {
            update.set((Path)this.qdo.wbsType, (Object)pmsProjectWbsPayload.getWbsType());
        }
        if (StringUtils.isNotEmpty((CharSequence)pmsProjectWbsPayload.getWbsCode())) {
            update.set((Path)this.qdo.wbsCode, (Object)pmsProjectWbsPayload.getWbsCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pmsProjectWbsPayload.getParentWbsCode())) {
            update.set((Path)this.qdo.parentWbsCode, (Object)pmsProjectWbsPayload.getParentWbsCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pmsProjectWbsPayload.getNodeCode())) {
            update.set((Path)this.qdo.nodeCode, (Object)pmsProjectWbsPayload.getNodeCode());
        }
        if (null != pmsProjectWbsPayload.getManagerUserId()) {
            update.set(this.qdo.managerUserId, (Object)pmsProjectWbsPayload.getManagerUserId());
        }
        if (null != pmsProjectWbsPayload.getSubjectDist()) {
            update.set(this.qdo.subjectDist, (Object)pmsProjectWbsPayload.getSubjectDist());
        }
        if (StringUtils.isNotEmpty((CharSequence)pmsProjectWbsPayload.getCostType())) {
            update.set((Path)this.qdo.costType, (Object)pmsProjectWbsPayload.getCostType());
        }
        if (null != pmsProjectWbsPayload.getPreStartDate()) {
            update.set(this.qdo.preStartDate, (Object)pmsProjectWbsPayload.getPreStartDate());
        }
        if (null != pmsProjectWbsPayload.getPreEndDate()) {
            update.set(this.qdo.preEndDate, (Object)pmsProjectWbsPayload.getPreEndDate());
        }
        if (null != pmsProjectWbsPayload.getPreDurationDay()) {
            update.set(this.qdo.preDurationDay, (Object)pmsProjectWbsPayload.getPreDurationDay());
        }
        if (null != pmsProjectWbsPayload.getWbsProgress()) {
            update.set(this.qdo.wbsProgress, (Object)pmsProjectWbsPayload.getWbsProgress());
        }
        if (null != pmsProjectWbsPayload.getStartDate()) {
            update.set(this.qdo.startDate, (Object)pmsProjectWbsPayload.getStartDate());
        }
        if (null != pmsProjectWbsPayload.getEndDate()) {
            update.set(this.qdo.endDate, (Object)pmsProjectWbsPayload.getEndDate());
        }
        if (null != pmsProjectWbsPayload.getEndDateIsNull()) {
            update.setNull(this.qdo.endDate);
        }
        if (null != pmsProjectWbsPayload.getDurationDay()) {
            update.set(this.qdo.durationDay, (Object)pmsProjectWbsPayload.getDurationDay());
        }
        if (null != pmsProjectWbsPayload.getEarlyStartDate()) {
            update.set(this.qdo.earlyStartDate, (Object)pmsProjectWbsPayload.getEarlyStartDate());
        }
        if (null != pmsProjectWbsPayload.getLateStartDate()) {
            update.set(this.qdo.lateStartDate, (Object)pmsProjectWbsPayload.getLateStartDate());
        }
        if (null != pmsProjectWbsPayload.getLateEndDate()) {
            update.set(this.qdo.lateEndDate, (Object)pmsProjectWbsPayload.getLateEndDate());
        }
        if (null != pmsProjectWbsPayload.getTotalFloat()) {
            update.set(this.qdo.totalFloat, (Object)pmsProjectWbsPayload.getTotalFloat());
        }
        if (null != pmsProjectWbsPayload.getFreeFloat()) {
            update.set(this.qdo.freeFloat, (Object)pmsProjectWbsPayload.getFreeFloat());
        }
        if (null != pmsProjectWbsPayload.getDelayLag()) {
            update.set(this.qdo.delayLag, (Object)pmsProjectWbsPayload.getDelayLag());
        }
        if (null != pmsProjectWbsPayload.getIsKeyNode()) {
            update.set(this.qdo.isKeyNode, (Object)pmsProjectWbsPayload.getIsKeyNode());
        }
        if (null != pmsProjectWbsPayload.getAutoScheduling()) {
            update.set(this.qdo.autoScheduling, (Object)pmsProjectWbsPayload.getAutoScheduling());
        }
        if (StringUtils.isNotEmpty((CharSequence)pmsProjectWbsPayload.getWbsStatus())) {
            update.set((Path)this.qdo.wbsStatus, (Object)pmsProjectWbsPayload.getWbsStatus());
        }
        if (null != pmsProjectWbsPayload.getEarlyEndDate()) {
            update.set(this.qdo.earlyEndDate, (Object)pmsProjectWbsPayload.getEarlyEndDate());
        }
        if (null != pmsProjectWbsPayload.getInvoiceAttr()) {
            update.set(this.qdo.invoiceAttr, (Object)pmsProjectWbsPayload.getInvoiceAttr());
        }
        if (null != pmsProjectWbsPayload.getWbsWeight()) {
            update.set(this.qdo.wbsWeight, (Object)pmsProjectWbsPayload.getWbsWeight());
        }
        if (null != pmsProjectWbsPayload.getManualSettingWeight()) {
            update.set(this.qdo.manualSettingWeight, (Object)pmsProjectWbsPayload.getManualSettingWeight());
        }
        if (null != pmsProjectWbsPayload.getCostPlan()) {
            update.set(this.qdo.costPlan, (Object)pmsProjectWbsPayload.getCostPlan());
        }
        if (StringUtils.isNotEmpty((CharSequence)pmsProjectWbsPayload.getState())) {
            update.set((Path)this.qdo.state, (Object)pmsProjectWbsPayload.getState());
        }
        if (pmsProjectWbsPayload.getEffRelateId() != null) {
            update.set(this.qdo.effRelateId, (Object)pmsProjectWbsPayload.getEffRelateId());
        }
        if (pmsProjectWbsPayload.getReleaseFlag() != null) {
            update.set((Path)this.qdo.releaseFlag, (Object)pmsProjectWbsPayload.getReleaseFlag());
        }
        if (pmsProjectWbsPayload.getCancelShowFlag() != null) {
            update.set((Path)this.qdo.cancelShowFlag, (Object)pmsProjectWbsPayload.getCancelShowFlag());
        }
        if (pmsProjectWbsPayload.getReceivePlanId() != null) {
            update.set(this.qdo.receivePlanId, (Object)pmsProjectWbsPayload.getReceivePlanId());
        }
        if (pmsProjectWbsPayload.getAllocateStatus() != null) {
            update.set((Path)this.qdo.allocateStatus, (Object)pmsProjectWbsPayload.getAllocateStatus());
        }
        if (pmsProjectWbsPayload.getAllocateEqva() != null) {
            update.set(this.qdo.allocateEqva, (Object)pmsProjectWbsPayload.getAllocateEqva());
        }
        if (pmsProjectWbsPayload.getAllocateCost() != null) {
            update.set(this.qdo.allocateCost, (Object)pmsProjectWbsPayload.getAllocateCost());
        }
        if (pmsProjectWbsPayload.getOriginalPlanEqva() != null) {
            update.set(this.qdo.originalPlanEqva, (Object)pmsProjectWbsPayload.getOriginalPlanEqva());
        }
        if (pmsProjectWbsPayload.getPlanEqva() != null) {
            update.set(this.qdo.planEqva, (Object)pmsProjectWbsPayload.getPlanEqva());
        }
        if (pmsProjectWbsPayload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)pmsProjectWbsPayload.getRemark());
        }
        if (pmsProjectWbsPayload.getDetailControlFlag() != null) {
            update.set((Path)this.qdo.detailControlFlag, (Object)pmsProjectWbsPayload.getDetailControlFlag());
        }
        if (pmsProjectWbsPayload.getOccupyEqva() != null) {
            update.set(this.qdo.occupyEqva, (Object)pmsProjectWbsPayload.getOccupyEqva());
        }
        if (pmsProjectWbsPayload.getUsedEqva() != null) {
            update.set(this.qdo.usedEqva, (Object)pmsProjectWbsPayload.getUsedEqva());
        }
        if (pmsProjectWbsPayload.getUsedEqvaProportion() != null) {
            update.set(this.qdo.usedEqvaProportion, (Object)pmsProjectWbsPayload.getUsedEqvaProportion());
        }
        if (pmsProjectWbsPayload.getUsedAmtProportion() != null) {
            update.set(this.qdo.usedAmtProportion, (Object)pmsProjectWbsPayload.getUsedAmtProportion());
        }
        return update;
    }

    public Long updateWbsStatus(Long id, String wbsStatus, String state, Boolean cancelShowFlag) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.wbsStatus, (Object)wbsStatus);
        if (StringUtils.isNotBlank((CharSequence)state)) {
            update.set((Path)this.qdo.state, (Object)state);
        }
        if (!ObjectUtils.isEmpty((Object)cancelShowFlag)) {
            update.set((Path)this.qdo.cancelShowFlag, (Object)cancelShowFlag);
        }
        update.where(new Predicate[]{this.qdo.id.eq((Object)id)});
        return update.execute();
    }

    public Long updateWbsStatusAndEndDateIsNull(Long id, String wbsStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.wbsStatus, (Object)wbsStatus).setNull(this.qdo.endDate).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        return update.execute();
    }

    public void delByEffIds(List<Long> effIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(effIds)});
        update.execute();
    }

    public long updateAllocateStatus(List<Long> keys, String allocateStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.allocateStatus, (Object)allocateStatus).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateAllocateStatusByEffId(List<Long> wbsIdList, String allocateStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.allocateStatus, (Object)allocateStatus).where(new Predicate[]{this.qdo.effRelateId.in(wbsIdList)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsProjectWbsDAO(JPAQueryFactory jpaQueryFactory, PmsProjectWbsRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

