/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.deliver.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.yeedocpro.vo.ItemInfoDataFileDTO;
import com.elitesland.tw.tw5.server.common.ExcelEntityDataListener;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.deliver.constants.DeliverItemStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.deliver.convert.PmsDeliverItemRoleConvert;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.entity.PmsDeliverItemRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemRoleExcelPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemRolePayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemRoleQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemRoleVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.repo.PmsDeliverItemRoleRepo;
import com.elitesland.tw.tw5.server.prd.pms.deliver.repo.dao.PmsDeliverItemRoleDao;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemRoleService;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemService;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedocpro.config.YeedocProProperties;
import com.elitesland.tw.tw5.server.yeedocpro.dto.CreateFolderPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.CreateFolderTwPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.ItemInfoPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.YeedocCreateFolderDataDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.YeedocCreateFolderForTwDTO;
import com.elitesland.tw.tw5.server.yeedocpro.service.YeedocProService;
import com.elitesland.tw.tw5.server.yeedocref.constants.YeedocRefTypeEnum;
import com.elitesland.tw.tw5.server.yeedocref.model.payload.PrdYeedocRefPayload;
import com.elitesland.tw.tw5.server.yeedocref.model.vo.PrdYeedocRefVO;
import com.elitesland.tw.tw5.server.yeedocref.service.PrdYeedocRefService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PmsDeliverItemRoleServiceImpl
implements PmsDeliverItemRoleService {
    private static final Logger log = LoggerFactory.getLogger(PmsDeliverItemRoleServiceImpl.class);
    private final PmsDeliverItemRoleDao pmsDeliverItemRoleDao;
    private final PmsDeliverItemRoleRepo pmsDeliverItemRoleRepo;
    private final YeedocProService yeedocProService;
    private final YeedocProProperties yeedocProProperties;
    private final PrdYeedocRefService prdYeedocRefService;
    private final UdcUtil udcUtil;
    @Resource
    @Lazy
    private PmsProjectService pmsProjectService;
    @Resource
    private PmsDeliverItemService pmsDeliverItemService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PmsDeliverItemRoleVO save(PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        this.checkData(pmsDeliverItemRolePayload);
        PmsDeliverItemRoleDO pmsDeliverItemRoleDO = PmsDeliverItemRoleConvert.INSTANCE.p2d(pmsDeliverItemRolePayload);
        PmsDeliverItemRoleDO res = (PmsDeliverItemRoleDO)((Object)this.pmsDeliverItemRoleRepo.save((Object)pmsDeliverItemRoleDO));
        return PmsDeliverItemRoleConvert.INSTANCE.d2v(res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PmsDeliverItemRoleVO updateAll(PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        Assert.notNull((Object)pmsDeliverItemRolePayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PmsDeliverItemRoleVO res = this.save(pmsDeliverItemRolePayload);
        return res;
    }

    @Override
    public PmsDeliverItemRoleVO get(Long id) {
        if (null == id) {
            return null;
        }
        PmsDeliverItemRoleVO res = this.pmsDeliverItemRoleDao.get(id);
        return res;
    }

    @Override
    public PagingVO<PmsDeliverItemRoleVO> page(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        PagingVO<PmsDeliverItemRoleVO> res = this.pmsDeliverItemRoleDao.page(pmsDeliverItemRoleQuery);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.pmsDeliverItemRoleDao.del(ids);
        return res;
    }

    @Override
    public List<PmsDeliverItemRoleVO> getList(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        List<PmsDeliverItemRoleVO> res = this.pmsDeliverItemRoleDao.getList(pmsDeliverItemRoleQuery);
        return res;
    }

    @Override
    public long count(PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery) {
        Long count = this.pmsDeliverItemRoleDao.count(pmsDeliverItemRoleQuery);
        return count;
    }

    private void checkData(PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(PmsDeliverItemRolePayload pmsDeliverItemRolePayload) {
        Assert.notNull((Object)pmsDeliverItemRolePayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.pmsDeliverItemRoleDao.update(pmsDeliverItemRolePayload);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Map<String, Object> excelImport(MultipartFile file, Long projectId, Boolean force, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Assert.notNull((Object)file, (String)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (force == null) {
            force = false;
        }
        PmsDeliverItemRoleQuery pmsDeliverItemRoleQuery = new PmsDeliverItemRoleQuery();
        pmsDeliverItemRoleQuery.setProjectId(projectId);
        List<PmsDeliverItemRoleVO> pmsDeliverItemRoleVOList = this.getList(pmsDeliverItemRoleQuery);
        if (force.booleanValue()) {
            this.pmsDeliverItemRoleDao.deleteByProjectId(projectId);
        }
        ExcelEntityDataListener dataListener = new ExcelEntityDataListener();
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)file.getInputStream(), PmsDeliverItemRoleExcelPayload.class, dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(2))).doRead();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165 excel\u7684\u5217\u503c\u662f\u5426\u4e0e\u6a21\u677f\u5bf9\u5e94");
        }
        List<PmsDeliverItemRoleExcelPayload> excelDataList = dataListener.getDatas();
        if (CollectionUtils.isEmpty(excelDataList)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        boolean flag = true;
        String error = "\u8be5\u8868\u683c\u6709\u6570\u636e\u672a\u586b\u5199\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20";
        for (int i = 0; i < excelDataList.size(); ++i) {
            PmsDeliverItemRoleExcelPayload pmsDeliverItemRoleExcelPayload = (PmsDeliverItemRoleExcelPayload)((Object)excelDataList.get(i));
            if (StringUtils.hasText((String)pmsDeliverItemRoleExcelPayload.getSavePath()) && StringUtils.hasText((String)pmsDeliverItemRoleExcelPayload.getName()) && StringUtils.hasText((String)pmsDeliverItemRoleExcelPayload.getShowConfigFlagStr()) && StringUtils.hasText((String)pmsDeliverItemRoleExcelPayload.getContent())) continue;
            flag = false;
            break;
        }
        if (!flag) {
            throw TwException.error("", error);
        }
        List<PmsDeliverItemRoleDO> pmsDeliverItemRoleDOS = PmsDeliverItemRoleConvert.INSTANCE.e2dList(excelDataList);
        pmsDeliverItemRoleDOS.forEach(pmsDeliverItemRoleDO -> {
            pmsDeliverItemRoleDO.setProjectId(projectId);
            pmsDeliverItemRoleVOList.stream().filter(item -> pmsDeliverItemRoleDO.getSavePath().equals(item.getSavePath()) && StringUtils.hasText((String)item.getItemId())).findFirst().ifPresent(item -> {
                pmsDeliverItemRoleDO.setItemId(item.getItemId());
                pmsDeliverItemRoleDO.setLibraryId(item.getLibraryId());
            });
        });
        String pmsLibraryId = this.yeedocProProperties.getPmsLibraryId();
        PrdYeedocRefVO prdYeedocRefVO = this.prdYeedocRefService.queryByRefTypeAndRefId(YeedocRefTypeEnum.PMS_PROJECT, projectId);
        if (prdYeedocRefVO == null) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(projectId);
            String fileName = pmsProjectVO.getProjName() + "-" + pmsProjectVO.getProjNo();
            CreateFolderTwPayload createFolderTwPayload = new CreateFolderTwPayload();
            createFolderTwPayload.setLibraryId(pmsLibraryId);
            createFolderTwPayload.setPathArry(Arrays.asList("/" + fileName));
            YeedocCreateFolderForTwDTO folderReturn = this.yeedocProService.createFolderForTw(createFolderTwPayload);
            PrdYeedocRefPayload save = new PrdYeedocRefPayload();
            save.setRefType(YeedocRefTypeEnum.PMS_PROJECT.getCode());
            save.setRefId(projectId);
            save.setLibraryId(pmsLibraryId);
            save.setItemId(folderReturn.getFolderId());
            save.setItemName(folderReturn.getLeafName());
            TwOutputUtil<PrdYeedocRefVO> insert = this.prdYeedocRefService.insert(save);
            if (insert.isOk()) {
                prdYeedocRefVO = insert.getData();
            }
        }
        String projectFolderId = prdYeedocRefVO.getItemId();
        pmsDeliverItemRoleDOS.stream().filter(pmsDeliverItemRoleDO -> ObjectUtils.isEmpty((Object)pmsDeliverItemRoleDO.getItemId())).forEach(item -> {
            item.setLibraryId(pmsLibraryId);
            CreateFolderPayload createFolderTwPayload = new CreateFolderPayload();
            createFolderTwPayload.setLibraryId(pmsLibraryId);
            createFolderTwPayload.setFolderId(projectFolderId);
            createFolderTwPayload.setPath("/" + item.getSavePath());
            String resultStr = this.yeedocProService.createFolder(createFolderTwPayload);
            YeedocCreateFolderDataDTO createFolderDataDTO = this.yeedocProService.createFolderReturn(resultStr);
            String folderId = createFolderDataDTO.getFolderId();
            item.setItemId(folderId);
        });
        this.pmsDeliverItemRoleRepo.saveAll(pmsDeliverItemRoleDOS);
        result.put("successNum", pmsDeliverItemRoleDOS.size());
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateItemByRole(Long projectId) {
        this.pmsDeliverItemService.delByProjectId(projectId);
        PmsDeliverItemQuery pmsDeliverItemQuery = new PmsDeliverItemQuery();
        pmsDeliverItemQuery.setProjectId(projectId);
        List<PmsDeliverItemVO> pmsDeliverItemVOList = this.pmsDeliverItemService.getList(pmsDeliverItemQuery);
        PmsDeliverItemRoleQuery query = new PmsDeliverItemRoleQuery();
        query.setProjectId(projectId);
        List<PmsDeliverItemRoleVO> roleList = this.getList(query);
        ArrayList itemList = new ArrayList();
        roleList.forEach(pmsDeliverItemRoleDO -> {
            long count = pmsDeliverItemVOList.stream().filter(item -> StringUtils.hasText((String)item.getName()) && item.getName().equals(pmsDeliverItemRoleDO.getName()) && StringUtils.hasText((String)item.getSavePath()) && item.getSavePath().equals(pmsDeliverItemRoleDO.getSavePath())).count();
            if (count > 0L) {
                return;
            }
            PmsDeliverItemPayload pmsDeliverItemPayload = new PmsDeliverItemPayload();
            BeanUtils.copyProperties((Object)pmsDeliverItemRoleDO, (Object)((Object)pmsDeliverItemPayload));
            pmsDeliverItemPayload.setProjectId(pmsDeliverItemRoleDO.getProjectId());
            pmsDeliverItemPayload.setRoleId(pmsDeliverItemRoleDO.getId());
            pmsDeliverItemPayload.setStatus(DeliverItemStatusEnum.NO.getCode());
            if (null != pmsDeliverItemRoleDO.getShowConfigFlag() && !pmsDeliverItemRoleDO.getShowConfigFlag().booleanValue()) {
                pmsDeliverItemPayload.setShowFlag(true);
            } else if (pmsDeliverItemRoleDO.getNoShowFlag() != null && pmsDeliverItemRoleDO.getNoShowFlag().booleanValue()) {
                pmsDeliverItemPayload.setShowFlag(false);
            } else {
                pmsDeliverItemPayload.setShowFlag(true);
            }
            itemList.add(pmsDeliverItemPayload);
        });
        Set<String> itemIdList = itemList.stream().filter(item -> StringUtils.hasText((String)item.getItemId())).map(PmsDeliverItemPayload::getItemId).collect(Collectors.toSet());
        ItemInfoPayload itemInfoPayload = new ItemInfoPayload();
        itemInfoPayload.setItemIds(itemIdList);
        Map<String, List<ItemInfoDataFileDTO>> stringListMap = this.yeedocProService.itemInfoReturn(itemInfoPayload);
        if (null != stringListMap) {
            itemList.forEach(i -> {
                String itemId = i.getItemId();
                List itemInfoDataFileDTOS = (List)stringListMap.get(itemId);
                if (!CollectionUtils.isEmpty((Collection)itemInfoDataFileDTOS)) {
                    i.setStatus(DeliverItemStatusEnum.OK.getCode());
                }
            });
        }
        int k = 0;
        for (int i2 = 0; i2 < itemList.size(); ++i2) {
            PmsDeliverItemPayload pmsDeliverItemPayload = (PmsDeliverItemPayload)((Object)itemList.get(i2));
            this.pmsDeliverItemService.save(pmsDeliverItemPayload);
            ++k;
        }
        return k;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateNoShowFlag(PmsDeliverItemRolePayload payload) {
        Long roleId = payload.getId();
        Assert.notNull((Object)roleId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean noShowFlag = payload.getNoShowFlag();
        Assert.notNull((Object)noShowFlag, (String)"noShowFlag\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.pmsDeliverItemRoleDao.update(payload);
        boolean showFlag = noShowFlag == null || noShowFlag == false;
        return this.pmsDeliverItemService.updateShowFlagByRoleId(roleId, showFlag);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateNoShowFlagList(List<PmsDeliverItemRolePayload> list) {
        Long sum = 0L;
        if (!CollectionUtils.isEmpty(list)) {
            for (PmsDeliverItemRolePayload payload : list) {
                Long l = this.updateNoShowFlag(payload);
                sum = sum + l;
            }
        }
        return sum;
    }

    public PmsDeliverItemRoleServiceImpl(PmsDeliverItemRoleDao pmsDeliverItemRoleDao, PmsDeliverItemRoleRepo pmsDeliverItemRoleRepo, YeedocProService yeedocProService, YeedocProProperties yeedocProProperties, PrdYeedocRefService prdYeedocRefService, UdcUtil udcUtil) {
        this.pmsDeliverItemRoleDao = pmsDeliverItemRoleDao;
        this.pmsDeliverItemRoleRepo = pmsDeliverItemRoleRepo;
        this.yeedocProService = yeedocProService;
        this.yeedocProProperties = yeedocProProperties;
        this.prdYeedocRefService = prdYeedocRefService;
        this.udcUtil = udcUtil;
    }
}

