/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskProVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActListService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsListVO;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectActListDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskProQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskProService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectActListServiceImpl
implements PmsProjectActListService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectActListServiceImpl.class);
    private final PmsProjectActListDAO pmsProjectActListDAO;
    @Resource
    @Lazy
    private TaskProService taskProService;

    public PagingVO<PmsProjectWbsListVO> queryPage(PmsProjectWbsQuery query) {
        PagingVO<PmsProjectWbsListVO> page = this.pmsProjectActListDAO.queryPage(query);
        String wbsStatus = query.getWbsStatusPro();
        page.getRecords().forEach(item -> {
            if (StringUtils.hasText((String)wbsStatus) && wbsStatus.equals(ProjectWbsStatusEnum.NOGIONG.getCode())) {
                TaskProQuery taskProQuery = new TaskProQuery();
                taskProQuery.setWbsId(item.getId());
                Long taskCount = this.taskProService.count(taskProQuery);
                item.setTaskNum(taskCount);
                TaskProQuery taskProQuery2 = new TaskProQuery();
                taskProQuery2.setWbsId(item.getId());
                taskProQuery2.setParentNullFlag(true);
                List<TaskProVO> taskProVOS = this.taskProService.queryListDynamic(taskProQuery2);
                if (!CollectionUtils.isEmpty(taskProVOS)) {
                    TaskProVO taskProVO = taskProVOS.get(0);
                    item.setTaskDirectorRelatedPartiesId(taskProVO.getDirectorRelatedPartiesId());
                    item.setTaskDirectorRelatedPartiesName(taskProVO.getDirectorRelatedPartiesName());
                }
            }
        });
        return page;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateWbsStatus(Long id, String wbsStatus) {
        return this.pmsProjectActListDAO.updateWbsStatus(id, wbsStatus);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateReleaseFlag(List<Long> idList) {
        return this.pmsProjectActListDAO.updateReleaseFlag(idList);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateReleaseFlagByEffRelateId(List<Long> effRelateIdList) {
        return this.pmsProjectActListDAO.updateReleaseFlagByEffRelateId(effRelateIdList);
    }

    public List<PmsProjectWbsListVO> queryList(PmsProjectWbsQuery pmsProjectWbsQuery) {
        return this.pmsProjectActListDAO.queryListDynamic(pmsProjectWbsQuery);
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateWbsStatusByVersionIdAndEffRelateId(Long versionId, Long effRelateId, String wbsStatus) {
        return this.pmsProjectActListDAO.updateWbsStatusByVersionIdAndEffRelateId(versionId, effRelateId, wbsStatus);
    }

    public PmsProjectActListServiceImpl(PmsProjectActListDAO pmsProjectActListDAO) {
        this.pmsProjectActListDAO = pmsProjectActListDAO;
    }
}

