/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectBriefPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectReportPlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectBriefQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectReportPlanQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectBriefService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectReportPlanService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectBriefVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectReportPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchInvdtlQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvBatchQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchInvdtlService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConWorkTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectBriefConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectReportPlanConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectBriefDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectBriefDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectBriefRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectBriefServiceImpl
extends BaseServiceImpl
implements PmsProjectBriefService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectBriefServiceImpl.class);
    private final WorkflowUtil workflowUtil;
    private final PmsProjectBriefRepo pmsProjectBriefRepo;
    private final PmsProjectBriefDAO pmsProjectBriefDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final ConReceivablePlanService conReceivablePlanService;
    private final PrdSystemRoleService roleService;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PmsProjectReportPlanService pmsProjectReportPlanService;
    private BeanSearcher beanSearcher;
    private final ExcelUtil excelUtil;
    private final UdcUtil udcUtil;
    private final ConInvBatchService invBatchService;
    private final ConInvBatchInvdtlService invBatchInvdtlService;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_PROJECT_BRIEF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(rollbackFor={Exception.class})
    public PmsProjectBriefVO insertOrUpdate(PmsProjectBriefPayload payload) {
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(payload.getProjId());
        int autoReportFlag = this.autoReportFlag(pmsProjectVO.getWorkType());
        payload.setAutoReportFlag(Integer.valueOf(autoReportFlag));
        if (autoReportFlag == -1) {
            throw TwException.error("", "\u5de5\u4f5c\u7c7b\u578b\u4e0d\u9700\u8981\u8fdb\u884c\u9879\u76ee\u6c47\u62a5");
        }
        if (autoReportFlag == 1) {
            throw TwException.error("", "\u5de5\u4f5c\u7c7b\u578b\u4e3a\u81ea\u52a8\u6c47\u62a5\u7b56\u7565");
        }
        BigDecimal amt = pmsProjectVO.getSumAmt() == null ? BigDecimal.ZERO : pmsProjectVO.getSumAmt();
        BigDecimal taxRate = pmsProjectVO.getTaxRate() == null ? BigDecimal.ZERO : pmsProjectVO.getTaxRate();
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setSaleConId(pmsProjectVO.getContractId());
        List recvPlanViews = this.conReceivablePlanService.queryListDynamic(query);
        BigDecimal actualReceivedAmt = recvPlanViews.stream().map(ConReceivablePlanVO::getActualRecvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal invoicedAmt = recvPlanViews.stream().map(ConReceivablePlanVO::getAlreadyInvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        payload.setProjAmt(amt);
        payload.setTaxRate(taxRate);
        payload.setRecvedAmt(actualReceivedAmt);
        payload.setInvoicedAmt(invoicedAmt);
        payload.setProjName(pmsProjectVO.getProjName());
        if (payload.getId() != null) {
            PmsProjectBriefVO pmsProjectBriefVO = this.pmsProjectBriefDAO.queryByKey(payload.getId());
            if (!pmsProjectBriefVO.getBriefStatus().equals("CREATE")) throw TwException.error("", "\u6d41\u7a0b\u5df2\u5b58\u5728\u4e0d\u53ef\u518d\u6b21\u63d0\u4ea4");
            payload.setProcInstId(pmsProjectBriefVO.getProcInstId());
            payload.setApplyDate(pmsProjectBriefVO.getApplyDate());
            payload.setCreateUserId(pmsProjectBriefVO.getCreateUserId());
            payload.setCreateTime(pmsProjectBriefVO.getCreateTime());
        } else {
            String code = this.generateSeqNum("PMS_PROJ_REPORT", new String[0]);
            payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
            payload.setApplyDate(LocalDate.now());
        }
        this.noAutoReport(payload, pmsProjectVO);
        payload.setBriefStatus("FINISHED");
        payload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        payload.setApplyUserId(GlobalUtil.getLoginUserId());
        PmsProjectPayload projectPayload = new PmsProjectPayload();
        projectPayload.setId(payload.getProjId());
        projectPayload.setReportTime(LocalDateTime.now());
        projectPayload.setCompPercent(payload.getReprotCompPercent());
        projectPayload.setProjProcessStatus(payload.getProjProcessStatus());
        this.pmsProjectDAO.updateByKeyDynamic(projectPayload);
        PmsProjectBriefDO entityDo = PmsProjectBriefConvert.INSTANCE.toDo(payload);
        entityDo = (PmsProjectBriefDO)this.pmsProjectBriefRepo.save(entityDo);
        payload.setId(entityDo.getId());
        return PmsProjectBriefConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectBriefVO autoInsert(PmsProjectBriefPayload payload) {
        payload.setProjProcessStatus("SUP");
        payload.setBriefStatus("FINISHED");
        payload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        payload.setCreateUserId(Long.valueOf(0L));
        payload.setApplyUserId(Long.valueOf(0L));
        PmsProjectBriefDO entityDo = PmsProjectBriefConvert.INSTANCE.toDo(payload);
        entityDo = (PmsProjectBriefDO)this.pmsProjectBriefRepo.save(entityDo);
        PmsProjectPayload projectPayload = new PmsProjectPayload();
        projectPayload.setId(payload.getProjId());
        projectPayload.setReportTime(LocalDateTime.now());
        projectPayload.setCompPercent(payload.getReprotCompPercent());
        projectPayload.setProjProcessStatus(payload.getProjProcessStatus());
        this.pmsProjectDAO.updateByKeyDynamic(projectPayload);
        return PmsProjectBriefConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsProjectBriefVO pmsProjectBriefVO = this.pmsProjectBriefDAO.queryByKey(Long.valueOf(businessKey));
        if (pmsProjectBriefVO != null) {
            PmsProjectBriefPayload projectBriefPayload = new PmsProjectBriefPayload();
            projectBriefPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
            projectBriefPayload.setApprStatus(procInstStatus.name());
            projectBriefPayload.setBriefStatus("REPORTING");
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    projectBriefPayload.setBriefStatus("CREATE");
                    break;
                }
                case INTERRUPT: {
                    projectBriefPayload.setBriefStatus("CREATE");
                    projectBriefPayload.setProcInstId(null);
                    projectBriefPayload.setNullFields(List.of("procInstId"));
                    break;
                }
                case INVALID: {
                    projectBriefPayload.setDeleteFlag(Integer.valueOf(1));
                    projectBriefPayload.setBriefStatus("CREATE");
                    break;
                }
                case REJECTED: {
                    projectBriefPayload.setBriefStatus("CREATE");
                    break;
                }
                case APPROVED: {
                    projectBriefPayload.setBriefStatus("FINISHED");
                    projectBriefPayload.setProcInstId(null);
                    break;
                }
            }
            this.pmsProjectBriefDAO.updateWorkFlow(projectBriefPayload);
            if (projectBriefPayload.getBriefStatus().equals("FINISHED")) {
                PmsProjectPayload projectPayload = new PmsProjectPayload();
                projectPayload.setId(pmsProjectBriefVO.getProjId());
                projectPayload.setReportTime(LocalDateTime.now());
                projectPayload.setCompPercent(pmsProjectBriefVO.getReprotCompPercent());
                projectPayload.setProjProcessStatus(pmsProjectBriefVO.getProjProcessStatus());
                this.pmsProjectDAO.updateByKeyDynamic(projectPayload);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void noAutoReport(PmsProjectBriefPayload payload, PmsProjectVO pmsProjectVO) {
        int monthValue2;
        LocalDate planEndDate;
        int year2;
        int monthValue1;
        if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) throw TwException.error("", "\u53ea\u6709\u6fc0\u6d3b\u72b6\u6001\u9879\u76ee\u624d\u80fd\u6c47\u62a5");
        boolean isTrue = false;
        LocalDate finPeriodDate = payload.getFinPeriodDate();
        int year = finPeriodDate.getYear();
        int monthValue = finPeriodDate.getMonthValue();
        LocalDate planStartDate = pmsProjectVO.getPlanStartDate();
        int year1 = planStartDate.getYear();
        if (!(year < year1 || monthValue < (monthValue1 = planStartDate.getMonthValue()) && year <= year1 || (year2 = (planEndDate = pmsProjectVO.getPlanEndDate()).getYear()) < year || (monthValue2 = planEndDate.getMonthValue()) < monthValue && year2 <= year)) {
            isTrue = true;
        }
        if (!isTrue) throw TwException.error("", "\u6c47\u62a5\u671f\u95f4\u4e0d\u5728\u9879\u76ee\u9884\u8ba1\u8d77\u6b62\u65e5\u671f\u8303\u56f4\u5185\uff0c\u8bf7\u5148\u53d8\u66f4\u9879\u76ee\u9884\u8ba1\u8d77\u6b62\u65e5\u671f");
        PmsProjectBriefVO pmsProjectBriefVO = this.pmsProjectBriefDAO.queryByProjectId(payload.getProjId(), null);
        if (ObjectUtils.isEmpty((Object)pmsProjectBriefVO) || payload.getId() != null && payload.getId().longValue() == pmsProjectBriefVO.getId().longValue()) return;
        LocalDate finPeriodDate1 = pmsProjectBriefVO.getFinPeriodDate();
        int year3 = finPeriodDate1.getYear();
        int monthValue3 = finPeriodDate1.getMonthValue();
        if (year == year3 && monthValue == monthValue3) {
            throw TwException.error("", "\u540c\u4e00\u9879\u76ee\u5728\u540c\u4e00\u4e2a\u671f\u95f4\u5185\u53ea\u80fd\u6c47\u62a5\u4e00\u6b21");
        }
        if (pmsProjectBriefVO.getBriefStatus().equals("FINISHED")) return;
        throw TwException.error("", "\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5b8c\u6210\u7684\u9879\u76ee\u6c47\u62a5\uff0c\u8bf7\u5148\u5b8c\u6210\u4ee5\u524d\u7684\u9879\u76ee\u6c47\u62a5");
    }

    int autoReportFlag(String workType) {
        List<String> cods;
        int autoReportFlag = -1;
        List<String> cods0 = Arrays.asList(SaleConWorkTypeEnum.DELIVERY.getCode(), SaleConWorkTypeEnum.DEVELOP.getCode());
        if (cods0.contains(workType)) {
            autoReportFlag = 0;
        }
        if ((cods = Arrays.asList(SaleConWorkTypeEnum.OPERATION.getCode(), SaleConWorkTypeEnum.PURETRADE.getCode(), SaleConWorkTypeEnum.INDEPENDENT.getCode(), SaleConWorkTypeEnum.CONSULT.getCode(), SaleConWorkTypeEnum.TM.getCode())).contains(workType)) {
            autoReportFlag = 1;
        }
        return autoReportFlag;
    }

    public PmsProjectBriefVO queryBriefInfo(Long projectId) {
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(projectId);
        int autoReportFlag = this.autoReportFlag(pmsProjectVO.getWorkType());
        if (autoReportFlag == -1) {
            throw TwException.error("", "\u5de5\u4f5c\u7c7b\u578b\u4e0d\u9700\u8981\u8fdb\u884c\u9879\u76ee\u6c47\u62a5");
        }
        if (autoReportFlag == 1) {
            throw TwException.error("", "\u5de5\u4f5c\u7c7b\u578b\u4e3a\u81ea\u52a8\u6c47\u62a5\u7b56\u7565");
        }
        PmsProjectBriefVO projBriefView = this.operitonBriefData(pmsProjectVO);
        PmsProjectBriefVO lastPeriodBrief = this.pmsProjectBriefDAO.queryByProjectId(projectId, "FINISHED");
        if (lastPeriodBrief != null) {
            this.updateProjectBriefVO(lastPeriodBrief);
        }
        projBriefView.setLastPeriodBrief(lastPeriodBrief);
        return projBriefView;
    }

    public PmsProjectBriefVO operitonBriefData(PmsProjectVO pmsProjectVO) {
        BigDecimal amt = pmsProjectVO.getSumAmt() == null ? BigDecimal.ZERO : pmsProjectVO.getSumAmt();
        BigDecimal taxRate = pmsProjectVO.getTaxRate() == null ? BigDecimal.ZERO : pmsProjectVO.getTaxRate();
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setSaleConId(pmsProjectVO.getContractId());
        List recvPlanViews = this.conReceivablePlanService.queryListDynamic(query);
        BigDecimal actualReceivedAmt = recvPlanViews.stream().map(ConReceivablePlanVO::getActualRecvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal invoicedAmt = recvPlanViews.stream().map(ConReceivablePlanVO::getAlreadyInvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal notTaxAmt = amt.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
        BigDecimal notReceivedAmt = amt.subtract(actualReceivedAmt);
        BigDecimal invoicedNotReceivedAmt = invoicedAmt.subtract(actualReceivedAmt);
        BigDecimal notInvoicedReceivedAmt = notReceivedAmt.subtract(invoicedNotReceivedAmt);
        BigDecimal actualReceivedRate = BigDecimal.ZERO;
        if (BigDecimal.ZERO.compareTo(amt) != 0) {
            actualReceivedRate = actualReceivedAmt.divide(amt, 4, RoundingMode.HALF_UP).movePointRight(2);
        }
        BigDecimal feeBudgetAmt = pmsProjectVO.getTotalReimbursement() == null ? BigDecimal.ZERO : pmsProjectVO.getTotalReimbursement();
        BigDecimal totalEqva = pmsProjectVO.getTotalEqva();
        if (totalEqva == null) {
            totalEqva = BigDecimal.ZERO;
        }
        BigDecimal eqvaBudgetAmt = BigDecimal.ZERO;
        if (pmsProjectVO.getEqvaPrice() != null) {
            eqvaBudgetAmt = totalEqva.multiply(pmsProjectVO.getEqvaPrice());
        }
        PmsProjectBriefVO projBriefView = new PmsProjectBriefVO();
        projBriefView.setProjId(pmsProjectVO.getId());
        projBriefView.setProjName(pmsProjectVO.getProjName());
        projBriefView.setWorkType(pmsProjectVO.getWorkType());
        projBriefView.setProjAmt(amt);
        projBriefView.setProjAmtNoTax(notTaxAmt);
        projBriefView.setRecvedAmt(actualReceivedAmt);
        projBriefView.setNotReceivedAmt(notReceivedAmt);
        projBriefView.setInvoicedAmt(invoicedAmt);
        projBriefView.setInvoicedNotReceivedAmt(invoicedNotReceivedAmt);
        projBriefView.setNotInvoicedReceivedAmt(notInvoicedReceivedAmt);
        projBriefView.setActualReceivedRate(actualReceivedRate);
        projBriefView.setSubsidyAmt(pmsProjectVO.getSubsidyAmt());
        projBriefView.setTaxRate(taxRate);
        projBriefView.setFeeBudgetAmt(feeBudgetAmt);
        projBriefView.setEqvaBudgetCnt(totalEqva);
        projBriefView.setEqvaBudgetAmt(eqvaBudgetAmt);
        projBriefView.setRecvPlanViews(recvPlanViews);
        return projBriefView;
    }

    public PmsProjectBriefVO queryByKey(Long key) {
        PmsProjectBriefVO pmsProjectBriefVO = this.pmsProjectBriefDAO.queryByKey(key);
        if (pmsProjectBriefVO != null) {
            this.updateProjectBriefVO(pmsProjectBriefVO);
            this.transferData(pmsProjectBriefVO);
            LocalDate lastFinPeriodDate = pmsProjectBriefVO.getFinPeriodDate().minusMonths(1L);
            PmsProjectBriefVO lastPeriodBrief = this.pmsProjectBriefDAO.queryByProjectIdAndDate(pmsProjectBriefVO.getProjId(), lastFinPeriodDate);
            if (lastPeriodBrief != null && lastPeriodBrief.getProjAmt() != null) {
                this.updateProjectBriefVO(lastPeriodBrief);
            }
            pmsProjectBriefVO.setLastPeriodBrief(lastPeriodBrief);
        }
        return pmsProjectBriefVO;
    }

    void updateProjectBriefVO(PmsProjectBriefVO lastPeriodBrief) {
        BigDecimal projAmt = lastPeriodBrief.getProjAmt() == null ? BigDecimal.ZERO : lastPeriodBrief.getProjAmt();
        BigDecimal lastTaxRate = lastPeriodBrief.getTaxRate() == null ? BigDecimal.ZERO : lastPeriodBrief.getTaxRate();
        BigDecimal lastNotTaxAmt = projAmt.divide(BigDecimal.ONE.add(lastTaxRate), 2, RoundingMode.HALF_UP);
        BigDecimal lastNotReceivedAmt = projAmt.subtract(lastPeriodBrief.getRecvedAmt());
        BigDecimal lastInvoicedNotReceivedAmt = lastPeriodBrief.getInvoicedAmt().subtract(lastPeriodBrief.getRecvedAmt());
        BigDecimal lastNotInvoicedReceivedAmt = lastNotReceivedAmt.subtract(lastInvoicedNotReceivedAmt);
        lastPeriodBrief.setProjAmtNoTax(lastNotTaxAmt);
        lastPeriodBrief.setNotReceivedAmt(lastNotReceivedAmt);
        lastPeriodBrief.setInvoicedNotReceivedAmt(lastInvoicedNotReceivedAmt);
        lastPeriodBrief.setNotInvoicedReceivedAmt(lastNotInvoicedReceivedAmt);
    }

    public PagingVO<PmsProjectBriefVO> queryPaging(PmsProjectBriefQuery query) {
        PagingVO<PmsProjectBriefVO> pmsProjectBriefVOPagingVO = this.pmsProjectBriefDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty(pmsProjectBriefVOPagingVO)) {
            pmsProjectBriefVOPagingVO.getRecords().forEach(this::transferData);
        }
        return pmsProjectBriefVOPagingVO;
    }

    void transferData(PmsProjectBriefVO vo) {
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
    }

    public List<PmsProjectBriefVO> queryListDynamic(PmsProjectBriefQuery query) {
        return this.pmsProjectBriefDAO.queryListDynamic(query);
    }

    public void downloadBatch(HttpServletResponse response, PmsProjectBriefQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/pmsProjectBrief.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u9879\u76ee\u6c47\u62a5\u6570\u636e");
            String fileName = "\u9879\u76ee\u6c47\u62a5\u6570\u636e-" + LocalDate.now();
            MapBuilder mapBuilder = this.pageWhereBuilder(query);
            List result = this.beanSearcher.searchList(PmsProjectBriefVO.class, mapBuilder.build());
            if (!ObjectUtils.isEmpty((Object)result)) {
                result = this.udcUtil.translateList(result);
                int nextRow = 1;
                for (PmsProjectBriefVO projectBriefVO : result) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, projectBriefVO.getBriefNo());
                    this.excelUtil.setCellValue((Row)row, 1, projectBriefVO.getBriefStatusDesc());
                    this.excelUtil.setCellValue((Row)row, 2, projectBriefVO.getProjName());
                    this.excelUtil.setCellValue((Row)row, 3, projectBriefVO.getReferCode());
                    if (projectBriefVO.getFinPeriodDate() != null) {
                        int year = projectBriefVO.getFinPeriodDate().getYear();
                        int monthValue = projectBriefVO.getFinPeriodDate().getMonthValue();
                        String month = "" + monthValue;
                        if (monthValue < 10) {
                            month = "0" + monthValue;
                        }
                        this.excelUtil.setCellValue((Row)row, 4, year + "-" + month);
                    }
                    this.excelUtil.setCellValue((Row)row, 5, projectBriefVO.getProjProcessStatusDesc());
                    this.excelUtil.setCellValue((Row)row, 6, projectBriefVO.getContractStatusDesc());
                    if (projectBriefVO.getReprotCompPercent() != null) {
                        this.excelUtil.setCellValue((Row)row, 7, projectBriefVO.getReprotCompPercent() + "%");
                    }
                    this.excelUtil.setCellValue((Row)row, 8, projectBriefVO.getConfirmAmt());
                    this.excelUtil.setCellValue((Row)row, 9, projectBriefVO.getApplyUserDesc());
                    this.excelUtil.setCellValue((Row)row, 10, projectBriefVO.getApplyDate());
                    this.excelUtil.setCellValue((Row)row, 11, projectBriefVO.getDeliBuName());
                    this.excelUtil.setCellValue((Row)row, 12, projectBriefVO.getSignBuName());
                    ++nextRow;
                }
            }
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        List<PmsProjectBriefVO> pmsProjectBriefVOS;
        if (!keys.isEmpty() && !ObjectUtils.isEmpty(pmsProjectBriefVOS = this.pmsProjectBriefDAO.queryByKeys(keys))) {
            List<Long> ids = pmsProjectBriefVOS.stream().filter(BriefVO -> BriefVO.getBriefStatus().equals("CREATE")).map(PmsProjectBriefVO::getId).collect(Collectors.toList());
            if (ids == null || ids.size() < pmsProjectBriefVOS.size()) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u6c47\u62a5\u5220\u9664");
            }
            this.pmsProjectBriefDAO.deleteSoft(ids);
        }
    }

    public List<PmsProjectBriefVO> projectBriefWork(List<Long> projectIds) {
        if (ObjectUtils.isEmpty(projectIds)) {
            return new ArrayList<PmsProjectBriefVO>();
        }
        List<Map<String, Object>> maps = this.pmsProjectBriefRepo.projectBriefWork(projectIds);
        if (maps.size() > 0) {
            List<PmsProjectBriefVO> collect = maps.stream().map(brief -> {
                PmsProjectBriefVO pmsProjectBriefVO = new PmsProjectBriefVO();
                pmsProjectBriefVO.setId(Long.valueOf("" + brief.get("id")));
                pmsProjectBriefVO.setConfirmedAmt((BigDecimal)brief.get("confirmed_amt"));
                pmsProjectBriefVO.setProjId(Long.valueOf("" + brief.get("proj_id")));
                Date fin_period_date = (Date)brief.get("fin_period_date");
                pmsProjectBriefVO.setFinPeriodDate(fin_period_date.toLocalDate());
                pmsProjectBriefVO.setProjProcessStatus("" + brief.get("proj_process_status"));
                pmsProjectBriefVO.setReprotCompPercent(brief.get("reprot_comp_percent") == null ? BigDecimal.ZERO : (BigDecimal)brief.get("reprot_comp_percent"));
                return pmsProjectBriefVO;
            }).collect(Collectors.toList());
            return collect;
        }
        return new ArrayList<PmsProjectBriefVO>();
    }

    @Transactional(rollbackFor={Exception.class})
    public void projectBriefJobHandler(String date) {
        LocalDate briefDate = LocalDate.now();
        if (StringUtils.hasText((String)date)) {
            briefDate = LocalDate.parse(date);
        }
        log.info("-----\u5f00\u59cb\u6267\u884c\u9879\u76ee\u81ea\u52a8\u6c47\u62a5------");
        ArrayList<String> workTypes = new ArrayList<String>(Arrays.asList(SaleConWorkTypeEnum.OPERATION.getCode(), SaleConWorkTypeEnum.PURETRADE.getCode(), SaleConWorkTypeEnum.INDEPENDENT.getCode(), SaleConWorkTypeEnum.CONSULT.getCode(), SaleConWorkTypeEnum.TM.getCode()));
        PmsProjectQuery query = new PmsProjectQuery();
        query.setWorkTypes(workTypes);
        query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        query.setProjStatusType("1");
        List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.projectBriefWork(query);
        if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
            Map mapProjects = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getId, Function.identity()));
            LocalDate starDate = briefDate.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
            LocalDate endDate = briefDate.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
            List projIds = pmsProjectVOS.stream().filter(vo -> vo.getWorkType().equals(SaleConWorkTypeEnum.OPERATION.getCode()) && (vo.getChangeFlag() == null || vo.getChangeFlag() == 0)).map(PmsProjectVO::getId).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(projIds)) {
                PmsProjectReportPlanQuery queryPlan = new PmsProjectReportPlanQuery();
                queryPlan.setProjIds(projIds);
                queryPlan.setStartDate(starDate);
                queryPlan.setEndDate(endDate);
                List pmsProjectReportPlanVOS = this.pmsProjectReportPlanService.queryListDynamic(queryPlan);
                if (!ObjectUtils.isEmpty((Object)pmsProjectReportPlanVOS)) {
                    ArrayList<PmsProjectReportPlanPayload> payloadList = new ArrayList<PmsProjectReportPlanPayload>();
                    List<Long> collect0 = pmsProjectReportPlanVOS.stream().map(PmsProjectReportPlanVO::getProjId).collect(Collectors.toList());
                    List<PmsProjectBriefVO> pmsProjectBriefVOS = this.projectBriefWork(collect0);
                    Map<Object, Object> mapBriefs = ObjectUtils.isEmpty(pmsProjectBriefVOS) ? new HashMap() : pmsProjectBriefVOS.stream().collect(Collectors.toMap(PmsProjectBriefVO::getProjId, Function.identity()));
                    for (int i = 0; i < pmsProjectReportPlanVOS.size(); ++i) {
                        PmsProjectBriefVO projectBriefVO;
                        PmsProjectReportPlanVO planVO = (PmsProjectReportPlanVO)pmsProjectReportPlanVOS.get(i);
                        if (!projIds.contains(planVO.getProjId()) || (projectBriefVO = (PmsProjectBriefVO)mapBriefs.get(planVO.getProjId())) != null && projectBriefVO.getFinPeriodDate().compareTo(planVO.getPeriodDate()) >= 0) continue;
                        PmsProjectVO pmsProjectVO = (PmsProjectVO)mapProjects.get(planVO.getProjId());
                        BigDecimal confirmedAmt = (projectBriefVO == null ? BigDecimal.ZERO : projectBriefVO.getConfirmedAmt()).add(planVO.getAmt());
                        PmsProjectBriefVO pmsProjectBriefVO = this.operitonBriefData(pmsProjectVO);
                        PmsProjectBriefPayload payload = new PmsProjectBriefPayload();
                        String code = this.generateSeqNum("PMS_PROJ_REPORT", new String[0]);
                        payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
                        payload.setFinPeriodDate(planVO.getPeriodDate());
                        payload.setProjId(planVO.getProjId());
                        payload.setProjName(pmsProjectBriefVO.getProjName());
                        payload.setProjAmt(pmsProjectBriefVO.getProjAmt());
                        payload.setRecvedAmt(pmsProjectBriefVO.getRecvedAmt());
                        payload.setInvoicedAmt(pmsProjectBriefVO.getInvoicedAmt());
                        payload.setTaxRate(pmsProjectBriefVO.getTaxRate());
                        payload.setConfirmedAmt(confirmedAmt);
                        payload.setConfirmAmt(planVO.getAmt());
                        payload.setAutoReportFlag(Integer.valueOf(1));
                        if (pmsProjectBriefVO.getProjAmtNoTax().compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal divide = confirmedAmt.divide(pmsProjectBriefVO.getProjAmtNoTax(), 4, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L));
                            payload.setReprotCompPercent(divide);
                        } else {
                            payload.setReprotCompPercent(BigDecimal.ZERO);
                        }
                        PmsProjectBriefVO pmsProjectBriefVO1 = this.autoInsert(payload);
                        planVO.setBriefId(pmsProjectBriefVO1.getId());
                        planVO.setBriefNo(pmsProjectBriefVO1.getBriefNo());
                        PmsProjectReportPlanPayload pmsProjectReportPlanPayload = PmsProjectReportPlanConvert.INSTANCE.toPayload(planVO);
                        payloadList.add(pmsProjectReportPlanPayload);
                    }
                    if (payloadList.size() > 0) {
                        this.pmsProjectReportPlanService.batchInsert(payloadList);
                    }
                }
            }
            workTypes.remove(SaleConWorkTypeEnum.OPERATION.getCode());
            List contractIds = pmsProjectVOS.stream().filter(vo -> workTypes.contains(vo.getWorkType())).map(PmsProjectVO::getContractId).filter(Objects::nonNull).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(contractIds)) {
                ArrayList<LocalDate> invDate = new ArrayList<LocalDate>();
                invDate.add(starDate);
                invDate.add(endDate);
                ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
                queryReceivablePlan.setSaleConIds(contractIds);
                queryReceivablePlan.setInvDate(invDate);
                List recvPlanViews = this.conReceivablePlanService.queryListDynamic(queryReceivablePlan);
                ConInvBatchQuery invBatchQuery = new ConInvBatchQuery();
                invBatchQuery.setRefundDate(invDate);
                invBatchQuery.setBatchStatus("10");
                invBatchQuery.setInvStatus("CHARGEOFF");
                List conInvBatchVOS = this.invBatchService.queryListDynamic(invBatchQuery);
                List returnedContractIds = conInvBatchVOS.stream().filter(e -> e.getSaleContractId() != null).map(e -> e.getSaleContractId()).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty((Object)recvPlanViews) || !CollectionUtils.isEmpty(returnedContractIds)) {
                    Map mapContractProjects = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, Function.identity()));
                    ArrayList newContractIds = ObjectUtils.isEmpty((Object)recvPlanViews) ? new ArrayList() : recvPlanViews.stream().map(ConReceivablePlanVO::getSaleConId).distinct().collect(Collectors.toList());
                    ArrayList<Long> collect0 = CollectionUtils.isEmpty(newContractIds) ? new ArrayList<Long>() : pmsProjectVOS.stream().filter(vo -> newContractIds.contains(vo.getContractId())).map(PmsProjectVO::getId).collect(Collectors.toList());
                    List collect1 = pmsProjectVOS.stream().filter(vo -> returnedContractIds.contains(vo.getContractId())).map(PmsProjectVO::getId).collect(Collectors.toList());
                    collect0.addAll(collect1);
                    newContractIds.addAll(returnedContractIds);
                    List<Long> distinctNewContractIds = newContractIds.stream().distinct().collect(Collectors.toList());
                    List<PmsProjectBriefVO> pmsProjectBriefVOS = this.projectBriefWork(collect0);
                    Map<Object, Object> mapBriefs = ObjectUtils.isEmpty(pmsProjectBriefVOS) ? new HashMap() : pmsProjectBriefVOS.stream().collect(Collectors.toMap(PmsProjectBriefVO::getProjId, Function.identity()));
                    distinctNewContractIds.forEach(contractId -> {
                        PmsProjectBriefVO projectBriefVO;
                        PmsProjectVO pmsProjectVO = (PmsProjectVO)mapContractProjects.get(contractId);
                        if (!(ObjectUtils.isEmpty((Object)pmsProjectVO) || (projectBriefVO = (PmsProjectBriefVO)mapBriefs.get(pmsProjectVO.getId())) != null && projectBriefVO.getFinPeriodDate().compareTo(starDate) >= 0)) {
                            PmsProjectBriefVO pmsProjectBriefVO = this.operitonBriefData(pmsProjectVO);
                            BigDecimal invoicedAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId)).map(ConReceivablePlanVO::getAlreadyInvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                            BigDecimal returnedInvoicedAmt = BigDecimal.ZERO;
                            for (ConInvBatchVO invBatchVO : conInvBatchVOS) {
                                if (invBatchVO.getSaleContractId() == null || !invBatchVO.getSaleContractId().equals(contractId)) continue;
                                ConInvBatchInvdtlQuery conInvBatchInvdtlQuery = new ConInvBatchInvdtlQuery();
                                conInvBatchInvdtlQuery.setInvbatchId(invBatchVO.getId());
                                conInvBatchInvdtlQuery.setCreateTimeStart(LocalDateTime.of(starDate, LocalTime.MIN));
                                conInvBatchInvdtlQuery.setCreateTimeEnd(LocalDateTime.of(endDate.plusDays(1L), LocalTime.MIN));
                                List conInvBatchInvdtlVOS = this.invBatchInvdtlService.queryListDynamic(conInvBatchInvdtlQuery);
                                BigDecimal returnedInvoicedAmtChild = conInvBatchInvdtlVOS.stream().map(entry -> entry.getInvAmt()).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                                returnedInvoicedAmt = returnedInvoicedAmt.add(returnedInvoicedAmtChild);
                            }
                            log.info("\u5408\u540c\u53f7" + contractId + "\u7684invoicedAmt::::::::::::::::::" + invoicedAmt);
                            log.info("\u5408\u540c\u53f7" + contractId + "\u7684returnedInvoicedAmt::::::::::::::::::" + returnedInvoicedAmt);
                            invoicedAmt = invoicedAmt.add(returnedInvoicedAmt);
                            BigDecimal notTaxInvoicedAmt = invoicedAmt.divide(BigDecimal.ONE.add(pmsProjectBriefVO.getTaxRate()), 2, RoundingMode.HALF_UP);
                            BigDecimal confirmedAmt = (projectBriefVO == null ? BigDecimal.ZERO : projectBriefVO.getConfirmedAmt()).add(notTaxInvoicedAmt);
                            PmsProjectBriefPayload payload = new PmsProjectBriefPayload();
                            String code = this.generateSeqNum("PMS_PROJ_REPORT", new String[0]);
                            payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
                            payload.setFinPeriodDate(starDate);
                            payload.setProjId(pmsProjectVO.getId());
                            payload.setProjName(pmsProjectBriefVO.getProjName());
                            payload.setProjAmt(pmsProjectBriefVO.getProjAmt());
                            payload.setRecvedAmt(pmsProjectBriefVO.getRecvedAmt());
                            payload.setInvoicedAmt(invoicedAmt);
                            payload.setTaxRate(pmsProjectBriefVO.getTaxRate());
                            payload.setConfirmedAmt(confirmedAmt);
                            payload.setConfirmAmt(notTaxInvoicedAmt);
                            payload.setAutoReportFlag(Integer.valueOf(1));
                            if (pmsProjectVO.getWorkType().equals(SaleConWorkTypeEnum.TM.getCode())) {
                                payload.setReprotCompPercent(BigDecimal.valueOf(100L));
                            } else {
                                BigDecimal divide = confirmedAmt.divide(pmsProjectBriefVO.getProjAmtNoTax(), 4, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L));
                                payload.setReprotCompPercent(divide);
                            }
                            PmsProjectBriefVO pmsProjectBriefVO2 = this.autoInsert(payload);
                        }
                    });
                }
            }
        }
        log.info("-----\u7ed3\u675f\u6267\u884c\u9879\u76ee\u81ea\u52a8\u6c47\u62a5------");
    }

    public void autoSupplementBierf(Long projectId) {
        block5: {
            List recvPlanViews;
            LocalDate localDate;
            PmsProjectBriefVO pmsProjectBriefVO;
            PmsProjectVO pmsProjectVO;
            block6: {
                pmsProjectVO = this.pmsProjectDAO.queryByKey(projectId);
                if (pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) break block5;
                List<String> cods = Arrays.asList(SaleConWorkTypeEnum.OPERATION.getCode(), SaleConWorkTypeEnum.PURETRADE.getCode(), SaleConWorkTypeEnum.INDEPENDENT.getCode(), SaleConWorkTypeEnum.CONSULT.getCode(), SaleConWorkTypeEnum.TM.getCode());
                pmsProjectBriefVO = this.operitonBriefData(pmsProjectVO);
                if (!cods.contains(pmsProjectVO.getWorkType())) break block5;
                localDate = pmsProjectVO.getCreateTime().toLocalDate();
                LocalDate with = localDate.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
                if (!pmsProjectVO.getWorkType().equals(SaleConWorkTypeEnum.OPERATION.getCode())) break block6;
                PmsProjectReportPlanQuery query = new PmsProjectReportPlanQuery();
                query.setProjId(projectId);
                query.setEndDate(with);
                List pmsProjectReportPlanVOS = this.pmsProjectReportPlanService.queryListDynamic(query);
                if (pmsProjectReportPlanVOS == null) break block5;
                ArrayList<PmsProjectReportPlanPayload> payloadList = new ArrayList<PmsProjectReportPlanPayload>();
                List collect = pmsProjectReportPlanVOS.stream().sorted(Comparator.comparing(PmsProjectReportPlanVO::getPeriodDate)).collect(Collectors.toList());
                BigDecimal confirmedAmt = BigDecimal.ZERO;
                for (int i = 0; i < collect.size(); ++i) {
                    PmsProjectReportPlanVO planVO = (PmsProjectReportPlanVO)collect.get(i);
                    int b = DateUtil.differenceMonth(planVO.getPeriodDate(), localDate);
                    if (b <= 0) continue;
                    confirmedAmt = confirmedAmt.add(planVO.getAmt());
                    PmsProjectBriefPayload payload = new PmsProjectBriefPayload();
                    String code = this.generateSeqNum("PMS_PROJ_REPORT", new String[0]);
                    payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
                    payload.setFinPeriodDate(planVO.getPeriodDate());
                    payload.setProjId(projectId);
                    payload.setProjName(pmsProjectVO.getProjName());
                    payload.setProjAmt(pmsProjectVO.getSumAmt());
                    payload.setRecvedAmt(pmsProjectBriefVO.getRecvedAmt());
                    payload.setInvoicedAmt(pmsProjectBriefVO.getInvoicedAmt());
                    payload.setTaxRate(pmsProjectBriefVO.getTaxRate());
                    payload.setConfirmedAmt(confirmedAmt);
                    payload.setConfirmAmt(planVO.getAmt());
                    BigDecimal divide = confirmedAmt.divide(pmsProjectBriefVO.getProjAmtNoTax(), 4, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L));
                    payload.setReprotCompPercent(divide);
                    PmsProjectBriefVO pmsProjectBriefVO1 = this.autoInsert(payload);
                    planVO.setBriefId(pmsProjectBriefVO1.getId());
                    planVO.setBriefNo(pmsProjectBriefVO1.getBriefNo());
                    planVO.setRemark("\u5386\u53f2\u6c47\u62a5\u6570\u636e\u81ea\u52a8\u8865\u9f50");
                    PmsProjectReportPlanPayload pmsProjectReportPlanPayload = PmsProjectReportPlanConvert.INSTANCE.toPayload(planVO);
                    payloadList.add(pmsProjectReportPlanPayload);
                }
                if (payloadList.size() <= 0) break block5;
                this.pmsProjectReportPlanService.batchInsert(payloadList);
                break block5;
            }
            int b = DateUtil.differenceMonth(pmsProjectVO.getPlanStartDate(), localDate);
            if (b > 0 && !ObjectUtils.isEmpty((Object)(recvPlanViews = pmsProjectBriefVO.getRecvPlanViews()))) {
                BigDecimal confirmedAmt = BigDecimal.ZERO;
                for (int i = 0; i < b; ++i) {
                    LocalDate localDate1 = pmsProjectVO.getPlanStartDate().plusMonths(i);
                    BigDecimal invoicedAmt = recvPlanViews.stream().filter(recvPlanView -> DateUtil.differenceMonth(recvPlanView.getInvDate(), localDate1) == 1).map(ConReceivablePlanVO::getAlreadyInvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    if (invoicedAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal notTaxInvoicedAmt = invoicedAmt.divide(BigDecimal.ONE.add(pmsProjectBriefVO.getTaxRate()), 2, RoundingMode.HALF_UP);
                    confirmedAmt = confirmedAmt.add(notTaxInvoicedAmt);
                    PmsProjectBriefPayload payload = new PmsProjectBriefPayload();
                    String code = this.generateSeqNum("PMS_PROJ_REPORT", new String[0]);
                    payload.setBriefNo(pmsProjectVO.getProjNo() + "-" + code);
                    payload.setFinPeriodDate(localDate1);
                    payload.setProjId(projectId);
                    payload.setProjName(pmsProjectVO.getProjName());
                    payload.setProjAmt(pmsProjectVO.getSumAmt());
                    payload.setRecvedAmt(pmsProjectBriefVO.getRecvedAmt());
                    payload.setInvoicedAmt(pmsProjectBriefVO.getInvoicedAmt());
                    payload.setTaxRate(pmsProjectBriefVO.getTaxRate());
                    payload.setConfirmedAmt(confirmedAmt);
                    payload.setConfirmAmt(notTaxInvoicedAmt);
                    if (pmsProjectVO.getWorkType().equals(SaleConWorkTypeEnum.TM.getCode())) {
                        payload.setReprotCompPercent(BigDecimal.valueOf(100L));
                    } else {
                        BigDecimal divide = confirmedAmt.divide(pmsProjectBriefVO.getProjAmtNoTax(), 4, RoundingMode.DOWN).multiply(BigDecimal.valueOf(100L));
                        payload.setReprotCompPercent(divide);
                    }
                    PmsProjectBriefVO pmsProjectBriefVO2 = this.autoInsert(payload);
                }
            }
        }
    }

    public PagingVO<PmsProjectBriefVO> queryPagingPermission(PmsProjectBriefQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(PmsProjectBriefVO.class, mapBuilder.build());
        long total = (Long)totalNum;
        if (total == 0L) {
            return PagingVO.empty();
        }
        List pmsProjectBriefVOList = this.beanSearcher.searchList(PmsProjectBriefVO.class, mapBuilder.build());
        if (!ObjectUtils.isEmpty((Object)pmsProjectBriefVOList)) {
            pmsProjectBriefVOList.forEach(this::transferData);
        }
        return PagingVO.builder().records(pmsProjectBriefVOList).total(total).build();
    }

    private MapBuilder pageWhereBuilder(PmsProjectBriefQuery query) {
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getBriefNo())) {
            ((MapBuilder)builder.field(PmsProjectBriefVO::getBriefNo, new Object[]{query.getBriefNo()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getBriefStatus())) {
            ((MapBuilder)builder.field(PmsProjectBriefVO::getBriefStatus, new Object[]{query.getBriefStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getApplyDate())) {
            ((MapBuilder)builder.field(PmsProjectBriefVO::getApplyDate, new Object[]{query.getApplyDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinPeriodDate())) {
            ((MapBuilder)builder.field(PmsProjectBriefVO::getFinPeriodDate, new Object[]{query.getFinPeriodDate()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            ((MapBuilder)builder.field(PmsProjectBriefVO::getCreateUserId, new Object[]{query.getCreateUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjSearch())) {
            String likeStr = "%" + query.getProjSearch() + "%";
            ((MapBuilder)builder.field(PmsProjectBriefVO::getProjName, new FieldFns.FieldFn[]{PmsProjectBriefVO::getProjNo})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractStatus())) {
            ((MapBuilder)builder.field(PmsProjectBriefVO::getContractStatus, new Object[]{query.getContractStatus()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliBuId())) {
            ((MapBuilder)builder.field(PmsProjectBriefVO::getDeliBuId, new Object[]{query.getDeliBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSignBuId())) {
            ((MapBuilder)builder.field(PmsProjectBriefVO::getSignBuId, new Object[]{query.getSignBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjProcessStatus())) {
            ((MapBuilder)builder.field(PmsProjectBriefVO::getProjProcessStatus, new Object[]{query.getProjProcessStatus()})).op((FieldOp)FieldOps.Equal);
        }
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public PmsProjectBriefServiceImpl(WorkflowUtil workflowUtil, PmsProjectBriefRepo pmsProjectBriefRepo, PmsProjectBriefDAO pmsProjectBriefDAO, PmsProjectDAO pmsProjectDAO, ConReceivablePlanService conReceivablePlanService, PrdSystemRoleService roleService, TransactionUtilService transactionUtilService, CacheUtil cacheUtil, PmsProjectReportPlanService pmsProjectReportPlanService, ExcelUtil excelUtil, UdcUtil udcUtil, ConInvBatchService invBatchService, ConInvBatchInvdtlService invBatchInvdtlService) {
        this.workflowUtil = workflowUtil;
        this.pmsProjectBriefRepo = pmsProjectBriefRepo;
        this.pmsProjectBriefDAO = pmsProjectBriefDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.conReceivablePlanService = conReceivablePlanService;
        this.roleService = roleService;
        this.transactionUtilService = transactionUtilService;
        this.cacheUtil = cacheUtil;
        this.pmsProjectReportPlanService = pmsProjectReportPlanService;
        this.excelUtil = excelUtil;
        this.udcUtil = udcUtil;
        this.invBatchService = invBatchService;
        this.invBatchInvdtlService = invBatchInvdtlService;
    }
}

