/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectCardConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectCardConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectCardConfigService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectCardConfigVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectPageConfigVO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProjectPageTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectCardConfigConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectCardConfigDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectCardConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectCardConfigRepo;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PmsProjectCardConfigServiceImpl
extends BaseServiceImpl
implements PmsProjectCardConfigService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectCardConfigServiceImpl.class);
    private final PmsProjectCardConfigRepo pmsProjectCardConfigRepo;
    private final PmsProjectCardConfigDAO pmsProjectCardConfigDAO;

    public PagingVO<PmsProjectCardConfigVO> queryPaging(PmsProjectCardConfigQuery query) {
        return this.pmsProjectCardConfigDAO.queryPaging(query);
    }

    public List<PmsProjectCardConfigVO> queryListDynamic(PmsProjectCardConfigQuery query) {
        return this.pmsProjectCardConfigDAO.queryListDynamic(query);
    }

    public PmsProjectCardConfigVO queryByKey(Long key) {
        PmsProjectCardConfigDO entity = this.pmsProjectCardConfigRepo.findById(key).orElseGet(PmsProjectCardConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectCardConfigVO vo = PmsProjectCardConfigConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectCardConfigVO insert(PmsProjectCardConfigPayload payload) {
        PmsProjectCardConfigDO entityDo = PmsProjectCardConfigConvert.INSTANCE.toDo(payload);
        return PmsProjectCardConfigConvert.INSTANCE.toVo((PmsProjectCardConfigDO)this.pmsProjectCardConfigRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectCardConfigVO update(PmsProjectCardConfigPayload payload) {
        PmsProjectCardConfigDO entity = this.pmsProjectCardConfigRepo.findById(payload.getId()).orElseGet(PmsProjectCardConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectCardConfigDO entityDo = PmsProjectCardConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectCardConfigConvert.INSTANCE.toVo((PmsProjectCardConfigDO)this.pmsProjectCardConfigRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectCardConfigPayload payload) {
        PmsProjectCardConfigDO entity = this.pmsProjectCardConfigRepo.findById(payload.getId()).orElseGet(PmsProjectCardConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsProjectCardConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.pmsProjectCardConfigDAO.deleteSoft(keys);
        }
    }

    public PmsProjectPageConfigVO queryPageConfigList(PmsProjectCardConfigQuery query) {
        List<PmsProjectCardConfigVO> pmsProjectCardConfigVOS = this.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(pmsProjectCardConfigVOS)) {
            PmsProjectPageConfigVO pmsProjectPageConfigVO = new PmsProjectPageConfigVO();
            List tabConfigVOList = pmsProjectCardConfigVOS.stream().filter(e -> PmsProjectPageTypeEnum.TAB.getCode().equals(e.getExtStr1())).collect(Collectors.toList());
            List cardConfigVOList = pmsProjectCardConfigVOS.stream().filter(e -> PmsProjectPageTypeEnum.CARD.getCode().equals(e.getExtStr1())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(tabConfigVOList)) {
                Collections.sort(tabConfigVOList, Comparator.comparing(PmsProjectCardConfigVO::getSort));
                pmsProjectPageConfigVO.setPmsProjectTabConfigVOS(tabConfigVOList);
            }
            if (!CollectionUtils.isEmpty(cardConfigVOList)) {
                Collections.sort(cardConfigVOList, Comparator.comparing(PmsProjectCardConfigVO::getSort));
                pmsProjectPageConfigVO.setPmsProjectCardConfigVOS(cardConfigVOList);
            }
            return pmsProjectPageConfigVO;
        }
        return null;
    }

    @Transactional
    public void saveAll(List<PmsProjectCardConfigPayload> payloadList) {
        if (!CollectionUtils.isEmpty(payloadList)) {
            List pmsProjectCardConfigDOList = payloadList.stream().map(e -> PmsProjectCardConfigConvert.INSTANCE.toDo((PmsProjectCardConfigPayload)e)).collect(Collectors.toList());
            this.pmsProjectCardConfigRepo.saveAll(pmsProjectCardConfigDOList);
        }
    }

    public PmsProjectCardConfigServiceImpl(PmsProjectCardConfigRepo pmsProjectCardConfigRepo, PmsProjectCardConfigDAO pmsProjectCardConfigDAO) {
        this.pmsProjectCardConfigRepo = pmsProjectCardConfigRepo;
        this.pmsProjectCardConfigDAO = pmsProjectCardConfigDAO;
    }
}

