/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetSubjectDetailService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCountVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetUsedVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalWideSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalWideSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanDtlPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.DayJsonVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectReportPlanPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectActivityQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectEventLogQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectBriefService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectEventLogService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectReportPlanService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsResourcePlanService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsActAndPlanJsonVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsPersonPlanAndActualVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectExcelExport;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectOverviewVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectPurContractVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectReceiveVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectReportPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractManagerQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoCountVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.change.dao.ComChangeDAO;
import com.elitesland.tw.tw5.server.common.constants.ComChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.permission.PermissionBeanSearcherFactory;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTurTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConWorkTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.personplan.constants.PersonPlanUomEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProjecReceiveTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectRiskLevelEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.StateFlowStateEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectReportPlanConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectMembersDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectRepo;
import com.elitesland.tw.tw5.server.prd.pms.service.event.ProjectAddEvent;
import com.elitesland.tw.tw5.server.prd.system.constant.SystemSettingsItemEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedocref.YeedocUtils;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsProjectServiceImpl
extends BaseServiceImpl
implements PmsProjectService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectServiceImpl.class);
    private final PmsProjectRepo pmsProjectRepo;
    private final PmsProjectDAO pmsProjectDAO;
    private final FileUtil fileUtil;
    private final PmsProjectBriefService pmsProjectBriefService;
    private final PmsProjectReportPlanService pmsProjectReportPlanService;
    private final TransactionUtilService transactionUtilService;
    private final ComChangeService changeService;
    private final WorkflowUtil workflowUtil;
    private final PrdSystemRoleService roleService;
    private final UdcUtil udcUtil;
    private final ConReceivablePlanService conReceivablePlanService;
    private final CrmCustomerOperationService customerOperationService;
    private final PmsProjectTemplateService pmsProjectTemplateService;
    private final CacheUtil cacheUtil;
    private final PmsProjectMembersDAO pmsProjectMembersDAO;
    private final CalAccountService calAccountService;
    private final CalWideSettleService calWideSettleService;
    private final com.elitesland.tw.tw5.server.common.ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PmsProjectActivityService projectActivityService;
    private final PmsProjectMembersService projectMembersService;
    private final PmsResourcePlanService resourcePlanService;
    private final BudgetDAO budgetDAO;
    private final TaskPackageDAO taskPackageDAO;
    private final BusinessPartnerService businessPartnerService;
    private final TaskCommonService taskCommonService;
    private final TaskInfoDAO taskInfoDAO;
    private BeanSearcher beanSearcher;
    @Autowired
    @Lazy
    private BudgetCommonService budgetCommonService;
    @Autowired
    @Lazy
    private BudgetService budgetService;
    private final BudgetSubjectDetailService budgetSubjectDetailService;
    @Autowired
    @Lazy
    private ProRelatedPartiesService proRelatedPartiesService;
    private final PmsProjectEventLogService pmsProjectEventLogService;
    private final ComChangeDAO comChangeDAO;
    @Autowired
    @Lazy
    private PurchaseContractManagerService purchaseContractManagerService;
    @Autowired
    @Lazy
    private PersonPlanService personPlanService;
    @Autowired
    @Lazy
    private PersonPlanDtlService personPlanDtlService;
    @Autowired
    @Lazy
    private TimesheetService timesheetService;
    @Autowired
    @Lazy
    private SaleConExecConditionService saleConExecConditionService;
    @Value(value="${tw5.project.briefDate:15}")
    private Integer briefDate = 15;
    private final YeedocUtils yeedocUtils;
    @Autowired(required=false)
    private Map<String, ProjectAddEvent> projectAddEventMap;

    @Autowired
    public void setBeanSearcher(PermissionBeanSearcherFactory permissionBeanSearcherFactory) {
        this.beanSearcher = permissionBeanSearcherFactory.getBeanSearcherService(PermissionDomainEnum.PMS_PROJECT);
    }

    private MapBuilder pageWhereBuilder(PmsProjectQuery query) {
        String likeStr;
        MapBuilder builder = MapUtils.builder();
        if (!ObjectUtils.isEmpty((Object)query.getProjectSearchKey())) {
            likeStr = "%" + query.getProjectSearchKey() + "%";
            ((MapBuilder)builder.field(PmsProjectVO::getProjName, new FieldFns.FieldFn[]{PmsProjectVO::getProjNo})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getWorkType())) {
            ((MapBuilder)builder.field(PmsProjectVO::getWorkType, new Object[]{query.getWorkType()})).op((FieldOp)FieldOps.Equal);
        }
        if (query.getIsExternalProject().booleanValue()) {
            query.setPlatType(SaleConEnum.FICTITIOUS.getCode());
            ((MapBuilder)builder.field(PmsProjectVO::getPlatType, new Object[]{query.getPlatType()})).op((FieldOp)FieldOps.NotEqual);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjStatus())) {
            if (ObjectUtils.isEmpty((Object)query.getProjStatusType()) || "1".equals(query.getProjStatusType())) {
                ((MapBuilder)builder.field(PmsProjectVO::getProjStatus, new Object[]{query.getProjStatus()})).op((FieldOp)FieldOps.Equal);
            } else {
                ((MapBuilder)builder.field(PmsProjectVO::getProjStatus, new Object[]{query.getProjStatus()})).op((FieldOp)FieldOps.NotEqual);
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliBuId())) {
            ((MapBuilder)builder.field(PmsProjectVO::getDeliBuId, new Object[]{query.getDeliBuId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliUserId())) {
            ((MapBuilder)builder.field(PmsProjectVO::getDeliUserId, new Object[]{query.getDeliUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleManUserId())) {
            ((MapBuilder)builder.field(PmsProjectVO::getSaleManUserId, new Object[]{query.getSaleManUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRiskLevel())) {
            ((MapBuilder)builder.field(PmsProjectVO::getRiskLevel, new Object[]{query.getRiskLevel()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPmResId())) {
            ((MapBuilder)builder.field(PmsProjectVO::getPmResId, new Object[]{query.getPmResId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPmoResId())) {
            ((MapBuilder)builder.field(PmsProjectVO::getPmoResId, new Object[]{query.getPmoResId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractSearchKey())) {
            likeStr = "%" + query.getContractSearchKey() + "%";
            ((MapBuilder)builder.field(PmsProjectVO::getContractName, new FieldFns.FieldFn[]{PmsProjectVO::getContractNo})).sql("$1 like ? or $2 like ?", new Object[]{likeStr, likeStr});
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostLevel())) {
            ((MapBuilder)builder.field(PmsProjectVO::getCostLevel, new Object[]{query.getCostLevel()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPmResId())) {
            ((MapBuilder)builder.field(PmsProjectVO::getPmResId, new Object[]{query.getPmResId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelatedProjNo())) {
            ((MapBuilder)builder.field(PmsProjectVO::getRelatedProjNo, new Object[]{query.getRelatedProjNo()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getProductNo())) {
            ((MapBuilder)builder.field(PmsProjectVO::getProductNo, new Object[]{query.getProductNo()})).op((FieldOp)FieldOps.Contain);
        }
        if (!ObjectUtils.isEmpty((Object)query.getFileUploadFlag()) && !ObjectUtils.isEmpty((Object)query.getConfigId())) {
            Long configId = query.getConfigId();
            if (Boolean.TRUE.equals(query.getFileUploadFlag())) {
                ((MapBuilder)builder.field(PmsProjectVO::getId, new FieldFns.FieldFn[0])).sql(" $1 in (SELECT r.doc_id FROM prd_business_doc_type_upload_record r WHERE r.doc_type='PMS_PROJECT' AND r.config_id=? AND r.delete_flag=0)", new Object[]{configId});
            } else if (Boolean.FALSE.equals(query.getFileUploadFlag())) {
                ((MapBuilder)builder.field(PmsProjectVO::getId, new FieldFns.FieldFn[0])).sql(" $1 not in (SELECT r.doc_id FROM prd_business_doc_type_upload_record r WHERE r.doc_type='PMS_PROJECT' AND r.config_id=? AND r.delete_flag=0)", new Object[]{configId});
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getProductNoExit())) {
            if ("1".equals(query.getProductNoExit())) {
                ((MapBuilder)builder.field(PmsProjectVO::getProductNo, new Object[]{query.getProductNo()})).op((FieldOp)FieldOps.NotEmpty);
            } else {
                ((MapBuilder)builder.field(PmsProjectVO::getProductNo, new Object[]{query.getProductNo()})).op((FieldOp)FieldOps.Empty);
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanStartDateBetween())) {
            ((MapBuilder)builder.field(PmsProjectVO::getPlanStartDate, new Object[]{query.getPlanStartDateBetween().get(0), query.getPlanStartDateBetween().get(1)})).op((FieldOp)FieldOps.Between);
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanEndDateBetween())) {
            ((MapBuilder)builder.field(PmsProjectVO::getPlanEndDate, new Object[]{query.getPlanEndDateBetween().get(0), query.getPlanEndDateBetween().get(1)})).op((FieldOp)FieldOps.Between);
        }
        builder.put("groupBy", (Object)"pp.id");
        SqlUtil.handleBS(builder, (TwQueryParam)query);
        return builder;
    }

    public PagingVO<PmsProjectVO> queryPaging(PmsProjectQuery query) {
        MapBuilder mapBuilder = this.pageWhereBuilder(query);
        Number totalNum = this.beanSearcher.searchCount(PmsProjectVO.class, mapBuilder.build());
        long total = (Long)totalNum;
        if (total == 0L) {
            return PagingVO.empty();
        }
        List pmsProjectVOs = this.beanSearcher.searchList(PmsProjectVO.class, mapBuilder.build());
        ArrayList<Long> contractIds = new ArrayList<Long>();
        ArrayList ids = new ArrayList();
        pmsProjectVOs.forEach(vo -> {
            if (vo.getCustId() != null) {
                vo.setCustName(this.cacheUtil.getCompanyNameByBookId(vo.getCustId()));
            }
            if (vo.getContractId() != null) {
                contractIds.add(vo.getContractId());
            }
            if (vo.getEqvaReleasedQty() != null && vo.getEqvaReleasedQty().compareTo(BigDecimal.ZERO) > 0) {
                ids.add(vo.getId());
                vo.setRemainReleasedEqva(vo.getEqvaBudgetCnt().subtract(vo.getEqvaReleasedQty()));
            }
        });
        this.tranContractData(pmsProjectVOs, contractIds);
        return PagingVO.builder().records(pmsProjectVOs).total(total).build();
    }

    void tranContractData(List<PmsProjectVO> pmsProjectVOs, List<Long> contractIds) {
        if (contractIds.size() > 0) {
            ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
            queryReceivablePlan.setSaleConIds(contractIds);
            List recvPlanViews = this.conReceivablePlanService.queryListDynamic(queryReceivablePlan);
            if (!ObjectUtils.isEmpty((Object)recvPlanViews)) {
                Map mapContractProjects = pmsProjectVOs.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, Function.identity()));
                mapContractProjects.forEach((contractId, pmsProjectVO) -> {
                    BigDecimal actualReceivedAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId)).map(ConReceivablePlanVO::getActualRecvAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal invoicedAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId)).map(ConReceivablePlanVO::getAlreadyInvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal notReceivedAmt = (pmsProjectVO.getSumAmt() == null ? BigDecimal.ZERO : pmsProjectVO.getSumAmt()).subtract(actualReceivedAmt);
                    pmsProjectVO.setNotReceivedAmt(notReceivedAmt);
                    pmsProjectVO.setInvoicedAmt(invoicedAmt);
                    pmsProjectVO.setRecvedAmt(actualReceivedAmt);
                    BigDecimal notInvAmt = recvPlanViews.stream().filter(recvPlanView -> recvPlanView.getSaleConId().equals(contractId)).map(ConReceivablePlanVO::getNotInvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    pmsProjectVO.setNotInvAmt(notInvAmt);
                });
            }
        }
    }

    public void downloadBatch(HttpServletResponse response, PmsProjectQuery query) {
        try {
            MapBuilder mapBuilder = this.pageWhereBuilder(query);
            List result = this.beanSearcher.searchList(PmsProjectVO.class, mapBuilder.build());
            if (!ObjectUtils.isEmpty((Object)result)) {
                List<Long> collect = result.stream().filter(vo -> vo.getContractId() != null).map(PmsProjectVO::getContractId).distinct().collect(Collectors.toList());
                this.tranContractData(result, collect);
                result = this.udcUtil.translateList(result);
                List<PmsProjectExcelExport> resultList = PmsProjectConvert.INSTANCE.voListVoExcelExport(result);
                resultList.forEach(vo -> {
                    vo.setPlanStartDateStr(vo.getPlanStartDate() == null ? "" : vo.getPlanStartDate().toString());
                    vo.setPlanEndDateStr(vo.getPlanEndDate() == null ? "" : vo.getPlanEndDate().toString());
                    if (vo.getCreateTime() != null) {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                        vo.setCreateTimeStr(vo.getCreateTime().format(formatter));
                    }
                });
                String sheetName = "\u9879\u76ee\u6570\u636e";
                String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                response.setCharacterEncoding("utf-8");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), PmsProjectExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
                ExcelUtil.excelHelper(sheet, PmsProjectExcelExport.class, null);
                sheet.doWrite(resultList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void downloadBatch0(HttpServletResponse response, PmsProjectQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/pmsProjectBatch.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u9879\u76ee\u6570\u636e");
            String fileName = "\u9879\u76ee\u6570\u636e-" + LocalDate.now();
            MapBuilder mapBuilder = this.pageWhereBuilder(query);
            List result = this.beanSearcher.searchList(PmsProjectVO.class, mapBuilder.build());
            if (!ObjectUtils.isEmpty((Object)result)) {
                List<Long> collect = result.stream().filter(vo -> vo.getContractId() != null).map(PmsProjectVO::getContractId).distinct().collect(Collectors.toList());
                this.tranContractData(result, collect);
                result = this.udcUtil.translateList(result);
                int nextRow = 1;
                for (PmsProjectVO projectVO : result) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, projectVO.getProjNo());
                    this.excelUtil.setCellValue((Row)row, 1, projectVO.getProjName());
                    this.excelUtil.setCellValue((Row)row, 2, projectVO.getBangwo8ProjName());
                    this.excelUtil.setCellValue((Row)row, 3, projectVO.getWorkTypeDesc());
                    this.excelUtil.setCellValue((Row)row, 4, projectVO.getProjStatusDesc());
                    this.excelUtil.setCellValue((Row)row, 5, projectVO.getDeliBuName());
                    this.excelUtil.setCellValue((Row)row, 6, projectVO.getRiskLevelDesc());
                    this.excelUtil.setCellValue((Row)row, 7, projectVO.getPmResName());
                    this.excelUtil.setCellValue((Row)row, 8, projectVO.getSaleManUserName());
                    this.excelUtil.setCellValue((Row)row, 9, projectVO.getPmoResName());
                    this.excelUtil.setCellValue((Row)row, 10, projectVO.getContractNo());
                    this.excelUtil.setCellValue((Row)row, 11, projectVO.getContractName());
                    this.excelUtil.setCellValue((Row)row, 12, projectVO.getPlatTypeDesc());
                    this.excelUtil.setCellValue((Row)row, 13, projectVO.getSumAmt());
                    this.excelUtil.setCellValue((Row)row, 14, projectVO.getInvoicedAmt());
                    this.excelUtil.setCellValue((Row)row, 15, projectVO.getRecvedAmt());
                    this.excelUtil.setCellValue((Row)row, 16, projectVO.getNotReceivedAmt());
                    if (projectVO.getCompPercent() != null) {
                        this.excelUtil.setCellValue((Row)row, 17, projectVO.getCompPercent());
                    }
                    this.excelUtil.setCellValue((Row)row, 18, projectVO.getProjProcessStatusDesc());
                    this.excelUtil.setCellValue((Row)row, 19, projectVO.getReportTime());
                    this.excelUtil.setCellValue((Row)row, 20, projectVO.getPlanUpdateDate());
                    this.excelUtil.setCellValue((Row)row, 21, projectVO.getRelatedProjNo());
                    this.excelUtil.setCellValue((Row)row, 22, projectVO.getProductNo());
                    this.excelUtil.setCellValue((Row)row, 23, projectVO.getPlanStartDate());
                    this.excelUtil.setCellValue((Row)row, 24, projectVO.getPlanEndDate());
                    this.excelUtil.setCellValue((Row)row, 25, projectVO.getCreateTime());
                    ++nextRow;
                }
            }
            com.elitesland.tw.tw5.server.common.ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map queryPlanAndActual(Long key) {
        HashSet resIdSet = new HashSet();
        ArrayList pmsPersonPlanAndActualVOList = new ArrayList();
        Map<Object, Object> personPlanDtlMap = new HashMap();
        Map<Object, Object> actResIdMap = new HashMap();
        LocalDate startDate = null;
        LocalDate endDate = null;
        ArrayList<CallSite> columnDateList = new ArrayList<CallSite>();
        PersonPlanVO personPlanVO = this.personPlanService.getByObjIdAndPlanType(key, Arrays.asList(PersonPlanTypeEnum.PROJECT.getCode()));
        String uom = null;
        if (personPlanVO != null) {
            uom = personPlanVO.getUom();
            startDate = personPlanVO.getStartDate();
            endDate = personPlanVO.getEndDate();
            List personPlanDtlVOList = personPlanVO.getPersonPlanDtlVOList();
            if (!CollectionUtils.isEmpty((Collection)personPlanDtlVOList)) {
                personPlanDtlMap = personPlanDtlVOList.stream().collect(Collectors.groupingBy(PersonPlanDtlVO::getResId));
                personPlanDtlVOList.stream().forEach(e -> {
                    PmsPersonPlanAndActualVO pmsPersonPlanAndActualVO = new PmsPersonPlanAndActualVO();
                    pmsPersonPlanAndActualVO.setResId(e.getResId());
                    pmsPersonPlanAndActualVO.setResName(e.getResName());
                    pmsPersonPlanAndActualVO.setCapasetLevelId(e.getCapasetLevelId());
                    pmsPersonPlanAndActualVO.setCapasetLevelIdDesc(e.getCapasetLevelIdDesc());
                    pmsPersonPlanAndActualVO.setDistributeRate(e.getDistributeRate());
                    pmsPersonPlanAndActualVO.setDays(e.getDays());
                    pmsPersonPlanAndActualVO.setTotalEqva(e.getTotalEqva());
                    pmsPersonPlanAndActualVOList.add(pmsPersonPlanAndActualVO);
                    resIdSet.add(e.getResId());
                });
            }
        }
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setProjId(key);
        List timesheetVOS = this.timesheetService.queryList(timesheetQuery);
        if (!CollectionUtils.isEmpty((Collection)timesheetVOS)) {
            List workDateList = timesheetVOS.stream().map(e -> e.getWorkDate()).collect(Collectors.toList());
            LocalDate maxDate = (LocalDate)Collections.max(workDateList);
            LocalDate minDate = (LocalDate)Collections.min(workDateList);
            if (minDate.compareTo(startDate) < 0) {
                startDate = minDate;
            }
            if (maxDate.compareTo(endDate) > 0) {
                endDate = maxDate;
            }
            actResIdMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getTsUserId));
            actResIdMap.keySet().stream().forEach(e -> {
                if (resIdSet.contains(e)) {
                    List collect = pmsPersonPlanAndActualVOList.stream().filter(f -> f.getResId().equals(e)).collect(Collectors.toList());
                    PmsPersonPlanAndActualVO pmsPersonPlanAndActualVO = (PmsPersonPlanAndActualVO)collect.get(0);
                    PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee((Long)e);
                    pmsPersonPlanAndActualVO.setActDistributeRate(employee.getEqvaRatio());
                    pmsPersonPlanAndActualVO.setActResId(e);
                    pmsPersonPlanAndActualVO.setActResName(employee.getEmployeeName());
                    pmsPersonPlanAndActualVO.setActGrade(employee.getExtString1());
                } else {
                    PmsPersonPlanAndActualVO pmsPersonPlanAndActualVO = new PmsPersonPlanAndActualVO();
                    PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee((Long)e);
                    pmsPersonPlanAndActualVO.setActDistributeRate(employee.getEqvaRatio());
                    pmsPersonPlanAndActualVO.setActResId(e);
                    pmsPersonPlanAndActualVO.setActResName(employee.getEmployeeName());
                    pmsPersonPlanAndActualVO.setActGrade(employee.getExtString1());
                    pmsPersonPlanAndActualVOList.add(pmsPersonPlanAndActualVO);
                }
            });
        }
        if (!CollectionUtils.isEmpty(pmsPersonPlanAndActualVOList)) {
            TemporalAdjuster adjuster = null;
            String title = "";
            if (!StringUtils.hasText((String)uom)) {
                uom = PersonPlanUomEnum.month.getCode();
                adjuster = TemporalAdjusters.lastDayOfMonth();
                title = "M";
            } else {
                if (PersonPlanUomEnum.week.getCode().equals(uom)) {
                    adjuster = TemporalAdjusters.next(DayOfWeek.SUNDAY);
                    title = "W";
                }
                if (PersonPlanUomEnum.month.getCode().equals(uom)) {
                    adjuster = TemporalAdjusters.lastDayOfMonth();
                    title = "M";
                }
                if (PersonPlanUomEnum.year.getCode().equals(uom)) {
                    adjuster = TemporalAdjusters.lastDayOfYear();
                    title = "Y";
                }
            }
            List dataRangeList = this.personPlanDtlService.dataRange(startDate, endDate, adjuster);
            int index = 0;
            for (PmsPersonPlanAndActualVO pmsPersonPlanAndActualVO : pmsPersonPlanAndActualVOList) {
                Long resId = pmsPersonPlanAndActualVO.getResId();
                List dayJsonVOS = null;
                List timesheetVOList = null;
                if (personPlanDtlMap.containsKey(resId)) {
                    List personPlanDtlVOS = (List)personPlanDtlMap.get(resId);
                    PersonPlanDtlVO personPlanDtlVO = (PersonPlanDtlVO)personPlanDtlVOS.get(0);
                    String daysJson = personPlanDtlVO.getDaysJson();
                    dayJsonVOS = JSON.parseArray((String)daysJson, DayJsonVO.class);
                }
                if (actResIdMap.containsKey(resId)) {
                    timesheetVOList = (List)actResIdMap.get(resId);
                }
                ArrayList<PmsActAndPlanJsonVO> pmsActAndPlanJsonVOList = new ArrayList<PmsActAndPlanJsonVO>();
                for (int i = 0; i < dataRangeList.size(); ++i) {
                    LocalDate date;
                    DateTimeFormatter outputFormatter;
                    PmsActAndPlanJsonVO pmsActAndPlanJsonVO = new PmsActAndPlanJsonVO();
                    Map stringStringMap = (Map)dataRangeList.get(index);
                    List collect = stringStringMap.keySet().stream().collect(Collectors.toList());
                    String start = (String)collect.get(0);
                    String end = (String)stringStringMap.get(start);
                    LocalDate startDateOne = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    LocalDate endDateOne = LocalDate.parse(end, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    if (PersonPlanUomEnum.month.getCode().equals(uom)) {
                        LocalDate monthDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        outputFormatter = DateTimeFormatter.ofPattern("yy-MM");
                        start = monthDate.format(outputFormatter);
                    }
                    if (PersonPlanUomEnum.year.getCode().equals(uom)) {
                        LocalDate yearDate = LocalDate.parse(start, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        outputFormatter = DateTimeFormatter.ofPattern("yyyy");
                        start = yearDate.format(outputFormatter);
                    }
                    String column = title + (index + 1) + " " + start;
                    columnDateList.add((CallSite)((Object)column));
                    pmsActAndPlanJsonVO.setColumn(column);
                    if (!CollectionUtils.isEmpty((Collection)dayJsonVOS)) {
                        BigDecimal days = BigDecimal.ZERO;
                        for (DayJsonVO dayJsonVO : dayJsonVOS) {
                            date = LocalDate.parse(dayJsonVO.getDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                            if (!date.isEqual(startDateOne) && !date.isEqual(endDateOne) && (!date.isAfter(startDateOne) || !date.isBefore(endDateOne))) continue;
                            days = days.add(dayJsonVO.getDay()).setScale(2, RoundingMode.HALF_UP);
                        }
                        pmsActAndPlanJsonVO.setPlanDays(days);
                    }
                    if (!CollectionUtils.isEmpty((Collection)timesheetVOList)) {
                        BigDecimal hours = BigDecimal.ZERO;
                        for (TimesheetVO timesheetVO : timesheetVOList) {
                            date = timesheetVO.getWorkDate();
                            if (!date.isEqual(startDateOne) && !date.isEqual(endDateOne) && (!date.isAfter(startDateOne) || !date.isBefore(endDateOne))) continue;
                            hours = hours.add(timesheetVO.getWorkHour()).setScale(2, RoundingMode.HALF_UP);
                        }
                        BigDecimal actDays = hours.divide(new BigDecimal(8), 2, RoundingMode.HALF_UP);
                        pmsActAndPlanJsonVO.setActDays(actDays);
                    }
                    pmsActAndPlanJsonVOList.add(pmsActAndPlanJsonVO);
                }
                pmsPersonPlanAndActualVO.setContentJson(JSON.toJSONString(pmsActAndPlanJsonVOList));
            }
        }
        HashMap map = new HashMap();
        map.put("column", columnDateList);
        map.put("pmsPersonPlanAndActualVOList", pmsPersonPlanAndActualVOList);
        return map;
    }

    public PmsProjectPayload autoCreateProject(SaleConContractVO saleConContractVO) {
        PmsProjectPayload pmsProjectPayload = new PmsProjectPayload();
        log.info("11111111111-----------------");
        List businessPartnerVOS = this.businessPartnerService.queryByBookId(saleConContractVO.getCustId());
        if (!CollectionUtils.isEmpty((Collection)businessPartnerVOS)) {
            BusinessPartnerVO businessPartnerVO = (BusinessPartnerVO)businessPartnerVOS.get(0);
            pmsProjectPayload.setCustIdst(businessPartnerVO.getPartnerIndustry());
        }
        log.info("22222222222-----------------");
        pmsProjectPayload.setProjName(saleConContractVO.getName());
        PmsProjectTemplateQuery query = new PmsProjectTemplateQuery();
        if (saleConContractVO.getWorkType().equals(SaleConWorkTypeEnum.PURETRADE.getCode())) {
            query.setSuitProjectType(SaleConWorkTypeEnum.PURETRADE.getCode());
        } else {
            query.setSuitProjectType(SaleConWorkTypeEnum.INDEPENDENT.getCode());
        }
        query.setTemplateStatus(Integer.valueOf(1));
        List pmsProjectTemplateVOS = this.pmsProjectTemplateService.queryListDynamic(query);
        if (!CollectionUtils.isEmpty((Collection)pmsProjectTemplateVOS)) {
            PmsProjectTemplateVO pmsProjectTemplateVO = (PmsProjectTemplateVO)pmsProjectTemplateVOS.get(0);
            Long subjectTemplateId = pmsProjectTemplateVO.getSubjectTemplateId();
            pmsProjectPayload.setProjTempId(pmsProjectTemplateVO.getId());
            pmsProjectPayload.setSubjectTempId(subjectTemplateId);
        }
        pmsProjectPayload.setPlanStartDate(saleConContractVO.getStartDate());
        pmsProjectPayload.setPlanEndDate(saleConContractVO.getEndDate());
        pmsProjectPayload.setContainsCustomerFlag(Integer.valueOf(saleConContractVO.getCustBarExpense() == null ? 0 : Integer.parseInt(saleConContractVO.getCustBarExpense())));
        pmsProjectPayload.setProjStatus("ACTIVE");
        pmsProjectPayload.setCreateUserId(saleConContractVO.getDeliUserId());
        pmsProjectPayload.setRemark("\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\u9879\u76ee");
        log.info("3333333333333333-----------------");
        pmsProjectPayload.setDeliBuId(saleConContractVO.getDeliBuId());
        pmsProjectPayload.setDeliUserId(saleConContractVO.getDeliUserId());
        pmsProjectPayload.setPmResId(saleConContractVO.getSaleManUserId());
        pmsProjectPayload.setSaleManUserId(saleConContractVO.getSaleManUserId());
        List userIds = this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_PMO_AID.getCode());
        if (!CollectionUtils.isEmpty((Collection)userIds)) {
            pmsProjectPayload.setPmoResId((Long)userIds.get(0));
        }
        pmsProjectPayload.setTotalDays(BigDecimal.ZERO);
        pmsProjectPayload.setTotalEqva(BigDecimal.ZERO);
        pmsProjectPayload.setEqvaPrice(BigDecimal.valueOf(800L));
        pmsProjectPayload.setTotalCost(BigDecimal.ZERO);
        pmsProjectPayload.setTotalReimbursement(BigDecimal.ZERO);
        pmsProjectPayload.setContractId(saleConContractVO.getId());
        pmsProjectPayload.setEpibolyPermitFlag(Integer.valueOf(0));
        pmsProjectPayload.setDeposit(BigDecimal.ZERO);
        log.info("44444444444444-----------------");
        return pmsProjectPayload;
    }

    public PmsProjectOverviewVO queryProjectOverview(Long key) {
        PmsProjectOverviewVO overviewVO = new PmsProjectOverviewVO();
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(key);
        overviewVO.setPmsProjectVO(pmsProjectVO);
        ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
        proRelatedPartiesQuery.setProId(key);
        proRelatedPartiesQuery.setType(Integer.valueOf(0));
        List res = this.proRelatedPartiesService.getList(proRelatedPartiesQuery);
        overviewVO.setProRelatedPartiesVOList(res);
        TaskInfoCountVO taskInfoCountVO = this.queryTaskCount(key);
        overviewVO.setTaskInfoCountVO(taskInfoCountVO);
        PmsProjectEventLogQuery pmsProjectEventLogQuery = new PmsProjectEventLogQuery();
        pmsProjectEventLogQuery.setProjectId(key);
        List pmsProjectEventLogVOS = this.pmsProjectEventLogService.queryList(pmsProjectEventLogQuery);
        overviewVO.setPmsProjectEventLogVOList(pmsProjectEventLogVOS);
        List<ComChangeVO> comChangeVOS = this.queryChangeLog(key);
        overviewVO.setComChangeVOList(comChangeVOS);
        BudgetCountVO budgetCountVO = new BudgetCountVO();
        budgetCountVO.setCompPercent(pmsProjectVO.getCompPercent());
        List<PmsProjectReceiveVO> pmsProjectReceiveVOList = this.queryReceiveList(pmsProjectVO.getContractId(), budgetCountVO);
        overviewVO.setPmsProjectReceiveVOList(pmsProjectReceiveVOList);
        List<PmsProjectPurContractVO> pmsProjectPurContractVOS = this.queryPrucahseContract(pmsProjectVO.getContractId());
        overviewVO.setPmsProjectPurContractVOList(pmsProjectPurContractVOS);
        this.queryBudgetCountData(key, budgetCountVO);
        overviewVO.setBudgetCountVO(budgetCountVO);
        return overviewVO;
    }

    private TaskInfoCountVO queryTaskCount(Long key) {
        TaskInfoCountVO taskInfoCountVO = new TaskInfoCountVO();
        TaskInfoQuery query = new TaskInfoQuery();
        query.setReasonId(key);
        query.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
        List<TaskInfoVO> taskInfoVOS = this.taskInfoDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(taskInfoVOS)) {
            List overDueTaskInfoVOList;
            List unComPeleteTaskInfoVOList;
            LocalDate currentDate = LocalDate.now();
            taskInfoVOS.forEach(p -> {
                if (p.getState() != null) {
                    if (StateFlowStateEnum.THREE.getCode() == p.getState().intValue()) {
                        p.setOverdue("\u5426");
                    } else if (p.getPlanEndDate() != null) {
                        Period period = Period.between(p.getPlanEndDate(), currentDate);
                        int overdueDays = period.getDays();
                        if (overdueDays > 0) {
                            p.setOverdue("\u662f");
                            p.setOverdueDays((long)overdueDays);
                        } else {
                            p.setOverdue("\u5426");
                        }
                    }
                    switch (p.getState()) {
                        case 1: {
                            p.setStateDesc(StateFlowStateEnum.ONE.getDesc());
                            break;
                        }
                        case 2: {
                            p.setStateDesc(StateFlowStateEnum.TWO.getDesc());
                            break;
                        }
                        case 3: {
                            p.setStateDesc(StateFlowStateEnum.THREE.getDesc());
                            break;
                        }
                    }
                }
                if (p.getTaskResId() != null) {
                    p.setTaskRes(this.cacheUtil.getUserName(p.getTaskResId()));
                }
            });
            taskInfoCountVO.setTotalNum(BigDecimal.valueOf(taskInfoVOS.size()));
            taskInfoCountVO.setTotalTaskInfoVOList(taskInfoVOS);
            List completeVOList = taskInfoVOS.stream().filter(TaskInfoVO2 -> StateFlowStateEnum.THREE.getCode() == TaskInfoVO2.getState().intValue()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(completeVOList)) {
                taskInfoCountVO.setCompleteNum(BigDecimal.valueOf(completeVOList.size()));
                taskInfoCountVO.setCompleteTaskInfoVOList(completeVOList);
            }
            if (!CollectionUtils.isEmpty(unComPeleteTaskInfoVOList = taskInfoVOS.stream().filter(TaskInfoVO2 -> StateFlowStateEnum.THREE.getCode() != TaskInfoVO2.getState().intValue()).collect(Collectors.toList()))) {
                taskInfoCountVO.setUnCompleteNum(BigDecimal.valueOf(unComPeleteTaskInfoVOList.size()));
                taskInfoCountVO.setUnCompleteTaskInfoVOList(unComPeleteTaskInfoVOList);
            }
            if (!CollectionUtils.isEmpty(overDueTaskInfoVOList = taskInfoVOS.stream().filter(taskInfoVO -> taskInfoVO.getPlanEndDate() != null && currentDate.isAfter(taskInfoVO.getPlanEndDate()) && (taskInfoVO.getCompletedDate() == null || taskInfoVO.getCompletedDate().isAfter(taskInfoVO.getPlanEndDate()))).collect(Collectors.toList()))) {
                taskInfoCountVO.setOverdueNum(BigDecimal.valueOf(overDueTaskInfoVOList.size()));
                taskInfoCountVO.setOverdueTaskInfoVOList(overDueTaskInfoVOList);
            }
            List todayOverTaskInfoVOList = unComPeleteTaskInfoVOList.stream().filter(unCompleteVO -> unCompleteVO.getPlanEndDate() != null && currentDate.isEqual(unCompleteVO.getPlanEndDate())).collect(Collectors.toList());
            taskInfoCountVO.setTodayOverNum(BigDecimal.valueOf(todayOverTaskInfoVOList.size()));
            taskInfoCountVO.setTodayOverTaskInfoVOList(todayOverTaskInfoVOList);
        }
        return taskInfoCountVO;
    }

    private List<ComChangeVO> queryChangeLog(Long key) {
        BudgetVO budgetVO;
        ArrayList<ComChangeVO> comChangeVOList = new ArrayList<ComChangeVO>();
        ComChangeQuery planQuery = new ComChangeQuery();
        planQuery.setChangeDocId(key.toString());
        planQuery.setChangeType(ComChangeTypeEnum.PMS_PROJECT_WBS.getCode());
        List<ComChangeVO> planComChangeVOS = this.comChangeDAO.queryListDynamic(planQuery);
        if (!CollectionUtils.isEmpty(planComChangeVOS)) {
            comChangeVOList.addAll(planComChangeVOS);
        }
        if ((budgetVO = this.budgetDAO.querySimpleBySource(key, PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) != null) {
            ComChangeQuery budgetQuery = new ComChangeQuery();
            budgetQuery.setChangeDocId(budgetVO.getId().toString());
            budgetQuery.setChangeType(ChangeTypeEnum.BUDGET_CHANGE.getCode());
            List<ComChangeVO> budgetComChangeVOS = this.comChangeDAO.queryListDynamic(budgetQuery);
            if (!CollectionUtils.isEmpty(budgetComChangeVOS)) {
                comChangeVOList.addAll(budgetComChangeVOS);
            }
        }
        comChangeVOList.sort(Comparator.comparing(BaseViewModel::getCreateTime).reversed());
        comChangeVOList = this.udcUtil.translateList(comChangeVOList);
        return comChangeVOList;
    }

    private List<PmsProjectReceiveVO> queryReceiveList(Long contractId, BudgetCountVO budgetCountVO) {
        ArrayList<PmsProjectReceiveVO> pmsProjectReceiveVOList = new ArrayList<PmsProjectReceiveVO>();
        List planVOS = this.conReceivablePlanService.queryBySaleConId(contractId);
        if (!CollectionUtils.isEmpty((Collection)planVOS)) {
            BigDecimal receivePlanAmt = BigDecimal.ZERO;
            BigDecimal receiveActualAmt = BigDecimal.ZERO;
            for (ConReceivablePlanVO planVO : planVOS) {
                PmsProjectReceiveVO planReceiveVO = new PmsProjectReceiveVO();
                planReceiveVO.setReceStage(planVO.getReceStage());
                planReceiveVO.setAmt(planVO.getReceAmt());
                planReceiveVO.setType(PmsProjecReceiveTypeEnum.PLAN.getDesc());
                receivePlanAmt = planVO.getReceAmt().add(receivePlanAmt);
                BigDecimal actualAmt = planVO.getActualRecvAmt() == null ? BigDecimal.ZERO : planVO.getActualRecvAmt();
                PmsProjectReceiveVO actualReceiveVO = new PmsProjectReceiveVO();
                actualReceiveVO.setReceStage(planVO.getReceStage());
                actualReceiveVO.setAmt(actualAmt);
                actualReceiveVO.setType(PmsProjecReceiveTypeEnum.ACTUAL.getDesc());
                pmsProjectReceiveVOList.add(planReceiveVO);
                pmsProjectReceiveVOList.add(actualReceiveVO);
                receiveActualAmt = actualAmt.add(receiveActualAmt);
            }
            if (receivePlanAmt.compareTo(BigDecimal.ZERO) == 0 || receiveActualAmt.compareTo(BigDecimal.ZERO) == 0) {
                budgetCountVO.setReceiveAmt(receiveActualAmt);
                budgetCountVO.setReceiveRatio(BigDecimal.ZERO);
            } else {
                budgetCountVO.setReceiveAmt(receiveActualAmt);
                budgetCountVO.setReceiveRatio(receiveActualAmt.divide(receivePlanAmt, 2, RoundingMode.HALF_UP));
            }
        }
        return pmsProjectReceiveVOList;
    }

    private List<PmsProjectPurContractVO> queryPrucahseContract(Long contractId) {
        ArrayList<PmsProjectPurContractVO> purchaseContractVOList = new ArrayList<PmsProjectPurContractVO>();
        PurchaseContractManagerQuery query = new PurchaseContractManagerQuery();
        query.setRelatedSalesContract(contractId);
        List managerVOS = this.purchaseContractManagerService.queryPurContractInfo(query);
        if (!CollectionUtils.isEmpty((Collection)managerVOS)) {
            managerVOS.stream().forEach(p -> {
                PmsProjectPurContractVO planPurContractVO = new PmsProjectPurContractVO();
                planPurContractVO.setPurchaseName(p.getPurchaseContractName());
                planPurContractVO.setAmt(p.getAmt());
                planPurContractVO.setType(PmsProjecReceiveTypeEnum.PLAN.getDesc());
                PmsProjectPurContractVO actualPurContractVO = new PmsProjectPurContractVO();
                actualPurContractVO.setPurchaseName(p.getPurchaseContractName());
                actualPurContractVO.setAmt(p.getPaymentAmt());
                actualPurContractVO.setType(PmsProjecReceiveTypeEnum.ACTUAL.getDesc());
                purchaseContractVOList.add(planPurContractVO);
                purchaseContractVOList.add(actualPurContractVO);
            });
        }
        return purchaseContractVOList;
    }

    public void queryBudgetCountData(Long key, BudgetCountVO budgetCountVO) {
        BudgetVO budgetVO = this.budgetCommonService.querySimpleBySource(key, PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
        if (budgetVO != null) {
            List subjectDetailVOS = this.budgetSubjectDetailService.queryListDyBudgetId(budgetVO.getId());
            budgetVO.setSubjectDetailVOS(subjectDetailVOS);
            this.budgetService.opertionOccupyAndUsed(budgetVO, null);
            ArrayList<BudgetUsedVO> budgetUsedVOList = new ArrayList<BudgetUsedVO>();
            BudgetUsedVO amtBudgetUsedVO = new BudgetUsedVO();
            amtBudgetUsedVO.setType("\u8d39\u7528\u6210\u672c");
            amtBudgetUsedVO.setBudgetAmt(budgetVO.getPlanAmt());
            amtBudgetUsedVO.setUsedBudgetAmt(budgetVO.getUsedAmt());
            amtBudgetUsedVO.setRemainingBudgetAmt(budgetVO.getPlanAmt().subtract(budgetVO.getUsedAmt()));
            amtBudgetUsedVO.setUsedRatio(budgetVO.getUsedAmtProportion());
            budgetUsedVOList.add(amtBudgetUsedVO);
            BudgetUsedVO personBudgetUsedVO = new BudgetUsedVO();
            personBudgetUsedVO.setType("\u4eba\u529b\u6210\u672c");
            personBudgetUsedVO.setBudgetAmt(budgetVO.getPlanEqvaAmt());
            personBudgetUsedVO.setUsedBudgetAmt(budgetVO.getUsedEqvaAmt());
            personBudgetUsedVO.setRemainingBudgetAmt(budgetVO.getPlanEqvaAmt().subtract(budgetVO.getOccupyEqvaAmt()));
            personBudgetUsedVO.setUsedRatio(budgetVO.getUsedEqvaProportion());
            budgetUsedVOList.add(personBudgetUsedVO);
            budgetCountVO.setBudgetUsedVOList(budgetUsedVOList);
            budgetCountVO.setTotalCost(budgetVO.getUsedEqvaAmt().add(budgetVO.getUsedAmt()));
        }
    }

    public List<PmsProjectVO> queryListDynamic(PmsProjectQuery query) {
        if (query.getPermissionFlag().booleanValue()) {
            query.setLoginUserId(GlobalUtil.getLoginUserId());
        }
        if (!StringUtils.hasText((String)query.getProjStatus())) {
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        }
        List<PmsProjectVO> result = this.pmsProjectDAO.queryListDynamic(query);
        result.stream().forEach(e -> e.setCustName(this.cacheUtil.getCompanyNameByBookId(e.getCustId())));
        return result;
    }

    public List<PmsProjectVO> queryListByReasonIdList(List<Long> reasonIdList) {
        PmsProjectQuery projectQuery = new PmsProjectQuery();
        projectQuery.setInIds(reasonIdList);
        List<PmsProjectVO> result = this.pmsProjectDAO.queryListDynamic(projectQuery);
        result.stream().forEach(e -> e.setCustName(this.cacheUtil.getCompanyNameByBookId(e.getCustId())));
        if (!CollectionUtils.isEmpty(result)) {
            List<Long> collect = result.stream().filter(vo -> vo.getContractId() != null).map(PmsProjectVO::getContractId).distinct().collect(Collectors.toList());
            this.tranContractData(result, collect);
        }
        return result;
    }

    public PmsProjectVO queryByKey(Long key) {
        PmsProjectVO vo = this.pmsProjectDAO.queryByKey(key);
        vo.setCustName(this.cacheUtil.getCompanyNameByBookId(vo.getCustId()));
        if (ObjectUtils.isEmpty((Object)vo)) {
            throw TwException.error("", "\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u8be6\u60c5");
        }
        PmsProjectActivityQuery query = new PmsProjectActivityQuery();
        query.setProjId(key);
        long activityCount = this.projectActivityService.countListDynamic(query);
        vo.setHaveActivityFlag(Integer.valueOf(activityCount > 0L ? 1 : 0));
        PmsProjectMembersQuery membersQuery = new PmsProjectMembersQuery();
        membersQuery.setProjId(key);
        Long memberCount = this.projectMembersService.countTreeByProjId(membersQuery);
        vo.setHaveMemberFlag(Integer.valueOf(memberCount > 0L ? 1 : 0));
        PersonPlanVO personPlanVO = this.personPlanService.getByObjIdAndPlanType(key, Arrays.asList(PersonPlanTypeEnum.PROJECT.getCode()));
        vo.setHaveResoucePlanFlag(Integer.valueOf(personPlanVO != null ? 1 : 0));
        BudgetQuery budgetQuery = new BudgetQuery();
        budgetQuery.setSourceId(key);
        budgetQuery.setSourceType("PROJ_CONTRACT");
        Long budgetCount = this.budgetDAO.count(budgetQuery);
        vo.setHaveBudgetFlag(Integer.valueOf(budgetCount > 0L ? 1 : 0));
        TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
        taskPackageQuery.setReasonId(key);
        taskPackageQuery.setReasonType("PROJ_CONTRACT");
        long taskPackageCount = this.taskPackageDAO.count(taskPackageQuery);
        vo.setHaveTaskFlag(Integer.valueOf(taskPackageCount > 0L ? 1 : 0));
        this.transferData(vo);
        return vo;
    }

    public PmsProjectVO queryByKeySimple(Long key) {
        return this.pmsProjectDAO.queryByKey(key);
    }

    public List<PmsProjectVO> queryByKeysSimple(List<Long> keys) {
        return this.pmsProjectDAO.queryByKeys(keys);
    }

    public PmsProjectVO querySimpleProjectByKey(Long key) {
        return this.pmsProjectDAO.queryByKey(key);
    }

    public PmsProjectVO queryByContractId(Long contractId) {
        return this.pmsProjectDAO.queryByContractId(contractId);
    }

    public List<PmsProjectVO> queryByContractIds(List<Long> contractIds) {
        return this.pmsProjectDAO.queryByContractIds(contractIds);
    }

    public CrmCustomerOperationVO queryProjectCustomerOperation(Long key) {
        PmsProjectVO vo = this.pmsProjectDAO.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)vo)) {
            throw TwException.error("", "\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u4e0d\u5230\u9879\u76ee\u8be6\u60c5");
        }
        if (vo.getCustId() != null) {
            return this.customerOperationService.queryCustomerOperationByCustomerId(vo.getCustId());
        }
        return null;
    }

    void transferData(PmsProjectVO vo) {
        vo.setSowFilesData(this.fileUtil.getFileDatas(vo.getSowFiles()));
        vo.setBudgetFilesData(this.fileUtil.getFileDatas(vo.getBudgetFiles()));
        vo.setPerformanceFilesData(this.fileUtil.getFileDatas(vo.getPerformanceFiles()));
        vo.setProjectFilesData(this.fileUtil.getFileDatas(vo.getProjectFiles()));
        vo.setResearchFilesData(this.fileUtil.getFileDatas(vo.getResearchFiles()));
        vo.setOuName(this.cacheUtil.getCompanyNameByBookId(vo.getOuBookId()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectVO insertOrUpdate(PmsProjectPayload payload) {
        PersonPlanVO personPlanVO;
        SaleConExecConditionVO saleConExecConditionVO;
        PmsProjectTemplateVO pmsProjectTemplateVO;
        this.checkData(payload);
        Long projTempId = payload.getProjTempId();
        if (projTempId != null) {
            pmsProjectTemplateVO = this.pmsProjectTemplateService.queryByKey(projTempId);
            if (pmsProjectTemplateVO == null) {
                throw TwException.error("", "\u5173\u8054\u9879\u76ee\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728");
            }
        } else {
            throw TwException.error("", "\u5173\u8054\u9879\u76ee\u6a21\u677f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        payload.setSubjectTempId(pmsProjectTemplateVO.getSubjectTemplateId());
        if (payload.getId() == null) {
            String code = this.generateSeqNum("PMS_PROJECT", new String[0]);
            payload.setProjNo(code);
            payload.setCreateUserId(GlobalUtil.getLoginUserId());
        }
        this.prjFileHandle(payload);
        PmsProjectDO entityDo = PmsProjectConvert.INSTANCE.toDo(payload);
        entityDo = (PmsProjectDO)this.pmsProjectRepo.save(entityDo);
        Long id = entityDo.getId();
        if (payload.getId() == null && payload.getContractId() != null && (saleConExecConditionVO = this.saleConExecConditionService.queryByContractId(payload.getContractId())) != null && saleConExecConditionVO.getId() != null && (personPlanVO = this.personPlanService.getByObjIdAndPlanType(payload.getContractId(), Arrays.asList(PersonPlanTypeEnum.BUDGET.getCode()))) != null) {
            PersonPlanPayload personPlanPayload = new PersonPlanPayload();
            BeanUtils.copyProperties((Object)personPlanVO, (Object)personPlanPayload);
            personPlanPayload.setId(null);
            personPlanPayload.setVersion("0");
            personPlanPayload.setPlanType(PersonPlanTypeEnum.PROJECT.getCode());
            personPlanPayload.setObjId(id);
            List personPlanDtlVOList = personPlanVO.getPersonPlanDtlVOList();
            if (!CollectionUtils.isEmpty((Collection)personPlanDtlVOList)) {
                ArrayList personPlanDtlPayloadList = new ArrayList();
                personPlanDtlVOList.stream().forEach(personPlanDtlVO -> {
                    PersonPlanDtlPayload personPlanDtlPayload = new PersonPlanDtlPayload();
                    BeanUtils.copyProperties((Object)personPlanDtlVO, (Object)personPlanDtlPayload);
                    personPlanDtlPayload.setId(null);
                    personPlanDtlPayload.setPlanId(null);
                    personPlanDtlPayloadList.add(personPlanDtlPayload);
                });
                personPlanPayload.setPersonPlanDtlPayloadList(personPlanDtlPayloadList);
            }
            this.personPlanService.save(personPlanPayload);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getProjectReportPlanPayloads())) {
            payload.getProjectReportPlanPayloads().forEach(reportPlan -> {
                if (reportPlan.getPeriodDate() == null) {
                    throw TwException.error("", "\u6c47\u62a5\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a");
                }
                reportPlan.setProjId(id);
            });
            List collect1 = payload.getProjectReportPlanPayloads().stream().map(planPayload -> planPayload.getPeriodDate().with(TemporalAdjusters.firstDayOfMonth())).distinct().collect(Collectors.toList());
            if (collect1.size() < payload.getProjectReportPlanPayloads().size()) {
                throw TwException.error("", "\u6c47\u62a5\u671f\u95f4\u4e0d\u53ef\u91cd\u590d");
            }
            this.pmsProjectReportPlanService.batchInsert(payload.getProjectReportPlanPayloads());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDelReportPlanIds())) {
            this.pmsProjectReportPlanService.deleteSoft(payload.getDelReportPlanIds());
        }
        if (payload.getId() == null) {
            this.createAccount(entityDo);
        }
        payload.setId(id);
        if (!this.projectAddEventMap.isEmpty()) {
            Collection<ProjectAddEvent> events = this.projectAddEventMap.values();
            events.forEach(event -> event.execute(payload));
        }
        return PmsProjectConvert.INSTANCE.toVo(entityDo);
    }

    void createAccount(PmsProjectDO entityDo) {
        CalAccountPayload accountPayload = new CalAccountPayload();
        accountPayload.setAuType(CalAccTypeEnum.PROJ.getCode());
        accountPayload.setAuId(entityDo.getId());
        accountPayload.setLedgerName(entityDo.getProjName());
        accountPayload.setLedgerNo(entityDo.getProjNo());
        this.calAccountService.insert(accountPayload);
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateProjStatus(Long key, String projStatus, Long pmResId) {
        PmsProjectPayload projectPayload = new PmsProjectPayload();
        projectPayload.setId(key);
        projectPayload.setProjStatus(projStatus);
        if (!ObjectUtils.isEmpty((Object)pmResId)) {
            projectPayload.setPmResId(pmResId);
        }
        long l = this.pmsProjectDAO.updateByKeyDynamic(projectPayload);
        if (projStatus.equals(ProjectStatusEnum.ACTIVE.getCode())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(key);
            this.transactionUtilService.executeWithRunnable(() -> {
                this.pmsProjectBriefService.autoSupplementBierf(key);
                HashSet<Long> userIds = new HashSet<Long>();
                if (pmsProjectVO.getDeliUserId() != null) {
                    userIds.add(pmsProjectVO.getDeliUserId());
                }
                if (pmsProjectVO.getPmoResId() != null) {
                    userIds.add(pmsProjectVO.getPmoResId());
                }
                if (pmsProjectVO.getPmResId() != null) {
                    userIds.add(pmsProjectVO.getPmResId());
                }
                if (pmsProjectVO.getSuperResId() != null) {
                    userIds.add(pmsProjectVO.getSuperResId());
                }
                ArrayList<PmsProjectMembersDO> pmsProjectMembersDOs = new ArrayList<PmsProjectMembersDO>();
                userIds.forEach(userId -> {
                    PmsProjectMembersDO membersDO = new PmsProjectMembersDO();
                    membersDO.setProjId(key);
                    membersDO.setResId((Long)userId);
                    membersDO.setWorkbenchFlag(1);
                    pmsProjectMembersDOs.add(membersDO);
                });
                this.pmsProjectMembersDAO.saveAll(pmsProjectMembersDOs);
                PrdSystemSettingVO settingVO = this.cacheUtil.getSystemSetting(SystemSettingsItemEnum.prj_member_init_task.getCode());
                if (settingVO != null && StringUtils.hasText((String)settingVO.getSettingValue()) && "true".equals(settingVO.getSettingValue())) {
                    this.taskCommonService.batchCreatTaskPackage(PmsReasonTypeEnum.PROJ_CONTRACT.getCode(), key, new ArrayList(userIds), (Object)pmsProjectVO);
                }
            });
            this.createProjInitWideSettle(pmsProjectVO, null);
        }
        return l;
    }

    public void initWideSettle() {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setProjStatusType("1");
        query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryListDynamic(query);
        pmsProjectVOS.forEach(vo -> this.createProjInitWideSettle((PmsProjectVO)vo, vo.getCreateTime().toLocalDate()));
    }

    void createProjInitWideSettle(PmsProjectVO pmsProjectVO, LocalDate date) {
        CalWideSettlePayload settlePayload = new CalWideSettlePayload();
        settlePayload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
        settlePayload.setSettleType(CalAccTurTypeEnum.PROJ_INIT.getCode());
        settlePayload.setSettleDate(date == null ? LocalDate.now() : date);
        settlePayload.setFromSourceType(CalAccTypeEnum.BU.getCode());
        settlePayload.setFromSourceId(pmsProjectVO.getDeliBuId());
        settlePayload.setFromSourceName(this.cacheUtil.getOrgName(pmsProjectVO.getDeliBuId()));
        settlePayload.setToSourceType(CalAccTypeEnum.PROJ.getCode());
        settlePayload.setToSourceId(pmsProjectVO.getId());
        settlePayload.setToSourceName(pmsProjectVO.getProjName());
        settlePayload.setApplySettleEqva(pmsProjectVO.getTotalEqva());
        settlePayload.setSettlePrice(pmsProjectVO.getEqvaPrice());
        settlePayload.setApplySettleAmt(pmsProjectVO.getTotalEqva().multiply(pmsProjectVO.getEqvaPrice()));
        settlePayload.setIsSubmit(Integer.valueOf(1));
        this.calWideSettleService.insertOrUpdate(settlePayload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void createProjFinishWideSettle(Long projectId) {
        BigDecimal avalAmt;
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(projectId);
        CalAccountVO calAccountVO = this.calAccountService.queryByAuTypeAndAuId(CalAccTypeEnum.PROJ.getCode(), pmsProjectVO.getId());
        BigDecimal avalQty = calAccountVO.getAvalQty() == null ? BigDecimal.ZERO : calAccountVO.getAvalQty();
        BigDecimal bigDecimal = avalAmt = calAccountVO.getAvalAmt() == null ? BigDecimal.ZERO : calAccountVO.getAvalAmt();
        if (avalQty.compareTo(BigDecimal.ZERO) > 0 || avalAmt.compareTo(BigDecimal.ZERO) > 0) {
            CalWideSettlePayload settlePayload = new CalWideSettlePayload();
            settlePayload.setSettleStatus(CalSettleStatusEnum.FINISH.getCode());
            settlePayload.setSettleType(CalAccTurTypeEnum.PROJ_FINISH.getCode());
            settlePayload.setSettleDate(LocalDate.now());
            settlePayload.setFromSourceType(CalAccTypeEnum.PROJ.getCode());
            settlePayload.setFromSourceId(pmsProjectVO.getId());
            settlePayload.setFromSourceName(pmsProjectVO.getProjName());
            settlePayload.setToSourceType(CalAccTypeEnum.BU.getCode());
            settlePayload.setToSourceId(pmsProjectVO.getDeliBuId());
            settlePayload.setToSourceName(this.cacheUtil.getOrgName(pmsProjectVO.getDeliBuId()));
            settlePayload.setApplySettleEqva(avalQty);
            settlePayload.setSettlePrice(pmsProjectVO.getEqvaPrice());
            settlePayload.setApplySettleAmt(avalAmt);
            settlePayload.setIsSubmit(Integer.valueOf(1));
            this.calWideSettleService.insertOrUpdate(settlePayload);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateProjectStatus(Long projectId) {
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(projectId);
        String status = ProjectStatusEnum.ACTIVE.getCode();
        if (pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode()) || pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.PENDING.getCode())) {
            if (pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                status = ProjectStatusEnum.PENDING.getCode();
            }
        } else {
            throw TwException.error("", "\u4e0d\u652f\u6301\u7684\u72b6\u6001\u4fee\u6539");
        }
        this.pmsProjectDAO.updateProjStatus(projectId, status);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateProjectCloseStatus(List<Long> projectIds, String status) {
        this.pmsProjectDAO.updateProjStatuss(projectIds, status);
    }

    void checkData(PmsProjectPayload payload) {
        if (payload.getContractId() == null) {
            throw TwException.error("", "\u521b\u5efa\u9879\u76ee\u4e3b\u6587\u4ef6\u65f6,\u5b50\u5408\u540c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (payload.getEqvaPrice() == null) {
            throw TwException.error("", "\u5f53\u91cf\u9884\u4f30\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByContractId(payload.getContractId());
        if (pmsProjectVO != null) {
            Long loginUserId;
            if (payload.getId() == null || !payload.getId().equals(pmsProjectVO.getId())) {
                throw TwException.error("", "\u5b50\u5408\u540c\u5df2\u521b\u5efa\u9879\u76ee\u4e3b\u6587\u4ef6,\u4e0d\u53ef\u91cd\u590d\u521b\u5efa");
            }
            Long pmResId = payload.getPmResId();
            if (!(pmResId.equals(loginUserId = GlobalUtil.getLoginUserId()) || pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.CREATE.getCode()) || pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.APPROVING.getCode()))) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u6216\u6d3e\u53d1\u4e2d\u7684\u4fee\u6539");
            }
            payload.setId(pmsProjectVO.getId());
            payload.setProjStatus(pmsProjectVO.getProjStatus());
            payload.setCreateTime(pmsProjectVO.getCreateTime());
            payload.setCreateUserId(pmsProjectVO.getCreateUserId());
        } else {
            payload.setId(null);
            payload.setProjStatus(payload.getProjStatus() == null ? ProjectStatusEnum.CREATE.getCode() : payload.getProjStatus());
            SaleConContractVO saleConContractVO = this.pmsProjectDAO.querySaleConContractBySaleConId(payload.getContractId());
            if (saleConContractVO == null) {
                throw TwException.error("", "\u5b50\u5408\u540c\u4e0d\u5b58\u5728,\u8bf7\u6838\u9a8c\uff01");
            }
            payload.setDeliBuId(saleConContractVO.getDeliBuId());
            payload.setDeliUserId(saleConContractVO.getDeliUserId());
            payload.setSaleManUserId(saleConContractVO.getSaleManUserId());
            payload.setSignBuId(saleConContractVO.getSignBuId());
        }
        payload.setAutoReportFlag(Integer.valueOf(0));
        if (payload.getTotalEqva() == null) {
            payload.setTotalEqva(BigDecimal.ZERO);
        }
        if (payload.getTotalCost() == null) {
            payload.setTotalCost(BigDecimal.ZERO);
        }
        if (payload.getTotalReimbursement() == null) {
            payload.setTotalReimbursement(BigDecimal.ZERO);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectPayload payload) {
        this.prjFileHandle(payload);
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(payload.getId());
        if (pmsProjectVO != null) {
            this.checkDataRiskLevel(pmsProjectVO, payload);
            if (pmsProjectVO.getNoContractFlag() != null && pmsProjectVO.getNoContractFlag().equals(1)) {
                payload.setNoContractFlag(Integer.valueOf(0));
            }
            long result = this.pmsProjectDAO.updateByKeyDynamic(payload);
            return result;
        }
        throw TwException.error("", "\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u6838\u9a8c\uff01");
    }

    void checkDataRiskLevel(PmsProjectVO pmsProjectVO, PmsProjectPayload payload) {
        if (pmsProjectVO.getPlanOnlineDate() != null && pmsProjectVO.getPlanOnlineDate().isBefore(LocalDate.now()) && StringUtils.hasText((String)pmsProjectVO.getRiskLevel()) && pmsProjectVO.getRiskLevel().equals(ProjectRiskLevelEnum.RISK9.getCode()) && StringUtils.hasText((String)payload.getRiskLevel()) && !payload.getRiskLevel().equals(ProjectRiskLevelEnum.RISK9.getCode())) {
            ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
            queryReceivablePlan.setSaleConId(pmsProjectVO.getContractId());
            List recvPlanViews = this.conReceivablePlanService.queryListDynamic(queryReceivablePlan);
            BigDecimal receAmt = recvPlanViews.stream().map(ConReceivablePlanVO::getReceAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal actualReceivedAmt = recvPlanViews.stream().map(ConReceivablePlanVO::getActualRecvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal actualReceivedRate = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(receAmt) != 0) {
                actualReceivedRate = actualReceivedAmt.divide(receAmt, 4, RoundingMode.HALF_UP).movePointRight(2);
            }
            if (BigDecimal.ZERO.compareTo(receAmt) != 0 && actualReceivedRate.compareTo(BigDecimal.valueOf(50L)) < 0) {
                throw TwException.error("", "\u98ce\u9669\u7b49\u7ea7\u4e0d\u53ef\u4fee\u6539");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> this.pmsProjectDAO.deleteSoft(keys));
        }
    }

    public List<PmsProjectVO> queryProjectBriefWork(Long userId) {
        int dayOfMonth;
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        if ((dayOfMonth = LocalDate.now().getDayOfMonth()) >= this.briefDate) {
            List<Object> pmsProjectVOS;
            List<String> workTypes = Arrays.asList(SaleConWorkTypeEnum.DELIVERY.getCode(), SaleConWorkTypeEnum.DEVELOP.getCode());
            List<Long> platPmoAidUsers = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.PLAT_PMO_AID.getCode()));
            PmsProjectQuery query = new PmsProjectQuery();
            query.setWorkTypes(workTypes);
            query.setBriefWorkFlag(Boolean.valueOf(true));
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
            query.setProjStatusType("1");
            if (CollectionUtils.isEmpty(platPmoAidUsers) || !platPmoAidUsers.contains(userId)) {
                query.setLoginUserId(userId);
            }
            if (!ObjectUtils.isEmpty(pmsProjectVOS = this.pmsProjectDAO.projectBriefWork(query))) {
                ArrayList delProjectIds = new ArrayList();
                LocalDate localDate = LocalDate.now();
                List collect = pmsProjectVOS.stream().map(PmsProjectVO::getId).collect(Collectors.toList());
                List pmsProjectBriefVOS = this.pmsProjectBriefService.projectBriefWork(collect);
                if (!ObjectUtils.isEmpty((Object)pmsProjectBriefVOS)) {
                    List<String> processStatus = Arrays.asList("CLOSED", "END");
                    pmsProjectBriefVOS.forEach(briefVO -> {
                        int i = DateUtil.differenceMonth(briefVO.getFinPeriodDate(), localDate);
                        if (i < 1) {
                            delProjectIds.add(briefVO.getProjId());
                        } else if (processStatus.contains(briefVO.getProjProcessStatus()) && BigDecimal.valueOf(100L).compareTo(briefVO.getReprotCompPercent()) == 0) {
                            delProjectIds.add(briefVO.getProjId());
                        }
                    });
                }
                if (delProjectIds.size() > 0) {
                    pmsProjectVOS = pmsProjectVOS.stream().filter(vo -> !delProjectIds.contains(vo.getId())).collect(Collectors.toList());
                }
                return pmsProjectVOS;
            }
        }
        return null;
    }

    public List<PmsProjectVO> queryProjectUpdateWork() {
        Long userId = GlobalUtil.getLoginUserId();
        PmsProjectQuery query = new PmsProjectQuery();
        query.setDeliUserId(userId);
        query.setNoContractFlag(Integer.valueOf(1));
        return this.pmsProjectDAO.queryProjectUpdateWork(query);
    }

    public long queryProjectUpdateWorkCount(Long userId) {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setDeliUserId(userId);
        query.setNoContractFlag(Integer.valueOf(1));
        return this.pmsProjectDAO.count0(query);
    }

    public long queryProjectUpdateBudgetWorkCount(Long userId) {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setPmResId(userId);
        query.setNoContractFlag(Integer.valueOf(2));
        return this.pmsProjectDAO.count1(query);
    }

    public List<PmsProjectVO> queryProjectUpdateBudgetWork() {
        Long userId = GlobalUtil.getLoginUserId();
        PmsProjectQuery query = new PmsProjectQuery();
        query.setPmResId(userId);
        query.setNoContractFlag(Integer.valueOf(2));
        return this.pmsProjectDAO.queryProjectUpdateBudgetWork(query);
    }

    @Transactional
    public PmsProjectVO updateChange(PmsProjectPayload payload) {
        this.prjFileHandle(payload);
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(payload.getId());
        if (!ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "\u6fc0\u6d3b\u9879\u76ee\u624d\u53ef\u4ee5\u53d1\u8d77\u53d8\u66f4");
            }
        } else {
            throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.updateByKeyDynamic(payload);
        return null;
    }

    void checkUpdateReportPlan(List<PmsProjectReportPlanVO> pmsProjectReportPlanVOS, PmsProjectPayload payload, BigDecimal notTaxAmt) {
        ArrayList delReportPlanIds = new ArrayList();
        pmsProjectReportPlanVOS.forEach(oldPlan -> {
            Optional<PmsProjectReportPlanPayload> first = payload.getProjectReportPlanPayloads().stream().filter(newPlan -> DateUtil.differenceMonth(newPlan.getPeriodDate(), oldPlan.getPeriodDate()) == 0).findFirst();
            if (first.isPresent()) {
                PmsProjectReportPlanPayload newPlanPayload = first.get();
                newPlanPayload.setId(oldPlan.getId());
                if (oldPlan.getBriefId() != null) {
                    if (oldPlan.getAmt().compareTo(newPlanPayload.getAmt()) != 0) {
                        throw TwException.error("", "\u5df2\u751f\u6210\u9879\u76ee\u6c47\u62a5\u8ba1\u5212\u91d1\u989d\u4e0d\u80fd\u53d8\u66f4");
                    }
                    newPlanPayload.setBriefId(oldPlan.getBriefId());
                    newPlanPayload.setBriefNo(oldPlan.getBriefNo());
                }
            } else {
                if (oldPlan.getBriefId() != null) {
                    throw TwException.error("", "\u5df2\u751f\u6210\u9879\u76ee\u6c47\u62a5\u8ba1\u5212\u4e0d\u53ef\u5220\u9664");
                }
                delReportPlanIds.add(oldPlan.getId());
            }
        });
        payload.setDelReportPlanIds(delReportPlanIds);
        this.checkReportPlan(notTaxAmt, payload.getProjectReportPlanPayloads());
    }

    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ComChangeVO comChangeVO = this.changeService.queryByKey(Long.valueOf(businessKey));
        if (comChangeVO != null) {
            PmsProjectVO projectVO = new PmsProjectVO();
            projectVO.setId(Long.valueOf(comChangeVO.getChangeDocId()));
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(comChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            changePayload.setProcInstId(comChangeVO.getProcInstId());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                }
                case INTERRUPT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    projectVO.setChangeFlag(Integer.valueOf(0));
                    this.updateWorkFlow(projectVO);
                    break;
                }
                case INVALID: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    changePayload.setDeleteFlag(Integer.valueOf(1));
                    projectVO.setChangeFlag(Integer.valueOf(0));
                    this.updateWorkFlow(projectVO);
                    break;
                }
                case REJECTED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    projectVO = (PmsProjectVO)JSON.parseObject((String)comChangeVO.getChangeContent(), PmsProjectVO.class);
                    projectVO.setChangeFlag(Integer.valueOf(0));
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    this.updateWorkFlow(projectVO);
                    break;
                }
            }
            this.changeService.updateWorkFlow(changePayload);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void projectJobHandler() {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        query.setPlanOnlineDate(LocalDate.now());
        List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(pmsProjectVOS)) {
            Map projectVOMap = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getContractId, Function.identity()));
            ConReceivablePlanQuery queryReceivablePlan = new ConReceivablePlanQuery();
            queryReceivablePlan.setSaleConIds(new ArrayList<Long>(projectVOMap.keySet()));
            ArrayList<Long> updateNullIds = new ArrayList<Long>();
            ArrayList<Long> updateHighIds = new ArrayList<Long>();
            List recvPlanViewVOs = this.conReceivablePlanService.queryListDynamic(queryReceivablePlan);
            if (!ObjectUtils.isEmpty((Object)recvPlanViewVOs)) {
                Map<Long, List<ConReceivablePlanVO>> collect = recvPlanViewVOs.stream().collect(Collectors.groupingBy(ConReceivablePlanVO::getSaleConId));
                collect.entrySet().stream().forEach(entry -> {
                    List recvPlanViews = (List)entry.getValue();
                    BigDecimal receAmt = recvPlanViews.stream().map(ConReceivablePlanVO::getReceAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal actualReceivedAmt = recvPlanViews.stream().map(ConReceivablePlanVO::getActualRecvAmt).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal actualReceivedRate = BigDecimal.ZERO;
                    if (BigDecimal.ZERO.compareTo(receAmt) != 0) {
                        actualReceivedRate = actualReceivedAmt.divide(receAmt, 4, RoundingMode.HALF_UP).movePointRight(2);
                    }
                    PmsProjectVO pmsProjectVO = (PmsProjectVO)projectVOMap.get(entry.getKey());
                    if (BigDecimal.ZERO.compareTo(receAmt) == 0 || actualReceivedRate.compareTo(BigDecimal.valueOf(50L)) >= 0) {
                        if (StringUtils.hasText((String)pmsProjectVO.getRiskLevel()) && pmsProjectVO.getRiskLevel().equals(ProjectRiskLevelEnum.RISK9.getCode())) {
                            updateNullIds.add(pmsProjectVO.getId());
                        }
                    } else if (!StringUtils.hasText((String)pmsProjectVO.getRiskLevel()) || !pmsProjectVO.getRiskLevel().equals(ProjectRiskLevelEnum.RISK9.getCode())) {
                        updateHighIds.add(pmsProjectVO.getId());
                    }
                });
            }
            if (updateNullIds.size() > 0) {
                this.pmsProjectDAO.updateRiskLevel(updateNullIds, "");
            }
            if (updateHighIds.size() > 0) {
                this.pmsProjectDAO.updateRiskLevel(updateHighIds, ProjectRiskLevelEnum.RISK9.getCode());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateNoContractData(PmsProjectPayload payload) {
        if (payload.getId() == null) throw TwException.error("", "\u9879\u76eeid\u4e0d\u53ef\u4e3a\u7a7a");
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(payload.getId());
        if (pmsProjectVO == null) throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728");
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (!loginUserId.equals(pmsProjectVO.getDeliUserId())) throw TwException.error("", "\u65e0\u64cd\u65e0\u5408\u540c\u5165\u573a\u865a\u62df\u5408\u540c\u9879\u76ee\u6570\u636e\u53d8\u66f4\u7684\u6743\u9650\uff01");
        if (payload.getNoContractFlag() == null || payload.getNoContractFlag() != 0) {
            payload.setNoContractFlag(Integer.valueOf(2));
        } else {
            payload.setNoContractFlag(Integer.valueOf(0));
        }
        this.pmsProjectDAO.updateByKeyDynamic(payload);
    }

    public void updateBudgetAfterUpdateProject(Long key) {
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(key);
        if (pmsProjectVO != null && pmsProjectVO.getNoContractFlag() != null && pmsProjectVO.getNoContractFlag() != 0) {
            PmsProjectPayload payload = new PmsProjectPayload();
            payload.setId(key);
            payload.setNoContractFlag(Integer.valueOf(0));
            this.pmsProjectDAO.updateByKeyDynamic(payload);
        }
    }

    public void noContractActivity(Long contractId) {
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByContractId(contractId);
        if (pmsProjectVO != null) {
            PmsProjectPayload payload = new PmsProjectPayload();
            payload.setId(pmsProjectVO.getId());
            payload.setNoContractFlag(Integer.valueOf(1));
            this.pmsProjectDAO.updateByKeyDynamic(payload);
        }
    }

    public List<PmsProjectVO> queryListByProjectMember(Long userId, Boolean selectAll) {
        if (userId == null) {
            userId = GlobalUtil.getLoginUserId();
        }
        PmsProjectQuery query = new PmsProjectQuery();
        query.setLoginUserId(userId);
        if (selectAll != null && selectAll.booleanValue()) {
            List<String> strings = Arrays.asList(ProjectStatusEnum.ACTIVE.getCode(), ProjectStatusEnum.PENDING.getCode(), ProjectStatusEnum.CLOSING.getCode(), ProjectStatusEnum.CLOSED.getCode(), ProjectStatusEnum.OVERDUE_ACCOUNTS.getCode());
            query.setProjStatusList(strings);
        } else {
            query.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        }
        List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryProjectListByMemberId(query);
        if (!CollectionUtils.isEmpty(pmsProjectVOS)) {
            pmsProjectVOS.stream().forEach(e -> e.setCustName(this.cacheUtil.getCompanyNameByBookId(e.getCustId())));
            List<Long> collect = pmsProjectVOS.stream().filter(vo -> vo.getContractId() != null).map(PmsProjectVO::getContractId).distinct().collect(Collectors.toList());
            this.tranContractData(pmsProjectVOS, collect);
        }
        return pmsProjectVOS;
    }

    public PmsProjectVO findIdByNo(String projectNo) {
        return this.pmsProjectDAO.findIdByNo(projectNo);
    }

    public long countByCustomerId(Long customerId) {
        PmsProjectQuery query = new PmsProjectQuery();
        query.setCustomerId(customerId);
        query.setMainType("SUB");
        return this.pmsProjectDAO.count(query);
    }

    void checkReportPlan(BigDecimal notTaxAmt, List<PmsProjectReportPlanPayload> projectReportPlanPayloads) {
    }

    public void updateWorkFlow(PmsProjectVO projectVO) {
        PmsProjectPayload payload = PmsProjectConvert.INSTANCE.toPayload(projectVO);
        List projectReportPlanVOs = projectVO.getProjectReportPlanVOs();
        List<PmsProjectReportPlanPayload> projectReportPlanPayloads = PmsProjectReportPlanConvert.INSTANCE.toPayloads(projectReportPlanVOs);
        payload.setProjectReportPlanPayloads(projectReportPlanPayloads);
        this.pmsProjectDAO.updateByKeyDynamic(payload);
        if (!ObjectUtils.isEmpty((Object)payload.getDelReportPlanIds())) {
            this.pmsProjectReportPlanService.deleteSoft(payload.getDelReportPlanIds());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getProjectReportPlanPayloads())) {
            payload.getProjectReportPlanPayloads().forEach(reportPlan -> reportPlan.setProjId(payload.getId()));
            this.pmsProjectReportPlanService.batchInsert(payload.getProjectReportPlanPayloads());
        }
    }

    private ProcessInfo startChangeWorkFlow(PmsProjectVO pmsProjectVO, Long saveId, Boolean isUpdatePm) {
        List userIds = this.roleService.queryUserIdByRoleCode(RoleEnum.PROJ_CHANGE_FINANCE_APPROVER.getCode());
        if (ObjectUtils.isEmpty((Object)userIds)) {
            throw TwException.error("", "\u8d22\u52a1\u5ba1\u6279\u89d2\u8272\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        HashMap<String, Serializable> batchMap = new HashMap<String, Serializable>();
        batchMap.put("Activity_0xnrn8j", Lists.newArrayList((Iterable)userIds));
        PrdOrgOrganizationVO org = this.cacheUtil.getOrg(pmsProjectVO.getDeliBuId());
        batchMap.put("Activity_11vp8hd", Lists.newArrayList((Object[])new Long[]{org.getManageId()}));
        batchMap.put("isUpdatePm", isUpdatePm);
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_PROJECT_CHANGE.name(), (String)("P07.\u9879\u76ee\u5173\u952e\u4fe1\u606f\u53d8\u66f4\u5ba1\u6279-" + pmsProjectVO.getProjName()), (String)("" + saveId), batchMap), new Long[0]);
        return processInfo;
    }

    private void prjFileHandle(PmsProjectPayload payload) {
        Map<String, Object> context = BeanUtil.beanToMap(payload);
        String sowFileStr = this.yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getSowFiles());
        payload.setSowFiles(sowFileStr);
        String projectFilesStr = this.yeedocUtils.saveYeedocFileByFieldConfig(context, payload.getProjectFiles());
        payload.setProjectFiles(projectFilesStr);
    }

    public PmsProjectServiceImpl(PmsProjectRepo pmsProjectRepo, PmsProjectDAO pmsProjectDAO, FileUtil fileUtil, PmsProjectBriefService pmsProjectBriefService, PmsProjectReportPlanService pmsProjectReportPlanService, TransactionUtilService transactionUtilService, ComChangeService changeService, WorkflowUtil workflowUtil, PrdSystemRoleService roleService, UdcUtil udcUtil, ConReceivablePlanService conReceivablePlanService, CrmCustomerOperationService customerOperationService, PmsProjectTemplateService pmsProjectTemplateService, CacheUtil cacheUtil, PmsProjectMembersDAO pmsProjectMembersDAO, CalAccountService calAccountService, CalWideSettleService calWideSettleService, com.elitesland.tw.tw5.server.common.ExcelUtil excelUtil, PrdSystemRoleDAO systemRoleDAO, PmsProjectActivityService projectActivityService, PmsProjectMembersService projectMembersService, PmsResourcePlanService resourcePlanService, BudgetDAO budgetDAO, TaskPackageDAO taskPackageDAO, BusinessPartnerService businessPartnerService, TaskCommonService taskCommonService, TaskInfoDAO taskInfoDAO, BudgetSubjectDetailService budgetSubjectDetailService, PmsProjectEventLogService pmsProjectEventLogService, ComChangeDAO comChangeDAO, YeedocUtils yeedocUtils) {
        this.pmsProjectRepo = pmsProjectRepo;
        this.pmsProjectDAO = pmsProjectDAO;
        this.fileUtil = fileUtil;
        this.pmsProjectBriefService = pmsProjectBriefService;
        this.pmsProjectReportPlanService = pmsProjectReportPlanService;
        this.transactionUtilService = transactionUtilService;
        this.changeService = changeService;
        this.workflowUtil = workflowUtil;
        this.roleService = roleService;
        this.udcUtil = udcUtil;
        this.conReceivablePlanService = conReceivablePlanService;
        this.customerOperationService = customerOperationService;
        this.pmsProjectTemplateService = pmsProjectTemplateService;
        this.cacheUtil = cacheUtil;
        this.pmsProjectMembersDAO = pmsProjectMembersDAO;
        this.calAccountService = calAccountService;
        this.calWideSettleService = calWideSettleService;
        this.excelUtil = excelUtil;
        this.systemRoleDAO = systemRoleDAO;
        this.projectActivityService = projectActivityService;
        this.projectMembersService = projectMembersService;
        this.resourcePlanService = resourcePlanService;
        this.budgetDAO = budgetDAO;
        this.taskPackageDAO = taskPackageDAO;
        this.businessPartnerService = businessPartnerService;
        this.taskCommonService = taskCommonService;
        this.taskInfoDAO = taskInfoDAO;
        this.budgetSubjectDetailService = budgetSubjectDetailService;
        this.pmsProjectEventLogService = pmsProjectEventLogService;
        this.comChangeDAO = comChangeDAO;
        this.yeedocUtils = yeedocUtils;
    }
}

