/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.common.log.payload.ComLogPayload;
import com.elitesland.tw.tw5.api.common.log.query.ComLogQuery;
import com.elitesland.tw.tw5.api.common.log.service.ComLogService;
import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectCalendarPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsAcceptPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsResourcePayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsSchedulingPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsSnapshotPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsSubmitDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsActCostPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsActPayPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsWbsVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsAcceptQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsLogQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsRelyQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsResourceQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsSnapshotQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsBudgetDetailService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectCalendarService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsAcceptService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsRelyService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsResourceService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsSnapshotService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsWbsVersionService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectCalendarVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsAcceptVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsSnapshotVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsActCostVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsActPayVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsVersionVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.task.service.PmsWbsTaskService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.ComChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.ComLogTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.common.util.AutoScheduling;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.personplan.dao.ProRelatedPartiesDao;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjWbsAllocateStateEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectWbsTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsAcceptConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsRelyConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectWbsResourceConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsWbsActCostConvert;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsWbsActPayConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsAcceptDao;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsRelyDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectWbsResourceDao;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsWbsActCostDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsWbsActPayDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsAcceptDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsRelyDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsResourceDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsWbsActCostDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsWbsActPayDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsAcceptRepo;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsResourceRepo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskContainer;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIWriter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PmsProjectWbsServiceImpl
extends BaseServiceImpl
implements PmsProjectWbsService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectWbsServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PmsProjectWbsDAO pmsProjectWbsDAO;
    private final PmsWbsActCostDAO pmsWbsActCostDAO;
    private final PmsWbsActPayDAO pmsWbsActPayDAO;
    private final ComLogService logService;
    private final ComChangeService changeService;
    private final PmsProjectDAO pmsProjectDAO;
    private final ChangeFieldUtil changeFieldUtil;
    private final PmsProjectWbsSnapshotService planSnapshotService;
    private final PmsProjectCalendarService calendarService;
    private final PmsProjectWbsRelyDAO pmsProjectWbsRelyDAO;
    private final PmsBudgetDetailService budgetDetailService;
    private final ConReceivablePlanService conReceivablePlanService;
    private final ProRelatedPartiesDao proRelatedPartiesDao;
    private final PmsProjectWbsAcceptService pmsProjectWbsAcceptService;
    @Autowired
    @Lazy
    private PmsProjectWbsResourceService pmsProjectWbsResourceService;
    @Autowired
    @Lazy
    private PmsProjectWbsRelyService pmsProjectWbsRelyService;
    @Autowired
    @Lazy
    private ProRelatedPartiesService proRelatedPartiesService;
    private final PmsWbsVersionService pmsWbsVersionService;
    private final PmsProjectWbsResourceDao pmsProjectWbsResourceDao;
    private final PmsProjectWbsResourceRepo pmsProjectWbsResourceRepo;
    private final PmsProjectWbsAcceptDao pmsProjectWbsAcceptDao;
    private final PmsProjectWbsAcceptRepo pmsProjectWbsAcceptRepo;
    private static Map<Long, Map<String, Object>> progressAndStatusCache = new HashMap<Long, Map<String, Object>>();

    public PmsWbsTaskService getPmsWbsTaskService() {
        return (PmsWbsTaskService)SpringUtil.getBean(PmsWbsTaskService.class);
    }

    void transferData(PmsProjectWbsPayload payload) {
        payload.setCostTypeName(this.cacheUtil.transferSystemSelection("PMS:WBS:ACT_COST:TYPE", payload.getCostType()));
        String wbsTypeName = payload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode()) ? "WBS\u5143\u7d20" : (payload.getWbsType().equals(ProjectWbsTypeEnum.NET.getCode()) ? "\u7f51\u7edc" : (payload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) ? "\u6d3b\u52a8" : "\u91cc\u7a0b\u7891"));
        payload.setWbsTypeName(wbsTypeName);
        if (payload.getInvoiceAttr() != null) {
            payload.setInvoiceAttrName(payload.getInvoiceAttr() == 0 ? "\u53d6\u6d88\u52fe\u9009" : "\u52fe\u9009");
        }
        if (payload.getCostPlan() != null) {
            payload.setCostPlanName(payload.getCostPlan() == 0 ? "\u53d6\u6d88\u52fe\u9009" : "\u52fe\u9009");
        }
        if (payload.getSubjectDist() != null) {
            payload.setSubjectDistName(payload.getSubjectDist() == 0 ? "\u53d6\u6d88\u52fe\u9009" : "\u52fe\u9009");
        }
    }

    void getParentUserIds(List<Long> parentUserIds, String parentWbsCode, List<PmsProjectWbsVO> projectWbsVOs) {
        PmsProjectWbsVO pmsProjectWbsVO;
        Optional<PmsProjectWbsVO> first = projectWbsVOs.stream().filter(wbsVO -> wbsVO.getWbsCode().equals(parentWbsCode)).findFirst();
        if (first.isPresent()) {
            pmsProjectWbsVO = first.get();
            if (!ObjectUtils.isEmpty((Object)pmsProjectWbsVO.getManagerUserId())) {
                parentUserIds.add(pmsProjectWbsVO.getManagerUserId());
            }
            if (!org.springframework.util.StringUtils.hasText((String)pmsProjectWbsVO.getParentWbsCode())) {
                return;
            }
        } else {
            return;
        }
        this.getParentUserIds(parentUserIds, pmsProjectWbsVO.getParentWbsCode(), projectWbsVOs);
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsVO batchInsertOrUpdate(PmsProjectWbsDataPayload payload) {
        List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS;
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error("", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(payload.getProjectId());
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error("", "\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List wbsPayloads = payload.getWbsPayloads();
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryByProjectId(payload.getProjectId());
        if ((payload.getIsTempCreate().booleanValue() || payload.getIsImportCreate().booleanValue()) && !ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
            List collect = pmsProjectWbsVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            payload.setDelWbsIds(collect);
        }
        ArrayList<Long> updateAllIds = new ArrayList<Long>();
        ArrayList checkDurationIds = new ArrayList();
        ArrayList<ComLogPayload> logPayloads = new ArrayList<ComLogPayload>();
        if (!ObjectUtils.isEmpty((Object)payload.getDelWbsIds())) {
            updateAllIds.addAll(payload.getDelWbsIds());
            List<PmsProjectWbsVO> collect = pmsProjectWbsVOS.stream().filter(wbsVO -> payload.getDelWbsIds().contains(wbsVO.getId())).collect(Collectors.toList());
            this.createWbsDelLog(logPayloads, collect);
            this.deleteSoft(payload.getDelWbsIds());
            pmsProjectWbsVOS.removeAll(collect);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getWbsPayloads())) {
            String lastFourDigits = String.format("%04d", System.currentTimeMillis() % 10000L);
            wbsPayloads.forEach(wbsPayload -> {
                this.checkData((PmsProjectWbsPayload)wbsPayload);
                if (ObjectUtils.isEmpty((Object)wbsPayload.getWbsStatus())) {
                    if (ProjectWbsTypeEnum.WBS.getCode().equals(wbsPayload.getWbsType())) {
                        wbsPayload.setWbsStatus(null);
                    }
                    if (ProjectWbsTypeEnum.MS.getCode().equals(wbsPayload.getWbsType())) {
                        wbsPayload.setWbsStatus(ProjectWbsStatusEnum.UN_FINISHED.getCode());
                    }
                    if (ProjectWbsTypeEnum.ACT.getCode().equals(wbsPayload.getWbsType())) {
                        wbsPayload.setWbsStatus(ProjectWbsStatusEnum.NOSTART.getCode());
                    }
                }
                if (!org.springframework.util.StringUtils.hasText((String)wbsPayload.getParentWbsCode())) {
                    wbsPayload.setParentWbsCode("");
                }
                wbsPayload.setProjectId(payload.getProjectId());
                if (wbsPayload.getId() == null) {
                    Random random = new Random();
                    int s = random.nextInt(99) % 90 + 10;
                    wbsPayload.setAutoScheduling(Integer.valueOf(0));
                    wbsPayload.setIsKeyNode(Integer.valueOf(0));
                } else {
                    Optional<PmsProjectWbsVO> vo1 = pmsProjectWbsVOS.stream().filter(vo -> vo.getId().equals(wbsPayload.getId())).findFirst();
                    if (vo1.isPresent()) {
                        BigDecimal preDurationDayPayload = wbsPayload.getPreDurationDay();
                        BigDecimal preDurationDayVO = vo1.get().getPreDurationDay();
                        if (!ObjectUtils.isEmpty((Object)preDurationDayVO)) {
                            if (ObjectUtils.isEmpty((Object)preDurationDayPayload)) {
                                updateAllIds.add(wbsPayload.getId());
                                checkDurationIds.add(wbsPayload.getId());
                            } else if (preDurationDayPayload.compareTo(preDurationDayVO) != 0) {
                                updateAllIds.add(wbsPayload.getId());
                            }
                        }
                    }
                }
                if (org.springframework.util.StringUtils.hasText((String)wbsPayload.getParentWbsCode())) {
                    Optional<PmsProjectWbsPayload> payload1 = wbsPayloads.stream().filter(load -> load.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                    if (payload1.isPresent()) {
                        wbsPayload.setParentWbsName(payload1.get().getWbsName());
                    } else {
                        Optional<PmsProjectWbsVO> vo1 = pmsProjectWbsVOS.stream().filter(vo -> vo.getWbsCode().equals(wbsPayload.getParentWbsCode())).findFirst();
                        if (vo1.isPresent()) {
                            wbsPayload.setParentWbsName(vo1.get().getWbsName());
                        }
                    }
                }
            });
            List<PmsProjectWbsDO> entityDos = wbsPayloads.stream().map(e -> {
                PmsProjectWbsDO wbsDO = PmsProjectWbsConvert.INSTANCE.toDo((PmsProjectWbsPayload)e);
                wbsDO.setState("0");
                e.setWbsDO((BaseModel)wbsDO);
                return wbsDO;
            }).collect(Collectors.toList());
            List<PmsProjectWbsDO> pmsProjectWbsDOS = this.pmsProjectWbsDAO.saveAll(entityDos);
            Map collectMap = pmsProjectWbsDOS.stream().collect(Collectors.toMap(PmsProjectWbsDO::getWbsCode, Function.identity(), (t1, t2) -> t1));
            if (!ObjectUtils.isEmpty((Object)payload.getWbsPayloads())) {
                wbsPayloads.forEach(wbsPayload -> {
                    List pmsProjectWbsResourcePayloadList = wbsPayload.getPmsProjectWbsResourcePayloadList();
                    if (null != wbsPayload.getId()) {
                        this.pmsProjectWbsResourceDao.delByWbsIds(List.of(wbsPayload.getId()));
                    }
                    if (CollUtil.isNotEmpty((Collection)wbsPayload.getPmsProjectWbsResourcePayloadList())) {
                        pmsProjectWbsResourcePayloadList.stream().forEach(x -> {
                            x.setWbsId(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getId());
                            x.setProjectId(payload.getProjectId());
                            x.setVersionId(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getVersionId());
                            x.setVersionNo(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getVersionNo());
                            x.setWbsCode(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getWbsCode());
                        });
                        this.pmsProjectWbsResourceService.saveAll(pmsProjectWbsResourcePayloadList);
                    }
                    List pmsProjectWbsRelyDataPayloadList = wbsPayload.getPmsProjectWbsRelyDataPayloadList();
                    if (null != wbsPayload.getId()) {
                        this.pmsProjectWbsRelyService.delByWbsId(wbsPayload.getId(), wbsPayload.getVersionNo());
                    }
                    if (CollUtil.isNotEmpty((Collection)pmsProjectWbsRelyDataPayloadList)) {
                        this.pmsProjectWbsRelyService.delByWbsId(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getId(), ((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getVersionNo());
                        pmsProjectWbsRelyDataPayloadList.stream().forEach(x -> {
                            HashSet addWbsRelyIds = new HashSet();
                            if (!ObjectUtils.isEmpty((Object)x.getAddWbsRelyIds())) {
                                addWbsRelyIds.addAll(x.getAddWbsRelyIds());
                            }
                            if (!ObjectUtils.isEmpty((Object)x.getAddWbsRelyCodes())) {
                                List collect = x.getAddWbsRelyCodes().stream().map(collectMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                                addWbsRelyIds.addAll(collect.stream().map(BaseModel::getId).collect(Collectors.toList()));
                            }
                            x.setAddWbsRelyIds(new ArrayList(addWbsRelyIds));
                            x.setWbsId(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getId());
                            x.setVersionId(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getVersionId());
                            x.setVersionNo(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getVersionNo());
                            x.setVersionNo(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getVersionNo());
                            x.setWbsCode(((PmsProjectWbsDO)collectMap.get(wbsPayload.getWbsCode())).getWbsCode());
                            this.pmsProjectWbsRelyService.batchInsert(x);
                        });
                    }
                });
            }
            List<PmsProjectWbsPayload> updatePayloads = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getId() != null).collect(Collectors.toList());
            List<Long> updateIds = this.createWbsUpdateLog(logPayloads, pmsProjectWbsVOS, updatePayloads);
            ArrayList<PmsProjectWbsPayload> addPayloads = new ArrayList<PmsProjectWbsPayload>();
            wbsPayloads.forEach(wbsPayload -> {
                wbsPayload.setId(wbsPayload.getWbsDO().getId());
                if (!updateIds.contains(wbsPayload.getId())) {
                    addPayloads.add((PmsProjectWbsPayload)wbsPayload);
                }
            });
            this.operProjectCalendar(payload);
            this.createWbsAddLog(logPayloads, addPayloads);
            List<PmsProjectWbsPayload> act = wbsPayloads.stream().filter(wbsPayload -> wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(act)) {
                List<Object> pmsWbsActCostVOS = this.pmsWbsActCostDAO.queryByProjectId(payload.getProjectId());
                List<Object> pmsWbsActPayVOS = this.pmsWbsActPayDAO.queryByProjectId(payload.getProjectId());
                ArrayList<Long> delActCostIds = new ArrayList<Long>();
                ArrayList<Long> delActPayIds = new ArrayList<Long>();
                for (PmsProjectWbsPayload wbsPayload2 : act) {
                    if (!ObjectUtils.isEmpty((Object)wbsPayload2.getDelActCostIds())) {
                        delActCostIds.addAll(wbsPayload2.getDelActCostIds());
                    }
                    if (!ObjectUtils.isEmpty((Object)wbsPayload2.getDelActPayIds())) {
                        delActPayIds.addAll(wbsPayload2.getDelActPayIds());
                    }
                    if (!ObjectUtils.isEmpty((Object)wbsPayload2.getDelActCostIds()) || !ObjectUtils.isEmpty((Object)wbsPayload2.getActCostPayloads())) {
                        this.operActCostLog(logPayloads, wbsPayload2, pmsWbsActCostVOS);
                    }
                    if (ObjectUtils.isEmpty((Object)wbsPayload2.getDelActPayIds()) && ObjectUtils.isEmpty((Object)wbsPayload2.getActPayPayloads())) continue;
                    this.operActPayLog(logPayloads, wbsPayload2, pmsWbsActPayVOS);
                }
                if (delActCostIds.size() > 0) {
                    this.pmsWbsActCostDAO.deleteSoft(delActCostIds);
                    pmsWbsActCostVOS = pmsWbsActCostVOS.stream().filter(costVO -> !delActCostIds.contains(costVO.getId())).collect(Collectors.toList());
                }
                if (delActPayIds.size() > 0) {
                    this.pmsWbsActPayDAO.deleteSoft(delActPayIds);
                    pmsWbsActPayVOS = pmsWbsActPayVOS.stream().filter(payVO -> !delActPayIds.contains(payVO.getId())).collect(Collectors.toList());
                }
                ArrayList<PmsWbsActCostPayload> actCostPayloads = new ArrayList<PmsWbsActCostPayload>();
                ArrayList<PmsWbsActPayPayload> actPayPayloads = new ArrayList<PmsWbsActPayPayload>();
                this.checkWbsAct(act, pmsProjectWbsDOS, actCostPayloads, actPayPayloads, payload.getProjectId(), pmsWbsActCostVOS, pmsWbsActPayVOS);
                if (actCostPayloads.size() > 0) {
                    List<PmsWbsActCostDO> pmsWbsActCostDOS = PmsWbsActCostConvert.INSTANCE.toDoList(actCostPayloads);
                    this.pmsWbsActCostDAO.saveAll(pmsWbsActCostDOS);
                }
                if (actPayPayloads.size() > 0) {
                    List<PmsWbsActPayDO> pmsWbsActPayDOS = PmsWbsActPayConvert.INSTANCE.toDoList(actPayPayloads);
                    this.pmsWbsActPayDAO.saveAll(pmsWbsActPayDOS);
                }
            }
        }
        if (logPayloads.size() > 0) {
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setChangeContent("\u9879\u76ee\u8ba1\u5212\u53d8\u66f4");
            changePayload.setChangeDocId("" + payload.getProjectId());
            changePayload.setChangeType(ComChangeTypeEnum.PMS_PROJECT_WBS.getCode());
            changePayload.setCreator(GlobalUtil.getLoginUserName());
            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED.getCode());
            ComChangeVO insert = this.changeService.insert(changePayload);
            String vid = payload.getProjectId() + "-" + insert.getVersionNo();
            logPayloads.forEach(log -> log.setExtString1(vid));
            this.logService.insertBacth(logPayloads);
        }
        if (updateAllIds.size() > 0 && !ObjectUtils.isEmpty(pmsProjectWbsRelyVOS = this.pmsProjectWbsRelyDAO.queryByWbsIds(updateAllIds))) {
            List collect = pmsProjectWbsRelyVOS.stream().filter(relyVO -> checkDurationIds.contains(relyVO.getWbsId()) || checkDurationIds.contains(relyVO.getWbsRelyId())).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(collect)) {
                throw TwException.error("", "\u5b58\u5728\u4f9d\u8d56\u5173\u7cfb\u7684wbs\u8282\u70b9\u5de5\u671f\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            this.updateSchedulingStatus(payload.getProjectId());
        }
        return null;
    }

    private void checkData(PmsProjectWbsPayload wbsPayload) {
        if (ObjectUtils.isEmpty((Object)wbsPayload.getVersionId())) {
            throw new BusinessException("\u7248\u672cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)wbsPayload.getVersionNo())) {
            throw new BusinessException("\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    void operProjectCalendar(PmsProjectWbsDataPayload projectWbsDataPayload) {
        List wbsPayloads;
        if (!ObjectUtils.isEmpty((Object)projectWbsDataPayload.getDelWbsIds())) {
            this.calendarService.deleteSoftBySource(projectWbsDataPayload.getDelWbsIds(), ProjectWbsTypeEnum.WBS.getCode());
        }
        if (!ObjectUtils.isEmpty((Object)(wbsPayloads = projectWbsDataPayload.getWbsPayloads()))) {
            ArrayList pmsProjectCalendarPayloads = new ArrayList();
            wbsPayloads.forEach(wbsPayload -> {
                PmsProjectCalendarPayload pmsProjectCalendarPayload = wbsPayload.getPmsProjectCalendarPayload();
                if (!ObjectUtils.isEmpty((Object)pmsProjectCalendarPayload)) {
                    pmsProjectCalendarPayload.setSourceId(wbsPayload.getId());
                    pmsProjectCalendarPayload.setSourceType(ProjectWbsTypeEnum.WBS.getCode());
                    pmsProjectCalendarPayloads.add(pmsProjectCalendarPayload);
                }
            });
            this.calendarService.batchSave(pmsProjectCalendarPayloads);
        }
    }

    void operActCostLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActCostVO> pmsWbsActCostVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals("" + wbsPayload.getId())).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            logPayload.setObjectId("" + wbsPayload.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("\u6210\u672c\u4f30\u8ba1:");
        builder.append("\n");
        List<Object> dels = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)wbsPayload.getDelActCostIds())) {
            dels = pmsWbsActCostVOS.stream().filter(wbsVO -> wbsPayload.getDelActCostIds().contains(wbsVO.getId())).map(PmsWbsActCostVO::getCostName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("\u5220\u9664");
            for (int i = 0; i < dels.size(); ++i) {
                if (i == 0) {
                    builder.append("\u3010" + (String)dels.get(i) + "\u3011");
                    continue;
                }
                builder.append(",\u3010" + (String)dels.get(i) + "\u3011");
            }
        }
        List actCostPayloads = wbsPayload.getActCostPayloads();
        List<Object> adds = new ArrayList();
        List<Object> updates = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)actCostPayloads)) {
            adds = actCostPayloads.stream().filter(actCost -> actCost.getId() == null).collect(Collectors.toList());
            updates = actCostPayloads.stream().filter(actCost -> actCost.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("\u6210\u672c\u8981\u7d20-\u6210\u672c\u4f30\u8ba1 \u521b\u5efa\u4e3a");
            builder.append("\n");
            for (PmsWbsActCostPayload pmsWbsActCostPayload : adds) {
                builder.append(pmsWbsActCostPayload.getCostName() + "-" + pmsWbsActCostPayload.getCostEstimate());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("\u6210\u672c\u8981\u7d20-\u6210\u672c\u4f30\u8ba1");
            builder.append("\n");
            for (PmsWbsActCostPayload pmsWbsActCostPayload : updates) {
                PmsWbsActCostVO pmsWbsActCostVO;
                Optional<PmsWbsActCostVO> firstCost = pmsWbsActCostVOS.stream().filter(actCost -> actCost.getId().equals(up.getId())).findFirst();
                if (!firstCost.isPresent() || (pmsWbsActCostVO = firstCost.get()).getCostName().equals(pmsWbsActCostPayload.getCostName()) && pmsWbsActCostVO.getCostEstimate().equals(pmsWbsActCostPayload.getCostEstimate())) continue;
                String str = pmsWbsActCostVO.getCostName() + "-" + pmsWbsActCostVO.getCostEstimate() + "\u66f4\u65b0\u4e3a" + pmsWbsActCostPayload.getCostName() + "-" + pmsWbsActCostPayload.getCostEstimate();
                builder.append(str);
                builder.append("\n");
            }
        }
        logPayload.setLogContent(builder.toString());
    }

    void operActPayLog(List<ComLogPayload> logPayloads, PmsProjectWbsPayload wbsPayload, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        Optional<ComLogPayload> first = logPayloads.stream().filter(log -> log.getObjectId().equals("" + wbsPayload.getId())).findFirst();
        StringBuilder builder = new StringBuilder();
        ComLogPayload logPayload = new ComLogPayload();
        if (first.isPresent()) {
            logPayload = first.get();
            builder.append(logPayload.getLogContent());
        } else {
            logPayload.setObjectId("" + wbsPayload.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setExtString2(wbsPayload.getWbsType());
            logPayload.setExtString3("UPDATE");
            logPayloads.add(logPayload);
        }
        builder.append("\n");
        builder.append("\u4ea4\u4ed8\u7269:");
        builder.append("\n");
        List<Object> dels = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)wbsPayload.getDelActPayIds())) {
            dels = pmsWbsActPayVOS.stream().filter(wbsVO -> wbsPayload.getDelActPayIds().contains(wbsVO.getId())).map(PmsWbsActPayVO::getPayName).collect(Collectors.toList());
        }
        if (dels.size() > 0) {
            builder.append("\u5220\u9664");
            for (int i = 0; i < dels.size(); ++i) {
                if (i == 0) {
                    builder.append("\u3010" + (String)dels.get(i) + "\u3011");
                    continue;
                }
                builder.append(",\u3010" + (String)dels.get(i) + "\u3011");
            }
        }
        List actPayPayloads = wbsPayload.getActPayPayloads();
        List<Object> adds = new ArrayList();
        List<Object> updates = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)actPayPayloads)) {
            adds = actPayPayloads.stream().filter(actPay -> actPay.getId() == null).collect(Collectors.toList());
            updates = actPayPayloads.stream().filter(actPay -> actPay.getId() != null).collect(Collectors.toList());
        }
        if (!ObjectUtils.isEmpty(adds)) {
            builder.append("\u4ea4\u4ed8\u7269\u540d\u79f0-\u4ea4\u4ed8\u7269\u7c7b\u578b \u521b\u5efa\u4e3a");
            builder.append("\n");
            for (PmsWbsActPayPayload pmsWbsActPayPayload : adds) {
                builder.append(pmsWbsActPayPayload.getPayName() + "-" + pmsWbsActPayPayload.getPayTypeName());
                builder.append("\n");
            }
        }
        if (!ObjectUtils.isEmpty(updates)) {
            builder.append("\u4ea4\u4ed8\u7269\u540d\u79f0-\u4ea4\u4ed8\u7269\u7c7b\u578b");
            builder.append("\n");
            for (PmsWbsActPayPayload pmsWbsActPayPayload : updates) {
                PmsWbsActPayVO pmsWbsActPayVO;
                Optional<PmsWbsActPayVO> firstPay = pmsWbsActPayVOS.stream().filter(actPay -> actPay.getId().equals(up.getId())).findFirst();
                if (!firstPay.isPresent() || (pmsWbsActPayVO = firstPay.get()).getPayName().equals(pmsWbsActPayPayload.getPayName()) && pmsWbsActPayVO.getPayTypeName().equals(pmsWbsActPayPayload.getPayTypeName())) continue;
                String str = pmsWbsActPayVO.getPayName() + "-" + pmsWbsActPayVO.getPayTypeName() + "\u66f4\u65b0\u4e3a" + pmsWbsActPayPayload.getPayName() + "-" + pmsWbsActPayPayload.getPayTypeName();
                builder.append(str);
                builder.append("\n");
            }
        }
        logPayload.setLogContent(builder.toString());
    }

    void createWbsAddLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsPayload> wbsPayloads) {
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                String fieldsCreateLog = this.changeFieldUtil.getFieldsCreateLog(wbsPayload, null);
                ComLogPayload logPayload = new ComLogPayload();
                logPayload.setObjectId("" + wbsPayload.getId());
                logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
                logPayload.setExtString2(wbsPayload.getWbsType());
                logPayload.setExtString3("CREATE");
                logPayload.setLogContent(fieldsCreateLog);
                logPayloads.add(logPayload);
            });
        }
    }

    List<Long> createWbsUpdateLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> wbsVOS, List<PmsProjectWbsPayload> wbsPayloads) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (!ObjectUtils.isEmpty(wbsPayloads)) {
            wbsPayloads.forEach(wbsPayload -> {
                Optional<PmsProjectWbsVO> first;
                ids.add(wbsPayload.getId());
                if (!ObjectUtils.isEmpty((Object)wbsVOS) && (first = wbsVOS.stream().filter(wbsVO -> wbsVO.getId().equals(wbsPayload.getId())).findFirst()).isPresent()) {
                    PmsProjectWbsVO pmsProjectWbsVO = first.get();
                    PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                    this.transferData(pmsProjectWbsPayload);
                    String fieldsUpdateLog = this.changeFieldUtil.getFieldsUpdateLog(wbsPayload, pmsProjectWbsPayload);
                    if (org.springframework.util.StringUtils.hasText((String)fieldsUpdateLog)) {
                        ComLogPayload logPayload = new ComLogPayload();
                        logPayload.setObjectId("" + wbsPayload.getId());
                        logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
                        logPayload.setExtString2(wbsPayload.getWbsType());
                        logPayload.setExtString3("UPDATE");
                        logPayload.setLogContent(fieldsUpdateLog);
                        logPayloads.add(logPayload);
                    }
                }
            });
        }
        return ids;
    }

    void createWbsDelLog(List<ComLogPayload> logPayloads, List<PmsProjectWbsVO> collect) {
        collect.forEach(wbsVO -> {
            ComLogPayload logPayload = new ComLogPayload();
            logPayload.setObjectId("" + wbsVO.getId());
            logPayload.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logPayload.setLogContent("\u8282\u70b9\u3010" + wbsVO.getWbsName() + "\u3011\u88ab\u5220\u9664");
            logPayload.setExtString2(wbsVO.getWbsType());
            logPayload.setExtString3("DEL");
            logPayloads.add(logPayload);
        });
    }

    @Transactional
    public List<PmsProjectWbsVO> queryList(PmsProjectWbsQuery query) {
        List taskVOS;
        if (ObjectUtils.isEmpty((Object)query.getProjectId())) {
            throw TwException.error("", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (null == query.getVersionNo()) {
            query.setVersionNo(Integer.valueOf(0));
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListDynamic(query);
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> this.transferData((PmsProjectWbsVO)pmsProjectWbsVO, null));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        this.countProgressAndStatus(pmsProjectWbsVOS);
        List actIds = pmsProjectWbsVOS.stream().filter(v -> ProjectWbsTypeEnum.ACT.getCode().equals(v.getWbsType())).map(v -> v.getId()).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(actIds) && !ObjectUtils.isEmpty((Object)(taskVOS = this.getPmsWbsTaskService().findByWbsIds(actIds)))) {
            List hasTask = taskVOS.stream().map(v -> v.getWbsId()).collect(Collectors.toList());
            pmsProjectWbsVOS.stream().filter(v -> ProjectWbsTypeEnum.ACT.getCode().equals(v.getWbsType()) && hasTask.contains(v.getId())).forEach(v -> v.setHasTaskFlag(Boolean.valueOf(true)));
        }
        if (!CollectionUtils.isEmpty(pmsProjectWbsVOS)) {
            List idList = pmsProjectWbsVOS.stream().map(v -> v.getId()).collect(Collectors.toList());
            PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
            pmsProjectWbsResourceQuery.setWbsIdList(idList);
            List resourceList = this.pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
            Map<Object, Object> resourceMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)resourceList)) {
                resourceMap = resourceList.stream().collect(Collectors.groupingBy(PmsProjectWbsResourceVO::getWbsId));
            }
            PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
            pmsProjectWbsRelyQuery.setWbsIdList(idList);
            List pmsProjectWbsRelyVOS = this.pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
            Map<Object, Object> wbsRelyMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)pmsProjectWbsRelyVOS)) {
                wbsRelyMap = pmsProjectWbsRelyVOS.stream().collect(Collectors.groupingBy(PmsProjectWbsRelyVO::getWbsId));
            }
            for (PmsProjectWbsVO pmsProjectWbsVO2 : pmsProjectWbsVOS) {
                if (resourceMap.containsKey(pmsProjectWbsVO2.getId())) {
                    pmsProjectWbsVO2.setPmsProjectWbsResourceVOList((List)resourceMap.get(pmsProjectWbsVO2.getId()));
                }
                if (!wbsRelyMap.containsKey(pmsProjectWbsVO2.getId())) continue;
                pmsProjectWbsVO2.setPmsProjectWbsRelyVOList((List)wbsRelyMap.get(pmsProjectWbsVO2.getId()));
            }
        }
        return pmsProjectWbsVOS;
    }

    public List<PmsProjectWbsVO> queryListSimple(PmsProjectWbsQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getProjectId())) {
            throw TwException.error("", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(query.getProjectId());
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error("", "\u5173\u8054\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (null == query.getVersionNo()) {
            query.setVersionNo(Integer.valueOf(0));
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListDynamic(query);
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> this.transferData((PmsProjectWbsVO)pmsProjectWbsVO, null));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        this.addPlanData(pmsProjectVO.getContractId(), pmsProjectWbsVOS);
        this.transferDataList(pmsProjectWbsVOS, null);
        return pmsProjectWbsVOS;
    }

    void addPlanData(Long contractId, List<PmsProjectWbsVO> activityVOS) {
        if (!ObjectUtils.isEmpty((Object)contractId)) {
            List planVOList = this.conReceivablePlanService.queryBySaleConId(contractId);
            if (!ObjectUtils.isEmpty((Object)planVOList)) {
                planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
            }
            if (!ObjectUtils.isEmpty((Object)planVOList)) {
                Map planInfo = planVOList.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
                activityVOS.forEach(v -> {
                    ConReceivablePlanVO planVO;
                    if (!ObjectUtils.isEmpty((Object)v.getReceivePlanId()) && !ObjectUtils.isEmpty((Object)(planVO = (ConReceivablePlanVO)planInfo.get(v.getReceivePlanId())))) {
                        v.setReceivePlanDesc(planVO.getReceStage());
                        v.setReceRatio(planVO.getReceRatio());
                        v.setReceAmt(planVO.getReceAmt());
                        v.setReceStatus(planVO.getReceStatus());
                        v.setExpectReceDate(planVO.getExpectReceDate());
                        if (v.getExpectReceDate() != null && null != v.getStartDate() && null != v.getEndDate() && v.getExpectReceDate().isAfter(v.getStartDate()) && v.getExpectReceDate().isBefore(v.getEndDate())) {
                            v.setExpectReceDateFlag(1);
                        } else {
                            v.setExpectReceDateFlag(0);
                        }
                    }
                });
            }
        }
    }

    private void updateMsWbsStatusByWbsAccept(PmsProjectWbsVO pmsProjectWbsVO) {
    }

    public List<PmsProjectWbsVO> queryListByIds(List<Long> keys) {
        return this.pmsProjectWbsDAO.queryListByIds(keys);
    }

    @Transactional
    public PmsProjectWbsVO queryByKey(Long key) {
        PmsProjectWbsVO pmsProjectWbsVO = this.pmsProjectWbsDAO.queryByKey(key);
        this.transferData(pmsProjectWbsVO, null);
        PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
        pmsProjectWbsResourceQuery.setWbsId(key);
        List resourceVOList = this.pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
        pmsProjectWbsVO.setPmsProjectWbsResourceVOList(resourceVOList);
        PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
        pmsProjectWbsRelyQuery.setWbsId(key);
        List pmsProjectWbsRelyVOS = this.pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
        pmsProjectWbsVO.setPmsProjectWbsRelyVOList(pmsProjectWbsRelyVOS);
        if (org.springframework.util.StringUtils.hasText((String)pmsProjectWbsVO.getWbsType()) && pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
            this.updateMsWbsStatusByWbsAccept(pmsProjectWbsVO);
        }
        return pmsProjectWbsVO;
    }

    void operDurationDay(PmsProjectWbsVO pmsProjectWbsVO) {
        if (pmsProjectWbsVO.getPreStartDate() != null && pmsProjectWbsVO.getPreEndDate() != null) {
            PmsProjectCalendarPayload payload = new PmsProjectCalendarPayload();
            payload.setSourceId(pmsProjectWbsVO.getId());
            payload.setSourceType(ProjectWbsTypeEnum.WBS.getCode());
            payload.setStartDate(pmsProjectWbsVO.getPreStartDate());
            payload.setEndDate(pmsProjectWbsVO.getPreEndDate());
            PmsProjectCalendarVO bySource = this.calendarService.findBySource(payload);
            pmsProjectWbsVO.setPreDurationDay(BigDecimal.valueOf(bySource.getDurationDays().intValue()));
        }
    }

    void transferData(PmsProjectWbsVO vo, Map<Long, String> planInfo) {
        vo.setCostTypeName(this.cacheUtil.transferSystemSelection("PMS:WBS:COST:TYPE", vo.getCostType()));
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        vo.setManagerUserName(this.cacheUtil.getUserName(vo.getManagerUserId()));
        if (vo.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
            vo.setWbsStatusName(this.cacheUtil.transferSystemSelection("PMS:WBS:MS:STATUS", vo.getWbsStatus()));
        } else {
            vo.setWbsStatusName(this.cacheUtil.transferSystemSelection("PMS:PROJECT:WBS:STATUS", vo.getWbsStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)vo.getAllocateStatus())) {
            vo.setAllocateStatusDesc(this.cacheUtil.transferSystemSelection("PMS:ACTIVITY:ALLOCATESTATUS", vo.getAllocateStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)vo.getReceStatus())) {
            vo.setReceStatusDesc(this.cacheUtil.transferSystemSelection("salecon:payment_status", vo.getReceStatus()));
        }
        if (!ObjectUtils.isEmpty(planInfo) && !ObjectUtils.isEmpty((Object)vo.getReceivePlanId())) {
            vo.setReceivePlanDesc(planInfo.get(vo.getReceivePlanId()));
        }
    }

    void transferDataList(List<PmsProjectWbsVO> list, Map<Long, String> planInfo) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(x -> this.transferData((PmsProjectWbsVO)x, planInfo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            Long projectId;
            List<Object> list = this.pmsProjectWbsDAO.queryByKeys(keys);
            for (PmsProjectWbsVO wbsVO : list) {
                if (!ProjectWbsTypeEnum.MS.getCode().equals(wbsVO.getWbsType()) || !ProjectWbsStatusEnum.FINISHED.getCode().equals(wbsVO.getWbsStatus())) continue;
                throw TwException.error("", wbsVO.getWbsName() + "\u72b6\u6001\u5df2\u8fbe\u6210\uff0c\u4e0d\u53ef\u88ab\u5220\u9664");
            }
            List<Long> effIds = list.stream().filter(x -> null != x.getEffRelateId()).map(x -> x.getEffRelateId()).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(effIds)) {
                this.pmsProjectWbsDAO.delByEffIds(effIds);
            }
            this.budgetDetailService.deleteSoftByWbsIds(keys);
            this.getPmsWbsTaskService().deleteSoftByWbsIds(keys);
            this.pmsProjectWbsDAO.deleteSoft(keys);
            this.pmsProjectWbsRelyDAO.deleteSoftByWbsIds(keys);
            this.pmsWbsActCostDAO.deleteSoftByWbsIds(keys);
            this.pmsWbsActPayDAO.deleteSoftByWbsIds(keys);
            this.pmsProjectWbsResourceDao.delByWbsIds(keys);
            this.pmsProjectWbsAcceptDao.delByWbsId(keys);
            List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = this.pmsProjectWbsRelyDAO.queryByWbsIds(keys);
            if (!ObjectUtils.isEmpty(pmsProjectWbsRelyVOS)) {
                projectId = list.get(0).getProjectId();
                this.updateSchedulingStatus(projectId);
            }
            projectId = list.get(0).getProjectId();
            List parentWbsCodes = list.stream().filter(v -> v.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) || v.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode())).map(v -> v.getParentWbsCode()).collect(Collectors.toList());
            for (String parentWbsCode : parentWbsCodes) {
                list = this.pmsProjectWbsDAO.queryByParentWbsCode(projectId, parentWbsCode);
                list = list.stream().filter(wbsPayload -> wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) || wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode())).collect(Collectors.toList());
                BigDecimal weights = list.stream().filter(v -> 1 == v.getManualSettingWeight() && !keys.contains(v.getId())).map(PmsProjectWbsVO::getWbsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                list = list.stream().filter(v -> 0 == v.getManualSettingWeight() && !keys.contains(v.getId())).collect(Collectors.toList());
                this.updateWbsWeight(list, weights);
            }
        }
    }

    public List<ComLogVO> queryLogList(PmsProjectWbsLogQuery query) {
        if (query.getProjectId() != null && query.getVersionNo() != null || query.getWbsId() != null) {
            ComLogQuery logQuery = new ComLogQuery();
            logQuery.setLogType(ComLogTypeEnum.pms_project_wbs.getCode());
            logQuery.setLogContent(query.getLogContent());
            if (query.getProjectId() != null && query.getVersionNo() != null) {
                String vid = query.getProjectId() + "-" + query.getVersionNo();
                logQuery.setExtString1(vid);
            } else {
                logQuery.setObjectId("" + query.getWbsId());
            }
            if (org.springframework.util.StringUtils.hasText((String)query.getOperType())) {
                logQuery.setExtString3(query.getOperType());
            }
            if (org.springframework.util.StringUtils.hasText((String)query.getWbsType())) {
                logQuery.setExtString2(query.getWbsType());
            }
            return this.logService.queryList(logQuery);
        }
        throw TwException.error("", "\u67e5\u8be2\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectWbsSnapshotVO insertSnapshot(PmsProjectWbsSnapshotPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error("", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.querySimpleByProjectId(payload.getProjectId());
        if (ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
            throw TwException.error("", "\u57fa\u7ebf\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        String originalContent = JSONObject.toJSONString(pmsProjectWbsVOS);
        payload.setSnapContent(originalContent);
        PmsProjectWbsSnapshotVO insert = this.planSnapshotService.insert(payload);
        return insert;
    }

    public List<PmsProjectWbsSnapshotVO> querySnapshotList(PmsProjectWbsSnapshotQuery query) {
        List pmsProjectWbsSnapshotVOS = this.planSnapshotService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty((Object)pmsProjectWbsSnapshotVOS)) {
            pmsProjectWbsSnapshotVOS.forEach(snapshotVO -> {
                List pmsProjectPlanVOS = (List)JSON.parseObject((String)snapshotVO.getSnapContent(), List.class);
                snapshotVO.setProjectWbsSimpleVOS(pmsProjectPlanVOS);
            });
        }
        return pmsProjectWbsSnapshotVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftSnapshot(List<Long> snapshotKeys) {
        this.planSnapshotService.deleteSoft(snapshotKeys);
    }

    public List<PmsProjectWbsVO> queryStakeholdersList(PmsProjectWbsQuery query) {
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListDynamic(query);
        return pmsProjectWbsVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteManagerUserIds(Long projectId, List<Long> managerUserIds) {
        this.pmsProjectWbsDAO.upadateManagerUserId(projectId, managerUserIds, null);
    }

    public void updateWbsProgress(Long wbsId, BigDecimal wbsProgress, String wbsStatus) {
        this.pmsProjectWbsDAO.updateWbsProgress(wbsId, wbsProgress, wbsStatus);
        PmsProjectWbsVO vo = this.pmsProjectWbsDAO.queryByKey(wbsId);
        this.updateParentWbsProgress(vo.getProjectId(), vo.getParentWbsCode());
    }

    public BigDecimal getProjectProgress(Long projectId) {
        List<PmsProjectWbsVO> list = this.pmsProjectWbsDAO.queryParentWbsCodeIsNull(projectId);
        list.forEach(pmsProjectWbsVO -> {
            Object wbsProgress;
            Map<String, Object> info = progressAndStatusCache.get(pmsProjectWbsVO.getId());
            if (!ObjectUtils.isEmpty(info) && !ObjectUtils.isEmpty((Object)(wbsProgress = info.get("wbsProgress")))) {
                pmsProjectWbsVO.setWbsProgress((BigDecimal)wbsProgress);
            }
        });
        return this.countWbsProgress(list);
    }

    public void updateParentWbsProgress(Long projectId, String parentWbsCode) {
        if (!ObjectUtils.isEmpty((Object)parentWbsCode)) {
            List<PmsProjectWbsVO> list = this.getSetWbs(projectId, Arrays.asList(parentWbsCode));
            BigDecimal wbsProgress = this.countWbsProgress(list);
            PmsProjectWbsVO wbsVO = this.pmsProjectWbsDAO.queryByProjectAndWbs(projectId, parentWbsCode);
            if (!ObjectUtils.isEmpty((Object)wbsVO)) {
                this.pmsProjectWbsDAO.updateWbsProgress(wbsVO.getId(), wbsProgress);
                this.updateParentWbsProgress(projectId, wbsVO.getParentWbsCode());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void autoScheduling(PmsProjectWbsSchedulingPayload payload) {
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryByProjectIdAndVersion(payload.getProjectId(), payload.getVersionNo());
        List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = this.pmsProjectWbsRelyDAO.queryByProjectIdAndVersionNo(payload.getProjectId(), payload.getVersionNo());
        this.pmsProjectWbsDAO.updateKeyNodeAndVersionNo(payload.getProjectId(), payload.getVersionNo());
        AutoScheduling autoScheduling = new AutoScheduling(pmsProjectWbsVOS, pmsProjectWbsRelyVOS, payload.getStartDate(), this.calendarService, payload.getProjectId());
        List<PmsProjectWbsVO> newVos = autoScheduling.startScheduling();
        List<PmsProjectWbsDO> pmsProjectWbsDOS = PmsProjectWbsConvert.INSTANCE.toDos(newVos);
        this.pmsProjectWbsDAO.saveAll(pmsProjectWbsDOS);
    }

    public void updateSchedulingStatus(Long projectId) {
        this.pmsProjectWbsDAO.updateScheduling(projectId);
    }

    @Transactional
    public List<PmsProjectWbsVO> listMilestone(PmsProjectWbsQuery query) {
        List<PmsProjectWbsVO> pmsProjectWbsVOS;
        if (ObjectUtils.isEmpty((Object)query.getProjectId())) {
            throw TwException.error("500", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!org.springframework.util.StringUtils.hasText((String)query.getWbsType())) {
            query.setWbsType(ProjectWbsTypeEnum.MS.getCode());
        }
        if (ObjectUtils.isEmpty((Object)query.getVersionNo())) {
            query.setVersionNo(Integer.valueOf(0));
        }
        if (CollectionUtils.isEmpty(pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListDynamic(query))) {
            return pmsProjectWbsVOS;
        }
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> this.transferData((PmsProjectWbsVO)pmsProjectWbsVO, null));
        List wbsIds = pmsProjectWbsVOS.stream().map(x -> x.getId()).collect(Collectors.toList());
        PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
        pmsProjectWbsAcceptQuery.setWbsIdList(wbsIds);
        List list = this.pmsProjectWbsAcceptService.getList(pmsProjectWbsAcceptQuery);
        Map<Long, Long> collectMap = list.stream().collect(Collectors.toMap(PmsProjectWbsAcceptVO::getWbsId, PmsProjectWbsAcceptVO::getProjectId, (t1, t2) -> t1));
        pmsProjectWbsVOS.forEach(x -> x.setHasAcceptFlag(Boolean.valueOf(collectMap.get(x.getId()) != null)));
        pmsProjectWbsVOS.forEach(x -> {
            PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
            pmsProjectWbsResourceQuery.setWbsId(x.getId());
            List list1 = this.pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
            x.setPmsProjectWbsResourceVOList(list1);
        });
        pmsProjectWbsVOS.stream().filter(pmsProjectWbsVO -> org.springframework.util.StringUtils.hasText((String)pmsProjectWbsVO.getWbsType()) && pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode()) && org.springframework.util.StringUtils.hasText((String)pmsProjectWbsVO.getState()) && "1".equals(pmsProjectWbsVO.getState())).forEach(pmsProjectWbsVO -> this.updateMsWbsStatusByWbsAccept((PmsProjectWbsVO)pmsProjectWbsVO));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        return pmsProjectWbsVOS;
    }

    public List<PmsProjectWbsVO> listStage(PmsProjectWbsQuery query) {
        List<PmsProjectWbsVO> pmsProjectWbsVOS;
        Long projectId = query.getProjectId();
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error("500", "\u5f52\u5c5e\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(projectId);
        Assert.notNull((Object)pmsProjectVO, (String)"\u9879\u76ee\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        if (!org.springframework.util.StringUtils.hasText((String)query.getWbsType())) {
            query.setWbsType(ProjectWbsTypeEnum.ACTG.getCode());
        }
        if (ObjectUtils.isEmpty((Object)query.getVersionNo())) {
            query.setVersionNo(Integer.valueOf(0));
        }
        if (CollectionUtils.isEmpty(pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListDynamic(query))) {
            return pmsProjectWbsVOS;
        }
        this.setActgPreDateByAct(pmsProjectWbsVOS, true);
        Long contractId = pmsProjectVO.getContractId();
        Map<Long, String> conReceivablePlanMap = this.listConReceivablePlanVO(contractId);
        pmsProjectWbsVOS.forEach(pmsProjectWbsVO -> this.transferData((PmsProjectWbsVO)pmsProjectWbsVO, conReceivablePlanMap));
        pmsProjectWbsVOS.sort(Comparator.comparing(PmsProjectWbsVO::getWbsCode));
        return pmsProjectWbsVOS;
    }

    public void setActgPreDateByAct(List<PmsProjectWbsVO> pmsProjectWbsVOS, boolean calculateCostsFlag) {
    }

    private BigDecimal getResCostSum(PmsProjectWbsVO wbs, Long versionId) {
        if (wbs == null) {
            throw new IllegalArgumentException("wbs cannot be null");
        }
        BigDecimal preDurationDay = wbs.getPreDurationDay() == null ? BigDecimal.ZERO : wbs.getPreDurationDay();
        PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
        Long wbsId = wbs.getId();
        pmsProjectWbsResourceQuery.setWbsId(wbsId);
        pmsProjectWbsResourceQuery.setVersionId(versionId);
        List wbsResourceVOS = this.pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
        BigDecimal resCostSum = this.calculateResourceCost(wbsResourceVOS, preDurationDay);
        return resCostSum;
    }

    private BigDecimal calculateResourceCost(List<PmsProjectWbsResourceVO> wbsResourceVOS, BigDecimal preDurationDay) {
        BigDecimal resCostSum = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(wbsResourceVOS)) {
            for (PmsProjectWbsResourceVO wbsResourceVO : wbsResourceVOS) {
                Long relatePartiesId = wbsResourceVO.getRelatePartiesId();
                ProRelatedPartiesVO proRelatedPartiesVO = this.proRelatedPartiesService.get(relatePartiesId);
                if (null == proRelatedPartiesVO) continue;
                BigDecimal eqvaRatio = proRelatedPartiesVO.getEqvaRatio() == null ? BigDecimal.ZERO : proRelatedPartiesVO.getEqvaRatio();
                BigDecimal input = wbsResourceVO.getInput() == null ? BigDecimal.ZERO : wbsResourceVO.getInput();
                BigDecimal resCost = preDurationDay.multiply(input).multiply(eqvaRatio).divide(new BigDecimal("100")).setScale(2, 4);
                resCostSum = resCostSum.add(resCost);
            }
        }
        return resCostSum;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<PmsProjectWbsVO> submitVer(List<Long> wbsId) {
        this.pmsProjectWbsDAO.submit(wbsId);
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.changeVersion(wbsId);
        if (CollUtil.isNotEmpty(pmsProjectWbsVOS)) {
            this.createNextVersion(pmsProjectWbsVOS);
        }
        return pmsProjectWbsVOS;
    }

    @Transactional
    public List<PmsProjectWbsVO> changeVersion2(List<Long> wbsId) {
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListByIds(wbsId);
        if (CollUtil.isNotEmpty(pmsProjectWbsVOS)) {
            PmsProjectWbsVO pmsProjectWbsVO1 = pmsProjectWbsVOS.get(0);
            Long versionId = pmsProjectWbsVO1.getVersionId();
            if (null != versionId) {
                PmsWbsVersionPayload pmsWbsVersionPayload = new PmsWbsVersionPayload();
                pmsWbsVersionPayload.setId(versionId);
                pmsWbsVersionPayload.setState(Integer.valueOf(3));
                this.pmsWbsVersionService.updateDynamic(pmsWbsVersionPayload);
            }
            for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
                Long res = this.pmsProjectWbsDAO.queryBykeyAndVersion(pmsProjectWbsVO.getProjectId(), pmsProjectWbsVO.getWbsCode(), 0);
                if (null == res) {
                    PmsProjectWbsDO pmsProjectWbsDO = (PmsProjectWbsDO)PmsProjectWbsConvert.INSTANCE.toEntity(pmsProjectWbsVO);
                    pmsProjectWbsDO.setId(null);
                    pmsProjectWbsDO.setVersionNo(0);
                    pmsProjectWbsDO.setEffRelateId(res);
                    pmsProjectWbsDO.setVersionId(0L);
                    PmsProjectWbsDO wbsSaveV0DO = this.pmsProjectWbsDAO.save(pmsProjectWbsDO);
                    PmsProjectWbsPayload payloadSelf = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                    payloadSelf.setEffRelateId(wbsSaveV0DO.getId());
                    this.pmsProjectWbsDAO.updateByKeyNoVersion(payloadSelf);
                    pmsProjectWbsVO.setEffRelateId(wbsSaveV0DO.getId());
                    continue;
                }
                PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                pmsProjectWbsPayload.setId(res);
                this.pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayload);
            }
        }
        return pmsProjectWbsVOS;
    }

    @Transactional
    public List<PmsProjectWbsVO> changeVersion(List<Long> wbsId) {
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListByIds(wbsId);
        if (CollUtil.isNotEmpty(pmsProjectWbsVOS)) {
            PmsProjectWbsVO pmsProjectWbsVO1 = pmsProjectWbsVOS.get(0);
            Long versionId = pmsProjectWbsVO1.getVersionId();
            if (null != versionId) {
                PmsWbsVersionPayload pmsWbsVersionPayload = new PmsWbsVersionPayload();
                pmsWbsVersionPayload.setId(versionId);
                pmsWbsVersionPayload.setState(Integer.valueOf(3));
                this.pmsWbsVersionService.updateDynamic(pmsWbsVersionPayload);
            }
            if (pmsProjectWbsVO1.getVersionNo() == 0) {
                PmsWbsVersionVO versionVO = this.createWbsVersion(pmsProjectWbsVO1, 3);
                List webIdList = pmsProjectWbsVOS.stream().map(p -> p.getId()).collect(Collectors.toList());
                PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
                pmsProjectWbsResourceQuery.setWbsIdList(webIdList);
                List pmsProjectWbsResourceVOList = this.pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
                Map<Object, Object> resourceMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)pmsProjectWbsResourceVOList)) {
                    resourceMap = pmsProjectWbsResourceVOList.stream().collect(Collectors.groupingBy(PmsProjectWbsResourceVO::getWbsId));
                }
                PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
                pmsProjectWbsAcceptQuery.setWbsIdList(webIdList);
                List pmsProjectWbsAcceptVOList = this.pmsProjectWbsAcceptService.getList(pmsProjectWbsAcceptQuery);
                Map<Object, Object> acceptMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)pmsProjectWbsAcceptVOList)) {
                    acceptMap = pmsProjectWbsAcceptVOList.stream().collect(Collectors.groupingBy(PmsProjectWbsAcceptVO::getWbsId));
                }
                PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
                pmsProjectWbsRelyQuery.setWbsIdList(webIdList);
                List pmsProjectWbsRelyVOS = this.pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
                Map<Object, Object> relyMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)pmsProjectWbsRelyVOS)) {
                    relyMap = pmsProjectWbsRelyVOS.stream().collect(Collectors.groupingBy(PmsProjectWbsRelyVO::getWbsId));
                }
                ArrayList<PmsProjectWbsResourceDO> pmsProjectWbsResourceDOList = new ArrayList<PmsProjectWbsResourceDO>();
                ArrayList<PmsProjectWbsRelyDO> pmsProjectWbsRelyDOS = new ArrayList<PmsProjectWbsRelyDO>();
                ArrayList<BaseModel> pmsProjectWbsAcceptDOList = new ArrayList<BaseModel>();
                for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
                    BaseModel v1entity;
                    PmsProjectWbsDO pmsProjectWbsDO = (PmsProjectWbsDO)PmsProjectWbsConvert.INSTANCE.toEntity(pmsProjectWbsVO);
                    pmsProjectWbsDO.setId(null);
                    pmsProjectWbsDO.setVersionNo(versionVO.getVersionNo());
                    pmsProjectWbsDO.setEffRelateId(pmsProjectWbsVO.getId());
                    pmsProjectWbsDO.setVersionId(versionVO.getId());
                    PmsProjectWbsDO wbsSaveV1DO = this.pmsProjectWbsDAO.save(pmsProjectWbsDO);
                    pmsProjectWbsVO.setVersionNo(versionVO.getVersionNo());
                    pmsProjectWbsVO.setEffRelateId(pmsProjectWbsVO.getId());
                    if (resourceMap.containsKey(pmsProjectWbsVO.getId())) {
                        Iterator wbsResourceVOList = (List)resourceMap.get(pmsProjectWbsVO.getId());
                        Iterator iterator = wbsResourceVOList.iterator();
                        while (iterator.hasNext()) {
                            PmsProjectWbsResourceVO pmsProjectWbsResourceVO = (PmsProjectWbsResourceVO)iterator.next();
                            PmsProjectWbsResourceDO v1entity2 = (PmsProjectWbsResourceDO)((Object)PmsProjectWbsResourceConvert.INSTANCE.toEntity(pmsProjectWbsResourceVO));
                            v1entity2.setId(null);
                            v1entity2.setEffRelateId(pmsProjectWbsResourceVO.getId());
                            v1entity2.setVersionId(versionVO.getId());
                            v1entity2.setVersionNo(versionVO.getVersionNo());
                            v1entity2.setWbsId(wbsSaveV1DO.getId());
                            pmsProjectWbsResourceDOList.add(v1entity2);
                        }
                    }
                    if (acceptMap.containsKey(pmsProjectWbsVO.getId())) {
                        for (PmsProjectWbsAcceptVO pmsProjectWbsAcceptVO : (List)acceptMap.get(pmsProjectWbsVO.getId())) {
                            v1entity = (PmsProjectWbsAcceptDO)((Object)PmsProjectWbsAcceptConvert.INSTANCE.toEntity(pmsProjectWbsAcceptVO));
                            v1entity.setId(null);
                            v1entity.setEffRelateId(pmsProjectWbsAcceptVO.getId());
                            v1entity.setVersionId(versionVO.getId());
                            v1entity.setVersionNo(versionVO.getVersionNo());
                            v1entity.setWbsId(wbsSaveV1DO.getId());
                            pmsProjectWbsAcceptDOList.add(v1entity);
                        }
                    }
                    if (relyMap.containsKey(pmsProjectWbsVO.getId())) {
                        for (PmsProjectWbsRelyVO pmsProjectWbsRelyVO : (List)relyMap.get(pmsProjectWbsVO.getId())) {
                            v1entity = (PmsProjectWbsRelyDO)PmsProjectWbsRelyConvert.INSTANCE.toEntity(pmsProjectWbsRelyVO);
                            v1entity.setId(null);
                            v1entity.setEffRelateId(pmsProjectWbsRelyVO.getId());
                            v1entity.setVersionId(versionVO.getId());
                            v1entity.setVersionNo(versionVO.getVersionNo());
                            v1entity.setWbsId(wbsSaveV1DO.getId());
                            PmsProjectWbsVO wbsRelyIdVO = this.pmsProjectWbsDAO.queryByKey(v1entity.getWbsRelyId());
                            if (null != wbsRelyIdVO) {
                                Long relyWbsId = this.pmsProjectWbsDAO.queryBykeyAndVersion(wbsRelyIdVO.getProjectId(), wbsRelyIdVO.getWbsCode(), v1entity.getVersionNo());
                                if (null == relyWbsId) {
                                    relyWbsId = 0L;
                                }
                                v1entity.setWbsRelyId(relyWbsId);
                            }
                            pmsProjectWbsRelyDOS.add((PmsProjectWbsRelyDO)v1entity);
                        }
                    }
                    pmsProjectWbsVO.setId(wbsSaveV1DO.getId());
                }
                if (!CollectionUtils.isEmpty(pmsProjectWbsResourceDOList)) {
                    this.pmsProjectWbsResourceDao.save(pmsProjectWbsResourceDOList);
                }
                if (!CollectionUtils.isEmpty(pmsProjectWbsAcceptDOList)) {
                    this.pmsProjectWbsAcceptDao.save(pmsProjectWbsAcceptDOList);
                }
                if (!CollectionUtils.isEmpty(pmsProjectWbsRelyDOS)) {
                    this.pmsProjectWbsRelyDAO.saveAll(pmsProjectWbsRelyDOS);
                }
            } else {
                List webIdList = pmsProjectWbsVOS.stream().map(p -> p.getId()).collect(Collectors.toList());
                PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
                pmsProjectWbsResourceQuery.setWbsIdList(webIdList);
                List reesourceVOList = this.pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
                Map<Object, Object> resourceMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)reesourceVOList)) {
                    resourceMap = reesourceVOList.stream().collect(Collectors.groupingBy(PmsProjectWbsResourceVO::getWbsId));
                }
                PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
                pmsProjectWbsAcceptQuery.setWbsIdList(webIdList);
                List acceptVOList = this.pmsProjectWbsAcceptService.getList(pmsProjectWbsAcceptQuery);
                Map<Object, Object> acceptMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)acceptVOList)) {
                    acceptMap = acceptVOList.stream().collect(Collectors.groupingBy(PmsProjectWbsAcceptVO::getWbsId));
                }
                PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
                pmsProjectWbsRelyQuery.setWbsIdList(webIdList);
                List relyVOS = this.pmsProjectWbsRelyService.queryListDynamic(pmsProjectWbsRelyQuery);
                Map<Object, Object> relyMap = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)relyVOS)) {
                    relyMap = relyVOS.stream().collect(Collectors.groupingBy(PmsProjectWbsRelyVO::getWbsId));
                }
                for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
                    Long wbsV0Id;
                    BaseModel entity;
                    if (null == pmsProjectWbsVO.getEffRelateId()) {
                        PmsProjectWbsDO pmsProjectWbsDO = (PmsProjectWbsDO)PmsProjectWbsConvert.INSTANCE.toEntity(pmsProjectWbsVO);
                        pmsProjectWbsDO.setId(null);
                        pmsProjectWbsDO.setVersionNo(0);
                        pmsProjectWbsDO.setVersionId(0L);
                        PmsProjectWbsDO wbsSaveV0DO = this.pmsProjectWbsDAO.save(pmsProjectWbsDO);
                        PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                        pmsProjectWbsPayload.setEffRelateId(wbsSaveV0DO.getId());
                        this.pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayload);
                        pmsProjectWbsVO.setEffRelateId(wbsSaveV0DO.getId());
                    } else {
                        PmsProjectWbsPayload pmsProjectWbsPayload = PmsProjectWbsConvert.INSTANCE.toPayload(pmsProjectWbsVO);
                        pmsProjectWbsPayload.setId(pmsProjectWbsVO.getEffRelateId());
                        if (StringUtils.isNotBlank((CharSequence)pmsProjectWbsPayload.getWbsStatus()) && !pmsProjectWbsPayload.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode())) {
                            pmsProjectWbsPayload.setWbsStatus(null);
                        }
                        this.pmsProjectWbsDAO.updateByKeyNoVersion(pmsProjectWbsPayload);
                    }
                    if (resourceMap.containsKey(pmsProjectWbsVO.getId())) {
                        List pmsProjectWbsResourceVOList = (List)resourceMap.get(pmsProjectWbsVO.getId());
                        List<Long> resourceDelIds = pmsProjectWbsResourceVOList.stream().filter(x -> null != x.getEffRelateId()).map(x -> x.getEffRelateId()).collect(Collectors.toList());
                        this.pmsProjectWbsResourceDao.delByV0(resourceDelIds, pmsProjectWbsVO.getEffRelateId());
                        for (PmsProjectWbsResourceVO pmsProjectWbsResourceVO : pmsProjectWbsResourceVOList) {
                            if (null == pmsProjectWbsResourceVO.getEffRelateId()) {
                                entity = (PmsProjectWbsResourceDO)((Object)PmsProjectWbsResourceConvert.INSTANCE.toEntity(pmsProjectWbsResourceVO));
                                entity.setId(null);
                                entity.setVersionId(0L);
                                entity.setVersionNo(0);
                                wbsV0Id = this.pmsProjectWbsDAO.queryBykeyAndVersion(pmsProjectWbsResourceVO.getProjectId(), pmsProjectWbsResourceVO.getWbsCode(), 0);
                                entity.setWbsId(wbsV0Id);
                                PmsProjectWbsResourceDO V0save = (PmsProjectWbsResourceDO)((Object)this.pmsProjectWbsResourceRepo.save(entity));
                                PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload = PmsProjectWbsResourceConvert.INSTANCE.toPayload(pmsProjectWbsResourceVO);
                                pmsProjectWbsResourcePayload.setEffRelateId(V0save.getId());
                                this.pmsProjectWbsResourceDao.updateByKeyNoVersion(pmsProjectWbsResourcePayload);
                                continue;
                            }
                            PmsProjectWbsResourcePayload pmsProjectWbsResourcePayload = PmsProjectWbsResourceConvert.INSTANCE.toPayload(pmsProjectWbsResourceVO);
                            pmsProjectWbsResourcePayload.setId(pmsProjectWbsResourceVO.getEffRelateId());
                            pmsProjectWbsResourcePayload.setWbsId(null);
                            pmsProjectWbsResourcePayload.setWbsCode(null);
                            this.pmsProjectWbsResourceDao.updateByKeyNoVersion(pmsProjectWbsResourcePayload);
                        }
                    }
                    if (relyMap.containsKey(pmsProjectWbsVO.getId())) {
                        List pmsProjectWbsRelyVOS = (List)relyMap.get(pmsProjectWbsVO.getId());
                        List<Long> relyDelIds = pmsProjectWbsRelyVOS.stream().filter(x -> null != x.getEffRelateId()).map(x -> x.getEffRelateId()).collect(Collectors.toList());
                        this.pmsProjectWbsRelyDAO.delByV0(relyDelIds, pmsProjectWbsVO.getEffRelateId());
                        for (PmsProjectWbsRelyVO pmsProjectWbsRelyVO : pmsProjectWbsRelyVOS) {
                            if (null == pmsProjectWbsRelyVO.getEffRelateId()) {
                                entity = (PmsProjectWbsRelyDO)PmsProjectWbsRelyConvert.INSTANCE.toEntity(pmsProjectWbsRelyVO);
                                entity.setId(null);
                                entity.setVersionId(0L);
                                entity.setVersionNo(0);
                                wbsV0Id = this.pmsProjectWbsDAO.queryBykeyAndVersion(pmsProjectWbsRelyVO.getProjectId(), pmsProjectWbsRelyVO.getWbsCode(), 0);
                                entity.setWbsId(wbsV0Id);
                                PmsProjectWbsVO wbsRelyIdVO = this.pmsProjectWbsDAO.queryByKey(entity.getWbsRelyId());
                                if (null != wbsRelyIdVO) {
                                    Long relyWbsId = this.pmsProjectWbsDAO.queryBykeyAndVersion(wbsRelyIdVO.getProjectId(), wbsRelyIdVO.getWbsCode(), entity.getVersionNo());
                                    if (null == relyWbsId) {
                                        relyWbsId = 0L;
                                    }
                                    entity.setWbsRelyId(relyWbsId);
                                }
                                PmsProjectWbsRelyDO v0Id = this.pmsProjectWbsRelyDAO.save((PmsProjectWbsRelyDO)entity);
                                PmsProjectWbsRelyPayload pmsProjectWbsRelyPayload = PmsProjectWbsRelyConvert.INSTANCE.toPayload(pmsProjectWbsRelyVO);
                                pmsProjectWbsRelyPayload.setEffRelateId(v0Id.getId());
                                this.pmsProjectWbsRelyDAO.updateByKeyDynamic(pmsProjectWbsRelyPayload);
                                continue;
                            }
                            PmsProjectWbsRelyPayload pmsProjectWbsRelyPayload = PmsProjectWbsRelyConvert.INSTANCE.toPayload(pmsProjectWbsRelyVO);
                            pmsProjectWbsRelyPayload.setId(pmsProjectWbsRelyVO.getEffRelateId());
                            pmsProjectWbsRelyPayload.setWbsId(null);
                            if (null == pmsProjectWbsRelyPayload.getWbsRelyId()) continue;
                            PmsProjectWbsVO wbsRelyIdVO = this.pmsProjectWbsDAO.queryByKey(pmsProjectWbsRelyPayload.getWbsRelyId());
                            if (null != wbsRelyIdVO) {
                                Long relyWbsId = this.pmsProjectWbsDAO.queryBykeyAndVersion(wbsRelyIdVO.getProjectId(), wbsRelyIdVO.getWbsCode(), pmsProjectWbsRelyPayload.getVersionNo());
                                if (null == relyWbsId) {
                                    relyWbsId = 0L;
                                }
                                pmsProjectWbsRelyPayload.setWbsRelyId(relyWbsId);
                            }
                            pmsProjectWbsRelyPayload.setWbsCode(null);
                            this.pmsProjectWbsRelyDAO.updateByKeyDynamic(pmsProjectWbsRelyPayload);
                        }
                    }
                    if (!acceptMap.containsKey(pmsProjectWbsVO.getId())) continue;
                    List pmsProjectWbsAcceptVOList = (List)acceptMap.get(pmsProjectWbsVO.getId());
                    List<Long> acceptDelIds = pmsProjectWbsAcceptVOList.stream().filter(x -> null != x.getEffRelateId()).map(x -> x.getEffRelateId()).collect(Collectors.toList());
                    this.pmsProjectWbsAcceptDao.delByV0(acceptDelIds, pmsProjectWbsVO.getEffRelateId());
                    for (PmsProjectWbsAcceptVO pmsProjectWbsAcceptVO : pmsProjectWbsAcceptVOList) {
                        if (null == pmsProjectWbsAcceptVO.getEffRelateId()) {
                            entity = (PmsProjectWbsAcceptDO)((Object)PmsProjectWbsAcceptConvert.INSTANCE.toEntity(pmsProjectWbsAcceptVO));
                            entity.setId(null);
                            entity.setVersionId(0L);
                            entity.setVersionNo(0);
                            wbsV0Id = this.pmsProjectWbsDAO.queryBykeyAndVersion(pmsProjectWbsAcceptVO.getProjectId(), pmsProjectWbsAcceptVO.getWbsCode(), 0);
                            entity.setWbsId(wbsV0Id);
                            PmsProjectWbsAcceptDO v0save = (PmsProjectWbsAcceptDO)((Object)this.pmsProjectWbsAcceptRepo.save(entity));
                            PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload = PmsProjectWbsAcceptConvert.INSTANCE.toPayload(pmsProjectWbsAcceptVO);
                            pmsProjectWbsAcceptPayload.setEffRelateId(v0save.getId());
                            this.pmsProjectWbsAcceptDao.update(pmsProjectWbsAcceptPayload);
                            continue;
                        }
                        PmsProjectWbsAcceptPayload pmsProjectWbsAcceptPayload = PmsProjectWbsAcceptConvert.INSTANCE.toPayload(pmsProjectWbsAcceptVO);
                        pmsProjectWbsAcceptPayload.setId(pmsProjectWbsAcceptVO.getEffRelateId());
                        pmsProjectWbsAcceptPayload.setWbsCode(null);
                        pmsProjectWbsAcceptPayload.setWbsId(null);
                        this.pmsProjectWbsAcceptDao.update(pmsProjectWbsAcceptPayload);
                    }
                }
            }
        }
        return pmsProjectWbsVOS;
    }

    @Transactional
    public void createNextVersion(List<PmsProjectWbsVO> pmsProjectWbsVOS) {
        PmsProjectWbsVO pmsProjectWbsVO1 = pmsProjectWbsVOS.get(0);
        PmsWbsVersionVO wbsVersion = this.createWbsVersion(pmsProjectWbsVO1, 1);
        for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
            pmsProjectWbsVO.setVersionId(wbsVersion.getId());
            pmsProjectWbsVO.setVersionNo(wbsVersion.getVersionNo());
            PmsProjectWbsDO wbsByVersion = this.createWbsByVersion(pmsProjectWbsVO);
            this.createWbsRelyByVersion(pmsProjectWbsVO, wbsByVersion.getId());
            this.createWbsResourceByVersion(pmsProjectWbsVO, wbsByVersion.getId());
            this.createWbsAcceptByVersion(pmsProjectWbsVO, wbsByVersion.getId());
        }
    }

    private void createWbsRelyByVersion(PmsProjectWbsVO pmsProjectWbsVO, Long wbsId) {
        PmsProjectWbsRelyQuery pmsProjectWbsRelyQuery = new PmsProjectWbsRelyQuery();
        pmsProjectWbsRelyQuery.setWbsId(pmsProjectWbsVO.getId());
        List<PmsProjectWbsRelyVO> pmsProjectWbsRelyVOS = this.pmsProjectWbsRelyDAO.queryListDynamic(pmsProjectWbsRelyQuery);
        ArrayList<PmsProjectWbsRelyDO> pmsProjectWbsRelyDOS = new ArrayList<PmsProjectWbsRelyDO>();
        for (PmsProjectWbsRelyVO pmsProjectWbsRelyVO : pmsProjectWbsRelyVOS) {
            PmsProjectWbsRelyDO entity = (PmsProjectWbsRelyDO)PmsProjectWbsRelyConvert.INSTANCE.toEntity(pmsProjectWbsRelyVO);
            entity.setId(null);
            entity.setWbsId(wbsId);
            entity.setVersionId(pmsProjectWbsVO.getVersionId());
            entity.setVersionNo(pmsProjectWbsVO.getVersionNo());
            PmsProjectWbsVO wbsRelyIdVO = this.pmsProjectWbsDAO.queryByKey(entity.getWbsRelyId());
            if (null != wbsRelyIdVO) {
                Long relyWbsId = this.pmsProjectWbsDAO.queryBykeyAndVersion(wbsRelyIdVO.getProjectId(), wbsRelyIdVO.getWbsCode(), entity.getVersionNo());
                if (null == relyWbsId) {
                    relyWbsId = 0L;
                }
                entity.setWbsRelyId(relyWbsId);
            }
            pmsProjectWbsRelyDOS.add(entity);
        }
        this.pmsProjectWbsRelyDAO.saveAll(pmsProjectWbsRelyDOS);
    }

    private void createWbsAcceptByVersion(PmsProjectWbsVO pmsProjectWbsVO, Long wbsId) {
        PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
        pmsProjectWbsAcceptQuery.setWbsId(pmsProjectWbsVO.getId());
        List<PmsProjectWbsAcceptVO> pmsProjectWbsAcceptVOList = this.pmsProjectWbsAcceptDao.getList(pmsProjectWbsAcceptQuery);
        ArrayList<PmsProjectWbsAcceptDO> pmsProjectWbsAcceptDOList = new ArrayList<PmsProjectWbsAcceptDO>();
        for (PmsProjectWbsAcceptVO pmsProjectWbsAcceptVO : pmsProjectWbsAcceptVOList) {
            PmsProjectWbsAcceptDO entity = (PmsProjectWbsAcceptDO)((Object)PmsProjectWbsAcceptConvert.INSTANCE.toEntity(pmsProjectWbsAcceptVO));
            entity.setId(null);
            entity.setWbsId(wbsId);
            entity.setVersionId(pmsProjectWbsVO.getVersionId());
            entity.setVersionNo(pmsProjectWbsVO.getVersionNo());
            pmsProjectWbsAcceptDOList.add(entity);
        }
        this.pmsProjectWbsAcceptDao.save(pmsProjectWbsAcceptDOList);
    }

    @Transactional
    public List<PmsProjectWbsVO> submitVerPro(PmsProjectWbsSubmitDataPayload payload) {
        List wbsPayloadList = payload.getWbsPayloadList();
        if (!CollectionUtils.isEmpty((Collection)wbsPayloadList)) {
            List<Long> websIdList = wbsPayloadList.stream().map(p -> p.getId()).collect(Collectors.toList());
            this.pmsProjectWbsDAO.updateReceplanIdNull(websIdList);
            this.batchUpdate(wbsPayloadList);
        }
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.submitVer(payload.getWbsId());
        return pmsProjectWbsVOS;
    }

    @Transactional
    public void savePro(PmsProjectWbsSubmitDataPayload payload) {
        List wbsPayloadList = payload.getWbsPayloadList();
        this.batchUpdate(wbsPayloadList);
    }

    @Transactional
    public Long updateState(PmsProjectWbsPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)payload.getWbsStatus(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (payload.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode())) {
            payload.setState("2");
            PmsProjectWbsVO pmsProjectWbsVO = this.pmsProjectWbsDAO.queryByKey(payload.getId());
            if (pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode())) {
                if (pmsProjectWbsVO.getWbsStatus().equals(ProjectWbsStatusEnum.NOGIONG.getCode())) {
                    payload.setCancelShowFlag(Boolean.valueOf(true));
                }
            } else if (pmsProjectWbsVO.getWbsType().equals(ProjectWbsTypeEnum.ACTG.getCode()) && org.springframework.util.StringUtils.hasText((String)pmsProjectWbsVO.getAllocateStatus()) && (pmsProjectWbsVO.getAllocateStatus().equals(ProjWbsAllocateStateEnum.ING.getCode()) || pmsProjectWbsVO.getWbsStatus().equals(ProjWbsAllocateStateEnum.OK.getCode()))) {
                throw TwException.error("", "\u62e8\u4ed8\u4e2d\u548c\u62e8\u4ed8\u6210\u529f\u7684\u9636\u6bb5\uff0c\u4e0d\u53ef\u5220\u9664");
            }
        }
        Long res = this.pmsProjectWbsDAO.updateWbsStatus(payload.getId(), payload.getWbsStatus(), payload.getState(), payload.getCancelShowFlag());
        return res;
    }

    public void createWbsResourceByVersion(PmsProjectWbsVO pmsProjectWbsVO, Long wbsId) {
        PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
        pmsProjectWbsResourceQuery.setWbsId(pmsProjectWbsVO.getId());
        List<PmsProjectWbsResourceVO> pmsProjectWbsResourceVOList = this.pmsProjectWbsResourceDao.getList(pmsProjectWbsResourceQuery);
        ArrayList<PmsProjectWbsResourceDO> pmsProjectWbsResourceDOList = new ArrayList<PmsProjectWbsResourceDO>();
        for (PmsProjectWbsResourceVO pmsProjectWbsResourceVO : pmsProjectWbsResourceVOList) {
            PmsProjectWbsResourceDO entity = (PmsProjectWbsResourceDO)((Object)PmsProjectWbsResourceConvert.INSTANCE.toEntity(pmsProjectWbsResourceVO));
            entity.setId(null);
            entity.setWbsId(wbsId);
            entity.setVersionId(pmsProjectWbsVO.getVersionId());
            entity.setVersionNo(pmsProjectWbsVO.getVersionNo());
            pmsProjectWbsResourceDOList.add(entity);
        }
        this.pmsProjectWbsResourceDao.save(pmsProjectWbsResourceDOList);
    }

    public PmsProjectWbsDO createWbsByVersion(PmsProjectWbsVO pmsProjectWbsVO) {
        PmsProjectWbsDO entity = (PmsProjectWbsDO)PmsProjectWbsConvert.INSTANCE.toEntity(pmsProjectWbsVO);
        entity.setId(null);
        if (pmsProjectWbsVO.getState() == null || !pmsProjectWbsVO.getState().equals("2")) {
            entity.setState("1");
        }
        PmsProjectWbsDO save = this.pmsProjectWbsDAO.save(entity);
        return save;
    }

    public PmsWbsVersionVO createWbsVersion(PmsProjectWbsVO pmsProjectWbsVO, Integer state) {
        PmsWbsVersionPayload pmsWbsVersionPayload = new PmsWbsVersionPayload();
        pmsWbsVersionPayload.setProId(pmsProjectWbsVO.getProjectId());
        pmsWbsVersionPayload.setVersionNo(Integer.valueOf(pmsProjectWbsVO.getVersionNo() + 1));
        pmsWbsVersionPayload.setStepNum(Integer.valueOf(1));
        pmsWbsVersionPayload.setState(state);
        PmsWbsVersionVO insert = this.pmsWbsVersionService.insert(pmsWbsVersionPayload);
        return insert;
    }

    void checkWbsAct(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsDO> pmsProjectWbsDOS, List<PmsWbsActCostPayload> actCostPayloads, List<PmsWbsActPayPayload> actPayPayloads, Long projectId, List<PmsWbsActCostVO> pmsWbsActCostVOS, List<PmsWbsActPayVO> pmsWbsActPayVOS) {
        for (PmsProjectWbsPayload wbsPayload : wbsPayloads) {
            List collect;
            List costPayloads = wbsPayload.getActCostPayloads();
            List payloads = wbsPayload.getActPayPayloads();
            if (ObjectUtils.isEmpty((Object)costPayloads) && ObjectUtils.isEmpty((Object)payloads)) continue;
            Optional<PmsProjectWbsDO> first = pmsProjectWbsDOS.stream().filter(wbsDO -> wbsDO.getWbsCode().equals(wbsPayload.getWbsCode())).findFirst();
            PmsProjectWbsDO pmsProjectWbsDO = first.get();
            if (!ObjectUtils.isEmpty((Object)costPayloads)) {
                collect = costPayloads.stream().map(PmsWbsActCostPayload::getCostName).distinct().collect(Collectors.toList());
                if (costPayloads.size() != collect.size()) {
                    throw TwException.error("", "\u3010" + pmsProjectWbsDO.getWbsName() + "\u3011\u6d3b\u52a8\u63cf\u8ff0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                costPayloads.forEach(costPayload -> {
                    costPayload.setProjectId(projectId);
                    costPayload.setWbsId(pmsProjectWbsDO.getId());
                    costPayload.setWbsName(pmsProjectWbsDO.getWbsName());
                });
                actCostPayloads.addAll(costPayloads);
            }
            if (ObjectUtils.isEmpty((Object)payloads)) continue;
            collect = payloads.stream().map(PmsWbsActPayPayload::getPayName).distinct().collect(Collectors.toList());
            if (payloads.size() != collect.size()) {
                throw TwException.error("", "\u3010" + pmsProjectWbsDO.getWbsName() + "\u3011\u76ee\u6807\u4ea4\u4ed8\u7269\u540d\u79f0\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            payloads.forEach(payPayload -> {
                payPayload.setProjectId(projectId);
                payPayload.setWbsId(pmsProjectWbsDO.getId());
                payPayload.setWbsName(pmsProjectWbsDO.getWbsName());
            });
            actPayPayloads.addAll(payloads);
        }
    }

    public List<PmsProjectWbsVO> getSetWbs(Long projectId, List<String> parentWbsCodes) {
        PmsProjectWbsQuery query = new PmsProjectWbsQuery();
        query.setProjectId(projectId);
        query.setParentWbsCodes(parentWbsCodes);
        List<PmsProjectWbsVO> list = this.pmsProjectWbsDAO.queryListDynamic(query);
        return list.stream().filter(v -> !ProjectWbsTypeEnum.MS.getCode().equals(v.getWbsType())).collect(Collectors.toList());
    }

    public void countProgressAndStatus(List<PmsProjectWbsVO> pmsProjectWbsVOS) {
        List wbsIds = pmsProjectWbsVOS.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<Object> hasTaskWbsIdS = new ArrayList();
        if (!ObjectUtils.isEmpty(wbsIds)) {
            List taskVOS = this.getPmsWbsTaskService().findByWbsIds(wbsIds);
            hasTaskWbsIdS = taskVOS.stream().map(v -> v.getWbsId()).collect(Collectors.toList());
        }
        ArrayList finalHasTaskWbsIdS = hasTaskWbsIdS;
        pmsProjectWbsVOS.forEach(wbs -> {
            if (ProjectWbsTypeEnum.ACT.getCode().equals(wbs.getWbsType()) && !finalHasTaskWbsIdS.contains(wbs.getId())) {
                this.countWbsProgress((PmsProjectWbsVO)wbs);
            }
        });
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        Map actMap = pmsProjectWbsVOS.stream().filter(v -> ProjectWbsTypeEnum.ACT.getCode().equals(v.getWbsType())).collect(Collectors.groupingBy(PmsProjectWbsVO::getParentWbsCode, Collectors.toList()));
        for (Map.Entry entry : actMap.entrySet()) {
            map.put(entry.getKey(), this.countWbsProgress(entry.getValue()));
        }
        pmsProjectWbsVOS.forEach(wbs -> {
            if (ProjectWbsTypeEnum.WBS.getCode().equals(wbs.getWbsType()) && !map.containsKey(wbs.getWbsCode())) {
                this.countWbsProgress((PmsProjectWbsVO)wbs);
            }
        });
        Map wbsMap = pmsProjectWbsVOS.stream().filter(v -> ProjectWbsTypeEnum.WBS.getCode().equals(v.getWbsType()) && !ObjectUtils.isEmpty((Object)v.getParentWbsCode())).collect(Collectors.groupingBy(PmsProjectWbsVO::getParentWbsCode, Collectors.toList()));
        for (Map.Entry entry : wbsMap.entrySet()) {
            List<PmsProjectWbsVO> value = entry.getValue();
            if (actMap.containsKey(entry.getKey())) {
                value.addAll(actMap.get(entry.getKey()));
            }
            map.put(entry.getKey(), this.countWbsProgress(value));
        }
        pmsProjectWbsVOS.forEach(wbs -> {
            if (ProjectWbsTypeEnum.WBS.getCode().equals(wbs.getWbsType()) && map.containsKey(wbs.getWbsCode())) {
                wbs.setWbsProgress((BigDecimal)map.get(wbs.getWbsCode()));
            }
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("wbsProgress", wbs.getWbsProgress());
            info.put("wbsStatus", wbs.getWbsStatus());
            progressAndStatusCache.put(wbs.getId(), info);
        });
    }

    public void countWbsProgress(PmsProjectWbsVO wbs) {
        if (!(ObjectUtils.isEmpty((Object)wbs.getPreStartDate()) || ObjectUtils.isEmpty((Object)wbs.getPreEndDate()) || ObjectUtils.isEmpty((Object)wbs.getStartDate()))) {
            if (ObjectUtils.isEmpty((Object)wbs.getPreDurationDay())) {
                PmsProjectCalendarPayload payload = new PmsProjectCalendarPayload();
                payload.setSourceId(wbs.getId());
                payload.setSourceType(ProjectWbsTypeEnum.WBS.getCode());
                payload.setStartDate(wbs.getPreStartDate());
                payload.setEndDate(wbs.getPreEndDate());
                payload.setProjectId(wbs.getProjectId());
                PmsProjectCalendarVO bySource = this.calendarService.findBySource(payload);
                if (!ObjectUtils.isEmpty((Object)bySource)) {
                    payload.setDurationDays(bySource.getDurationDays());
                }
            }
            if (!ObjectUtils.isEmpty((Object)wbs.getPreDurationDay())) {
                BigDecimal wbsProgress = BigDecimal.valueOf(Period.between(wbs.getStartDate(), LocalDate.now()).getDays()).divide(wbs.getPreDurationDay(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
                if (wbsProgress.doubleValue() > 100.0) {
                    wbsProgress = BigDecimal.valueOf(100L);
                }
                wbs.setWbsProgress(wbsProgress);
                if (wbsProgress.doubleValue() > 0.0 && wbsProgress.doubleValue() < 100.0) {
                    wbs.setWbsStatus(ProjectWbsStatusEnum.NOGIONG.getCode());
                    wbs.setWbsStatusName(ProjectWbsStatusEnum.NOGIONG.getDesc());
                } else if (wbsProgress.doubleValue() == 100.0) {
                    wbs.setWbsStatus(ProjectWbsStatusEnum.FINISHED.getCode());
                    wbs.setWbsStatusName(ProjectWbsStatusEnum.FINISHED.getDesc());
                } else if (wbsProgress.doubleValue() == 0.0) {
                    wbs.setWbsStatus(ProjectWbsStatusEnum.NOSTART.getCode());
                    wbs.setWbsStatusName(ProjectWbsStatusEnum.NOSTART.getDesc());
                }
            }
        }
    }

    private BigDecimal countWbsProgress(List<PmsProjectWbsVO> list) {
        if (ObjectUtils.isEmpty(list)) {
            return BigDecimal.ZERO;
        }
        long size = list.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getWbsProgress()) && v.getWbsProgress().doubleValue() == 100.0).count();
        if ((long)list.size() == size) {
            return BigDecimal.valueOf(100L);
        }
        BigDecimal wbsProgress = BigDecimal.ZERO;
        for (PmsProjectWbsVO wbs : list) {
            if (ObjectUtils.isEmpty((Object)wbs.getWbsProgress()) || ObjectUtils.isEmpty((Object)wbs.getWbsWeight())) continue;
            wbsProgress = wbsProgress.add(wbs.getWbsProgress().multiply(wbs.getWbsWeight()));
        }
        return wbsProgress.divide(BigDecimal.valueOf(100L));
    }

    private void setWbsWeight(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsVO> pmsProjectWbsVOS) {
        Boolean insertFlag = ObjectUtils.isEmpty((Object)wbsPayloads.get(0).getId()) || wbsPayloads.get(0).getId() < 1L;
        Map groupMap = wbsPayloads.stream().collect(Collectors.groupingBy(PmsProjectWbsPayload::getParentWbsCode, Collectors.toList()));
        for (Map.Entry entry : groupMap.entrySet()) {
            String parentWbsCode = entry.getKey();
            ArrayList<PmsProjectWbsVO> list = new ArrayList();
            if (!ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
                list = pmsProjectWbsVOS.stream().filter(vo -> vo.getParentWbsCode().equals(parentWbsCode) && (vo.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) || vo.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode()))).collect(Collectors.toList());
            }
            if (insertFlag.booleanValue()) {
                List<PmsProjectWbsPayload> value = entry.getValue();
                if (ObjectUtils.isEmpty(value = value.stream().filter(wbsPayload -> wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.ACT.getCode()) || wbsPayload.getWbsType().equals(ProjectWbsTypeEnum.WBS.getCode())).collect(Collectors.toList()))) continue;
                this.insertWbsWeight(value, list);
                continue;
            }
            ArrayList finalList = list;
            wbsPayloads.forEach(v -> this.updateWbsWeight((PmsProjectWbsPayload)v, finalList));
        }
    }

    private void insertWbsWeight(List<PmsProjectWbsPayload> wbsPayloads, List<PmsProjectWbsVO> list) {
        wbsPayloads.forEach(v -> v.setManualSettingWeight(Integer.valueOf(0)));
        if (ObjectUtils.isEmpty(list)) {
            BigDecimal average = BigDecimal.valueOf(100L).divide(BigDecimal.valueOf(wbsPayloads.size()), 2, RoundingMode.HALF_UP);
            wbsPayloads.forEach(v -> v.setWbsWeight(average));
        } else {
            BigDecimal weights = list.stream().filter(v -> 1 == v.getManualSettingWeight()).map(PmsProjectWbsVO::getWbsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
            list = list.stream().filter(v -> 0 == v.getManualSettingWeight()).collect(Collectors.toList());
            long count = list.size();
            BigDecimal averageNew = BigDecimal.valueOf(100L).subtract(weights).divide(BigDecimal.valueOf(count + (long)wbsPayloads.size()), 2, RoundingMode.HALF_UP);
            wbsPayloads.forEach(v -> v.setWbsWeight(averageNew));
            list.forEach(v -> v.setWbsWeight(averageNew));
            this.pmsProjectWbsDAO.saveAll(PmsProjectWbsConvert.INSTANCE.toEntity(list));
        }
    }

    private void updateWbsWeight(PmsProjectWbsPayload payload, List<PmsProjectWbsVO> list) {
        BigDecimal weightNew = payload.getWbsWeight();
        if (!ObjectUtils.isEmpty((Object)weightNew)) {
            payload.setManualSettingWeight(Integer.valueOf(1));
            BigDecimal weightOld = list.stream().filter(v -> payload.getId().equals(v.getId())).findFirst().get().getWbsWeight();
            if (weightNew.compareTo(weightOld) != 0) {
                BigDecimal weights = list.stream().filter(v -> !payload.getId().equals(v.getId()) && 1 == v.getManualSettingWeight()).map(PmsProjectWbsVO::getWbsWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                if ((weights = weights.add(weightNew)).doubleValue() > 100.0) {
                    throw TwException.error("", "\u8be5\u8282\u70b9\u4e0b\u7684\u624b\u52a8\u8bbe\u7f6e\u8282\u70b9\u6743\u91cd\u603b\u548c\u8d85\u8fc7100\u4e86\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                list = list.stream().filter(v -> !payload.getId().equals(v.getId()) && 0 == v.getManualSettingWeight()).collect(Collectors.toList());
                this.updateWbsWeight(list, weights);
            }
        }
    }

    private void updateWbsWeight(List<PmsProjectWbsVO> list, BigDecimal weights) {
        long count = list.size();
        if (count > 0L) {
            BigDecimal averageNew = BigDecimal.valueOf(100L).subtract(weights).divide(BigDecimal.valueOf(count), 2, RoundingMode.HALF_UP);
            list.forEach(v -> v.setWbsWeight(averageNew));
            this.pmsProjectWbsDAO.saveAll(PmsProjectWbsConvert.INSTANCE.toEntity(list));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAllocateInfo(Long activityId, BigDecimal allocateEqva, BigDecimal allocateCost, String allocateStatus) {
        PmsProjectWbsPayload activityPayload = new PmsProjectWbsPayload();
        activityPayload.setId(activityId);
        activityPayload.setAllocateCost(allocateCost);
        activityPayload.setAllocateEqva(allocateEqva);
        activityPayload.setAllocateStatus(allocateStatus);
        this.pmsProjectWbsDAO.updateByKeyNoVersion(activityPayload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAllocateInfoByEffId(Long effId, BigDecimal allocateEqva, BigDecimal allocateCost, String allocateStatus) {
        PmsProjectWbsPayload activityPayload = new PmsProjectWbsPayload();
        activityPayload.setEffRelateId(effId);
        activityPayload.setAllocateCost(allocateCost);
        activityPayload.setAllocateEqva(allocateEqva);
        activityPayload.setAllocateStatus(allocateStatus);
        this.pmsProjectWbsDAO.updateByKeyNoVersionByEffId(activityPayload);
    }

    public void checkStep2(PmsProjectWbsQuery query) {
        List ids = query.getIds();
        List<PmsProjectWbsVO> pmsProjectWbsVOS = this.pmsProjectWbsDAO.queryListByIds(ids);
        for (PmsProjectWbsVO pmsProjectWbsVO : pmsProjectWbsVOS) {
            if (pmsProjectWbsVO.getWbsType().equals("ACT")) {
                if (null == pmsProjectWbsVO.getPreStartDate()) {
                    throw new BusinessException("\u7f16\u53f7\u4e3a" + pmsProjectWbsVO.getWbsCode() + "\u7684\u8ba1\u5212\u9884\u8ba1\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == pmsProjectWbsVO.getPreEndDate()) {
                    throw new BusinessException("\u7f16\u53f7\u4e3a" + pmsProjectWbsVO.getWbsCode() + "\u7684\u8ba1\u5212\u9884\u8ba1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            if (!pmsProjectWbsVO.getWbsType().equals("MS") || null != pmsProjectWbsVO.getPreEndDate()) continue;
            throw new BusinessException("\u7f16\u53f7\u4e3a" + pmsProjectWbsVO.getWbsCode() + "\u7684\u8ba1\u5212\u9884\u8ba1\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void exportElecPlanTask(HttpServletResponse response, PmsProjectWbsQuery query) {
        try {
            int bytesRead;
            List<PmsProjectWbsVO> pmsProjectWbsVOS = this.queryList(query);
            if (!ObjectUtils.isEmpty(pmsProjectWbsVOS)) {
                AtomicInteger atomicId = new AtomicInteger(1);
                pmsProjectWbsVOS.forEach(mpxjMppTaskVO -> mpxjMppTaskVO.setRowId(Integer.valueOf(atomicId.getAndIncrement())));
            }
            ProjectFile projectFile = new ProjectFile();
            pmsProjectWbsVOS.forEach(mpxjMppTaskVO -> {
                Task task = projectFile.addTask();
                task.setID(mpxjMppTaskVO.getRowId());
                task.setWBS(mpxjMppTaskVO.getWbsCode());
                task.setName(mpxjMppTaskVO.getWbsName());
                if (mpxjMppTaskVO.getWbsProgress() != null) {
                    task.setPercentageComplete((Number)mpxjMppTaskVO.getWbsProgress());
                }
                double preDurationDay = mpxjMppTaskVO.getPreDurationDay() == null ? 0.0 : mpxjMppTaskVO.getPreDurationDay().doubleValue();
                task.setDuration(Duration.getInstance((double)preDurationDay, (TimeUnit)TimeUnit.getInstance((int)TimeUnit.DAYS.getValue())));
                if (mpxjMppTaskVO.getPreStartDate() != null) {
                    Date planStartDate = Date.from(mpxjMppTaskVO.getPreStartDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                    task.setStart(planStartDate);
                }
                if (mpxjMppTaskVO.getPreEndDate() != null) {
                    Date planFinishDate = Date.from(mpxjMppTaskVO.getPreEndDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                    task.setFinish(planFinishDate);
                }
                if (org.springframework.util.StringUtils.hasText((String)mpxjMppTaskVO.getWbsType())) {
                    if (mpxjMppTaskVO.getWbsType().equals(ProjectWbsTypeEnum.ACTG.getCode())) {
                        task.setSummary(true);
                    }
                    if (mpxjMppTaskVO.getWbsType().equals(ProjectWbsTypeEnum.MS.getCode())) {
                        task.setMilestone(true);
                    }
                }
                if (!ObjectUtils.isEmpty((Object)mpxjMppTaskVO.getPmsProjectWbsResourceVOList())) {
                    mpxjMppTaskVO.getPmsProjectWbsResourceVOList().forEach(resourceVO -> {
                        Resource resource = projectFile.addResource();
                        resource.setName(resourceVO.getRelatePartiesName());
                        task.addResourceAssignment(resource);
                    });
                }
            });
            TaskContainer tasks = projectFile.getTasks();
            tasks.forEach(arg_0 -> PmsProjectWbsServiceImpl.lambda$exportElecPlanTask$103(pmsProjectWbsVOS, (List)tasks, arg_0));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MSPDIWriter writer = new MSPDIWriter();
            writer.write(projectFile, (OutputStream)bos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment;filename=project.xml");
            byte[] buffer = new byte[1024];
            while ((bytesRead = byteArrayInputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, bytesRead);
            }
            ((InputStream)byteArrayInputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<PmsProjectWbsVO> importElecPlanTask(MultipartFile file, Long projectId) {
        String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if (!"mpp".equals(extension)) {
            log.info("\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u540d\u540e\u7f00\u5fc5\u987b\u4e3a\u201cmpp\u201d\uff01");
        }
        MPPReader mppRead = new MPPReader();
        ProjectFile project = null;
        try {
            project = mppRead.read(file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        ArrayList<PmsProjectWbsVO> pmsProjectWbsVOS = new ArrayList<PmsProjectWbsVO>();
        this.analysisFile(project, pmsProjectWbsVOS, projectId);
        return pmsProjectWbsVOS;
    }

    void analysisFile(ProjectFile project, List<PmsProjectWbsVO> pmsProjectWbsVOS, Long projectId) {
        ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
        proRelatedPartiesQuery.setProId(projectId);
        List<ProRelatedPartiesVO> list = this.proRelatedPartiesDao.getList(proRelatedPartiesQuery);
        TaskContainer tasks = project.getTasks();
        for (int i = 1; i < tasks.size(); ++i) {
            List task_predecessors;
            boolean summary;
            PmsProjectWbsVO pmsProjectWbsVO = new PmsProjectWbsVO();
            Task task = (Task)tasks.get(i);
            Integer task_id = task.getID();
            pmsProjectWbsVO.setId(Long.valueOf(task_id.intValue()));
            Task parentTask = task.getParentTask();
            if (parentTask != null) {
                pmsProjectWbsVO.setParentWbsCode(parentTask.getWBS());
                pmsProjectWbsVO.setParentWbsName(parentTask.getName());
            }
            String task_wbs = task.getWBS();
            pmsProjectWbsVO.setWbsCode(task_wbs);
            String task_name = task.getName();
            pmsProjectWbsVO.setWbsName(task_name);
            Date task_start_date = task.getStart();
            pmsProjectWbsVO.setPreStartDate(task_start_date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            Date task_finish_date = task.getFinish();
            pmsProjectWbsVO.setPreEndDate(task_finish_date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            double duration = task.getDuration().getDuration();
            pmsProjectWbsVO.setPreDurationDay(BigDecimal.valueOf(duration));
            List resourceAssignments = task.getResourceAssignments();
            if (!ObjectUtils.isEmpty((Object)resourceAssignments)) {
                ArrayList resourceVOS = new ArrayList();
                resourceAssignments.forEach(resourceAssignment -> {
                    Optional<ProRelatedPartiesVO> first;
                    Resource resource = resourceAssignment.getResource();
                    if (resource != null && (first = list.stream().filter(proRelatedPartiesVO -> proRelatedPartiesVO.getName().equals(resource.getName())).findFirst()).isPresent()) {
                        PmsProjectWbsResourceVO resourceVO = new PmsProjectWbsResourceVO();
                        resourceVO.setRelatePartiesName(resource.getName());
                        resourceVO.setRelatePartiesId(first.get().getId());
                        resourceVO.setRelatePartiesName(first.get().getName());
                        resourceVOS.add(resourceVO);
                    }
                });
                pmsProjectWbsVO.setPmsProjectWbsResourceVOList(resourceVOS);
            }
            pmsProjectWbsVO.setWbsProgress(BigDecimal.valueOf(task.getPercentageComplete().doubleValue()));
            pmsProjectWbsVO.setWbsType(ProjectWbsTypeEnum.ACT.getCode());
            boolean milestone = task.getMilestone();
            if (milestone) {
                pmsProjectWbsVO.setWbsType(ProjectWbsTypeEnum.MS.getCode());
            }
            if (summary = task.getSummary()) {
                pmsProjectWbsVO.setWbsType(ProjectWbsTypeEnum.ACTG.getCode());
            }
            if ((task_predecessors = task.getPredecessors()) != null) {
                ArrayList taskRelations = new ArrayList();
                task_predecessors.forEach(relation -> {
                    if (relation.getTargetTask() != null) {
                        PmsProjectWbsRelyVO relationVO = new PmsProjectWbsRelyVO();
                        relationVO.setWbsId(Long.valueOf(task.getID().intValue()));
                        relationVO.setWbsName(task.getName());
                        relationVO.setWbsCode(task.getWBS());
                        relationVO.setWbsRelyId(Long.valueOf(relation.getTargetTask().getID().intValue()));
                        relationVO.setWbsRelyName(relation.getTargetTask().getName());
                        relationVO.setWbsRelyCode(relation.getTargetTask().getWBS());
                        relationVO.setRelyType(relation.getType().toString());
                        taskRelations.add(relationVO);
                    }
                });
                pmsProjectWbsVO.setPmsProjectWbsRelyVOList(taskRelations);
            }
            pmsProjectWbsVOS.add(pmsProjectWbsVO);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAllocateStatus(List<Long> wbsIdList, String status) {
        this.pmsProjectWbsDAO.updateAllocateStatus(wbsIdList, status);
    }

    @Transactional
    public void batchUpdate(List<PmsProjectWbsPayload> activityPayloads) {
        if (!CollectionUtils.isEmpty(activityPayloads)) {
            activityPayloads.forEach(item -> this.pmsProjectWbsDAO.updateByKeyNoVersion((PmsProjectWbsPayload)item));
        }
    }

    @Transactional
    public void updateAllocateStatusByEffId(List<Long> wbsIdList, String allocateStatus) {
        this.pmsProjectWbsDAO.updateAllocateStatusByEffId(wbsIdList, allocateStatus);
    }

    public Map<Long, String> listConReceivablePlanVO(Long contractId) {
        List planVOList = this.conReceivablePlanService.queryBySaleConId(contractId);
        if (!ObjectUtils.isEmpty((Object)planVOList)) {
            planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
        }
        Map<Long, String> planInfo = planVOList.stream().collect(Collectors.toMap(BaseViewModel::getId, ConReceivablePlanVO::getReceStage));
        return planInfo;
    }

    public PmsProjectWbsServiceImpl(CacheUtil cacheUtil, PmsProjectWbsDAO pmsProjectWbsDAO, PmsWbsActCostDAO pmsWbsActCostDAO, PmsWbsActPayDAO pmsWbsActPayDAO, ComLogService logService, ComChangeService changeService, PmsProjectDAO pmsProjectDAO, ChangeFieldUtil changeFieldUtil, PmsProjectWbsSnapshotService planSnapshotService, PmsProjectCalendarService calendarService, PmsProjectWbsRelyDAO pmsProjectWbsRelyDAO, PmsBudgetDetailService budgetDetailService, ConReceivablePlanService conReceivablePlanService, ProRelatedPartiesDao proRelatedPartiesDao, PmsProjectWbsAcceptService pmsProjectWbsAcceptService, PmsWbsVersionService pmsWbsVersionService, PmsProjectWbsResourceDao pmsProjectWbsResourceDao, PmsProjectWbsResourceRepo pmsProjectWbsResourceRepo, PmsProjectWbsAcceptDao pmsProjectWbsAcceptDao, PmsProjectWbsAcceptRepo pmsProjectWbsAcceptRepo) {
        this.cacheUtil = cacheUtil;
        this.pmsProjectWbsDAO = pmsProjectWbsDAO;
        this.pmsWbsActCostDAO = pmsWbsActCostDAO;
        this.pmsWbsActPayDAO = pmsWbsActPayDAO;
        this.logService = logService;
        this.changeService = changeService;
        this.pmsProjectDAO = pmsProjectDAO;
        this.changeFieldUtil = changeFieldUtil;
        this.planSnapshotService = planSnapshotService;
        this.calendarService = calendarService;
        this.pmsProjectWbsRelyDAO = pmsProjectWbsRelyDAO;
        this.budgetDetailService = budgetDetailService;
        this.conReceivablePlanService = conReceivablePlanService;
        this.proRelatedPartiesDao = proRelatedPartiesDao;
        this.pmsProjectWbsAcceptService = pmsProjectWbsAcceptService;
        this.pmsWbsVersionService = pmsWbsVersionService;
        this.pmsProjectWbsResourceDao = pmsProjectWbsResourceDao;
        this.pmsProjectWbsResourceRepo = pmsProjectWbsResourceRepo;
        this.pmsProjectWbsAcceptDao = pmsProjectWbsAcceptDao;
        this.pmsProjectWbsAcceptRepo = pmsProjectWbsAcceptRepo;
    }

    private static /* synthetic */ void lambda$exportElecPlanTask$103(List pmsProjectWbsVOS, List tasks, Task task) {
        Optional<Task> first;
        PmsProjectWbsVO mpxjMppTaskVO = pmsProjectWbsVOS.stream().filter(taskVO -> taskVO.getRowId().equals(task.getID())).findFirst().get();
        if (!ObjectUtils.isEmpty((Object)mpxjMppTaskVO.getPmsProjectWbsRelyVOList())) {
            mpxjMppTaskVO.getPmsProjectWbsRelyVOList().forEach(relation -> {
                PmsProjectWbsVO pmsProjectWbsVO1 = pmsProjectWbsVOS.stream().filter(pmsProjectWbsVO -> pmsProjectWbsVO.getId().equals(relation.getWbsRelyId())).findFirst().get();
                Optional<Task> first = tasks.stream().filter(taskVO -> taskVO.getID().equals(pmsProjectWbsVO1.getRowId())).findFirst();
                if (first.isPresent()) {
                    String relyType;
                    int typeValue = 0;
                    switch (relyType = relation.getRelyType()) {
                        case "FS": {
                            typeValue = 1;
                            break;
                        }
                        case "SF": {
                            typeValue = 2;
                            break;
                        }
                        case "SS": {
                            typeValue = 3;
                        }
                    }
                    task.addPredecessor(first.get(), RelationType.getInstance((int)typeValue), Duration.getInstance((int)0, (TimeUnit)TimeUnit.getInstance((int)TimeUnit.DAYS.getValue())));
                }
            });
        }
        if (org.springframework.util.StringUtils.hasText((String)mpxjMppTaskVO.getParentWbsCode()) && (first = tasks.stream().filter(taskVO -> taskVO.getWBS().equals(mpxjMppTaskVO.getParentWbsCode())).findFirst()).isPresent()) {
            first.get().addChildTask(task);
        }
    }
}

