/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.stateflow.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.convert.StateFlowConfigConvert;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.convert.StateFlowConvert;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.StateFlowDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.PmsStateFlowVersionPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.PmsStateFlowVersionQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowConfigQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.PmsStateFlowVersionVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowConfigVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.StateFlowRepo;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.PmsStateFlowVersionDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.StateFlowConfigDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.PmsStateFlowVersionService;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowConfigService;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PmsStateFlowVersionServiceImpl
implements PmsStateFlowVersionService {
    private static final Logger log = LoggerFactory.getLogger(PmsStateFlowVersionServiceImpl.class);
    private final PmsStateFlowVersionDao dao;
    private final StateFlowService stateFlowService;
    private final StateFlowConfigService stateFlowConfigService;
    private final StateFlowRepo stateFlowRepo;
    private final StateFlowConfigDao stateFlowConfigDao;

    @Override
    public TwOutputUtil<PagingVO<PmsStateFlowVersionVO>> queryPage(PmsStateFlowVersionQuery query) {
        PagingVO<PmsStateFlowVersionVO> pageVO = this.dao.queryPage(query);
        this.translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PmsStateFlowVersionVO>> queryList(PmsStateFlowVersionQuery query) {
        List<PmsStateFlowVersionVO> listVO = this.dao.queryList(query);
        this.translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PmsStateFlowVersionQuery query) {
        return TwOutputUtil.ok(this.dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PmsStateFlowVersionVO> queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsStateFlowVersionVO vo = this.dao.queryByKey(id);
        Assert.notNull((Object)vo, (String)"\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsStateFlowVersionVO> insert(PmsStateFlowVersionPayload payload) {
        PmsStateFlowVersionVO lastVersionNo;
        this.checkData(payload);
        if (null == payload.getState()) {
            payload.setState(1);
        }
        payload.setVersionNo((lastVersionNo = this.dao.getLastVersionNo(payload.getCategoryId(), null)) == null ? 1 : lastVersionNo.getVersionNo() + 1);
        PmsStateFlowVersionVO save = this.dao.save(payload);
        if (null != lastVersionNo) {
            PmsStateFlowVersionVO lastVersionNo2 = this.dao.getLastVersionNo(payload.getCategoryId(), 3);
            if (null == lastVersionNo2) {
                return TwOutputUtil.ok(save);
            }
            StateFlowQuery stateFlowQuery = new StateFlowQuery();
            stateFlowQuery.setObjId(payload.getCategoryId());
            stateFlowQuery.setVersionNo(lastVersionNo2.getVersionNo());
            stateFlowQuery.setVersionId(lastVersionNo2.getId());
            List<StateFlowVO> oldStateFlowList = this.stateFlowService.getList(stateFlowQuery);
            if (CollUtil.isNotEmpty(oldStateFlowList)) {
                ArrayList allStateFlowConfigList = new ArrayList();
                oldStateFlowList.forEach(x -> {
                    StateFlowConfigQuery stateFlowConfigQuery = new StateFlowConfigQuery();
                    stateFlowConfigQuery.setFlowId(x.getId());
                    List<StateFlowConfigVO> stateFlowConfigVOList = this.stateFlowConfigService.getList(stateFlowConfigQuery);
                    x.setId(null);
                    x.setVersionId(save.getId());
                    x.setVersionNo(save.getVersionNo());
                    StateFlowDO entity = (StateFlowDO)((Object)((Object)StateFlowConvert.INSTANCE.toEntity(x)));
                    StateFlowDO newStateFlowEntity = (StateFlowDO)((Object)((Object)this.stateFlowRepo.save((Object)entity)));
                    stateFlowConfigVOList.forEach(x1 -> {
                        x1.setId(null);
                        x1.setFlowId(newStateFlowEntity.getId());
                    });
                    List entityList2 = StateFlowConfigConvert.INSTANCE.toEntity(stateFlowConfigVOList);
                    allStateFlowConfigList.addAll(entityList2);
                });
                allStateFlowConfigList.forEach(x -> {
                    StateFlowQuery stateFlowQuery1 = new StateFlowQuery();
                    stateFlowQuery1.setVersionId(save.getId());
                    stateFlowQuery1.setObjId(save.getCategoryId());
                    stateFlowQuery1.setCode(x.getConfigFlowCode());
                    List<StateFlowVO> list = this.stateFlowService.getList(stateFlowQuery1);
                    if (CollUtil.isNotEmpty(list)) {
                        x.setConfigFlowId(list.get(0).getId());
                    }
                });
                this.stateFlowConfigDao.save(allStateFlowConfigList);
            }
        }
        return TwOutputUtil.ok(save);
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsStateFlowVersionVO> update(PmsStateFlowVersionPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        PmsStateFlowVersionVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PmsStateFlowVersionVO> updateDynamic(PmsStateFlowVersionPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        this.dao.updateByKeyDynamic(payload);
        return this.queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw TwException.error("", "ids\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return TwOutputUtil.ok(this.dao.deleteSoft(ids));
    }

    private TwOutputUtil<Long> startWorkFlow(PmsStateFlowVersionPayload payload) {
        HashMap varMaps = new HashMap();
        String procInstId = "";
        Long update = this.dao.updateByKeyDynamic(payload);
        return TwOutputUtil.ok(update);
    }

    private void checkData(PmsStateFlowVersionPayload payload) {
    }

    private void translate(List<PmsStateFlowVersionVO> vos) {
        vos.forEach(vo -> {});
    }

    public PmsStateFlowVersionServiceImpl(PmsStateFlowVersionDao dao, StateFlowService stateFlowService, StateFlowConfigService stateFlowConfigService, StateFlowRepo stateFlowRepo, StateFlowConfigDao stateFlowConfigDao) {
        this.dao = dao;
        this.stateFlowService = stateFlowService;
        this.stateFlowConfigService = stateFlowConfigService;
        this.stateFlowRepo = stateFlowRepo;
        this.stateFlowConfigDao = stateFlowConfigDao;
    }
}

