/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.stateflow.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.convert.StateFlowConvert;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.entity.StateFlowDO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.payload.StateFlowPayload;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowConfigQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.PmsStateFlowVersionVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowConfigVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.StateFlowRepo;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.PmsStateFlowVersionDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.repo.dao.StateFlowDao;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowConfigService;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneVO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StateFlowServiceImpl
extends BaseServiceImpl
implements StateFlowService {
    private static final Logger log = LoggerFactory.getLogger(StateFlowServiceImpl.class);
    private final StateFlowDao stateFlowDao;
    private final StateFlowRepo stateFlowRepo;
    private final StateFlowConfigService stateFlowConfigService;
    private final TaskSceneService taskSceneService;
    @Lazy
    @Autowired
    private PmsStateFlowVersionDao pmsStateFlowVersionService;
    @Autowired
    @Lazy
    private TaskInfoService taskInfoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StateFlowVO save(StateFlowPayload stateFlowPayload) {
        Assert.notNull((Object)stateFlowPayload.getObjId(), (String)"objId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PmsStateFlowVersionVO pmsStateFlowVersionVO = this.pmsStateFlowVersionService.getLastVersionNo(stateFlowPayload.getObjId(), null);
        if (null == pmsStateFlowVersionVO) {
            throw new BusinessException("\u8be5\u5206\u7c7b\u4e0b\u6ca1\u6709\u6d41\u7a0b\u7248\u672c");
        }
        stateFlowPayload.setVersionId(pmsStateFlowVersionVO.getId());
        stateFlowPayload.setVersionNo(pmsStateFlowVersionVO.getVersionNo());
        if (null == stateFlowPayload.getState()) {
            stateFlowPayload.setState(1);
        }
        this.checkData(stateFlowPayload);
        if (stateFlowPayload.getState() == 1) {
            stateFlowPayload.setProgressPercentage(BigDecimal.ZERO);
        }
        if (stateFlowPayload.getState() == 3) {
            stateFlowPayload.setProgressPercentage(BigDecimal.ONE);
        }
        if (null == stateFlowPayload.getId()) {
            String code = this.generateSeqNum("STATE_FLOW_NO", new String[0]);
            stateFlowPayload.setCode(code);
        }
        StateFlowQuery stateFlowQuery = new StateFlowQuery();
        stateFlowQuery.setName(stateFlowPayload.getName());
        stateFlowQuery.setType(stateFlowPayload.getType());
        stateFlowQuery.setObjId(stateFlowPayload.getObjId());
        stateFlowQuery.setVersionId(stateFlowPayload.getVersionId());
        Long count = this.stateFlowDao.count(stateFlowQuery);
        if (count > 0L) {
            throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u540d\u5b57: " + stateFlowPayload.getName());
        }
        StateFlowDO stateFlowDO = StateFlowConvert.INSTANCE.p2d(stateFlowPayload);
        StateFlowDO res = (StateFlowDO)((Object)this.stateFlowRepo.save((Object)stateFlowDO));
        return StateFlowConvert.INSTANCE.d2v(res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StateFlowVO updateAll(StateFlowPayload stateFlowPayload) {
        Assert.notNull((Object)stateFlowPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        StateFlowVO res = this.save(stateFlowPayload);
        return res;
    }

    @Override
    public StateFlowVO get(Long id) {
        if (null == id) {
            return null;
        }
        StateFlowVO res = this.stateFlowDao.get(id);
        if (null == res) {
            return null;
        }
        StateFlowConfigQuery stateFlowConfigQuery = new StateFlowConfigQuery();
        stateFlowConfigQuery.setFlowId(id);
        List<StateFlowConfigVO> list = this.stateFlowConfigService.getList(stateFlowConfigQuery);
        res.setStateFlowConfigVOList(list);
        return res;
    }

    @Override
    public PagingVO<StateFlowVO> page(StateFlowQuery stateFlowQuery) {
        PagingVO<StateFlowVO> res = this.stateFlowDao.page(stateFlowQuery);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long taskCount = this.taskInfoService.countByFlowId(ids);
        if (taskCount > 0L) {
            throw new BusinessException("\u8bf7\u5148\u79fb\u9664\u4efb\u52a1\u4e0b\u7684\u72b6\u6001\u540e\u5728\u8fdb\u884c\u5220\u9664\u64cd\u4f5c");
        }
        Long res = this.stateFlowDao.del(ids);
        for (Long id : ids) {
            this.stateFlowConfigService.delByFlowId(id);
        }
        return res;
    }

    @Override
    public List<StateFlowVO> getList(StateFlowQuery stateFlowQuery) {
        if (stateFlowQuery.getVersionNo() == null && null == stateFlowQuery.getVersionId()) {
            Assert.notNull((Object)stateFlowQuery.getObjId(), (String)"objId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            PmsStateFlowVersionVO lastVersionNo = this.pmsStateFlowVersionService.getLastVersionNo(stateFlowQuery.getObjId(), 3);
            if (null == lastVersionNo) {
                return new ArrayList<StateFlowVO>();
            }
            stateFlowQuery.setVersionId(lastVersionNo.getId());
            stateFlowQuery.setVersionNo(lastVersionNo.getVersionNo());
        }
        List<StateFlowVO> res = this.stateFlowDao.getList(stateFlowQuery);
        return res;
    }

    private void checkData(StateFlowPayload stateFlowPayload) {
        Assert.notNull((Object)stateFlowPayload.getType(), (String)"objId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)stateFlowPayload.getType(), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)stateFlowPayload.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)stateFlowPayload.getState(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(StateFlowPayload stateFlowPayload) {
        Assert.notNull((Object)stateFlowPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (stateFlowPayload.getState() == 1) {
            stateFlowPayload.setProgressPercentage(BigDecimal.ZERO);
        }
        if (stateFlowPayload.getState() == 3) {
            stateFlowPayload.setProgressPercentage(new BigDecimal("100"));
        }
        if (stateFlowPayload.getState() == 2 && null == stateFlowPayload.getProgressPercentage()) {
            stateFlowPayload.setProgressPercentage(new BigDecimal("10"));
        }
        Long res = this.stateFlowDao.update(stateFlowPayload);
        return res;
    }

    @Override
    public List<StateFlowVO> getListByDtl(StateFlowQuery stateFlowQuery) {
        List<StateFlowVO> list = this.getList(stateFlowQuery);
        list.forEach(x -> {
            StateFlowConfigQuery stateFlowConfigQuery = new StateFlowConfigQuery();
            stateFlowConfigQuery.setFlowId(x.getId());
            List<StateFlowConfigVO> dtlList = this.stateFlowConfigService.getList(stateFlowConfigQuery);
            x.setStateFlowConfigVOList(dtlList);
        });
        return list;
    }

    @Override
    public StateFlowVO getDefStateFlow(StateFlowQuery stateFlowQuery) {
        StateFlowVO stateFlowVO = this.stateFlowDao.getDefStateFlow(stateFlowQuery);
        return stateFlowVO;
    }

    @Override
    public StateFlowVO getDefStateFlowByScenId(Long sceneId) {
        TaskSceneVO taskSceneVO = this.taskSceneService.queryByKey(sceneId);
        StateFlowQuery stateFlowQuery = new StateFlowQuery();
        stateFlowQuery.setObjId(taskSceneVO.getCategoryId());
        StateFlowVO defStateFlow = this.getDefStateFlow(stateFlowQuery);
        return defStateFlow;
    }

    public StateFlowServiceImpl(StateFlowDao stateFlowDao, StateFlowRepo stateFlowRepo, StateFlowConfigService stateFlowConfigService, TaskSceneService taskSceneService) {
        this.stateFlowDao = stateFlowDao;
        this.stateFlowRepo = stateFlowRepo;
        this.stateFlowConfigService = stateFlowConfigService;
        this.taskSceneService = taskSceneService;
    }
}

