/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.product.controller;

import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea7\u54c1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/product"})
public class PrdProductController {
    private static final Logger log = LoggerFactory.getLogger(PrdProductController.class);
    private final PrdProductService productService;

    @PostMapping
    @ApiOperation(value="\u4ea7\u54c1\u7ba1\u7406-\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody PrdProductPayload payload) {
        return TwOutputUtil.ok(this.productService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u4ea7\u54c1\u7ba1\u7406-\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody PrdProductPayload payload) {
        return TwOutputUtil.ok(this.productService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4ea7\u54c1\u7ba1\u7406-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.productService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u4ea7\u54c1\u7ba1\u7406-\u5206\u9875")
    public TwOutputUtil paging(PrdProductQuery query) {
        return TwOutputUtil.ok(this.productService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u4ea7\u54c1\u7ba1\u7406-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(PrdProductQuery query) {
        return TwOutputUtil.ok(this.productService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4ea7\u54c1\u7ba1\u7406-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.productService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public PrdProductController(PrdProductService productService) {
        this.productService = productService;
    }
}

