/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.product.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductCasePayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductCaseQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductCaseService;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductCaseVO;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.product.convert.PrdProductCaseConvert;
import com.elitesland.tw.tw5.server.prd.product.dao.PrdProductCaseDAO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductCaseDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductCaseRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PrdProductCaseServiceImpl
extends BaseServiceImpl
implements PrdProductCaseService {
    private static final Logger log = LoggerFactory.getLogger(PrdProductCaseServiceImpl.class);
    private final PrdProductCaseRepo prdProductCaseRepo;
    private final PrdProductCaseDAO prdProductCaseDAO;
    private final FileUtil fileUtil;

    public PagingVO<PrdProductCaseVO> queryPaging(PrdProductCaseQuery query) {
        return this.prdProductCaseDAO.queryPaging(query);
    }

    public List<PrdProductCaseVO> queryListDynamic(PrdProductCaseQuery query) {
        return this.prdProductCaseDAO.queryListDynamic(query);
    }

    public PrdProductCaseVO queryByKey(Long key) {
        PrdProductCaseDO entity = this.prdProductCaseRepo.findById(key).orElseGet(PrdProductCaseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdProductCaseVO vo = PrdProductCaseConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public List<PrdProductCaseVO> queryByProductKey(Long prodId) {
        PrdProductCaseQuery query = new PrdProductCaseQuery();
        query.setProdId(prodId);
        List<PrdProductCaseVO> prdProductCaseVOS = this.prdProductCaseDAO.queryListDynamic(query);
        this.setFileData(prdProductCaseVOS);
        return prdProductCaseVOS;
    }

    private void setFileData(List<PrdProductCaseVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (PrdProductCaseVO vo : list) {
            vo.setCasePicData(this.fileUtil.getFileDatas(vo.getCasePicPath()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdProductCaseVO insert(PrdProductCasePayload payload) {
        PrdProductCaseDO entityDo = PrdProductCaseConvert.INSTANCE.toDo(payload);
        return PrdProductCaseConvert.INSTANCE.toVo((PrdProductCaseDO)this.prdProductCaseRepo.save(entityDo));
    }

    public List<PrdProductCaseVO> insertAll(List<PrdProductCasePayload> list) {
        List<PrdProductCaseDO> entityDoList = PrdProductCaseConvert.INSTANCE.toDo(list);
        return PrdProductCaseConvert.INSTANCE.toVo(this.prdProductCaseRepo.saveAll(entityDoList));
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdProductCaseVO update(PrdProductCasePayload payload) {
        PrdProductCaseDO entity = this.prdProductCaseRepo.findById(payload.getId()).orElseGet(PrdProductCaseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdProductCaseDO entityDo = PrdProductCaseConvert.INSTANCE.toDo(payload);
        return PrdProductCaseConvert.INSTANCE.toVo((PrdProductCaseDO)this.prdProductCaseRepo.save(entityDo));
    }

    public List<PrdProductCaseVO> updateAll(List<PrdProductCasePayload> payloads) {
        List<PrdProductCaseDO> prdProductCaseDOS = PrdProductCaseConvert.INSTANCE.toDo(payloads);
        return PrdProductCaseConvert.INSTANCE.toVo(this.prdProductCaseRepo.saveAll(prdProductCaseDOS));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.prdProductCaseDAO.deleteSoft(keys);
        }
    }

    public PrdProductCaseServiceImpl(PrdProductCaseRepo prdProductCaseRepo, PrdProductCaseDAO prdProductCaseDAO, FileUtil fileUtil) {
        this.prdProductCaseRepo = prdProductCaseRepo;
        this.prdProductCaseDAO = prdProductCaseDAO;
        this.fileUtil = fileUtil;
    }
}

