/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.provacation.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.provacation.convert.ProVacationConvert;
import com.elitesland.tw.tw5.server.prd.provacation.model.entity.ProVacationDO;
import com.elitesland.tw.tw5.server.prd.provacation.model.payload.ProVacationPayload;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationVO;
import com.elitesland.tw.tw5.server.prd.provacation.repo.ProVacationRepo;
import com.elitesland.tw.tw5.server.prd.provacation.repo.dao.ProVacationDao;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProVacationServiceImpl
implements ProVacationService {
    private static final Logger log = LoggerFactory.getLogger(ProVacationServiceImpl.class);
    private final ProVacationDao proVacationDao;
    private final ProVacationRepo proVacationRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ProVacationVO save(ProVacationPayload proVacationPayload) {
        this.checkData(proVacationPayload);
        if (null == proVacationPayload.getWorkHours()) {
            proVacationPayload.setWorkHours(new BigDecimal("8"));
        }
        ProVacationDO proVacationDO = new ProVacationDO();
        proVacationDO = ProVacationConvert.INSTANCE.p2d(proVacationPayload);
        Long count = this.proVacationDao.updateVacationByDate(proVacationDO);
        if (count == 0L) {
            ProVacationDO proVacationDO2 = (ProVacationDO)((Object)this.proVacationRepo.save((Object)proVacationDO));
        }
        return null;
    }

    @Override
    @Transactional
    public Boolean saveAll(List<ProVacationPayload> proVacationPayloadList, Long projectId, Integer year) {
        ArrayList insertList = new ArrayList();
        Assert.notNull((Object)year, (String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.proVacationDao.delByProId(projectId, year);
        proVacationPayloadList.forEach(x -> {
            this.checkData((ProVacationPayload)((Object)x));
            if (null == x.getWorkHours()) {
                x.setWorkHours(new BigDecimal("8"));
            }
            ProVacationDO proVacationDO = new ProVacationDO();
            proVacationDO = ProVacationConvert.INSTANCE.p2d((ProVacationPayload)((Object)x));
            insertList.add(proVacationDO);
        });
        if (CollUtil.isNotEmpty(insertList)) {
            this.proVacationRepo.saveAll(insertList);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ProVacationVO updateAll(ProVacationPayload proVacationPayload) {
        Assert.notNull((Object)proVacationPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        ProVacationVO res = this.save(proVacationPayload);
        return res;
    }

    @Override
    public ProVacationVO get(Long id) {
        if (null == id) {
            return null;
        }
        ProVacationVO res = this.proVacationDao.get(id);
        return res;
    }

    @Override
    public PagingVO<ProVacationVO> page(ProVacationQuery proVacationQuery) {
        PagingVO<ProVacationVO> res = this.proVacationDao.page(proVacationQuery);
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.proVacationDao.del(ids);
        return res;
    }

    @Override
    public List<ProVacationVO> getList(ProVacationQuery proVacationQuery) {
        Assert.notNull((Object)proVacationQuery.getProjectId(), (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ProVacationVO> res = this.proVacationDao.getList(proVacationQuery);
        return res;
    }

    private void checkData(ProVacationPayload proVacationPayload) {
        Assert.notNull((Object)proVacationPayload.getType(), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)proVacationPayload.getProjectId(), (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(ProVacationPayload proVacationPayload) {
        Assert.notNull((Object)proVacationPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.proVacationDao.update(proVacationPayload);
        return res;
    }

    public ProVacationServiceImpl(ProVacationDao proVacationDao, ProVacationRepo proVacationRepo) {
        this.proVacationDao = proVacationDao;
        this.proVacationRepo = proVacationRepo;
    }
}

