/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.workflow;

import com.elitesland.tw.tw5.api.prd.humanresources.service.ResWithdrawApplyService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentSlipService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentPlanService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchasePaymentDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchasePaymentPlanDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchasePaymentPlanRepo;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rpc/workflow/DIB_PUR_PAYMENT_PAY/callBack", "/rpc/workflow/DIB_PUR_ADVANCE_PAY/callBack", "/rpc/workflow/DIB_PUR_ADVANCE_PAY_W_O/callBack"})
@Transactional
public class PaymentApplyWorkFlowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PaymentApplyWorkFlowCallBackController.class);
    private final PurchasePaymentService service;
    private final PaymentSlipService paymentSlipService;
    private final PurchasePaymentPlanRepo purchasePaymentPlanRepo;
    private final PurchasePaymentDAO purchasePaymentDAO;
    private final ResWithdrawApplyService resWithdrawApplyService;
    private final PurchasePaymentPlanService purchasePaymentPlanService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        block19: {
            PurchasePaymentPayload purchasePaymentPayload;
            block20: {
                Long businessKey;
                log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
                try {
                    businessKey = Long.valueOf(payload.getBusinessKey());
                }
                catch (Exception e) {
                    throw TwException.error("", "\u4e1a\u52a1key\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
                }
                ProcInstStatus procInstStatus = payload.getProcInstStatus();
                purchasePaymentPayload = new PurchasePaymentPayload();
                purchasePaymentPayload.setId(businessKey);
                PurchasePaymentVO purchasePaymentVO = this.service.queryByKey(businessKey);
                if (purchasePaymentVO == null) break block19;
                block1 : switch (procInstStatus) {
                    case NOTSUBMIT: {
                        purchasePaymentPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                        purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.CREATE.getCode());
                        break;
                    }
                    case INTERRUPT: {
                        purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.CREATE.getCode());
                        purchasePaymentPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                        break;
                    }
                    case INVALID: {
                        purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.CREATE.getCode());
                        this.service.deleteSoft(businessKey, Boolean.valueOf(true));
                        log.info("\u4ed8\u6b3e\u7533\u8bf7\u5355\u6d41\u7a0b\u4f5c\u5e9f\uff0c\u4e1a\u52a1id\u4e3a{}", (Object)businessKey);
                        return WorkflowResult.success(null);
                    }
                    case REJECTED: {
                        purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.APPROVING.getCode());
                        purchasePaymentPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                        break;
                    }
                    case APPROVED: {
                        purchasePaymentPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                        purchasePaymentPayload.setApprovedTime(LocalDateTime.now());
                        purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.APPROVED.getCode());
                        this.paymentSlipService.updateStatusByPaymentApplyId(businessKey, PurchasePaymentEnum.PaymentSlipStatus.READY.getCode());
                        String paymentApplicationType = purchasePaymentVO.getPaymentApplicationType();
                        switch (PurchasePaymentEnum.PaymentType.match(paymentApplicationType)) {
                            case CONTRACT: {
                                this.paymentPlanSplit(purchasePaymentVO.getPurchasePaymentPlanVOS());
                                break;
                            }
                            case ADVANCE_PAY: {
                                if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType())) {
                                    this.paymentPlanSplit(purchasePaymentVO.getPurchasePaymentPlanVOS());
                                    break;
                                }
                                break block20;
                            }
                            case ADVANCE_PAY_WRITE_OFF: {
                                String prePaymentNo = purchasePaymentVO.getPrePaymentNo();
                                if (prePaymentNo == null) break block1;
                                BigDecimal currPaymentAmt = Optional.ofNullable(purchasePaymentVO.getCurrPaymentAmt()).orElse(BigDecimal.ZERO);
                                BigDecimal currPaymentAmtByNo = this.purchasePaymentDAO.findCurrPaymentAmtByNo(prePaymentNo);
                                BigDecimal writeOffAmtByPrePaymentNo = this.purchasePaymentPlanService.findWriteOffAmtByPrePaymentNo(prePaymentNo);
                                BigDecimal bigDecimal = writeOffAmtByPrePaymentNo = writeOffAmtByPrePaymentNo == null ? BigDecimal.ZERO : writeOffAmtByPrePaymentNo;
                                if (currPaymentAmt.add(writeOffAmtByPrePaymentNo).compareTo(currPaymentAmtByNo) >= 0) {
                                    this.purchasePaymentDAO.updatePaymentStatus(prePaymentNo, PurchasePaymentEnum.PaymentStatus.WRITTEN_OFF);
                                    if (!PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType())) break block1;
                                    this.paymentSlipService.closePaymentContract(purchasePaymentVO.getDocNo());
                                    break;
                                }
                                if (currPaymentAmt.add(writeOffAmtByPrePaymentNo).compareTo(BigDecimal.ZERO) > 0) {
                                    this.purchasePaymentDAO.updatePaymentStatus(prePaymentNo, PurchasePaymentEnum.PaymentStatus.WRITE_OFF_PART);
                                    break;
                                }
                                throw TwException.error("", "\u9884\u4ed8\u6b3e\u6838\u9500\u91d1\u989d\u6709\u8bef");
                            }
                            case AGREEMENT: {
                                this.resWithdrawApplyService.updateWithdrawStatusByPaymentApplyId(businessKey, PurchasePaymentEnum.WithdrawStatus.APPROVED.getCode());
                            }
                        }
                        break;
                    }
                    case APPROVING: {
                        purchasePaymentPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                        purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.APPROVING.getCode());
                    }
                }
            }
            log.info("\u6d41\u7a0b\u6267\u884c\uff0c\u4ed8\u6b3e\u7533\u8bf7\u5355\u4fee\u6539\u7ed3\u679c: {}", (Object)purchasePaymentPayload);
            this.service.updateByKeyDynamic(purchasePaymentPayload);
        }
        return WorkflowResult.success(null);
    }

    private void paymentPlanSplit(List<PurchasePaymentPlanVO> purchasePaymentPlanVOS) {
        purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
            BigDecimal paymentAmt = purchasePaymentPlanVO.getPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getPaymentAmt();
            BigDecimal currentPaymentAmt = purchasePaymentPlanVO.getCurrentPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getCurrentPaymentAmt();
            ArrayList<PurchasePaymentPlanDO> purchasePaymentPlanDOS = new ArrayList<PurchasePaymentPlanDO>();
            if (currentPaymentAmt.compareTo(paymentAmt) < 0) {
                PurchasePaymentPlanDO purchasePaymentPlanDO = new PurchasePaymentPlanDO();
                purchasePaymentPlanDO.setPaymentStage(purchasePaymentPlanVO.getPaymentStage());
                purchasePaymentPlanDO.setPaymentAmt(paymentAmt.subtract(currentPaymentAmt));
                purchasePaymentPlanDO.setCurrentPaymentAmt(BigDecimal.ZERO);
                purchasePaymentPlanDO.setEstimatedPaymentDate(purchasePaymentPlanVO.getEstimatedPaymentDate());
                purchasePaymentPlanDO.setContractId(purchasePaymentPlanVO.getContractId());
                purchasePaymentPlanDO.setContractNo(purchasePaymentPlanVO.getContractNo());
                purchasePaymentPlanDO.setPaymentStatus(PurchasePaymentEnum.PaymentPlanPayStatus.UNPAID.getCode());
                purchasePaymentPlanDO.setMilestone(purchasePaymentPlanVO.getMilestone());
                purchasePaymentPlanDO.setDocType(purchasePaymentPlanVO.getDocType());
                purchasePaymentPlanDO.setContractNode(purchasePaymentPlanVO.getContractNode());
                purchasePaymentPlanDOS.add(purchasePaymentPlanDO);
            }
            if (purchasePaymentPlanDOS.size() > 0) {
                this.purchasePaymentPlanRepo.saveAll(purchasePaymentPlanDOS);
            }
        });
    }

    public PaymentApplyWorkFlowCallBackController(PurchasePaymentService service, PaymentSlipService paymentSlipService, PurchasePaymentPlanRepo purchasePaymentPlanRepo, PurchasePaymentDAO purchasePaymentDAO, ResWithdrawApplyService resWithdrawApplyService, PurchasePaymentPlanService purchasePaymentPlanService) {
        this.service = service;
        this.paymentSlipService = paymentSlipService;
        this.purchasePaymentPlanRepo = purchasePaymentPlanRepo;
        this.purchasePaymentDAO = purchasePaymentDAO;
        this.resWithdrawApplyService = resWithdrawApplyService;
        this.purchasePaymentPlanService = purchasePaymentPlanService;
    }
}

