/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchieveDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchievePayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConContractPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConAchieveService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConAchieveVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.constants.ConAchieveTypeEnum;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwContractAchieveAllInfoEntity;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwContractAchieveEntity;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConAchieveConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConAchieveDConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.SaleConContractConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConAchieveDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConAchieveDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConAchieveDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConAchieveDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.SaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConAchieveDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConAchieveRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.xxl.job.core.log.XxlJobLogger;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ConAchieveServiceImpl
extends BaseServiceImpl
implements ConAchieveService {
    private static final Logger log = LoggerFactory.getLogger(ConAchieveServiceImpl.class);
    private final ConAchieveRepo conAchieveRepo;
    private final ConAchieveDAO conAchieveDAO;
    private final ConAchieveDDAO conAchieveDDAO;
    private final ConAchieveDRepo conAchieveDRepo;
    @Autowired
    private final SaleConContractService saleConContractService;
    private final SaleConContractRepo saleConContractRepo;
    private final SaleConContractDAO saleConContractDAO;
    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;
    public static final String SIGN = "SIGN";
    private static final String CO = "CO";
    public static final String DELI = "DELI";
    private static final String CODELI = "CODELI";
    public static final String PRE_SALE = "PRE_SALE";

    public PagingVO<ConAchieveVO> queryPaging(ConAchieveQuery query) {
        return this.conAchieveDAO.queryPaging(query);
    }

    public List<ConAchieveVO> queryListDynamic(ConAchieveQuery query) {
        return this.conAchieveDAO.queryListDynamic(query);
    }

    public ConAchieveVO queryByKey(Long key) {
        ConAchieveDO entity = this.conAchieveRepo.findById(key).orElseGet(ConAchieveDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConAchieveVO vo = ConAchieveConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConAchieveVO insert(ConAchievePayload payload) {
        ConAchieveDO entityDo = ConAchieveConvert.INSTANCE.toDo(payload);
        return ConAchieveConvert.INSTANCE.toVo((ConAchieveDO)this.conAchieveRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConAchieveVO update(ConAchievePayload payload) {
        ConAchieveDO entity = this.conAchieveRepo.findById(payload.getId()).orElseGet(ConAchieveDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConAchieveDO entityDo = ConAchieveConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ConAchieveConvert.INSTANCE.toVo((ConAchieveDO)this.conAchieveRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conAchieveDAO.deleteSoft(keys);
        }
    }

    public ConAchieveVO queryByContractId(Long contractId) {
        ConAchieveVO vo = this.conAchieveDAO.queryByContractId(contractId);
        if (vo == null) {
            return null;
        }
        List<ConAchieveDVO> dvos = this.conAchieveDDAO.queryByAchieveId(vo.getId());
        vo.setConAchieveDVOS(dvos);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConAchieveVO saveAchieve(ConAchievePayload payload) {
        if (payload.getId() == null) {
            payload.setAchieveStatus("unhandled");
        } else {
            payload.setAchieveStatus("handled");
        }
        BigDecimal amt = payload.getAmt() == null ? BigDecimal.ZERO : payload.getAmt();
        ConAchieveDO save = (ConAchieveDO)this.conAchieveRepo.save(ConAchieveConvert.INSTANCE.toDo(payload));
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(payload.getContractId(), new Boolean[0]);
        SaleConContractPayload contractPayload = SaleConContractConvert.INSTANCE.toPayload(saleConContractVO);
        contractPayload.setAmt(amt);
        SaleConContractPayload saleConContractPayload = this.saleConContractService.subAmtCount(contractPayload);
        BigDecimal effectiveAmt = saleConContractPayload.getEffectiveAmt();
        this.conAchieveDAO.updateConAmt(amt, effectiveAmt, payload.getContractId());
        List conAchieveDPayloads = payload.getConAchieveDPayloads();
        if (conAchieveDPayloads != null) {
            for (ConAchieveDPayload conAchieveDPayload : conAchieveDPayloads) {
                ConAchieveDDO subDo = ConAchieveDConvert.INSTANCE.toDo(conAchieveDPayload);
                subDo.setAchieveId(save.getId());
                this.conAchieveDDAO.save(subDo);
            }
        }
        return ConAchieveConvert.INSTANCE.toVo(save);
    }

    public void syncConAchieveTo4(String param) {
        LocalDateTime syncTime;
        String syncType = "con_achieve_to4";
        syncTime = StringUtils.hasText((String)param) ? LocalDateTime.parse(param) : ((syncTime = this.daoLog.queryOrgSyncLog(syncType)) == null ? LocalDateTime.of(2023, 7, 1, 0, 0) : syncTime.minusSeconds(120L));
        XxlJobLogger.log((String)"\u4e1a\u7ee9\u7edf\u8ba1\u540c\u6b65\u52304.0\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncConAchieveTo4 localDateTime\uff1a" + syncTime), (Object[])new Object[0]);
        String format = DateUtil.format((LocalDateTime)syncTime, (String)"yyyy-MM-dd HH:mm:ss");
        List<ConAchieveDO> querySyncDatas = this.conAchieveRepo.findByModifyTimeStart(format);
        Object syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(querySyncDatas)) {
            Map<Long, Long> v4AndV5UserIds = this.employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            Map<Long, Long> v4AndV5OrgIds = this.orgService.getV4AndV5OrgIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            ArrayList<TwContractAchieveAllInfoEntity> copy = new ArrayList<TwContractAchieveAllInfoEntity>();
            for (ConAchieveDO tempDo : querySyncDatas) {
                SaleConContractDO saleConContractVO;
                TwContractAchieveAllInfoEntity e = new TwContractAchieveAllInfoEntity();
                e.setAchieveIdV5(tempDo.getId());
                List<ConAchieveDDO> conAchieveDVOS = this.conAchieveDRepo.findConAchieveByAchieveId(tempDo.getId());
                if (!ObjectUtils.isEmpty(conAchieveDVOS)) {
                    ArrayList<TwContractAchieveEntity> detail = new ArrayList<TwContractAchieveEntity>();
                    conAchieveDVOS.stream().forEach(item -> {
                        TwContractAchieveEntity view = new TwContractAchieveEntity();
                        if (tempDo.getContractId() != null) {
                            view.setContractId(tempDo.getContractId().intValue());
                        }
                        view.setAchieveIdV5(item.getId());
                        view.setBuType(item.getBuType());
                        if (v4AndV5OrgIds.get(item.getBuId()) != null) {
                            view.setBuId(((Long)v4AndV5OrgIds.get(item.getBuId())).intValue());
                        }
                        view.setCountType(item.getAchieveType());
                        if (v4AndV5UserIds.get(item.getChargeResId()) != null) {
                            view.setChargeResId(((Long)v4AndV5UserIds.get(item.getChargeResId())).intValue());
                        }
                        view.setRatio(item.getRatio());
                        view.setAmt(item.getAmt());
                        view.setAchieveIdV4(item.getAchievedIdV4());
                        view.setRemark(item.getRemark());
                        view.setDelFlag(item.getDeleteFlag());
                        view.setValueRole(item.getValueRole());
                        detail.add(view);
                    });
                    e.setDetail(detail);
                }
                if ((saleConContractVO = this.saleConContractRepo.findContractById(tempDo.getContractId())) != null) {
                    e.setContractId(tempDo.getContractId());
                    e.setAchieveStatus(tempDo.getAchieveStatus());
                    e.setObversionedEffectiveAmt(tempDo.getObversionEffectiveAmt());
                }
                copy.add(e);
            }
            if (!ObjectUtils.isEmpty(copy)) {
                int failNum = 0;
                for (TwContractAchieveAllInfoEntity temDo : copy) {
                    LocalDateTime syncStartTime = LocalDateTime.now();
                    try {
                        Map<String, Object> map = BeanUtil.beanToMap(temDo);
                        HashMap data = new HashMap();
                        if (("" + data.get("ok")).equals("true")) continue;
                        throw new Exception();
                    }
                    catch (Exception e) {
                        XxlJobLogger.log((String)("\u4e1a\u7ee9\u7edf\u8ba1" + temDo.getAchieveIdV5() + "\u540c\u6b65\u5f02\u5e38......" + e), (Object[])new Object[0]);
                        LocalDateTime syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "\u4e1a\u7ee9\u7edf\u8ba1id" + temDo.getAchieveIdV5() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + e, null);
                        ++failNum;
                        this.conAchieveRepo.updateRemark(temDo.getAchieveIdV5());
                    }
                }
                syncData = "\u66f4\u65b0\u4e86" + (copy.size() - failNum) + "\u6570\u636e,\u6709" + failNum + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01";
            } else {
                syncData = "\u4e1a\u7ee9\u7edf\u8ba1\u6570\u636e\u672a\u53d8\u5316";
            }
        } else {
            syncData = "\u4e1a\u7ee9\u7edf\u8ba1\u6570\u636e\u672a\u53d8\u5316";
        }
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, (String)syncData, syncNow);
        XxlJobLogger.log((String)("\u540c\u6b65\u4e1a\u7ee9\u7edf\u8ba1\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        this.daoLog.save(logDO);
        return logDO;
    }

    public List<ConAchieveDVO> initSignAndDeli(Long contractId) {
        Long preSaleBuId;
        Integer number;
        ConAchieveDVO view;
        Long codeliBuId;
        Long deliBuId;
        Integer number2;
        ConAchieveDVO view2;
        Long coSignBuId;
        SaleConContractVO parentCon;
        ArrayList<ConAchieveDVO> result = new ArrayList<ConAchieveDVO>();
        SaleConContractVO saleConContractVO = this.saleConContractDAO.queryByKey(contractId);
        if (saleConContractVO == null) {
            return result;
        }
        Long signBuId = saleConContractVO.getSignBuId();
        if (signBuId != null) {
            ConAchieveDVO view3 = new ConAchieveDVO();
            view3.setBuId(signBuId);
            view3.setAchieveType(SIGN);
            view3.setChargeResId(saleConContractVO.getSaleManUserId());
            Integer number3 = new Random().nextInt(900000) + 100000;
            view3.setId(Long.valueOf(System.currentTimeMillis() + (long)number3.intValue()));
            result.add(view3);
        }
        if ((parentCon = this.saleConContractDAO.queryByKey(saleConContractVO.getParentId())) != null && (coSignBuId = parentCon.getCoSignBuId()) != null) {
            view2 = new ConAchieveDVO();
            view2.setBuId(coSignBuId);
            view2.setAchieveType(CO);
            view2.setChargeResId(parentCon.getCoSignUserId());
            number2 = new Random().nextInt(900000) + 100000;
            view2.setId(Long.valueOf(System.currentTimeMillis() + (long)number2.intValue()));
            result.add(view2);
        }
        if ((deliBuId = saleConContractVO.getDeliBuId()) != null) {
            view2 = new ConAchieveDVO();
            view2.setBuId(deliBuId);
            view2.setAchieveType(DELI);
            view2.setChargeResId(saleConContractVO.getDeliUserId());
            number2 = new Random().nextInt(900000) + 100000;
            view2.setId(Long.valueOf(System.currentTimeMillis() + (long)number2.intValue()));
            result.add(view2);
        }
        if (parentCon != null && (codeliBuId = parentCon.getCodeliBuId()) != null) {
            view = new ConAchieveDVO();
            view.setBuId(codeliBuId);
            view.setAchieveType(CODELI);
            view.setChargeResId(parentCon.getCodeliUserId());
            number = new Random().nextInt(900000) + 100000;
            view.setId(Long.valueOf(System.currentTimeMillis() + (long)number.intValue()));
            result.add(view);
        }
        if ((preSaleBuId = saleConContractVO.getPreSaleBuId()) != null) {
            view = new ConAchieveDVO();
            view.setBuId(preSaleBuId);
            view.setAchieveType(PRE_SALE);
            view.setChargeResId(saleConContractVO.getPreSaleUserId());
            number = new Random().nextInt(900000) + 100000;
            view.setId(Long.valueOf(System.currentTimeMillis() + (long)number.intValue()));
            result.add(view);
        }
        return result;
    }

    public List<ConAchieveDVO> initSignAndDeliDib(Long contractId, BigDecimal obversionEffectiveAmt) {
        Long deliBuId;
        Long signBuId;
        ArrayList<ConAchieveDVO> result = new ArrayList<ConAchieveDVO>();
        SaleConContractVO saleConContractVO = this.saleConContractDAO.queryByKey(contractId);
        if (saleConContractVO == null) {
            return result;
        }
        BigDecimal amt = saleConContractVO.getAmt();
        if (null == obversionEffectiveAmt) {
            obversionEffectiveAmt = amt;
        }
        if ((signBuId = saleConContractVO.getSignBuId()) != null) {
            ConAchieveDVO view = new ConAchieveDVO();
            view.setBuId(signBuId);
            view.setAchieveType(ConAchieveTypeEnum.SIGN.getCode());
            view.setRatio("100");
            view.setAmt(obversionEffectiveAmt);
            view.setUserRatio("100");
            view.setUserAmt(obversionEffectiveAmt);
            Integer number = new Random().nextInt(900000) + 100000;
            view.setId(Long.valueOf(System.currentTimeMillis() + (long)number.intValue()));
            result.add(view);
        }
        if ((deliBuId = saleConContractVO.getDeliBuId()) != null) {
            ConAchieveDVO view = new ConAchieveDVO();
            view.setBuId(deliBuId);
            view.setRatio("100");
            view.setAmt(obversionEffectiveAmt);
            view.setUserRatio("100");
            view.setUserAmt(obversionEffectiveAmt);
            view.setAchieveType(ConAchieveTypeEnum.RETURN.getCode());
            Integer number = new Random().nextInt(900000) + 100000;
            view.setId(Long.valueOf(System.currentTimeMillis() + (long)number.intValue()));
            result.add(view);
        }
        return result;
    }

    public ConAchieveServiceImpl(ConAchieveRepo conAchieveRepo, ConAchieveDAO conAchieveDAO, ConAchieveDDAO conAchieveDDAO, ConAchieveDRepo conAchieveDRepo, SaleConContractService saleConContractService, SaleConContractRepo saleConContractRepo, SaleConContractDAO saleConContractDAO, HttpUtil httpUtil, PrdOrgSyncLogDAO daoLog, PrdOrgEmployeeService employeeService, PrdOrgOrganizationService orgService) {
        this.conAchieveRepo = conAchieveRepo;
        this.conAchieveDAO = conAchieveDAO;
        this.conAchieveDDAO = conAchieveDDAO;
        this.conAchieveDRepo = conAchieveDRepo;
        this.saleConContractService = saleConContractService;
        this.saleConContractRepo = saleConContractRepo;
        this.saleConContractDAO = saleConContractDAO;
        this.httpUtil = httpUtil;
        this.daoLog = daoLog;
        this.employeeService = employeeService;
        this.orgService = orgService;
    }
}

