/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.controller;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoCountVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskProBoardVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4efb\u52a1\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/taskInfo"})
public class TaskInfoController {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoController.class);
    private final TaskInfoService taskInfoService;

    @PostMapping(value={"/updateTask"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1")
    public TwOutputUtil updateTask(@RequestBody TaskInfoPayload taskInfoPayload) {
        this.taskInfoService.updateTask(taskInfoPayload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/batchAddTask"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u4efb\u52a1")
    public TwOutputUtil addTask(@RequestBody TaskPayload taskPayload) {
        this.taskInfoService.batchAddTask(taskPayload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/taskDetail"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u8be6\u60c5")
    public TwOutputUtil<TaskInfoVO> taskDetail(Long key, Boolean needTaskPackage) {
        return TwOutputUtil.ok(this.taskInfoService.queryByKey(key, needTaskPackage));
    }

    @GetMapping(value={"/taskList"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u5217\u8868")
    public TwOutputUtil<TaskInfoVO> taskList(TaskInfoQuery taskInfoQuery) {
        return TwOutputUtil.ok(this.taskInfoService.queryList(taskInfoQuery));
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @UdcNameClass
    public TwOutputUtil<PagingVO<TaskInfoVO>> paging(TaskInfoQuery taskInfoQuery) {
        PagingVO taskInfoVOPagingVO = this.taskInfoService.queryPage(taskInfoQuery);
        return TwOutputUtil.ok(taskInfoVOPagingVO);
    }

    @GetMapping(value={"/queryTaskInfoCount"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u7edf\u8ba1")
    public TwOutputUtil<TaskInfoCountVO> queryTaskInfoCount(TaskInfoQuery taskInfoQuery) {
        return TwOutputUtil.ok(this.taskInfoService.queryTaskInfoCount(taskInfoQuery));
    }

    @GetMapping(value={"/queryDeptUserTaskLoadRate"})
    @UdcNameClass
    @ApiOperation(value="\u90e8\u95e8\u6210\u5458\u4efb\u52a1\u8d1f\u8377\u7387")
    public TwOutputUtil<TaskInfoCountVO> queryDeptUserTaskLoadRate(TaskInfoQuery taskInfoQuery) {
        return TwOutputUtil.ok(this.taskInfoService.queryDeptUserTaskLoadRate(taskInfoQuery));
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @PostMapping(value={"/batchExport"})
    @UdcNameClass
    public void permissionBatchExport(HttpServletResponse response, @RequestBody TaskInfoQuery query) throws IOException {
        log.info("\u6279\u91cf\u5bfc\u51faexcel");
        this.taskInfoService.batchExport(response, query);
    }

    @PostMapping(value={"/saveChangeLog"})
    @ApiOperation(value="\u5f53\u91cf\u8c03\u6574--\u53d8\u66f4")
    public TwOutputUtil saveChangeLog(@RequestBody TaskInfoPayload payload) {
        this.taskInfoService.saveChangeLog(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/taskDecompose"})
    @ApiOperation(value="\u4efb\u52a1\u5206\u89e3")
    public TwOutputUtil taskDecompose(@RequestBody TaskPayload taskPayload) {
        this.taskInfoService.taskDecompose(taskPayload);
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u4efb\u52a1-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.taskInfoService.deleteSoft(Arrays.asList(keys), new Boolean[0]);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/apply"})
    @ApiOperation(value="\u4efb\u52a1\u7533\u8bf7")
    public TwOutputUtil apply(@RequestBody TaskPayload taskPayload) {
        this.taskInfoService.taskApply(taskPayload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/taskFinish"})
    @ApiOperation(value="\u4efb\u52a1\u5b8c\u5de5\u7533\u8bf7")
    public TwOutputUtil finish(Long[] keys) {
        this.taskInfoService.taskFinish(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/taskClose"})
    @ApiOperation(value="\u4efb\u52a1\u5173\u95ed")
    public TwOutputUtil taskClose(Long[] keys) {
        this.taskInfoService.taskClose(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/operationTaskFinish"})
    @ApiOperation(value="\u5904\u7406\u4efb\u52a1\u5b8c\u5de5\u7533\u8bf7")
    public TwOutputUtil operationTaskFinish(Long key, String operationStatus) {
        this.taskInfoService.operationTaskFinish(key, operationStatus);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/updateTaskProgress"})
    @ApiOperation(value="\u66f4\u6539\u4efb\u52a1\u8fdb\u5ea6")
    public TwOutputUtil updateTaskProgress(Long key, BigDecimal progress) {
        this.taskInfoService.updateTaskProgress(key, progress);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/taskAssign"})
    @ApiOperation(value="\u4efb\u52a1\u6d3e\u53d1")
    public TwOutputUtil taskAssign(Long[] keys) {
        this.taskInfoService.taskAssign(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryListCommon"})
    @UdcNameClass
    @ApiOperation(value="\u901a\u7528\u4efb\u52a1\u5217\u8868")
    public TwOutputUtil<TaskInfoVO> queryListCommon(TaskInfoQuery taskInfoQuery) {
        return TwOutputUtil.ok(this.taskInfoService.queryListCommon(taskInfoQuery));
    }

    @GetMapping(value={"boardView"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u770b\u677f")
    public TwOutputUtil boardView(TaskInfoQuery taskInfoQuery) {
        Assert.notNull((Object)taskInfoQuery.getTaskSceneId(), (String)"\u4efb\u52a1\u573a\u666fid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List res = this.taskInfoService.boardView(taskInfoQuery);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"/queryTaskInfoView"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u770b\u677f\u89c6\u56fe")
    public TwOutputUtil<List<TaskProBoardVO>> queryTaskInfoView(TaskInfoQuery taskInfoQuery) {
        List res = this.taskInfoService.queryTaskInfoView(taskInfoQuery);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"taskGroupView"})
    @UdcNameClass
    @ApiOperation(value="\u4efb\u52a1\u5206\u7ec4\u67e5\u8be2")
    public TwOutputUtil taskGroupView(TaskInfoQuery taskInfoQuery) {
        Assert.notNull((Object)taskInfoQuery.getReasonId(), (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List res = this.taskInfoService.taskGroupView(taskInfoQuery);
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"/updateTaskStateFlow"})
    @ApiOperation(value="\u66f4\u6539\u4efb\u52a1\u72b6\u6001\u6d41")
    public TwOutputUtil updateTaskStateFlowId(@RequestBody TaskInfoPayload taskInfoPayload) {
        Long res = this.taskInfoService.updateTaskStateFlowId(taskInfoPayload);
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"/updateTaskGroup"})
    @ApiOperation(value="\u66f4\u6539\u4efb\u52a1\u5206\u7ec4")
    public TwOutputUtil updateTaskGroup(@RequestBody TaskInfoPayload taskInfoPayload) {
        Long res = this.taskInfoService.updateTaskGroup(taskInfoPayload);
        return TwOutputUtil.ok(res);
    }

    @PostMapping(value={"/updateDynamic"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1")
    public TwOutputUtil updateDynamic(@RequestBody TaskInfoPayload taskInfoPayload) {
        this.taskInfoService.updateDynamic(taskInfoPayload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/relateList"})
    @UdcNameClass
    @ApiOperation(value="\u5173\u8054\u4efb\u52a1\u5217\u8868")
    public TwOutputUtil<List<TaskInfoVO>> relateList(Long id) {
        return TwOutputUtil.ok(this.taskInfoService.relateList(id));
    }

    public TaskInfoController(TaskInfoService taskInfoService) {
        this.taskInfoService = taskInfoService;
    }
}

