/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsWbsTaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsWbsTaskQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsWbsTaskVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPmsProjectRoleDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsDO;
import com.elitesland.tw.tw5.server.prd.task.entity.PmsWbsTaskDO;
import com.elitesland.tw.tw5.server.prd.task.entity.QPmsWbsTaskDO;
import com.elitesland.tw.tw5.server.prd.task.repo.PmsWbsTaskRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsWbsTaskDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsWbsTaskRepo repo;
    private final QPmsWbsTaskDO qdo = QPmsWbsTaskDO.pmsWbsTaskDO;
    private final QPmsProjectDO projectQdo = QPmsProjectDO.pmsProjectDO;
    private final QPmsProjectWbsDO wbsQdo = QPmsProjectWbsDO.pmsProjectWbsDO;
    private final QPmsProjectRoleDO roleQdo = QPmsProjectRoleDO.pmsProjectRoleDO;

    private JPAQuery<PmsWbsTaskVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsWbsTaskVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createTime, this.qdo.projectId, this.qdo.wbsId, this.qdo.disterUserId, this.qdo.receiverUserId, this.qdo.taskCode, this.qdo.taskName, this.qdo.taskStatus, this.qdo.startDate, this.qdo.endDate, this.qdo.days, this.qdo.projectRoleId, this.qdo.progress, this.qdo.weight, this.qdo.taskExplain, this.qdo.sourceType, this.qdo.deliveryDocuments, this.qdo.manualSettingWeight, this.projectQdo.projName.as("projectName"), this.wbsQdo.wbsName, this.wbsQdo.managerUserId, this.roleQdo.roleName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.projectQdo)).on((Predicate)this.qdo.projectId.eq(this.projectQdo.id))).leftJoin((EntityPath)this.wbsQdo)).on((Predicate)this.qdo.wbsId.eq(this.wbsQdo.id))).leftJoin((EntityPath)this.roleQdo)).on((Predicate)this.qdo.projectRoleId.eq(this.roleQdo.id));
    }

    private JPAQuery<PmsWbsTaskVO> getJpaQueryWhere(PmsWbsTaskQuery query) {
        JPAQuery<PmsWbsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsWbsTaskQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsWbsTaskQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectName())) {
            list.add(this.projectQdo.projName.like(SqlUtil.toSqlLikeString(query.getProjectName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsId())) {
            list.add(this.qdo.wbsId.eq((Object)query.getWbsId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManagerUserId())) {
            list.add(this.wbsQdo.managerUserId.eq((Object)query.getManagerUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            list.add(this.qdo.sourceType.eq((Object)query.getSourceType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDisterUserId())) {
            list.add(this.qdo.disterUserId.eq((Object)query.getDisterUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceiverUserId())) {
            list.add(this.qdo.receiverUserId.eq((Object)query.getReceiverUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskCode())) {
            list.add(this.qdo.taskCode.like(SqlUtil.toSqlLikeString(query.getTaskCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskName())) {
            list.add(this.qdo.taskName.like(SqlUtil.toSqlLikeString(query.getTaskName())));
        }
        if (ObjectUtils.isEmpty((Object)query.getTaskStatusType())) {
            query.setTaskStatusType("1");
        }
        if (!ObjectUtils.isEmpty((Object)query.getTaskStatus())) {
            if ("0".equals(query.getTaskStatusType())) {
                list.add(this.qdo.taskStatus.ne((Object)query.getTaskStatus()));
            } else {
                list.add(this.qdo.taskStatus.eq((Object)query.getTaskStatus()));
            }
        }
        if (!ObjectUtils.isEmpty((Object[])query.getTaskStatusList())) {
            if ("0".equals(query.getTaskStatusType())) {
                list.add(this.qdo.taskStatus.notIn((Object[])query.getTaskStatusList()));
            } else {
                list.add(this.qdo.taskStatus.in((Object[])query.getTaskStatusList()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartDate())) {
            list.add(this.qdo.startDate.eq((Object)query.getStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndDate())) {
            list.add(this.qdo.endDate.eq((Object)query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDays())) {
            list.add(this.qdo.days.eq((Object)query.getDays()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectRoleId())) {
            list.add(this.qdo.projectRoleId.eq((Object)query.getProjectRoleId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsWbsTaskVO queryByKey(Long id) {
        JPAQuery<PmsWbsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsWbsTaskVO)jpaQuery.fetchFirst();
    }

    public List<PmsWbsTaskVO> queryByKeys(List<Long> keys) {
        JPAQuery<PmsWbsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(keys));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsWbsTaskVO> findByWbsIds(List<Long> wbsIds) {
        JPAQuery<PmsWbsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.wbsId.in(wbsIds));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsWbsTaskVO> queryByWbsId(Long wbsId) {
        JPAQuery<PmsWbsTaskVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.wbsId.in((Object[])new Long[]{wbsId}));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsWbsTaskVO> queryListDynamic(PmsWbsTaskQuery query) {
        JPAQuery<PmsWbsTaskVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsWbsTaskVO> queryPaging(PmsWbsTaskQuery query) {
        JPAQuery<PmsWbsTaskVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public PmsWbsTaskDO save(PmsWbsTaskDO ado) {
        return (PmsWbsTaskDO)this.repo.save(ado);
    }

    public List<PmsWbsTaskDO> saveAll(List<PmsWbsTaskDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsWbsTaskPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getProjectId() != null) {
            update.set(this.qdo.projectId, (Object)payload.getProjectId());
        }
        if (payload.getWbsId() != null) {
            update.set(this.qdo.wbsId, (Object)payload.getWbsId());
        }
        if (payload.getSourceType() != null) {
            update.set((Path)this.qdo.sourceType, (Object)payload.getSourceType());
        }
        if (payload.getDisterUserId() != null) {
            update.set(this.qdo.disterUserId, (Object)payload.getDisterUserId());
        }
        if (payload.getReceiverUserId() != null) {
            update.set(this.qdo.receiverUserId, (Object)payload.getReceiverUserId());
        }
        if (payload.getTaskCode() != null) {
            update.set((Path)this.qdo.taskCode, (Object)payload.getTaskCode());
        }
        if (payload.getTaskName() != null) {
            update.set((Path)this.qdo.taskName, (Object)payload.getTaskName());
        }
        if (payload.getTaskStatus() != null) {
            update.set((Path)this.qdo.taskStatus, (Object)payload.getTaskStatus());
        }
        if (payload.getStartDate() != null) {
            update.set(this.qdo.startDate, (Object)payload.getStartDate());
        }
        if (payload.getEndDate() != null) {
            update.set(this.qdo.endDate, (Object)payload.getEndDate());
        }
        if (payload.getDays() != null) {
            update.set(this.qdo.days, (Object)payload.getDays());
        }
        if (payload.getProjectRoleId() != null) {
            update.set(this.qdo.projectRoleId, (Object)payload.getProjectRoleId());
        }
        if (payload.getProgress() != null) {
            update.set(this.qdo.progress, (Object)payload.getProgress());
        }
        if (payload.getWeight() != null) {
            update.set(this.qdo.weight, (Object)payload.getWeight());
        }
        if (payload.getTaskExplain() != null) {
            update.set((Path)this.qdo.taskExplain, (Object)payload.getTaskExplain());
        }
        if (payload.getDeliveryDocuments() != null) {
            update.set((Path)this.qdo.deliveryDocuments, (Object)payload.getDeliveryDocuments());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("projectId")) {
                update.setNull(this.qdo.projectId);
            }
            if (nullFields.contains("wbsId")) {
                update.setNull(this.qdo.wbsId);
            }
            if (nullFields.contains("disterUserId")) {
                update.setNull(this.qdo.disterUserId);
            }
            if (nullFields.contains("receiverUserId")) {
                update.setNull(this.qdo.receiverUserId);
            }
            if (nullFields.contains("taskCode")) {
                update.setNull((Path)this.qdo.taskCode);
            }
            if (nullFields.contains("taskName")) {
                update.setNull((Path)this.qdo.taskName);
            }
            if (nullFields.contains("taskStatus")) {
                update.setNull((Path)this.qdo.taskStatus);
            }
            if (nullFields.contains("startDate")) {
                update.setNull(this.qdo.startDate);
            }
            if (nullFields.contains("endDate")) {
                update.setNull(this.qdo.endDate);
            }
            if (nullFields.contains("days")) {
                update.setNull(this.qdo.days);
            }
            if (nullFields.contains("projectRoleId")) {
                update.setNull(this.qdo.projectRoleId);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByWbsIds(List<Long> wbsIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.wbsId.in(wbsIds)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateTaskStatus(List<Long> keys, String taskStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.taskStatus, (Object)taskStatus).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateTaskStatus(List<Long> keys, String taskStatus, BigDecimal progress) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.taskStatus, (Object)taskStatus).set(this.qdo.progress, (Object)progress).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateTaskWeight(Long key, BigDecimal weight) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.weight, (Object)weight).set(this.qdo.manualSettingWeight, (Object)1).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateTaskStatus(List<Long> keys, String taskStatus, long disterUserId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.taskStatus, (Object)taskStatus).set(this.qdo.disterUserId, (Object)disterUserId).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsWbsTaskDAO(JPAQueryFactory jpaQueryFactory, PmsWbsTaskRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

