/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.taskpro.repo.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.QTaskSceneCategoryRefDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskSceneCategoryRefDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskSceneCategoryRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneCategoryRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneCategoryRefVO;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskSceneCategoryRefRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class TaskSceneCategoryRefDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final TaskSceneCategoryRefRepo repo;
    private final QTaskSceneCategoryRefDO qdo = QTaskSceneCategoryRefDO.taskSceneCategoryRefDO;

    private JPAQuery<TaskSceneCategoryRefVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(TaskSceneCategoryRefVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.sceneId, this.qdo.categoryId})).from((EntityPath)this.qdo);
    }

    private JPAQuery<TaskSceneCategoryRefVO> getJpaQueryWhere(TaskSceneCategoryRefQuery query) {
        JPAQuery<TaskSceneCategoryRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(TaskSceneCategoryRefQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(TaskSceneCategoryRefQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSceneId())) {
            list.add(this.qdo.sceneId.eq((Object)query.getSceneId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCategoryId())) {
            list.add(this.qdo.categoryId.eq((Object)query.getCategoryId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public TaskSceneCategoryRefVO queryByKey(Long id) {
        JPAQuery<TaskSceneCategoryRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (TaskSceneCategoryRefVO)jpaQuery.fetchFirst();
    }

    public List<TaskSceneCategoryRefVO> queryListDynamic(TaskSceneCategoryRefQuery query) {
        JPAQuery<TaskSceneCategoryRefVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<TaskSceneCategoryRefVO> queryPaging(TaskSceneCategoryRefQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<TaskSceneCategoryRefVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public TaskSceneCategoryRefDO save(TaskSceneCategoryRefDO ado) {
        return (TaskSceneCategoryRefDO)this.repo.save(ado);
    }

    public List<TaskSceneCategoryRefDO> saveAll(List<TaskSceneCategoryRefDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(TaskSceneCategoryRefPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getSceneId() != null) {
            update.set(this.qdo.sceneId, (Object)payload.getSceneId());
        }
        if (payload.getCategoryId() != null) {
            update.set(this.qdo.categoryId, (Object)payload.getCategoryId());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("sceneId")) {
                update.setNull(this.qdo.sceneId);
            }
            if (nullFields.contains("categoryId")) {
                update.setNull(this.qdo.categoryId);
            }
        }
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long deleteSoftBySceneId(Long sceneId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.sceneId.eq((Object)sceneId)});
        return update.execute();
    }

    public long deleteSoftBySceneIdList(List<Long> sceneIdList) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.sceneId.in(sceneIdList)});
        return update.execute();
    }

    public TaskSceneCategoryRefDAO(JPAQueryFactory jpaQueryFactory, TaskSceneCategoryRefRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

