/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskCategoryConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskCategoryDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskCategoryPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskCategoryQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskCategoryRepo;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.dao.TaskCategoryDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskCategoryService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskProService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TaskCategoryServiceImpl
extends BaseServiceImpl
implements TaskCategoryService {
    private static final Logger log = LoggerFactory.getLogger(TaskCategoryServiceImpl.class);
    private final TaskCategoryRepo taskCategoryRepo;
    private final TaskCategoryDAO taskCategoryDAO;
    private final StateFlowService stateFlowService;
    @Autowired
    @Lazy
    private TaskSceneService taskSceneService;
    @Resource
    @Lazy
    private TaskProService taskProService;

    @Override
    public PagingVO<TaskCategoryVO> queryPaging(TaskCategoryQuery query) {
        return this.taskCategoryDAO.queryPaging(query);
    }

    @Override
    public List<TaskCategoryVO> queryListDynamic(TaskCategoryQuery query) {
        List<TaskCategoryVO> taskCategoryVOS = this.taskCategoryDAO.queryListDynamic(query);
        taskCategoryVOS.forEach(taskCategoryVO -> {
            StateFlowQuery stateFlowQuery = new StateFlowQuery();
            stateFlowQuery.setObjId(taskCategoryVO.getId());
            List<StateFlowVO> stateFlowVOS = this.stateFlowService.getList(stateFlowQuery);
            taskCategoryVO.setStateFlowConfigVOList(stateFlowVOS);
        });
        return taskCategoryVOS;
    }

    @Override
    public TaskCategoryVO queryByKey(Long key) {
        TaskCategoryDO entity = this.taskCategoryRepo.findById(key).orElseGet(TaskCategoryDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4efb\u52a1\u7c7b\u522b\u4e0d\u5b58\u5728");
        TaskCategoryVO vo = TaskCategoryConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaskCategoryVO insert(TaskCategoryPayload payload) {
        this.check(payload);
        this.uniquenessVerification(payload);
        TaskCategoryDO entityDo = TaskCategoryConvert.INSTANCE.toDo(payload);
        return TaskCategoryConvert.INSTANCE.toVo((TaskCategoryDO)this.taskCategoryRepo.save(entityDo));
    }

    private void uniquenessVerification(TaskCategoryPayload payload) {
        TaskCategoryQuery categoryQuery = new TaskCategoryQuery();
        categoryQuery.setNameEq(payload.getName());
        categoryQuery.setIdNeq(payload.getId());
        long count = this.taskCategoryDAO.count(categoryQuery);
        if (count > 0L) {
            throw TwException.error("", "\u8be5\u72b6\u6001\u6d41\u540d\u79f0\u7684\u6570\u636e\u5df2\u5b58\u5728\uff01");
        }
    }

    private void check(TaskCategoryPayload payload) {
        Assert.hasText((String)payload.getName(), (String)"\u4efb\u52a1\u7c7b\u522b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaskCategoryVO update(TaskCategoryPayload payload) {
        TaskCategoryDO entity = this.taskCategoryRepo.findById(payload.getId()).orElseGet(TaskCategoryDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4efb\u52a1\u7c7b\u522b\u4e0d\u5b58\u5728");
        this.check(payload);
        this.uniquenessVerification(payload);
        TaskCategoryDO entityDo = TaskCategoryConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskCategoryConvert.INSTANCE.toVo((TaskCategoryDO)this.taskCategoryRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TaskCategoryPayload payload) {
        TaskCategoryDO entity = this.taskCategoryRepo.findById(payload.getId()).orElseGet(TaskCategoryDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.taskCategoryDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.forEach(key -> {
                TaskSceneQuery taskSceneQuery = new TaskSceneQuery();
                taskSceneQuery.setCategoryId((Long)key);
                Long count = this.taskSceneService.count(taskSceneQuery);
                if (count > 0L) {
                    throw new BusinessException("\u8be5\u72b6\u6001\u6d41\u5df2\u5173\u8054\u4efb\u52a1\u6d41\uff0c\u4e0d\u80fd\u5220\u9664");
                }
            });
            this.taskCategoryDAO.deleteSoft(keys);
        }
    }

    public TaskCategoryServiceImpl(TaskCategoryRepo taskCategoryRepo, TaskCategoryDAO taskCategoryDAO, StateFlowService stateFlowService) {
        this.taskCategoryRepo = taskCategoryRepo;
        this.taskCategoryDAO = taskCategoryDAO;
        this.stateFlowService = stateFlowService;
    }
}

