/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskGroupVO;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskGroupConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskGroupDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskGroupPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskGroupQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskGroupRepo;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.dao.TaskGroupDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskGroupService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TaskGroupServiceImpl
extends BaseServiceImpl
implements TaskGroupService {
    private static final Logger log = LoggerFactory.getLogger(TaskGroupServiceImpl.class);
    private final TaskGroupRepo taskGroupRepo;
    private final TaskGroupDAO taskGroupDAO;

    @Override
    public PagingVO<TaskGroupVO> queryPaging(TaskGroupQuery query) {
        return this.taskGroupDAO.queryPaging(query);
    }

    @Override
    public List<TaskGroupVO> queryListDynamic(TaskGroupQuery query) {
        return this.taskGroupDAO.queryListDynamic(query);
    }

    @Override
    public TaskGroupVO queryByKey(Long key) {
        TaskGroupDO entity = this.taskGroupRepo.findById(key).orElseGet(TaskGroupDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TaskGroupVO vo = TaskGroupConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaskGroupVO insert(TaskGroupPayload payload) {
        TaskGroupDO entityDo = TaskGroupConvert.INSTANCE.toDo(payload);
        return TaskGroupConvert.INSTANCE.toVo((TaskGroupDO)this.taskGroupRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaskGroupVO update(TaskGroupPayload payload) {
        TaskGroupDO entity = this.taskGroupRepo.findById(payload.getId()).orElseGet(TaskGroupDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TaskGroupDO entityDo = TaskGroupConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskGroupConvert.INSTANCE.toVo((TaskGroupDO)this.taskGroupRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TaskGroupPayload payload) {
        TaskGroupDO entity = this.taskGroupRepo.findById(payload.getId()).orElseGet(TaskGroupDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.taskGroupDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.taskGroupDAO.deleteSoft(keys);
        }
    }

    public TaskGroupServiceImpl(TaskGroupRepo taskGroupRepo, TaskGroupDAO taskGroupDAO) {
        this.taskGroupRepo = taskGroupRepo;
        this.taskGroupDAO = taskGroupDAO;
    }
}

