/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerChangeVO;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BusinessPartnerDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/ACC_INVOICE_CHANGE/callBack"})
@Transactional
public class BusinessAccAndInvoiceCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(BusinessAccAndInvoiceCallBackController.class);
    private final BusinessPartnerDAO dao;
    private final BusinessPartnerService service;
    private final ComChangeService changeService;
    private final WorkflowUtil workflowUtil;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u94f6\u884c\u8d26\u6237/\u5f00\u7968\u4fe1\u606f\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ComChangeVO comChangeVO = this.changeService.queryByKey(Long.valueOf(businessKey));
        if (comChangeVO != null) {
            BusinessPartnerChangeVO newVO = (BusinessPartnerChangeVO)JSON.parseObject((String)comChangeVO.getChangeContent(), BusinessPartnerChangeVO.class);
            BusinessPartnerPayload payload0 = new BusinessPartnerPayload();
            payload0.setId(Long.valueOf(comChangeVO.getChangeDocId()));
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(comChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            changePayload.setProcInstId(comChangeVO.getProcInstId());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    changePayload.setChangeContent(JSONObject.toJSONString((Object)newVO));
                    break;
                }
                case INTERRUPT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    break;
                }
                case INVALID: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    changePayload.setDeleteFlag(Integer.valueOf(1));
                    payload0.setNullFields(Arrays.asList("applyStatus"));
                    break;
                }
                case REJECTED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    changePayload.setChangeContent(JSONObject.toJSONString((Object)newVO));
                    break;
                }
                case APPROVED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    payload0.setNullFields(Arrays.asList("applyStatus"));
                    this.service.updateAccAndInvoice(newVO);
                    break;
                }
            }
            this.changeService.updateWorkFlow(changePayload);
            this.dao.updateWorkFlow(payload0);
        }
        return WorkflowResult.success(null);
    }

    public BusinessAccAndInvoiceCallBackController(BusinessPartnerDAO dao, BusinessPartnerService service, ComChangeService changeService, WorkflowUtil workflowUtil) {
        this.dao = dao;
        this.service = service;
        this.changeService = changeService;
        this.workflowUtil = workflowUtil;
    }
}

