/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActReportPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActReportVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/MARKET_END_REPORT/callBack"})
@Transactional
public class MarketEndReportWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(MarketEndReportWorkflowCallBackController.class);
    private final CrmActActivityService actActivityService;
    private final PrdSystemBusinessChangeService changeService;
    private final CrmActActivityDAO actActivityDAO;
    private final PrjProjectDAO projectDAO;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        CrmActReportPayload reportPayload = new CrmActReportPayload();
        reportPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        List crmActReportVOS = this.actActivityService.queryReportByKey(Long.valueOf(businessKey), Integer.valueOf(2));
        if (crmActReportVOS != null && !crmActReportVOS.isEmpty()) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    reportPayload.setReportStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    reportPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    reportPayload.setReportStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    reportPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    reportPayload.setReportStatus(WorkFlowStatusEnum.INVALID.getCode());
                    reportPayload.setDeleteFlag(Integer.valueOf(1));
                    reportPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    reportPayload.setReportStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    reportPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    PrjProjectVO project = this.projectDAO.queryByKey(((CrmActReportVO)crmActReportVOS.get(0)).getProjectId());
                    reportPayload.setReportStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    reportPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    reportPayload.setApprovedTime(LocalDateTime.now());
                    CrmActActivityPayload acPayload = new CrmActActivityPayload();
                    acPayload.setProjectStatus(WorkFlowStatusEnum.CLOSED_WORK.getCode());
                    acPayload.setCloseReason("act_end");
                    this.actActivityDAO.updateProjectByKeyDynamic(acPayload, project.getId());
                    break;
                }
                case APPROVING: {
                    reportPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    reportPayload.setReportStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.actActivityDAO.updateReportyKeyDynamic(reportPayload);
        }
        return WorkflowResult.success(null);
    }

    public MarketEndReportWorkflowCallBackController(CrmActActivityService actActivityService, PrdSystemBusinessChangeService changeService, CrmActActivityDAO actActivityDAO, PrjProjectDAO projectDAO) {
        this.actActivityService = actActivityService;
        this.changeService = changeService;
        this.actActivityDAO = actActivityDAO;
        this.projectDAO = projectDAO;
    }
}

