/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/SALE_CON_CHANGE/callBack"})
@Transactional
public class SaleConChangeWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(SaleConChangeWorkflowCallBackController.class);
    private final SaleConContractService saleConContractService;
    private final SaleConContractDAO saleConContractDAO;
    private final ComChangeService changeService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ComChangeVO comChangeVO = this.changeService.queryByKey(Long.valueOf(businessKey));
        if (comChangeVO != null) {
            SaleConContractVO saleConContractVO = new SaleConContractVO();
            saleConContractVO.setId(Long.valueOf(comChangeVO.getChangeDocId()));
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(comChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            changePayload.setProcInstId(comChangeVO.getProcInstId());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                }
                case INTERRUPT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    saleConContractVO.setChangeFlag(Integer.valueOf(0));
                    this.saleConContractService.updateWorkFlow(saleConContractVO);
                    break;
                }
                case INVALID: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    changePayload.setDeleteFlag(Integer.valueOf(1));
                    saleConContractVO.setChangeFlag(Integer.valueOf(0));
                    this.saleConContractService.updateWorkFlow(saleConContractVO);
                    break;
                }
                case REJECTED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    saleConContractVO = (SaleConContractVO)JSON.parseObject((String)comChangeVO.getChangeContent(), SaleConContractVO.class);
                    saleConContractVO.setChangeFlag(Integer.valueOf(0));
                    saleConContractVO.setApproveFlag(Boolean.valueOf(true));
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    this.saleConContractService.updateWorkFlow(saleConContractVO);
                    break;
                }
            }
            this.changeService.updateWorkFlow(changePayload);
        }
        return WorkflowResult.success(null);
    }

    public SaleConChangeWorkflowCallBackController(SaleConContractService saleConContractService, SaleConContractDAO saleConContractDAO, ComChangeService changeService) {
        this.saleConContractService = saleConContractService;
        this.saleConContractDAO = saleConContractDAO;
        this.changeService = changeService;
    }
}

