package com.elitesland.yst.demo.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "SaleSaveVo", description = "保存销售订单--仅供测试使用")
public class SaleSaveVo  implements Serializable {

    private static final long serialVersionUID = -22172061917237390L;

    @ApiModelProperty("记录唯一ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("订单状态")
    String status;

    @ApiModelProperty("品项编号")
    String itemCode;

    @ApiModelProperty("品项名称")
    String itemName;

    @ApiModelProperty("品项价格")
    String itemPrice;

    @ApiModelProperty("数量")
    Double qty;

    @ApiModelProperty("部门id")
    Long buId;

}
