package com.elitesland.fin.dto.account;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel("订货集分页返回")
public class ScpDemandOrderTitlePageRespRpcVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -4607660124307291057L;

    @ApiModelProperty("订货集编码")
    private String demandCode;

    @ApiModelProperty("订货集名称")
    private String demandName;

    @ApiModelProperty("订货单编码")
    private String docCode;

    @ApiModelProperty("单据类别")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_CLS")
    private String docCls;
    private String docClsName;

    @ApiModelProperty("单据状态")
    @SysCode(sys = "yst-suplan", mod = "DEO_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-suplan", mod = "DEMAND_SET_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("单据类型")
    @SysCode(sys = "yst-suplan", mod = "OB_DOC_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("付款状态")
    @SysCode(sys = "yst-suplan", mod = "PAY_STATUS")
    private String payStatus;
    private String payStatusName;

    @ApiModelProperty("需求仓库id/门店id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long demandWhStId;

    @ApiModelProperty("需求仓库编码/门店编码")
    private String demandWhStCode;

    @ApiModelProperty("需求仓库名称/门店名称")
    private String demandWhStName;

    @ApiModelProperty("需求日期")
    private LocalDateTime demandDate;

    @ApiModelProperty("经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;

    @ApiModelProperty("是否已分配,false-否,true-是")
    private Boolean isCalculated;

    @ApiModelProperty("是否已推送,false-否,true-是")
    private Boolean isPushed;

    public String getIsCalculatedName() {
        return (isCalculated != null && isCalculated) ? "已计算" : "未计算";
    }

    public String getIsPushedName() {
        return (isPushed != null && isPushed) ? "已推送" : "未推送";
    }

    @ApiModelProperty("账户或信用账户和流水")
    private List<AccountFlowAppRpcVO> flowList;


}
