package com.elitesland.fin.service.accountingengine;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.accountingengine.FinSetOfBookRpcDTO;
import com.elitesland.fin.param.accountingengine.FinSetOfBookSyncParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;


/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/19
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + FinSetOfBookRpcService.PATH)
public interface FinSetOfBookRpcService {

    String PATH = "/finSetOfBook";

    /**
     * 根据编码查询账簿信息，包含明细
     * @return
     */
    @GetMapping("/findSetOfBookByCode")
    ApiResult<FinSetOfBookRpcDTO> findSetOfBookByCode(@RequestParam(name = "sobCode") @NotBlank(message = "账套编码") String sobCode);

    /**
     * 更新客户更新状态
     * @param param
     * @return
     */
    @GetMapping("/updateSyncStatus")
    ApiResult<Void> updateSyncStatus(@RequestBody List<FinSetOfBookSyncParam> param);

}
