package com.elitesland.fin.dto.financial;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * @author zhiyu.he
 * @date 2025/10/14 14:21
 */
@Data
public class FinancialBillDRpcDTO implements Serializable {

    private static final long serialVersionUID = 4400038093517476687L;
    @ApiModelProperty("账单类型")
    private String detailBillType;
    private String detailBillTypeName;

    @ApiModelProperty("明细金额（标准）")
    private BigDecimal detailStandardAmount;

    @ApiModelProperty("明细金额（减免）")
    private BigDecimal detailReductionAmount;

    @ApiModelProperty("明细金额（实收）")
    private BigDecimal detailActualAmount;

    @ApiModelProperty("实收未税金额")
    private BigDecimal amt;

    @ApiModelProperty("实收税额")
    private BigDecimal netAmt;

    @ApiModelProperty("账单ID")
    private Long masId;

    @ApiModelProperty("税码")
    private String taxCode;

}
