package com.elitesland.fin.param.payorder;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author lucan.liu
 * @date 2023/7/28 14:30
 */
@Data
public class PayOrderPageRpcParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -6336410737207556968L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("ID")
    private List<Long> idList;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("付款单号")
    private String payOrderNo;

    @ApiModelProperty("状态'")
    private String orderState;

    @ApiModelProperty("是否期初")
    private Boolean initFlag;

    @ApiModelProperty("是否预付'")
    private Boolean apFlag;

    @ApiModelProperty("来源系统单号")
    private String sourceNo;

    @ApiModelProperty("付款单类型ID")
    private Long payTypeId;

    @ApiModelProperty("业务日期开始")
    private LocalDateTime buDateStart;

    @ApiModelProperty("业务日期结束")
    private LocalDateTime buDateEnd;

    @ApiModelProperty("总金额从")
    private BigDecimal totalAmtFrom;

    @ApiModelProperty("总金额至")
    private BigDecimal totalAmtTo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("经办人")
    private String operator;

    @ApiModelProperty("明细行来源单号")
    private String sourceNoDtl;

    @ApiModelProperty("来源单据")
    private String createMode;

    @ApiModelProperty("核销状态")
    private String verState;
}
