package com.elitesland.fin.openapiservice.aporder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.aporder.ApOrderRpcDTO;
import com.elitesland.fin.param.aporder.ApOrderPageRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author lucan.liu
 * @version V1.0
 * 应付单
 * @Package com.elitesland.fin.openapiservice.aporder
 * @date 2023/07/28 14:10
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + ApOrderRpcService.PATH)
public interface ApOrderRpcService {
    String PATH = "/apOrder";

    /**
     * 应付单列表查询
     * @param apOrderPageRpcParam
     * @return
     */
    @PostMapping("/page")
    ApiResult<PagingVO<ApOrderRpcDTO>> page(@RequestBody ApOrderPageRpcParam apOrderPageRpcParam);

}
