package com.elitesland.fin.openapiservice.payorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.payorder.PayOrderRpcDTO;
import com.elitesland.fin.param.payorder.PayOrderPageRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author lucan.liu
 * @version V1.0
 * 应付单
 * @Package com.elitesland.fin.openapiservice.payorder
 * @date 2023/07/28 14:10
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + PayOrderRpcService.PATH)
public interface PayOrderRpcService {
    String PATH = "/payOrder";

    /**
     * 付款单列表查询
     * @param payOrderPageRpcParam
     * @return
     */
    @PostMapping("/page")
    ApiResult<PagingVO<PayOrderRpcDTO>> page(@RequestBody PayOrderPageRpcParam payOrderPageRpcParam);

}
