package com.elitesland.fin.service.flow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.flow.AccountFlowRpcDTO;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:账户流水
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + AccountFlowRpcService.PATH)
public interface AccountFlowRpcService {

    String PATH = "/accountFlow";

    /**
     * 账户流水保存
     *
     * @param rpcParams 入参
     * @return 流水号
     */
    @PostMapping("/save")
    ApiResult<AccountFlowRpcDTO> save(@RequestBody List<AccountFlowRpcParam> rpcParams);

    /**
     * 账户流水保存
     *
     * @param rpcParams 入参
     * @return 流水号
     */
    @PostMapping("/generateAccountFlow")
    ApiResult<String> generateAccountFlow(@RequestBody AccountFlowRpcParam rpcParams);

    /**
     * 校验账户余额
     */
    @PostMapping("/checkAccountBalance")
    ApiResult<Boolean> checkAccountBalance(@RequestBody AccountFlowRpcParam rpcParams);
}
