package com.elitesland.fin.service.cost;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.invoice.InvoiceRuleConfigRpcDTO;
import com.elitesland.fin.param.invoice.InvoiceRuleConfigRpcParam;
import com.elitesland.fin.service.pay.PayRpcService;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author brayson
 * @date 2025/11/1
 * @description
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + CostAccountingRpcService.PATH)
public interface CostAccountingRpcService {

    String PATH = "/cost";

    @PostMapping("/saveCostAccountings")
    ApiResult<Void> saveCostAccountings(@RequestBody List<InvoiceRuleConfigRpcParam> params);

}
