package com.elitesland.fin.dto.paymentperiod;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/04/22
 * @Version 1.0
 * @Content:
 */
@ApiModel(value = "receiptPaymentAgreementRpcDTO",description = "收付款协议出参")
@Data
public class ReceiptPaymentAgreementRpcDTO implements Serializable {
    private static final long serialVersionUID = 4342474745744312796L;

    @ApiModelProperty(value = "收付款协议ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("协议类型")
    @SysCode(sys = "yst-fin", mod = "AGREEMENT_PROTOCOL_TYPE")
    private String protocolType;
    @ApiModelProperty("协议类型名称")
    private String protocolTypeName;

    @ApiModelProperty("协议编码")
    private String protocolCode;

    @ApiModelProperty("协议名称")
    private String protocolName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    @ApiModelProperty("状态名称")
    private String statusName;

}
