package com.elitesland.fin.service.expense;

import com.elitesland.fin.Application;
import com.elitesland.fin.param.expense.ExpRuleQueryRpcParam;
import com.elitesland.fin.param.expense.ExpRuleQueryRpcRespVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:账户流水
 * </p>
 *
 * @Author Mark
 * @Date 2024/08/16
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + ExpenseRuleConfigRpcService.PATH)
public interface ExpenseRuleConfigRpcService {

    String PATH = "/expenseRuleConfig";


    /**
     * 费用类型规则查询
     */
    @PostMapping("/getList")
    List<ExpRuleQueryRpcRespVO> getList(@RequestBody ExpRuleQueryRpcParam param);

}
