package com.elitesland.fin.service.expense;

import com.elitesland.fin.Application;
import com.elitesland.fin.param.expense.ExpTypeQueryRpcParam;
import com.elitesland.fin.param.expense.ExpTypeQueryRpcRespPVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * <p>
 * 功能说明:账户流水
 * </p>
 *
 * @Author Mark
 * @Date 2024/08/16
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + ExpenseTypeRpcService.PATH)
public interface ExpenseTypeRpcService {

    String PATH = "/expenseType";


    /**
     * 指定费用类型配置查询
     */
    @PostMapping("/getList")
    ExpTypeQueryRpcRespPVO getList(@RequestBody ExpTypeQueryRpcParam param);

}
