package com.elitesland.fin.dto.paymentruleconfig;

import com.el.coordinator.core.common.jpa.vo.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/7/17 19:29
 * @Description:
 */
@Data
public class PaymentRuleConfigQueryDTO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 3335575439614404897L;

    @ApiModelProperty("账户规则码")
    private String ruleCode;

    @ApiModelProperty("账户规则名称")
    private String ruleName;

    @ApiModelProperty("适用单据")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String optDoc;
    private String optDocName;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    private List<PaymentRuleConfigDtlDTO> paymentRuleConfigDtlVoList;

}
