package com.elitesland.fin.dto.receiptpayment;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;

/**
 * @Author: Unicorn
 * @Description: 收付款协议
 * @Date: 2024/6/5 11:43
 * @Version: 1.0
 */
@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ReceiptPaymentAgreementDTO implements Serializable {

    private static final long serialVersionUID = -6354959295305116840L;

    @ApiModelProperty("协议类型")
    private String protocolType;

    @ApiModelProperty("协议类型名称")
    private String protocolTypeName;

    @ApiModelProperty("协议编码")
    private String protocolCode;

    @ApiModelProperty("协议名称")
    private String protocolName;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("状态名称")
    private String statusName;
}
