package com.elitesland.fin.param.recorder;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author zhiyu.he
 * @date 2022/4/13 11:16
 */
@Data
public class RecOrderDtlRpcParam implements Serializable {

    private static final long serialVersionUID = -8554671614425038666L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("总单ID")
    private Long masId;

    @ApiModelProperty("收款方式")
//    @SysCode(sys = "COM", mod = "PAY_METHOD")
    private String recType;

    @ApiModelProperty("收款类型")
//    @SysCode(sys = "SAL", mod = "RECEIPT_TYPE")
    private String recKind;

    @ApiModelProperty("收款银行名称")
    private String recBank;

    @ApiModelProperty("收款银行账户")
    private String recAccount;

    @ApiModelProperty("收款流水")
    private String recFlow;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("来源单号ID")
    private Long sourceId;

    @ApiModelProperty("来源行号")
    private Integer sourceLine;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("来源行号ID")
    private Long sourceLineId;

    @ApiModelProperty("实际收款金额")
    private BigDecimal realRecAmt;

    @ApiModelProperty("实际收款金额(本位币)")
    private BigDecimal realRecCurAmt;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("费用类型")
//    @SysCode(sys = "FIN", mod = "EXPENSES_TYPE")
    private String expensesType;

    @ApiModelProperty("税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;

//
//    @ApiModelProperty("客户编码")
//    private String es10;
//
//    @ApiModelProperty("收款性质")
//    private String es11;
//
//    @ApiModelProperty("销售组织编码")
//    private String es12;
//
//    @ApiModelProperty("业务员编码")
//    private String es13;
//
//    @ApiModelProperty("币种")
//    private String es14;
//
//    @ApiModelProperty("汇率")
//    private BigDecimal es15;
//
//    @ApiModelProperty("收款银行账户")
//    private String es16;
//
//    @ApiModelProperty("付款银行账户")
//    private String es17;
//
//    @ApiModelProperty("第三方应收单明细id")
//    private Long es18;
}
