package com.elitesland.fin.service.expense;

import com.elitesland.fin.Application;
import com.elitesland.fin.param.expense.ExpLedgerSaveRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/8/30 09:39
 * @Description:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + ExpenseLedgerRpcService.PATH)
public interface ExpenseLedgerRpcService {

    String PATH = "/expenseLedger";

    @PostMapping("/create")
    void createExpenseLedger(@RequestBody ExpLedgerSaveRpcParam expLedgerSaveRpcParam);

    @PostMapping("/createBatch")
    void createExpenseLedgerBatch(@RequestBody List<ExpLedgerSaveRpcParam> expLedgerSaveRpcParamList);
}
