package com.elitesland.fin.service.inputinv;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.inputinv.InputInvRpcDTO;
import com.elitesland.fin.param.inputinv.InputInvRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * 进项发票
 * @Package com.elitesland.fin.service.inputinv
 * @date 2022/5/20 10:24
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + InputInvRpcService.PATH)
public interface InputInvRpcService {
    String PATH = "/inputInv";

    @PostMapping("/save")
    Long save(InputInvRpcParam inputInvRpcParam);

    /**
     * 销售发票查询
     */
    @PostMapping("/queryInputInvById")
    ApiResult<InputInvRpcDTO> queryInputInvById(@RequestBody Long id);

    /**
     * 进项发票批量新增RPC接口
     * @param inputInvRpcParams
     * @return
     */
    @PostMapping("/batchAdd")
    ApiResult batchAdd(@RequestBody List<InputInvRpcParam> inputInvRpcParams);
}
