package com.elitesland.fin.service.paymentruleconfig;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigDtlNewRpcDTO;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigDtlRpcDTO;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigQueryDTO;
import com.elitesland.fin.param.paymentruleconfig.PaymentRuleConfigRpcParam;
import com.elitesland.fin.param.paymentruleconfig.PaymentRuleConfigRuleCodeRpcParam;
import io.swagger.annotations.ApiOperation;
import lombok.val;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * @author gyj
 * @date 2023/3/7 13:56
 */
@RestController
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PaymentRuleConfigRpcService.PATH)
public interface PaymentRuleConfigRpcService {

    String PATH = "/paymentRule";

    /**
     * 查询账户金额
     */
    @PostMapping("/queryAccountAmount")
    ApiResult<List<PaymentRuleConfigDtlRpcDTO>> queryAccountAmount(@RequestBody PaymentRuleConfigRpcParam param);

    /**
     * 支付
     */
    @PostMapping("/pay")
    ApiResult<List<PaymentRuleConfigDtlRpcDTO>> pay(@RequestBody PaymentRuleConfigRpcParam param);

    @PostMapping("/byRuleCode")
    ApiResult<Optional<PaymentRuleConfigQueryDTO>> byRuleCode(@RequestBody PaymentRuleConfigRuleCodeRpcParam param);

    @PostMapping("/dtlsByRuleCode")
    ApiResult<List<PaymentRuleConfigDtlNewRpcDTO>> dtlsByRuleCode(PaymentRuleConfigRuleCodeRpcParam param);
}
