package com.elitesland.fin.param.writeoff;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author brayson
 * @date 2025/11/28
 * @description
 */
@Data
@ApiModel("应收收款核销记录保存参数")
public class FinArRecVerRecordSaveRpcParam implements Serializable {

    /**
     * 主键ID
     */
    @ApiModelProperty("主键ID")
    private Long id;

    /**
     * 单据号
     */
    @ApiModelProperty("单据号")
    private String docNo;

    /**
     * 核销日期
     */
    @ApiModelProperty("核销日期")
    private LocalDateTime verDate;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;

    /**
     * 出库单ID
     */
    @ApiModelProperty("出库单ID")
    private Long invOdoId;

    /**
     * 出库单号
     */
    @ApiModelProperty("出库单号")
    private String invOdoNo;

    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String custCode;

    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custName;

    /**
     * 核销结果
     */
    @ApiModelProperty("核销结果")
    private String verResult;

}
